<?php
function it_pie_shortcode($atts, $content=null){
    global $allowedposttags;
    extract(shortcode_atts( array(
              
        'foregroundcolor'           => '',
        'foregroundborderwidth'     => '2',
        'backgroundcolor'           => '',
        'backgroundborderwidth'     => '1',
        'text'                      => '',
        'textcolor'                 => '',
        'textsize'                  => '2.5',
        'percent'                   => '50',
        'fontcolor'                 => '',
        'percentagetextsize'        => '',
        'use_icon'                  => '',
        'icon_param'                => '',
        'icon_size'                 => '',
        'icon_color'                => '',
        'line_cap'                  => 'round',
        
        'it_animation'              => '',
        'delay'                     => '',
        'duration'                  => '',
        
        'el_class'                  => '',
        
    ), $atts));
        
    $output = $custom_stle = $data_anim = $data_dur = $data_del = '';
    
    $cid = uniqid( 'chrt_' );
    
    if( $backgroundcolor || $backgroundborderwidth ){
        $custom_stle .= "#{$cid} .itr-chart-bg{";
            $custom_stle .= ($backgroundcolor != '') ? "stroke: {$backgroundcolor};" : "";
            $custom_stle .= ($backgroundborderwidth != '') ? "stroke-width: {$backgroundborderwidth};" : "";
        $custom_stle .= "}";
    }
    
    if( $foregroundcolor || $foregroundborderwidth ){
        $custom_stle .= "#{$cid} .itr-chart-fore{";
            $custom_stle .= ($foregroundcolor != '') ? "stroke: {$foregroundcolor};" : "";
            $custom_stle .= ($foregroundborderwidth != '') ? "stroke-width: {$foregroundborderwidth};" : "";
        $custom_stle .= "}";
    }
    
    if( $percentagetextsize || $fontcolor ){
        $custom_stle .= "#{$cid} .itr-chart-percent{";
            $custom_stle .= ($percentagetextsize != '') ? "font-size: {$percentagetextsize}px;" : "";
            $custom_stle .= ($fontcolor != '') ? "fill: {$fontcolor};" : "";
        $custom_stle .= "}";
    }
    
    if( $textsize || $textcolor ){
        $custom_stle .= "#{$cid} .itr-chart-text{";
            $custom_stle .= ($textsize != '') ? "font-size: {$textsize}px;" : "";
            $custom_stle .= ($textcolor != '') ? "fill: {$textcolor};" : "";
        $custom_stle .= "}";
    }
    
    if( $icon_color || $icon_size ){
        $custom_stle .= "#{$cid} .itr-chart-icon{";
            $custom_stle .= ($icon_color != '') ? "fill: {$icon_color};" : "";
            $custom_stle .= ($icon_size != '') ? "font-size: {$icon_size}px;" : "";
        $custom_stle .= "}";    
    }
    
    itr_inline_css( $custom_stle );
            
    // animation styling...
    $data_anim  = ( $it_animation != '' )   ? ' data-animate="'.esc_attr($it_animation).'"'           : '';
    $data_dur   = ( $duration != '' )       ? ' data-animation-duration="'.esc_attr($duration).'"'    : '';
    $data_del   = ( $delay != '' )          ? ' data-animation-delay="'.esc_attr($delay).'"'          : '';
    $animations = $data_anim . $data_del . $data_dur;
    
    $pie_class  = 'itr-circle-pie';
    $pie_class .= ($it_animation != '') ? ' fx' : "";
    $pie_class .= ($line_cap != '')     ? ' line-'.$line_cap : "";
    $pie_class .= ($el_class != '') ? ' '.$el_class : "";
    $hd_class   = ($icon_param != '') ? ' '.esc_attr($icon_param) : "";
        
    $atrs       = '';
    $atrs      .= ( $percent != '' )       ? ' data-percentage="'.esc_attr($percent).'"'   : "";  
    $atrs      .= ( $text != '' )          ? ' data-text="'.esc_attr($text).'"'            : "";
    $atrs      .= ( $icon_param != '' )    ? ' data-icon="'.esc_attr($icon_param).'"'      : "";
    
    $output .= "<i class='hidden itr-hid-chrt-icon".$hd_class."'></i>";     
    $output .= "<div id='{$cid}' class='{$pie_class}'{$animations}{$atrs}></div>";                           
    
    wp_enqueue_script ( 'progresscircle', Munza_THM_URI . 'assets/front/js/vendor/progresscircle.js', null, null, true );
    
    return $output; 
 
}
add_shortcode('it_pie', 'it_pie_shortcode');





