<?php
function it_step_shortcode($atts, $content=null){
    global $allowedposttags; 
    global $steps_style;
    extract(shortcode_atts( array(
        'icon_param'             => 'fontawesome',
        'step_title'             => '',        
        'use_icon'               => '1',
        'hover_show'             => '',
        'shape'                  => '',
        'title_color'            => '',
        'bg_color'               => '',
        'hover_bg_color'         => '',
        'color'                  => '#ef2674',
        'hover_color'            => '',
        'border_color'           => '#ef2674',
        'hover_border_color'     => '',
        'line_color'             => '#ef2674',
        'sep_height'             => '',
        'border_width'           => '4',
        'border_style'           => '',
        'it_animation'           => '',
        'delay'                  => '',
        'icon_width'             => '',
        'icon_height'            => '',
        'icon_size'              => '',
        'duration'               => '',
        'cont_top'               => '',
        'cont_right'             => '',
        'cont_bottom'            => '',
        'cont_left'              => '',
        'el_class'               => ''
    ), $atts));
        
    $stepid = uniqid( 'stp_' );
    $custom_stle = $data_anim = $data_del = $data_dur = $iconClass = '';    
    
    if( $bg_color || $color || $border_color || $border_width || $icon_size || $icon_width || $icon_height || $border_style  ){
        $custom_stle .= ".{$stepid} .step_icon{";
            $custom_stle .= ($bg_color != '') ? "background-color: {$bg_color};" : "";
            $custom_stle .= ($color != '') ? "color: {$color};" : "";
            $custom_stle .= ($icon_size != '') ? "font-size: {$icon_size}px;" : "";
            $custom_stle .= ($icon_width != '') ? "width: {$icon_width}px;" : "";
            $custom_stle .= ($icon_height != '') ? "height: {$icon_height}px;" : "";
            $custom_stle .= ($border_color != '') ? "border-color: {$border_color};" : "";
            $custom_stle .= ($border_width != '') ? "border-width: {$border_width}px;" : "";
            $custom_stle .= ($border_style != '') ? "border-style: {$border_style};" : "";
        $custom_stle .= "}";    
    }
    
    if( $hover_bg_color || $hover_color || $border_width || $hover_border_color ){
        $custom_stle .= ".{$stepid}:hover .step_icon{";
            $custom_stle .= ($hover_bg_color != '') ? "background-color: {$hover_bg_color};" : "";
            $custom_stle .= ($hover_border_color != '') ? "border: {$border_width}px {$hover_border_color} solid;" : "";
            $custom_stle .= ($hover_color != '') ? "color: {$hover_color};" : ""; 
        $custom_stle .= "}";    
    }
    
    if( $line_color || $sep_height  ){
        $custom_stle .= ".{$stepid} .step_line:before,.{$stepid} .step_line:after{";
            $custom_stle .= ($line_color != '') ? "background-color: {$line_color};" : "";
            $custom_stle .= ($sep_height != '') ? "height: {$sep_height}px;" : ""; 
        $custom_stle .= "}";    
    }
    
    if( $icon_width ){
        $iconW = $icon_width + 50;
        $iconL = $icon_width / 2 + 25;    
        $custom_stle .= ".{$stepid} .step_line:before,.{$stepid} .step_line:after{";
            $custom_stle .= ($icon_width != '') ? "width: calc(100% - {$iconW}px);" : "";
            $custom_stle .= ($icon_width != '') ? "left: calc(50% + {$iconL}px);" : "";
        $custom_stle .= "}";    
    }
            
    if( $title_color ){
        $custom_stle .= ".{$stepid} .step_title{";
            $custom_stle .= ($title_color != '') ? "color: {$title_color};" : "";
        $custom_stle .= "}";
    }
    
    if( $cont_top || $cont_right || $cont_bottom || $cont_left ){
        $custom_stle .= ".{$stepid} .step_content{";
            $custom_stle .= ($cont_top != '') ? "padding-top: {$cont_top}px;" : "";
            $custom_stle .= ($cont_right != '') ? "padding-right: {$cont_right}px;" : "";
            $custom_stle .= ($cont_bottom != '') ? "padding-bottom: {$cont_bottom}px;" : "";
            $custom_stle .= ($cont_left != '') ? "padding-left: {$cont_left}px;" : "";
        $custom_stle .= "}";
    }
    
    if( $border_color && $border_width && $icon_height ){
        $borderW = $icon_height - $border_width;
        $custom_stle .= ".{$stepid} .step_icon{";
            $custom_stle .= "line-height: {$borderW}px !important;";
        $custom_stle .= "}";    
    } else if ( $border_color && $border_width && $icon_height == '' ){
        $borderW = 70 - $border_width;
        $custom_stle .= ".{$stepid} .step_icon{";
            $custom_stle .= "line-height: {$borderW}px !important;";
        $custom_stle .= "}";
    }
    
    itr_inline_css( $custom_stle );
    
    $iconClass .= $icon_param . ' ';
    
    // animation styling...
    if($it_animation != ''){$data_anim = ' data-animate="'.esc_js($it_animation).'"';}
    if($duration != ''){$data_dur = ' data-animation-duration="'.esc_js($duration).'"';}
    if($delay != ''){$data_del = ' data-animation-delay="'.esc_js($delay).'"';}
    $animation = $data_anim.$data_del.$data_dur; 
  
    $class = 'itr_step';
    $class .= ( $el_class != '' ) ? ' '.$el_class : '';
    $class .= ( $it_animation != '' ) ? ' fx' : '';
    $class .= ( $hover_show != '' ) ? ' hidden_content' : '';
    $class .= ( $bg_color || $border_color || $border_width || $color || $title_color ) ? ' ' . $stepid : '';
    
    $iconClass .= 'step_icon ';
    $iconClass .= ( $shape != '' ) ? ' '.$shape : '';
        
    $output = "<div class='{$class}'>";
        
        $output .= "<div class='stp_wrp'>";
        
            if( $steps_style == 'vert_steps' ) {

                $output .= "<span class='step_line'>";
                    $output .= '<i class="'.$iconClass.'"></i>';
                $output .= "</span>";
                    
                $output .= '<div class="step_inner">';
                    $output .= '<h4 class="step_title">'.$step_title.'</h4>';
                    $output .= '<p class="step_content">'.wp_kses($content,$allowedposttags,null).'</p>';
                $output .= '</div>';

            } else {
                
                $output .= "<span class='step_line'>";
                    $output .= '<i class="'.$iconClass.'"></i>';
                $output .= "</span>";
                
                $output .= '<h4 class="step_title">'.$step_title.'</h4>';
                $output .= '<p class="step_content">'.wp_kses($content,$allowedposttags,null).'</p>';

            }
            
        $output .= '</div>';  
    
    $output .= '</div>';
        
    return $output;
  
}                                               
add_shortcode('it_step', 'it_step_shortcode');