<?php
if ( ! defined( 'ABSPATH' ) ) {
	die( '-1' );
}

/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $values
 * @var $units
 * @var $bgcolor
 * @var $custombgcolor
 * @var $customtxtcolor
 * @var $options
 * @var $el_class
 * @var $el_id
 * @var $css
 * @var $css_animation
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Progress_Bar
 */
$title = $values = $units = $barsstyle = $output = $barsbgcolor = $barshape = $bgcolor = $css = $custombgcolor = $customtxtcolor = $options = $el_class = $el_id = $css_animation = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
$atts = $this->convertAttributesToNewProgressBar( $atts );

extract( $atts );
wp_enqueue_script( 'waypoints' );
$proid = uniqid('pro-', '');
$el_class = $this->getExtraClass( $el_class ) . $this->getCSSAnimation( $css_animation );

$bar_options = array();
$options = explode( ',', $options );
if ( in_array( 'animated', $options ) ) {
	$bar_options[] = 'animated';
}
if ( in_array( 'striped', $options ) ) {
	$bar_options[] = 'striped';
}

if ( 'custom' === $bgcolor && '' !== $custombgcolor ) {
	$custombgcolor = ' style="' . vc_get_css_color( 'background-color', $custombgcolor ) . '"';
	if ( '' !== $customtxtcolor ) {
		$customtxtcolor = ' style="' . vc_get_css_color( 'color', $customtxtcolor ) . '"';
	}
	$bgcolor = '';
} else {
	$custombgcolor = '';
	$customtxtcolor = '';
	$bgcolor = 'vc_progress-bar-color-' . esc_attr( $bgcolor );
	$el_class .= ' ' . $bgcolor;
}

if ( $barsbgcolor != '' ) {
    echo "<style type='text/css'>";
        if ( $barsstyle == 'prog4' ) {
            echo  ".vc_progress_bar .{$proid}.vc_single_bar .vc_label {";
                echo "border-bottom-color:{$barsbgcolor};";
            echo "}";
        } else if ( $barsstyle == 'prog3' ) {
            echo  ".vc_progress_bar .{$proid}.vc_single_bar .vc_label:after {";
                echo "background-color:{$barsbgcolor};";
            echo "}";
        } else {
            echo  ".vc_progress_bar.prog1 .{$proid}.vc_single_bar:after {";
                echo "background-color:{$barsbgcolor};";
            echo "}";
        }
    echo "</style>";
}

$class_to_filter = 'vc_progress_bar wpb_content_element';
$class_to_filter .= vc_shortcode_custom_css_class( $css, ' ' ) . $this->getExtraClass( $el_class ) . ' ' . $barsstyle . ' ' . $barshape;
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, $class_to_filter, $this->settings['base'], $atts );
$wrapper_attributes = array();
if ( ! empty( $el_id ) ) {
	$wrapper_attributes[] = 'id="' . esc_attr( $el_id ) . '"';
}
echo '<div class="' . esc_attr( $css_class ) . '" ' . implode( ' ', $wrapper_attributes ) . '>';

echo wpb_widget_title( array( 'title' => $title, 'extraclass' => 'wpb_progress_bar_heading' ) );

$values = (array) vc_param_group_parse_atts( $values );
$max_value = 0.0;
$graph_lines_data = array();
foreach ( $values as $data ) {
	$new_line = $data;
	$new_line['value'] = isset( $data['value'] ) ? $data['value'] : 0;
	$new_line['label'] = isset( $data['label'] ) ? $data['label'] : '';
	$new_line['bgcolor'] = isset( $data['color'] ) && 'custom' !== $data['color'] ? '' : $custombgcolor;
	$new_line['txtcolor'] = isset( $data['color'] ) && 'custom' !== $data['color'] ? '' : $customtxtcolor;
	if ( isset( $data['customcolor'] ) && ( ! isset( $data['color'] ) || 'custom' === $data['color'] ) ) {
		$new_line['bgcolor'] = ' style="background-color: ' . esc_attr( $data['customcolor'] ) . ';"';
	}
	if ( isset( $data['customtxtcolor'] ) && ( ! isset( $data['color'] ) || 'custom' === $data['color'] ) ) {
		$new_line['txtcolor'] = ' style="color: ' . esc_attr( $data['customtxtcolor'] ) . ';"';
	}

	if ( $max_value < (float) $new_line['value'] ) {
		$max_value = $new_line['value'];
	}
	$graph_lines_data[] = $new_line;
}

$main_class = 'vc_single_bar';
$main_class .= ( $barsbgcolor != '' ) ? ' '.$proid : '';

foreach ( $graph_lines_data as $line ) {
	
    $unit = ( '' !== $units && $barsstyle != 'prog4' ) ? ' <span class="vc_label_units">' . $line['value'] . $units . '</span>' : '';
	
    echo '<div class="'.$main_class.' ' . ( ( isset( $line['color'] ) && 'custom' !== $line['color'] ) ? ' vc_progress-bar-color-' . $line['color'] : '' ) . '">';
	    
        echo '<h6 class="vc_label"' . $line['txtcolor'] . '>' . $line['label'] . $unit . '</h6>';
	    
        if ( $max_value > 100.00 ) {
		    $percentage_value = (float) $line['value'] > 0 && $max_value > 100.00 ? round( (float) $line['value'] / $max_value * 100, 4 ) : 0;
	    } else {
		    $percentage_value = $line['value'];
	    }
	    
        echo '<span class="vc_bar ' . esc_attr( implode( ' ', $bar_options ) ) . '" data-percentage-value="' . esc_attr( $percentage_value ) . '" data-value="' . esc_attr( $line['value'] ) . '"' . $line['bgcolor'] . '>';
            if( $barsstyle == 'prog4' ) echo '<span class="vc_label_units">' . $line['value'] . $units . '</span>';
        echo '</span>';
        
	echo '</div>';
    
}

echo '</div>';