<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );
/**
 * Shortcode attributes
 * @var $atts
 * @var $title
 * @var $link
 * @var $el_class
 * @var $css
 * Shortcode class
 * @var $this WPBakeryShortCode_VC_Video
 */
$title = $link = $el_class = $css = $up_video = $vc_video_poster = $vc_video_mp4 = $vc_video_webm = $vc_video_ogv = '';
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$el_class = $this->getExtraClass( $el_class );

$po_id = preg_replace( '/[^\d]/', '', $vc_video_poster );
$po_src = wp_get_attachment_image_src( $po_id,'full' );

$vid_mp4 = wp_get_attachment_url( $vc_video_mp4 );
$vid_webm = wp_get_attachment_url( $vc_video_webm );
$vid_ogv = wp_get_attachment_url( $vc_video_ogv );


$video_w = ( isset( $content_width ) ) ? $content_width : 500;
$video_h = $video_w / 1.61; //1.61 golden ratio
/** @var WP_Embed $wp_embed */
global $wp_embed;
$embed = '';
if ( is_object( $wp_embed ) ) {
	$embed = $wp_embed->run_shortcode( '[embed width="' . $video_w . '"' . $video_h . ']' . $link . '[/embed]' );
}
$css_class = apply_filters( VC_SHORTCODE_CUSTOM_CSS_FILTER_TAG, 'wpb_video_widget wpb_content_element' . $el_class . $el_class . vc_shortcode_custom_css_class( $css, ' ' ), $this->settings['base'], $atts );

echo '<div class="' . esc_attr( $css_class ) . '">';
	echo '<div class="wpb_wrapper">';
		echo wpb_widget_title( array( 'title' => $title, 'extraclass' => 'wpb_video_heading' ) );
        if($up_video == '1'){
            if ($vc_video_poster != '' || $vc_video_mp4 != '' || $vc_video_webm != '' || $vc_video_ogv != ''){
                echo '<video poster="'.$po_src[0].'" loop controls>';
                    echo ($vc_video_mp4 != '') ? '<source src="'.$vid_mp4.'" type="video/mp4">' : "";
                    echo ($vc_video_webm != '') ? '<source src="'.$vid_webm.'" type="video/webm">' : "";
                    echo ($vc_video_ogv != '') ? '<source src="'.$vid_ogv.'" type="video/ogv">' : "";
                echo '</video>';
            }
        }else{
            echo '<div class="wpb_video_wrapper">' . $embed . '</div>'; 
        }
        
	echo '</div>';
echo '</div>';