<?php
// if called directly, abort.
if (!defined('WPINC')) { die; }

class raysgrid_Config {
    
    public $settings;
    
    public function __construct() {
        add_action('init', [ $this, 'rsgd_configs'] );
    }
    
    public function rsgd_configs() {
        $this->settings = [
            [
                "name"          => "id",
                "title"         => "id",
                "data_type"     => "mediumint(9)",
                "type"          => "int",
                "auto"          => "AUTO_INCREMENT",
                "not_null"      => "NOT NULL",
            ],
            /* Start Naming */
            [
                "name"          => "title",
                "title"         => esc_html__( "Title" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "text",
                "section"       => "rsgd_naming",
                "not_null"      => "NOT NULL",
                "description"   => esc_html__( "Insert the grid title." , RSGD_SLUG ),
            ],
            [
                "name"          => "alias",
                "title"         => esc_html__( "Alias" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "text",
                "class"         => "alias_txt",
                "section"       => "rsgd_naming",
                "not_null"      => "NOT NULL",
                "description"   => esc_html__( "Insert the grid alias." , RSGD_SLUG ),
            ],
            [
                "name"          => "shortcode",
                "title"         => esc_html__( "Shortcode" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "disabledtext",
                "class"         => "shortcode_txt",
                "section"       => "rsgd_naming",
                "not_null"      => "NOT NULL",
                "description"   => esc_html__( "Shortcode will be generated automatically once you type the alias." , RSGD_SLUG ),
            ],
            [
                "name"          => "extra_class",
                "title"         => esc_html__( "Extra CSS Class" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "text",
                "section"       => "rsgd_naming",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Add extra css class name and refer to it in custom CSS." , RSGD_SLUG ),
            ],
            [
                "name"          => "oldalias",
                "data_type"     => "text",
                "type"          => "hidden",
                "section"       => "rsgd_naming",
                "not_null"      => "NULL",
            ],
            /* Start Source */
            [
                "name"          => "post_type",
                "title"         => esc_html__( "Post Types" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "multidropdown",
                "choices"       => rsgd_post_types(),
                "section"       => "rsgd_source",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Select from available post types." , RSGD_SLUG ),
            ],
            [
                "name"          => "select_taxonomy",
                "title"         => esc_html__( "Post Categories" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "taxsdropdown",
                "section"       => "rsgd_source",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Select from available categories or tags." , RSGD_SLUG ),
            ],
            [
                "name"          => "maximum_entries",
                "title"         => esc_html__( "Maximun Entries" , RSGD_SLUG ),
                "data_type"     => "int",
                "type"          => "number",
                "section"       => "rsgd_source",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Leave it (-1) if you want to show all portfolio posts." , RSGD_SLUG ),
                "placeholder"   => "-1",
                "std"           => "-1",
                "min"           => "-1",
                "max"           => "100",
            ],
            [
                "name"          => "order_by",
                "title"         => esc_html__( "Order By" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "dropdown",
                "class"         => "rsgd_select_boxes",
                "choices"       => [
                    'date'      => esc_html__( 'Date' , RSGD_SLUG ),
                    'title'     => esc_html__( 'Title' , RSGD_SLUG ),
                    'id'        => esc_html__( 'Id' , RSGD_SLUG ),
                    'name'      => esc_html__( 'Name' , RSGD_SLUG ),
                    'modified'  => esc_html__( 'Modified' , RSGD_SLUG ),
                    'author'    => esc_html__( 'Author' , RSGD_SLUG ),
                ],
                "section"       => "rsgd_source",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Select the grids order from the available options." , RSGD_SLUG ),
            ],
            [
                "name"          => "order_type",
                "title"         => esc_html__( "Order Type" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "dropdown",
                "class"         => "rsgd_select_boxes",
                "choices"       => [
                    'desc' => esc_html__( 'Descending' , RSGD_SLUG ),
                    'asc'  => esc_html__( 'Ascending' , RSGD_SLUG ),
                ],
                "section"       => "rsgd_source",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Order posts ascending or descending." , RSGD_SLUG ),
            ],
            [
                "name"          => "image_source",
                "title"         => esc_html__( "Image Source Type" , RSGD_SLUG ),
                "data_type"     => "text",
                "class"         => "rsgd_select_boxes",
                "type"          => "dropdown",
                "choices"       => [
                    'full'          => esc_html__( 'Full' , RSGD_SLUG ),
                    'thumbnail'     => esc_html__( 'Thumbnail' , RSGD_SLUG ),
                    'medium'        => esc_html__( 'Medium' , RSGD_SLUG ),
                    'medium_large'  => esc_html__( 'Medium Large' , RSGD_SLUG ),
                    'large'         => esc_html__( 'Large' , RSGD_SLUG ),
                ],
                "section"       => "rsgd_source",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Choose what image size to be set to the image in the grid items." , RSGD_SLUG ),
            ],
            [
                "name"          => "pagination_type",
                "title"         => esc_html__( "Pagination" , RSGD_SLUG ),
                "data_type"     => "text",
                "class"         => "rsgd_select_boxes",
                "type"          => "dropdown",
                "choices"       => [
                    'enable' => esc_html__( 'Enable' , RSGD_SLUG ),
                    'smart'  => esc_html__( 'Smart Loading' , RSGD_SLUG ),
                ],
                "section"       => "rsgd_source",
                "not_null"      => "NULL",
            ],
            [
                "name"          => "pagination_style",
                "title"         => esc_html__( "Smart Loading" , RSGD_SLUG ),
                "data_type"     => "text",
                "class"         => "rsgd_select_boxes",
                "type"          => "dropdown",
                "choices"       => [
                    'infinite' => esc_html__( 'Infinite Scroll' , RSGD_SLUG ),
                    'loadmore' => esc_html__( 'Load More Button' , RSGD_SLUG ),
                ],
                "section"       => "rsgd_source",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Choose pagination smart loading type." , RSGD_SLUG ),
                'dependency'    => [
                    'element' => 'pagination_type',
                    'value'   => 'smart'
                ],
            ],
            [
                "name"          => "load_more_button_text",
                "title"         => esc_html__( "Load More Button Text" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "text",
                "section"       => "rsgd_source",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Align the pager below the grids horizontally." , RSGD_SLUG ),
                'dependency'    => [
                    'element' => 'pagination_style',
                    'value'   => 'loadmore'
                ],
                "placeholder"   => esc_html__( "Load More" , RSGD_SLUG ),
                "std"           => esc_html__( "Load More" , RSGD_SLUG ),
            ],
            [
                "name"          => "items_per_page",
                "title"         => esc_html__( "Max. Visible Rows" , RSGD_SLUG ),
                "data_type"     => "int",
                "type"          => "number",
                "section"       => "rsgd_source",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Number of visible rows." , RSGD_SLUG ),
                "placeholder"   => "9",
                "std"           => "9",
                "min"           => "0",
                "max"           => "500",
                'dependency'    => [
                    'element' => 'pagination_type',
                    'value'   => 'enable'
                ],
            ],
            [
                "name"          => "items_start",
                "title"         => esc_html__( "Visible Items" , RSGD_SLUG ),
                "data_type"     => "int",
                "type"          => "number",
                "section"       => "rsgd_source",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Number of visible Items On Load." , RSGD_SLUG ),
                "placeholder"   => "3",
                "std"           => "3",
                "min"           => "3",
                "max"           => "100",
                'dependency'    => [
                    'element' => 'pagination_type',
                    'value'   => 'smart'
                ],
            ],
            [
                "name"          => "pagination_alignment",
                "title"         => esc_html__( "Button Alignment" , RSGD_SLUG ),
                "data_type"     => "text",
                "class"         => "rsgd_select_boxes",
                "type"          => "dropdown",
                "choices"       => [
                    'center' => esc_html__( 'Center' , RSGD_SLUG ),
                    'left'   => esc_html__( 'Left' , RSGD_SLUG ),
                    'right'  => esc_html__( 'Right' , RSGD_SLUG ),
                ],
                "section"       => "rsgd_source",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Align the load more button." , RSGD_SLUG ),
                'dependency'    => [
                    'element' => 'pagination_style',
                    'value'   => 'loadmore'
                ],
            ],
            /* Start Grid Setting */
            [
                "name"          => "main_color",
                "title"         => esc_html__( "Main Color" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "color",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "placeholder"   => "#7da600",
                "std"           => "#7da600",
            ],
            [
                "name"          => "grid_layout",
                "title"         => esc_html__( "Grid Layout" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "dropdown",
                "class"         => "rsgd_select_boxes",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "choices"       => [
                    'grid'          => esc_html__( 'Even' , RSGD_SLUG ),
                    'masonry'       => esc_html__( 'Masonry' , RSGD_SLUG ),
                    'onecolumn'     => esc_html__( 'One Column' , RSGD_SLUG ),
                    'slider'        => esc_html__( 'Slider' , RSGD_SLUG ),
                ],
                "description"   => esc_html__( "Choose how the grid will appear for users." , RSGD_SLUG ),
                "std"           => "grid",
            ],
            [
                "name"          => "img_ratio",
                "title"         => esc_html__( "Media Ratio X:Y" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "twonumber",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "placeholder"   => "5|4",
                "std"           => "5|4",
                'dependency'    => [
                    'element' => 'grid_layout',
                    'value' => ['grid','slider']
                ],
            ],
            [
                "name"          => "slider_type",
                "title"         => esc_html__( "Slider Type" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "dropdown",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "class"         => "rsgd_select_boxes",
                "choices"       => [
                    'horizontal'    => esc_html__( 'Horizontal' , RSGD_SLUG ),
                    'vertical'      => esc_html__( 'Vertical' , RSGD_SLUG ),
                ],
                "std"           => "horizontal",
                'dependency'    => [
                    'element' => 'grid_layout',
                    'value' => 'slider'
                ],
            ],
            [
                "name"          => "slide_to_show",
                "title"         => esc_html__( "Slides To Show" , RSGD_SLUG ),
                "data_type"     => "int",
                "type"          => "number",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "placeholder"   => "4",
                "description"   => esc_html__( "Enter the number of slides to be shown." , RSGD_SLUG ),
                "std"           => "4",
                "min"           => "1",
                "max"           => "10",
                'dependency'    => [
                    'element' => 'grid_layout',
                    'value' => 'slider'
                ],
            ],
            [
                "name"          => "slide_to_scroll",
                "title"         => esc_html__( "Slide To Scroll" , RSGD_SLUG ),
                "data_type"     => "int",
                "type"          => "number",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "placeholder"   => "1",
                "description"   => esc_html__( "Number of slides that will be scrolled." , RSGD_SLUG ),
                "std"           => "1",
                "min"           => "1",
                "max"           => "10",
                'dependency'    => [
                    'element' => 'grid_layout',
                    'value' => 'slider'
                ],
            ],
            [
                "name"          => "slide_speed",
                "title"         => esc_html__( "Slide Speed" , RSGD_SLUG ),
                "data_type"     => "int",
                "type"          => "number",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "placeholder"   => "500",
                "description"   => esc_html__( "Speed of the slider in milliseconds." , RSGD_SLUG ),
                "std"           => "500",
                "min"           => "0",
                "max"           => "1000",
                'dependency'    => [
                    'element' => 'grid_layout',
                    'value' => 'slider'
                ],
            ],
            [
                "name"          => "fade",
                "title"         => esc_html__( "Fade ?" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "checkbox",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "std"           => "",
                'dependency'    => [
                    'element' => 'grid_layout',
                    'value' => 'slider'
                ],
            ],
            [
                "name"          => "auto_play",
                "title"         => esc_html__( "Auto Play ? " , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "checkbox",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "std"           => "",
                'dependency'    => [
                    'element' => 'grid_layout',
                    'value' => 'slider'
                ],
            ],
            [
                "name"          => "show_arrows",
                "title"         => esc_html__( "Show Arrows ? " , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "checkbox",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "std"           => "1",
                'dependency'    => [
                    'element' => 'grid_layout',
                    'value' => 'slider'
                ],
            ],
            [
                "name"          => "show_bullets",
                "title"         => esc_html__( "Show Bullets ?" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "checkbox",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "std"           => "",
                'dependency'    => [
                    'element' => 'grid_layout',
                    'value' => 'slider'
                ],
            ],
            [
                "name"          => "infinite",
                "title"         => esc_html__( "Infinite ?" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "checkbox",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "std"           => "1",
                'dependency'    => [
                    'element' => 'grid_layout',
                    'value' => 'slider'
                ],
            ],
            [
                "name"          => "number_of_columns",
                "title"         => esc_html__( "Columns Per Row" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "dropdown",
                "class"         => "rsgd_select_boxes",
                "section"       => "rsgd_gnrlsetting",
                "choices"       => [
                    '2' => esc_html__( '2 Columns' , RSGD_SLUG ),
                    '3' => esc_html__( '3 Columns' , RSGD_SLUG ),
                    '4' => esc_html__( '4 Columns' , RSGD_SLUG ),
                    '5' => esc_html__( '5 Columns' , RSGD_SLUG ),
                    '6' => esc_html__( '6 Columns' , RSGD_SLUG ),
                ],
                "std"           => "4",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Items per row that will be shown horizontally." , RSGD_SLUG ),
                'dependency'    => [
                    'element' => 'grid_layout',
                    'value' => ['grid','masonry']
                ],
            ],
            [
                "name"          => "item_spacing",
                "title"         => esc_html__( "Item Spacing" , RSGD_SLUG ),
                "data_type"     => "int",
                "type"          => "number",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Enter the Spacing between grid items." , RSGD_SLUG ),
                "placeholder"   => "15",
                "std"           => "15",
                "min"           => "0",
                "max"           => "100",
            ],
            [
                "name"          => "preloader",
                "title"         => esc_html__( "Pre-loader" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "dropdown",
                "choices"       => [
                    '-1'            => esc_html__( 'None' , RSGD_SLUG ),
                    'cp-round'      => esc_html__( 'Spinner Round' , RSGD_SLUG ),
                    'cp-pinwheel'   => esc_html__( 'Spinner Pinwheel' , RSGD_SLUG ),
                    'cp-balls'      => esc_html__( 'Spinner Balls' , RSGD_SLUG ),
                    'cp-bubble'     => esc_html__( 'Spinner Bubble' , RSGD_SLUG ),
                    'cp-flip'       => esc_html__( 'Spinner Flip' , RSGD_SLUG ),
                    'cp-hue'        => esc_html__( 'Spinner Hue' , RSGD_SLUG ),
                    'cp-skeleton'   => esc_html__( 'Spinner Skeleton' , RSGD_SLUG ),
                    'cp-eclipse'    => esc_html__( 'Spinner Eclipse' , RSGD_SLUG ),
                    'cp-boxes'      => esc_html__( 'Spinner Boxes' , RSGD_SLUG ),
                    'cp-morph'      => esc_html__( 'Spinner Morph' , RSGD_SLUG ),
                ],
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Select a preloading styles that appears before all grid items completely loaded." , RSGD_SLUG ),
            ],
            [
                "name"          => "rtl",
                "title"         => esc_html__( "RTL" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "checkbox",
                "section"       => "rsgd_gnrlsetting",
                "not_null"      => "NULL",
                "std"           => "0",
            ],
            /* Start Skins & Styles */
            [
                "name"          => "choose_skin",
                "title"         => esc_html__( "Choose Skin" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "radio",
                "choices"       => [
                    'kara'      => esc_html__( 'Kara' , RSGD_SLUG ),
                    'hub'       => esc_html__( 'Hub' , RSGD_SLUG ),
                    'ivy'       => esc_html__( 'Ivy' , RSGD_SLUG ),
                    'krosh'     => esc_html__( 'Krosh' , RSGD_SLUG ),
                    'impress'   => esc_html__( 'Impress' , RSGD_SLUG ),
                    'transit'   => esc_html__( 'Transit' , RSGD_SLUG ),
                    'neuron'    => esc_html__( 'Neuron' , RSGD_SLUG ),
                    'onair'     => esc_html__( 'OnAir' , RSGD_SLUG ),
                    'rotato'    => esc_html__( 'Rotato' , RSGD_SLUG ),
                    'agent'     => esc_html__( 'Agent' , RSGD_SLUG ),
                    'rolly'     => esc_html__( 'Rolly' , RSGD_SLUG ),
                    'mass'      => esc_html__( 'Mass' , RSGD_SLUG ),
                    'marbele'   => esc_html__( 'Marble' , RSGD_SLUG ),
                    'astro'     => esc_html__( 'Asrto' , RSGD_SLUG ),
                    
                    'paleo'     => esc_html__( 'Paleo' , RSGD_SLUG ),
                    'sublime'   => esc_html__( 'Sublime' , RSGD_SLUG ),
                    'resort'    => esc_html__( 'Resort' , RSGD_SLUG ),
                    'gemini'    => esc_html__( 'Gemini' , RSGD_SLUG ),
                    'solo'      => esc_html__( 'Solo' , RSGD_SLUG ),
                    'focus'     => esc_html__( 'Focus' , RSGD_SLUG ),
                    'zilla'     => esc_html__( 'Zilla' , RSGD_SLUG ),
                    
                ],
                "class"         => "portfolio-item",
                "section"       => "rsgd_skins",
                "not_null"      => "NULL",
                "std"           => "p-style1",
            ],
            [
                "name"          => "show_title",
                "title"         => esc_html__( "Show Title" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "checkbox",
                "section"       => "rsgd_skins",
                "not_null"      => "NULL",
                "std"           => "1",
            ],
            [
                "name"          => "show_categories",
                "title"         => esc_html__( "Show Taxonomies" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "checkbox",
                "section"       => "rsgd_skins",
                "not_null"      => "NULL",
                "std"           => "1",
            ],
            [
                "name"          => "show_link_to_post",
                "title"         => esc_html__( "Show Link to post" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "checkbox",
                "section"       => "rsgd_skins",
                "not_null"      => "NULL",
                "std"           => "1",
            ],
            [
                "name"          => "show_zoom_image",
                "title"         => esc_html__( "Show Zoom Image" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "checkbox",
                "section"       => "rsgd_skins",
                "not_null"      => "NULL",
                "std"           => "1",
            ],
            [
                "name"          => "show_excerpt",
                "title"         => esc_html__( "Show Excerpt" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "checkbox",
                "section"       => "rsgd_skins",
                "not_null"      => "NULL",
                "std"           => "",
            ],
            
            /* Start Nav Filter */
            [
                "name"          => "nav_filter",
                "title"         => esc_html__( "Nav-Filter" , RSGD_SLUG ),
                "data_type"     => "text",
                "class"         => "rsgd_select_boxes",
                "type"          => "dropdown",
                "choices"       => [
                    'style1'    => esc_html__( 'Round Boxes' , RSGD_SLUG ),
                    'style2'    => esc_html__( 'Bottom Border' , RSGD_SLUG ),
                    'style3'    => esc_html__( 'Small Bottom Border' , RSGD_SLUG ),
                    'style4'    => esc_html__( 'Simple' , RSGD_SLUG ),
                    'style5'    => esc_html__( 'Top Bottom Borders' , RSGD_SLUG ),
                    'none'      => esc_html__( 'None' , RSGD_SLUG ),
                ],
                "section"       => "rsgd_nav",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Select Navigation filter style that appears at the top of the grids." , RSGD_SLUG ),
            ],
            [
                "name"          => "show_all",
                "title"         => esc_html__( "Show All Button" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "checkbox",
                "section"       => "rsgd_nav",
                "not_null"      => "NULL",
                "description"   => esc_html__( "Show / Hide (All) button." , RSGD_SLUG ),
                "std"           => "1",
            ],
            [
                "name"          => "all_text",
                "title"         => esc_html__( "Show All Button Text" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "text",
                "section"       => "rsgd_nav",
                "not_null"      => "NULL",
                "std"           => esc_html__( "All" , RSGD_SLUG ),
                'dependency'    => [
                    'element' => 'show_all',
                    'value' => '1'
                ],
            ],
            [
                "name"          => "nav_layout",
                "title"         => esc_html__( "Layout Option" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "dropdown",
                "class"         => "rsgd_select_boxes",
                "choices"       => [
                    'inline'   => esc_html__( 'List' , RSGD_SLUG ),
                    'dropdown' => esc_html__( 'DropDown' , RSGD_SLUG ),
                ],
                "section"       => "rsgd_nav",
                "not_null"      => "NULL",
            ],
            [
                "name"          => "els_num",
                "title"         => esc_html__( "Show Number of Elements" , RSGD_SLUG ),
                "data_type"     => "text",
                "type"          => "checkbox",
                "section"       => "rsgd_nav",
                "not_null"      => "NULL",
                "std"           => "0",
            ],
            [
                "name"          => "num_style",
                "title"         => esc_html__( "Numbers Style" , RSGD_SLUG ),
                "data_type"     => "text",
                "class"         => "rsgd_select_boxes",
                "type"          => "dropdown",
                "choices"       => [
                    'inline' => esc_html__( 'Inline' , RSGD_SLUG ),
                    'popup'  => esc_html__( 'Tooltip' , RSGD_SLUG ),
                ],
                'dependency'    => [
                    'element' => 'els_num',
                    'value' => '1'
                ],
                "section"       => "rsgd_nav",
                "not_null"      => "NULL",
            ],
        ];
        return $this->settings;
    }
    
}
new raysgrid_Config();
