<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

get_header();

$curauth = $wp_query->get_queried_object(); 
$auth_info = itr_theme_option('show_auth_info');
$auth_posts = itr_theme_option('show_auth_posts');
$posts_style = itr_theme_option('auth_posts_style');
$content_before = itr_theme_option('auth_content_before');
$content_after = itr_theme_option('auth_content_after');
$meta_lay = get_post_meta(itr_page_ID(),'meta_page_layout',true);
$lay = ($meta_lay != '') ? $meta_lay : itr_theme_option('blog_sidebar');

$cell = 'row flxrow';
$cell .= ( $lay == "left" ) ? ' rit-cell' : ' nobar';
$cell .= ( $lay == "right" ) ? ' lft-cell' : ' nobar';

itr_title_style();

?>

<div class="container">
    <div class="<?php echo esc_attr($cell) ?>">
        
        <div class="itr-main-content itr-content-column">
            
            <?php if($content_before != ''){ ?>
                <div class="m-b-3">
                    <?php echo wp_kses($content_before,itr_allowed_tags()); ?>
                </div>
            <?php } ?>
            
            <?php if($auth_info == '1'){ ?>
                <div class="my-details clearfix">
                    <div class="pull-left my-img">
                        <?php echo get_avatar(get_the_author_meta('user_email', $curauth->post_author), 150); ?>
                    </div>
                    <div class="rit-details">
                        <ul class="list col-md-4">
                            <li><i class="fa fa-check"></i><b class="main-color"><?php echo esc_html__('Email: ','munza') ?></b> <?php echo esc_attr($curauth->user_email); ?></li>
                            <li><i class="fa fa-check"></i><b class="main-color"><?php echo esc_html__('Nice Name: ','munza') ?></b> <?php echo esc_attr($curauth->user_nicename); ?></li>
                            <li><i class="fa fa-check"></i><b class="main-color"><?php echo esc_html__('Website: ','munza') ?></b> <?php echo esc_attr($curauth->user_url); ?></li>
                        </ul>
                        <ul class="list col-md-4">
                            <li><i class="fa fa-check"></i><b class="main-color"><?php echo esc_html__('Registered On :','munza') ?></b> <?php echo esc_attr($curauth->user_registered); ?></li>
                            <li><i class="fa fa-check"></i><b class="main-color"><?php echo esc_html__('Logged in as: ','munza') ?></b> <?php echo esc_attr($curauth->user_login); ?></li>
                        </ul>
                    </div>
                </div>
                <?php if($curauth->description != ''){ ?>
                <div class="m-b-3 author-desc">
                    <?php echo esc_attr($curauth->description); ?>
                </div>
                <?php } ?>
            <?php } ?>
            
            <?php if($auth_posts == '1'){ ?> 
                <?php if ( have_posts() ) : ?>
                    <h3 class="itr-heading style3 left"><?php echo esc_html__('All','munza') ?> <?php echo esc_html__('Posts','munza') ?><i class="head_bot stline-navigation-menu-horizontal main-color"></i></h3>
                    <div class="blog-posts <?php echo esc_attr($posts_style) ?>" id="content">
                        <?php get_template_part( 'layout/blog/listing') ?>
                    </div>
                    <?php else: 
                    the_content;
                    endif; ?>
                <div class="clearfix"></div>
                <?php itr_paging_nav(); ?>
            <?php } ?>
            
            <?php if($content_after != ''){ ?>
                <div class="m-t-3">
                    <?php echo wp_kses($content_after,itr_allowed_tags()); ?>
                </div>
            <?php } ?>
            
        </div>
        
        <?php if ( $lay == 'left' || $lay == 'right' ) { get_sidebar(); } ?>
        
    </div>
</div>
<?php get_footer(); ?>