<?php

/**
 * Statistics Content Part
 *
 * @package bbPress
 * @subpackage Theme
 */
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

// Get the statistics
$stats = bbp_get_statistics(); ?>

<ul class="bbp-forums forum-stats">
    <li class="stats-header"><?php echo esc_html__("What's Going On?", 'munza') ?></li>
    <li class="stats-inner">
    <?php do_action( 'bbp_before_statistics' ); ?>
    
    <?php echo esc_html__("Our users have posted a total of: ", 'munza') ?><strong><?php echo esc_html( $stats['topic_count'] ); ?></strong> <?php echo esc_html__( 'Topics', 'munza' ); ?> <?php echo esc_html__("in", 'munza') ?> <strong><?php echo esc_html( $stats['forum_count'] ); ?></strong> <?php echo esc_html__( 'Forums', 'munza' ); ?>
    <br>
    
    <?php echo esc_html__("We have", 'munza') ?> <strong><?php echo esc_html( $stats['user_count'] ); ?></strong> <?php echo esc_html__( 'Registered Users', 'munza' ); ?>
    <br>
	
	<?php echo esc_html__("Number of total replaies on all forums is", 'munza') ?> <strong><?php echo esc_html( $stats['reply_count'] ); ?></strong> <?php echo esc_html__( 'Replies', 'munza' ); ?>
	<br>
    
	<?php echo esc_html__( 'Topic Tags: ', 'munza' ); ?><strong><?php echo esc_html( $stats['topic_tag_count'] ); ?></strong>
	<br>
	<?php if ( !empty( $stats['empty_topic_tag_count'] ) ) : ?>

		<?php echo esc_html__( 'Empty Topic Tags', 'munza' ); ?>: <strong><?php echo esc_html( $stats['empty_topic_tag_count'] ); ?></strong>

	<?php endif; ?>

	<?php if ( !empty( $stats['topic_count_hidden'] ) ) : ?>

		<dt><?php echo esc_html__( 'Hidden Topics', 'munza' ); ?></dt>
		<dd>
			<strong>
				<abbr title="<?php echo esc_attr( $stats['hidden_topic_title'] ); ?>"><?php echo esc_html( $stats['topic_count_hidden'] ); ?></abbr>
			</strong>
		</dd>

	<?php endif; ?>

	<?php if ( !empty( $stats['reply_count_hidden'] ) ) : ?>

		<dt><?php echo esc_html__( 'Hidden Replies', 'munza' ); ?></dt>
		<dd>
			<strong>
				<abbr title="<?php echo esc_attr( $stats['hidden_reply_title'] ); ?>"><?php echo esc_html( $stats['reply_count_hidden'] ); ?></abbr>
			</strong>
		</dd>

	<?php endif; ?>
    </li>
	<?php do_action( 'bbp_after_statistics' ); ?>

</ul>

<?php unset( $stats );