<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

if ( post_password_required() ) return;

if ( have_comments() ) { ?>
    <div id="comments" class="comments">    
        
        <h3 class="itr-inner-heading"><?php echo esc_html__('Comments','munza'); ?></h3>

        <p class="hint text-right bold">
            <?php ob_start(); ?>
            <?php comments_number( esc_html__( 'No Comments Found!', 'munza' ), esc_html__( 'One Comment', 'munza' ), '<span class="main-color">%</span> ' . esc_html__( 'Comments', 'munza' ) ); ?>
        </p>
        
        <?php if (have_comments()) { ?>
		
            <ul class="comment-list">
			    <?php wp_list_comments(); ?>
		    </ul>
        
        <?php } ?>
        
		<?php if ( get_comment_pages_count() > 1 && get_option( 'page_comments' ) ) { ?>
		    <nav id="comment-nav-below" class="navigation" role="navigation">
			    <div class="nav-previous"><?php previous_comments_link( esc_html__( '&larr; Older Comments', 'munza' ) ); ?></div>
			    <div class="nav-next"><?php next_comments_link( esc_html__( 'Newer Comments &rarr;', 'munza' ) ); ?></div>
		    </nav>
		<?php }
        
		if ( ! comments_open() && get_comments_number() ) { ?>
		    <p class="nocomments"><?php esc_html__( 'Comments are closed.' , 'munza' ); ?></p>
	    <?php } ?>
        
    </div>
<?php }
$comments_args = array(
    'title_reply' => '<h3 class="itr-inner-heading">'.esc_html__('Leave a','munza').' <span class="main-color">'.esc_html__('reply', 'munza').'</span></h3>'
);
comment_form( $comments_args );

