
var MunzaTHM = MunzaTHM || {};

(function($) { 

	"use strict";

	MunzaTHM.init = {

		radios: function(){
			/* ============= Radios Select Functions. ============= */
			$('.radio-img').each(function(){
				var th = $(this),
					prv = th.prev().val(),
					nxt = th.parent().parent().find('.rad_val');

				if (nxt.val() == prv){
					th.addClass('selected-im');
				}
				th.on('click', function(){
					var prv = $(this).prev().val(),
						nxt = $(this).parent().parent().find('.rad_val');
					th.parent().parent().find('.radio-img').removeClass('selected-im');
					th.addClass('selected-im');
					nxt.attr('value',prv);
					MunzaTHM.init.itemdepend();
				});
				th.tipr();
			});
		},

		import_demo: function(){
			/* ================== Import Demo Data. ================= */
			var $import_true = '',
				_attachment 	= $('#import_data'),
		    	_is_attachment  = null;

			$('.import_btn').on('click', function(e){
				e.preventDefault();
				var th = $(this);
				$import_true = confirm('Are you sure ? This will overwrite the existing data!');
		        if($import_true === false) return;

		        if( _attachment.is(':checked') ) {
		        	_is_attachment = true;
		        }

		        th.addClass('actbtn');
		        $('.noticeImp').fadeIn();
		        th.find('.loader').fadeIn();
		        $('.attachments').fadeOut();
		        $.ajax({
		            type  : 'POST',
		            url   : ajaxurl,
		            data  : { action: 'itr_import_action', attachment: _is_attachment },
		            success : function( data ) {
		              	th.find('.loader').fadeOut();
		              	th.find('.import_success').fadeIn();
		            	$('.noticeImp').fadeOut();
				    	window.location.reload(true);
		            },
		            error: function () {
		            	$('.import_message').html('<div class="import_message_error">There is a problem importing Data.</div>');
		            }
		        });
		    });
		},

		mainform: function(){
			/* ============== Ajax Save Form Functions. ============= */
			var adminurl = $('.adm').text();

			$('button.reset_btn[name="reset"]').on('click', function(){
				var $reset_true = confirm('Click OK to reset. Any theme settings will be lost!');
				if($reset_true === false) return false;
			});

			$('.save_btn').on('click',  function () {
				var th = $(this),
					b =  th.parent().parent('.main-options-form').serialize(),
					el = th.find('.msg');

				th.find('.loader').fadeIn();
				th.addClass('actbtn');
				$.post( adminurl +'options.php', b ).error(function() {
				el.html('<i class="stline-close"></i> Error saving data').addClass('error').fadeIn();
				}).success( function() {
					el.html('<i class="stline-check-double"></i>').addClass('success').fadeIn();
					th.find('.loader').fadeOut();
					$('.it_bx').customcheck();
					setTimeout(function () {
						el.fadeOut(500).removeClass('success');
						th.removeClass('actbtn');
					}, 1500);
				});
				return false;    
			});
		},

		globals: function(){
			
			$('.sec-heading').each(function(){
				var $ids = $(this).attr('data-id');
				var idd = '';
				if(typeof $ids !== typeof undefined && $ids !== false){
					 idd = ' id="'+$ids+'"';
				}
				$(this).nextUntil('.sec-heading').wrapAll('<div class="acc-content"'+idd+'></div>');
			});

			var $importer_msg = $('.importer_active').text();
			if($importer_msg.length > 0){
				$('div[data-id="import_data"]').before('<div class="it-sec section oc_notice warning">'+$importer_msg+'</div>');
			}
			

			if( $('#cusom_page_settings-hide').is(":checked") ){
				$('#cusom_page_settings').fadeIn();
			}

			$('.header-imgs').each(function(){
				$(this).parent().addClass('header-img-wrap');
			});

			var media = wp.media;

			media.view.Settings.Gallery = media.view.Settings.Gallery.extend({
				render: function() {
					media.view.Settings.prototype.render.apply( this, arguments );

					// Append the custom template
					this.$el.append( media.template( 'custom-gallery-setting' ) );

					// Save the setting
					media.gallery.defaults.slideshow = 'no';
					this.update.apply( this, ['slideshow'] );
					return this;
				}
			} );
			
			$('.it-sec').each(function(){
				var that 	= $(this),
					grp 	= that.find('> .group'),
					idd 	= that.attr('data-id'),
					subs 	= $(".sub-section."+idd);
				subs.appendTo(grp).wrapAll('<div class="subs"></div>');
				$('.subs').find('.subs').removeClass('subs').find('.sub-section').removeClass('sub-section').addClass('child-sec');
			});

			$('.itr-tabs-nav li a').each(function(){
				var th = $(this),
					ur = th.attr('href');
				$('.itr-tabs-nav li').eq(0).addClass('itr-state-active');
				$('.itr-tabs-panel').eq(0).show(0);

				th.on('click',function(e){
					e.preventDefault();
					if($(ur).is(':hidden')){
						$('.itr-tabs-panel').fadeOut(0);
						$('.itr-tabs-nav li').removeClass('itr-state-active');
						th.parent().addClass('itr-state-active');
						$(ur).fadeIn(200);
					}
				});
			});

			$('[id*="colpic_"]').each(function(){
				var th = $(this);
				gradX(th,{
					code_shown: false,
					sliders: [
						{
							color: "#2f9d8f",
							position: 0
						},
						{
							color: "#82eee1",
							position: 100
						}
					]
				});
			});

			$(".slidernum").each(function(){
				var th 		= $(this),
					thP 	= th.next().attr('value'),
					thMin	= th.data('min'),
					thMax	= th.data('max');

				if(thMin == '' & thMax == ''){
					
					th.remove();

				}else {

					th.slider({
						range: "min",
						value: thP,
						step: 1,
						min: thMin,
						max: thMax,
						slide: function (event, ui) {
			                var thPre = th.next();
			                thPre.val(ui.value);
			            }
					});

				}
				
			});

			$('.hid_two_num').each(function(){
				var t = $(this),
					input = $('.num-txt'),
					tFirst = t.parent().find('.firstVL'),
					tLast = t.parent().find('.lastVL');
				
				input.on('input',function(){
					var val1 = (isNaN(parseInt(tFirst.val()))) ? '' : parseInt(tFirst.val());
    				var val2 = (isNaN(parseInt(tLast.val()))) ? '' : parseInt(tLast.val());
					if( val1 && val1 ){
						t.val(val1+'|'+val2);
					} else {
						t.val('');
					}
				});

			});

			$('.arraySelect img').each(function(){
				var th = $(this),
					thVl = th.data('value'),
					part = th.parent().parent().find('.hiddenSelect'),
					partv = part.val();
				
				if(partv == thVl){
					th.parent().addClass('active');
				}

				th.on('click', function(){
					part.val($(this).data('value')).trigger('change');
					$('.sel_block').removeClass('active');
					th.parent().addClass('active');
				});
				
			});

			$('.select_boxes:not(.hidden)').each(function(){
				var th = $(this),
					act = '';
				th.before('<ul class="sel_opts"></ul>');
				var opts = th.parent().find('.sel_opts');
				th.find('option').each(function(){
					if(this.selected) {
						opts.append('<li class="active" data-value="'+$(this).val()+'">'+$(this).text()+'</li>');
					} else {
						opts.append('<li data-value="'+$(this).val()+'">'+$(this).text()+'</li>');
					}
					
				});

				opts.find('li').on('click', function(){
					th.val($(this).data('value')).trigger('change');
					opts.find('li').removeClass('active');
					$(this).addClass('active');
				});
				
			});

			$('.num-txt:not(.no-slider)').change(function () {
				var value = this.value,
				selector = $(this).prev();
				selector.slider("value", value);
			});

			/* ================= Color Picker Options. ================= */
			var colorOpts = {
			    defaultColor: false,
			    change: function(event, ui){
			    	var hexcolor = $( this ).wpColorPicker( 'color' );
			    	$(this).parent().parent().parent().find('.hexa-color').attr('value',hexcolor);
			    },
			    clear: function() {
			    	$(this).parent().parent().parent().find('.hexa-color').attr('value','');
			    },
			    hide: true,
			    palettes: true
			};
			$('.color-field,.color-chooser,.colorpicker_field').wpColorPicker(colorOpts);

			$('.itr-tabs-panel').each(function(){
				$(this).find('.acc-content').eq(0).show(0);
				var thP = $(this);
				if(thP.find('.sec-heading').length > 0){
					$(this).prepend('<ul class="inner-menu"></ul>');
			    	$(this).find('.acc-content').each(function(){
			    		var tt = $(this).prev('.sec-heading').text();
			    		var $tid = $(this).attr('id');
			    		thP.find('.inner-menu').append('<li><a href="#'+$tid+'">'+tt+'</a></li>');
			    		thP.find('.inner-menu').find('li').eq(0).addClass('selected');
			    	});
				}
		    });
		    
		    $('.inner-menu > li > a').on('click',function(e){
				e.preventDefault();
				var aID = $(this).attr('href');
				if($(aID).is(':hidden')){
					$(this).parent().parent().find('li').removeClass('selected');
					$(this).parent().addClass('selected');
					$(this).parent().parent().parent().find('.acc-content').fadeOut(0);
			    	$(aID).fadeIn(200);
		    	}
		    });
		},

		add_boxes: function(){
			$('.add_btn').each(function(){
		    	var that 		= $(this),
		    		subss 		= that.parent().find('.subs'),
		    		bar_box 	= that.find('.hid_txt'),
		    		subs_sec 	= subss.find('.sub-section');

		    	if(subss.length){
			    	that.after('<div class="clearfix"></div>');
			    	subss.addClass('sortable');
			    }else{
			    	that.after('<div class="subs sortable"></div>');
			    }
			    		    
			    // social icons
				if($(this).find('.hid_txt').is('.socials')){
		    		for(var i = 0; i < subs_sec.length; i+=3) {
						subs_sec.slice(i, i+3).wrapAll('<div class="grup"></div>');
					}
		    		subs_sec.each(function(){
				    	$(this).removeClass('sub-section').addClass('in-item');
				    });

		    	// custom fonts
		    	}else if($(this).find('.hid_txt').is('.fontat')){
		    		for(var i = 0; i < subs_sec.length; i+=6) {
						subs_sec.slice(i, i+6).wrapAll('<div class="grup"></div>');
					}
		    		subs_sec.each(function(){
				    	$(this).removeClass('sub-section').addClass('in-item');
				    });
		    	
		    	// sidebars
		    	} else {
		    		subs_sec.each(function(){
				    	$(this).removeClass('sub-section').addClass('in-item').wrap('<div class="grup"></div>');
				    });
		    	}

		    	subss.find('.grup').each(function(index){
		    		$(this).addClass('section_group').attr('data-id',$(this).index());
		    	});

			    that.find('.add_box').on('click', function(e){
			    	e.preventDefault();					
					var v = bar_box.val();
					v++;
					bar_box.val(v);

			    	// clone and add bar boxes...
					MunzaTHM.init.cloneitems( subss,v );

			    	that.parent().parent().find('.subs').find('.section_group').removeClass('open selected');
			    	that.parent().parent().find('.subs').find('.section_group[data-id="'+v+'"]').addClass('open selected');

					MunzaTHM.init.indVal();
					MunzaTHM.init.load_icons();
					MunzaTHM.init.remove_box();
					MunzaTHM.init.collap();
					MunzaTHM.init.sorting();
					MunzaTHM.init.itr_upload_font();

			    	return false;
			    });
		    });
		},

		add_modules: function(){
			$('.add_mod').each(function(){
		    	var that 		= $(this),
		    		subss 		= that.parent().parent().find('.subs'),
		    		bar_box 	= that.find('.hid_txt'),
		    		subs_sec 	= subss.find('.sub-section');

		    	if(subss.length){
			    	that.after('<div class="clearfix"></div>');
			    	subss.addClass('sortable');
			    }else{
			    	that.after('<div class="subs sortable"></div>');
			    }

		    	// top bar    			
	    		subs_sec.each(function(index){
			    	$(this).removeClass('sub-section').addClass('in-item').wrap('<div class="section_group" data-id="'+$(this).index()+'"></div>');
			    });

			    that.find('.add_module').on('click', function(e){
			    	e.preventDefault();
					var v = bar_box.val();
					v++;
					bar_box.val(v);

					// clone and add bar modules...
			    	MunzaTHM.init.cloneitems( subss,v );

			    	that.parent().parent().find('.subs').find('.section_group').removeClass('open selected');
			    	that.parent().parent().find('.subs').find('.section_group[data-id="'+v+'"]').addClass('open selected');

					MunzaTHM.init.itemdepend();
					MunzaTHM.init.selVal();
					MunzaTHM.init.load_icons();
					MunzaTHM.init.remove_box();
					MunzaTHM.init.collap();
					MunzaTHM.init.sorting();

			    	return false;
			    });
		    });
		},

		subsections: function(){
			$('.section_group').each(function(){
				$(this).prepend('<h4 class="th_title collapse_row"><span></span><a class="remove_box" href="#" title="Remove"><i class="stline-close"></i></a><a class="tgl" href="#" title=""><i class="stline-arrow-down-1"></i></a></h4>');
			});
		},

		itemdepend: function(){

			$('.dep-field').each(function(){
				var t 		= $(this),
					vl 		= t.val(),
					deps 	= t.attr('id');
		    	
		    	if( t.attr('type') == 'text' ) {
		    		
		    		if ( t.is('.radioimages') ) {
		    			$("[data-dep='"+deps+"']").hide(0);
		    			$("[data-dep='"+deps+"'][data-vl*='"+vl+"']").show(0).css('display','table');
		    			t.parent().find('.radio-img').on('click',function(){
		    				var vl2 = t.val();
							$("[data-dep='"+deps+"']").hide(0);
							$("[data-dep='"+deps+"'][data-vl*='"+vl2+"']").show(0).css('display','table');
		    			});
		    		} else {
			    		if( t.val() == '' ){
			    			$("[data-dep='"+deps+"']").hide(0);
			    		} else {
			    			$("[data-dep='"+deps+"']").show(0).css('display','table');
			    		}

			    		t.on('input',function(){
							if(t.val() == ''){
				    			$("[data-dep='"+deps+"']").hide(0);
				    		} else {
				    			$("[data-dep='"+deps+"']").show(0).css('display','table');
				    		}
			    		});	
		    		}

		    		

		    	} else if( t.attr('type') == 'hidden' ) {
		    		
		    	} else {		    		
					
					$("[data-dep='"+deps+"']").hide(0);
		    		$("[data-dep='"+deps+"'][data-vl*='"+vl+"']").show(0).css('display','table');

		    		t.on('change',function(){
						var vl2 = t.val();
						$("[data-dep='"+deps+"']").hide(0);
						$("[data-dep='"+deps+"'][data-vl*='"+vl2+"']").show(0).css('display','table');
					});

		    	}
			});
		},

		add_vls: function(){
			$('.hid-vl').each(function(){
				var th = $(this),
					thv = th.val(),
					prv = th.prev();
							
				prv.find('option[value="'+thv+'"]').attr('selected','selected');

				prv.change(function(){
					var v = $(this).val();
					th.val(v);
				});

			});

			$('.hid-widget').each(function(){
				var th = $(this),
					thv = th.val(),
					sel = th.prev();

				sel.val(thv);

				sel.on('change',function(){
					var vl = $(this).val();
					th.val(vl);
				});
			});
		},

		uploads: function(){
			$('.upload_image_button').each(function(){
				var parnt = $(this).parent(),
					txtb = $(this).prev();

				if(txtb.val() != ''){
					parnt.find('.clear-img').show(0);
				}

				$(this).on('click', function(e) {
					e.preventDefault();
					wp.media.editor.send.attachment = function(props, attachment) {
						txtb.val(attachment.id);
						
						if( parnt.find('.logo-im').length == 0 ) {
							parnt.find('.upload_image_button').after("<span class='clear-img'><img class='logo-im' alt='' src='"+attachment.url+"' /><a href='#' class='remove-img' style='display:inline-block'></a></span>");
						}

						parnt.find('img.logo-im').attr('src',attachment.url);
						parnt.find('.clear-img').show(0);
						parnt.find('.remove-img').show();

						var dep 	= txtb.attr('name'),
							deps 	= txtb.attr('id');
				    	
				    	$("div[data-dep='"+deps+"']").show(0);

				    	parnt.find('.remove-img').on('click', function(e){
							e.preventDefault();
							parnt.find('.clear-img').remove();

							var dep 	= $(this).parent().parent().find('.regular-text').attr('name'),
								deps 	= $(this).parent().parent().find('.regular-text').attr('id');
					    	
					    	$("div[data-dep='"+deps+"']").hide(0);
						});

					}
					wp.media.editor.open(this);
					return false;
				});
			});

			$('.remove-img').each(function(){
				$(this).on('click', function(e){
					e.preventDefault();
					$(this).parent().parent().find('.regular-text').val('');
					$(this).parent().remove();

					var dep 	= $(this).parent().parent().find('.regular-text').attr('name'),
						deps 	= $(this).parent().parent().find('.regular-text').attr('id');
			    	
			    	$("div[data-dep='"+deps+"']").hide(0);
				});
			});

			$('.section .upload_button,.edit_form_line .upload_button,.menu_btn.upload_button').each(function(){
				var txtb = $(this).parent().find('.regular-text');
				txtb.on('input',function(){
					var dep 	= txtb.attr('name'),
						deps 	= txtb.attr('id');
			    	if( txtb.val() == ''){
			    		$('img.logo-im').hide(0);
			    	}
				});
				$(this).on('click', function(e) {
					e.preventDefault();
					wp.media.editor.send.attachment = function(props, attachment) {
						txtb.val(attachment.url);
						txtb.next().show(0).css('display','inline-block');
					}
					wp.media.editor.open(this);
					return false;
				});
			});
		
			$('.remove-val').each(function(){
				if($(this).prev().val() === ''){
					$(this).hide();
				}
				$(this).on('click', function(e){
					e.preventDefault();
					$(this).prev().val('');
					$(this).hide();

					var dep 	= $(this).prev().attr('name'),
						deps 	= $(this).prev().attr('id');
			    	
			    	$("div[data-dep='"+deps+"']").hide(0);

				});
			});
			
		},

		itr_upload_font: function(){
			$('.section .upload_font_button').each(function(){
				var txtb = $(this).parent().find('.regular-text');

				if( txtb.val() != '' ){
					$(this).text(txtb.val());
				}

				$(this).on('click', function(e) {
					e.preventDefault();
					var th = $(this);
					wp.media.editor.open(this);
					wp.media.editor.send.attachment = function(props, attachment) {
						txtb.val(attachment.url);
						txtb.next().show(0).css('display','inline-block');
						th.text(attachment.url);
					}

					return false;
				});
			});
			$('.remove-font').each(function(){
				var btTxt = $(this).next().attr('data-orig-text');
				if($(this).prev().val() === ''){
					$(this).hide();
				}
				$(this).on('click', function(e){
					e.preventDefault();
					$(this).prev().val('');
					$(this).hide();
					$(this).next().text(btTxt);
					var dep 	= $(this).prev().attr('name'),
						deps 	= $(this).prev().attr('id');
			    	
			    	$("div[data-dep='"+deps+"']").hide(0);

				});
			});
		},

		indVal: function(){
			$('.indval').each(function(){
		    	
		    	var th = $(this),
		    		thhold = th.attr('placeholder'),
		    		thv = th.val();

		    	th.parents('.section_group').find('h4.th_title').find('span').text(thv);		    	
		    	th.keyup(function(){
		    		th.parents('.section_group').find('h4.th_title span').text('');
		    		var vlc = th.val();
		    		th.parents('.section_group').find('h4.th_title span').text(vlc);
		    	});
		    });
		},

		selVal: function(){
			$('.selVal').each(function(){
		    	var th = $(this),
		    		thv = th.find("option:selected").text();

		    	if(thv == '-- Select Box --')thv = 'New Module';

		    	th.parents('.section_group').find('h4.th_title').find('span').text(thv);
		    	
		    	th.on('change',function(){
		    		th.parents('.section_group').find('h4.th_title span').text('');
		    		var vlc = th.val(),
		    			thT = th.find("option:selected").text();

		    		if( thT == '-- Select Box --' ){
		    			thT = 'New Module';
		    		} else {
		    			th.parents('.section_group').find('h4.th_title').find('span').text(thT);
		    		}
		    		th.val(vlc);	    		
		    	});

		    });
		},

		icons_init: function(){
			
			$('.icon_cust').each(function(){
				if($(this).val() != ''){
					$(this).next('.icon-remove').fadeIn().css('display','inline-block');
					$(this).parent().find('.ico').fadeIn();
					var ic = $(this).val(),
						ico = $(this).parent().find('.ico');
					$(this).parent().find('.ico').addClass(ic);
					$(this).parent().find('.btn_icon').text('Change Icon');
				}else{
					$(this).next('.icon-remove').fadeOut();
					$(this).parent().find('.ico').fadeOut();
				}
			});
		},

		load_icons: function(){
						
			var themeurl 	= $('.it_add_icon').attr('data-theme-url'),
				iconsurl 	= themeurl + '/it-framework/includes/fields/icons/',
				icsArr 		= ['streamline','outlinefont','fontawesome'];

			$('.btn_icon').on( 'click', function(e){
				
				e.preventDefault();

				var th = $(this);
				
				$.each( icsArr , function ( index , value ){
				    
				    var ic = iconsurl + value;				    
				    
				    $.getJSON ( ic + '.json' , function ( data ) {
				    	
				    	var output = '';
							
						$.each( data.items, function ( key , val ){
					  		if ( value == 'fontawesome' ) {
					  			output += '<a href="#" data-icon="fa ' + val + '"><i class="fa ' + val + '"></i></a>';
						  	} else {
						  		output += '<a href="#" data-icon="' + val + '"><i class="' + val + '"></i></a>';
						  	}
						});

						$( '.icons_set .' + value ).html( output );
						MunzaTHM.init.click_icons();
						$('#boo-overlay').fadeIn(200);
						$('.it_add_icon').fadeIn(300);
						$('.btn_icon').removeClass('clicked');
						th.addClass('clicked');

						$('.icons_set a').each(function(){
							$(this).on('click', function(e){
								e.preventDefault();
								var icon = $(this).find('i').attr('class'),
									ht = $(this).find('i').html();
								$('.btn_icon.clicked').next('.icon_cust').val(icon);
								$('.btn_icon.clicked').prev('.ico').removeAttr('class').addClass('ico '+icon);
								$('#boo-overlay,.it_add_icon').fadeOut(400);
								th.parent().find('.icon-remove').fadeIn().css('display','inline-block');
								th.parent().find('.ico').fadeIn().html(ht);
								th.text('Change Icon');
								th.removeClass('clicked');
								return false;
							});
						});
					});
				});

				return false;
			});
			
			MunzaTHM.init.icons_init();
			
			var dw = parseInt($(window).width())/2,
				mw = parseInt($('.it_add_icon').width())/2,
				dh = parseInt($(window).height())/2,
				mh = parseInt($('.it_add_icon').height())/2,
				lft = dw-mw+'px',
				tp = dh-mh+'px';
			$('.it_add_icon').css({left:lft,top:tp});

			var iconSearch = $('.iconSearch'),
				iconLoad     = $('.icons_set > div');
			iconSearch.keyup( function(){
				var $this = $(this),
					val   = $this.val(),
					list_icon  = iconLoad.find('a');
				list_icon.each(function() {
					var $ico = $(this);
					if ( $ico.data('icon').search( new RegExp(val, "i") ) < 0 ) {
						$ico.hide();
					} else {
						$ico.show();
					}
				});
			});
		},		

		click_icons: function(){
								
			$('.close-login').on('click', function(e){
				e.preventDefault();
				$('.btn_icon').removeClass('clicked');
				$('#boo-overlay,.it_add_icon').fadeOut(400);
				return false;
			});
				
			$('.icon-remove').each(function(){
				$(this).on('click', function(e){
					e.preventDefault();
					$(this).parent().find('.icon_cust').val('');
					$(this).parent().find('.ico').removeAttr('class').addClass('ico');
					$(this).fadeOut(200);
					$(this).parent().find('.ico').fadeOut(200);
					$(this).parent().find('.btn_icon').html('<i class="stline-add"></i> Add Icon');
				});
			});
			
			$('.select_icon').change(function(){
				var thisVal = $(this).val();
				$( '.icons_set > div' ).hide();
				$( '.icons_set' ).find( '.' + thisVal ).show();
			});
		},

		remove_box: function(){
			$('.theme-options .remove_box').each(function(){
		    	var th  = $(this);
		    	th.unbind('click').on('click',function(e){
		    		e.preventDefault();
					var txt = th.parents('.section').find('.hid_txt'),
						ind = th.parent().parent().data('id'),
			    		vll = txt.val();

			        vll--;
		    		txt.val(vll);
		    		var all = th.parent().parent().nextAll('.section_group');
		    		all.each(function(){
		    			var tt = $(this),
		    				idd = tt.attr('data-id'),
		    				ne = idd-1;

		    			tt.attr('data-id',ne);
		    			tt.find('[data-id*="_'+idd+'"]').each(function(){ $(this).attr('data-id',$(this).attr('data-id').replace('_'+idd,'_'+ne)); });
		    			tt.find('[class*="_'+idd+'"]').each(function(){ $(this).attr('class',$(this).attr('class').replace('_'+idd,'_'+ne)); });
						tt.find('[name*="_'+idd+'"]').each(function(){ $(this).attr('name',$(this).attr('name').replace('_'+idd,'_'+ne)); });
						tt.find('[id*="_'+idd+'"]').each(function(){ $(this).attr('id',$(this).attr('id').replace('_'+idd,'_'+ne)); });
						tt.find('[data-parent*="_'+idd+'"]').each(function(){ $(this).attr('data-parent',$(this).attr('data-parent').replace('_'+idd,'_'+ne)); });
						tt.find('[data-dependency*="_'+idd+'"]').each(function(){ $(this).attr('data-dependency',$(this).attr('data-dependency').replace('_'+idd,'_'+ne)); });
						tt.find('[data-dep*="_'+idd+'"]').each(function(){ $(this).attr('data-dep',$(this).attr('data-dep').replace('_'+idd,'_'+ne)); });
						
		    		});
	    			th.parents('.section_group').slideUp(300, function() { $(this).remove(); });
		    	});
		    });
		},

		load_google_fonts: function(){

			var themeurl = $('.themeURI').text(),
				iconsurl = themeurl + '/it-framework/assets/fonts/fonts.json';

			$.getJSON ( iconsurl , function ( data ) {
				    	
		    	var output = '<option value="">-- Select Font Family --</option>';
					
				$.each( data.items, function ( key , val ){
			  		output += '<option value="' + val.family + '">' + val.family + '</option>';
				});

				$( '.fontSel' ).html( output );

				$( '.fontSel' ).each(function(){
					
					var th = $(this),
						val = th.val(),
						txt = th.next('.font-hid'),
						old = txt.attr('value');
						
					if( old != '' ){
						$("option[value='"+old+"']", this).attr('selected', 'selected');
						$(this).parent().parent().next().find('.gfonts').append("<link rel='stylesheet' href='//fonts.googleapis.com/css?family="+old+":100,200,300,400,500,600,700,900&#038;subset=latin,latin-ext' type='text/css' media='all' />");
						$(this).parent().parent().next().find('.gfonts').css('font-family',old);
					}
						
					
					th.on('change', function(){
						val = th.val();
						txt.val(val);
						if( val != '' ){
							$(this).parent().parent().next().find('.gfonts').append("<link rel='stylesheet' href='//fonts.googleapis.com/css?family="+val+":100,200,300,400,500,600,700,900&#038;subset=latin,latin-ext' type='text/css' media='all' />");
							$(this).parent().parent().next().find('.gfonts').css('font-family',val);
						}
					});

				});

			});

		},

		collap: function(){
			$('.theme-options .collapse_row').each(function(){
				var th = $(this);
	    		th.nextAll('.in-item').wrapAll('<div class="coll"></div>');
	    		$('.theme-options .coll').slideUp(0);
				$('.theme-options .collapse_row').removeClass('selected');
				$(this).unbind('click').on('click',function(e){
		    		e.preventDefault();
		    		var tt = th.next('.coll');
		    		if(tt.is(':hidden')){
		    			$('.section_group').removeClass('open');
		    			th.parents('.subs').find('.coll').slideUp(300);
		    			tt.slideDown(300);
		    			th.parent().addClass('selected');
		    			th.parents('.subs').find('.collapse_row').not(th).parent().removeClass('selected');
		    		}else{
		    			$('.section_group').removeClass('open');
		    			tt.slideUp(300);
		    			$(this).parent().removeClass('selected');
		    		}
		    	});	
			});
		},

		cloneitems: function( subss , l ){
			var orgclone = subss.find('.section_group[data-id="0"]'),
				cloned = orgclone.clone().attr('data-id', l ).removeAttr('style');
			
			cloned.find('.indval').val('');
			cloned.find('[class*="_0"]').each(function(){ $(this).attr('class',$(this).attr('class').replace('_0','_'+l)); });
			cloned.find('[name*="_0"]').each(function(){ $(this).attr('name',$(this).attr('name').replace('_0','_'+l)); });
			cloned.find('[id*="_0"]').each(function(){ $(this).attr('id',$(this).attr('id').replace('_0','_'+l)); });
			cloned.find('[data-parent*="_0"]').each(function(){ $(this).attr('data-parent',$(this).attr('data-parent').replace('_0','_'+l)); });
			cloned.find('[data-dependency*="_0"]').each(function(){ $(this).attr('data-dependency',$(this).attr('data-dependency').replace('_0','_'+l)); });
			cloned.find('[data-dep*="_0"]').each(function(){ $(this).attr('data-dep',$(this).attr('data-dep').replace('_0','_'+l)); });
			cloned.find('[data-id*="_0"]').each(function(){ $(this).attr('data-id',$(this).attr('data-id').replace('_0','_'+l)); });
			
			cloned.find('.it_bx').customcheck();

			cloned.appendTo(subss);
		},

		sorting: function(){
			$( ".theme-options .sortable" ).each(function(){
				$(this).sortable({
					connectWith: ".connectedSortable",
					update: function( event, ui ) {
						$(this).find('.section_group').each(function(i) { 
							var tt = $(this),
			           			idd = tt.attr('data-id');

							tt.attr('data-id', i);
							tt.find('[data-id*="_'+idd+'"]').each(function(){ $(this).attr('data-id',$(this).attr('data-id').replace('_'+idd,'_'+i)); });
							tt.find('[class*="_'+idd+'"]').each(function(){ $(this).attr('class',$(this).attr('class').replace('_'+idd,'_'+i)); });
							tt.find('[name*="_'+idd+'"]').each(function(){ $(this).attr('name',$(this).attr('name').replace('_'+idd,'_'+i)); });
							tt.find('[id*="_'+idd+'"]').each(function(){ $(this).attr('id',$(this).attr('id').replace('_'+idd,'_'+i)); });
							tt.find('[data-parent*="_'+idd+'"]').each(function(){ $(this).attr('data-parent',$(this).attr('data-parent').replace('_'+idd,'_'+i)); });
							tt.find('[data-dependency*="_'+idd+'"]').each(function(){ $(this).attr('data-dependency',$(this).attr('data-dependency').replace('_'+idd,'_'+i)); });
							tt.find('[data-dep*="_'+idd+'"]').each(function(){ $(this).attr('data-dep',$(this).attr('data-dep').replace('_'+idd,'_'+i)); });
				           
				        });
					}
				});
			});
		},

		countdate: function(){
			$('.count_date').each(function(){
				$(this).attr('readonly','readonly').attr('autocomplete','off');
				$(this).datepicker({
			        dateFormat : 'yy/mm/dd'
			    });	
			});
		},

		sidebars: function(){
			$('.sidebar_imgs').find('.radio').each(function(){
				var thissrc = $(this).attr('data-src');
				$(this).before('<img alt="Sidebar" src="'+thissrc+'" />');
				$('.radio:checked').prev('img').addClass('selected');
				$('.sidebar_imgs').find('img').each(function(){
					$(this).on('click', function(){
						$('.sidebar_imgs img').removeClass('selected');
						$(this).addClass('selected');
						$(this).next('.radio').attr('checked','checked');
						if($('.sidebar-right').prev().hasClass('selected') || $('.sidebar-left').prev().hasClass('selected')){
							$('.custom_side').show(0);
						}else{
							$('.custom_side').hide(0);
						}
					});
				});
				if($('.sidebar-right').prev().hasClass('selected') || $('.sidebar-left').prev().hasClass('selected')){
					$('.custom_side').show(0);
				}
			});
		},

		gradientPicker: function(){
			
			var $field = $('.grad_wrapper');
			
			if( $field.length > 0){

				$field.each(function(){
					var th = $(this);
					var grad = th.find('.gradpic');
					th.find('.grad_link').click(function(e){
						e.preventDefault();
						if(grad.is(':hidden')){
							grad.fadeIn();
						} else{
							grad.fadeOut();
						}
					});
					if( th.find('.gradientPicker-preview').length === 0 ){

						var st 		= th.find('.grad_vl').attr('data-vl'),
							txtbox 	= th.find('.grad_vl'),
							gtype 	= st.substr(0, st.indexOf('(')),
							tp 		= ( gtype == '-webkit-radial-gradient' ) ? 'radial' : 'linear',
							gposition,i,arr = [];

						st = st.substring(st.indexOf("(") + 1).split(';')[0].slice(0,-1);
						
						if( tp == 'linear' ) {
							var dir = st.substr(0, st.indexOf(',')).trim();
							gposition = (dir != '') ? dir : "left";
						}
						
						st = ( gtype == '-webkit-radial-gradient' ) ? st :  st.substring(st.indexOf(",") + 1);
						
						st = st.replace(/ #/g, '#');

						if( st.indexOf('rgb') > 0 ){
							arr = st.split(', rgb').join(",rgb");
						} else if( st.indexOf('rgba') > 0 ){
							arr = st.split(', rgba').join(",rgba");
						} else {
							arr = st.split(',');
							if( gtype == '-webkit-radial-gradient' ){
								arr.splice(0, 2);
							}
						}

						th.find('select.gtype').val(tp);
						if( tp == 'linear' ) {
							th.find('select.gposition').val(gposition);
						}

						if( st == '' ){
							arr 		= ["#b400ff 0%", "#3f0a9e 100%"];
							gposition 	= 'left';
							tp 			= 'linear';
						}
						
						th.find('.gradpic').gradientPicker({
							change: function(points, styles) {
								for (i = 0; i < styles.length; ++i) {
									txtbox.attr("value", styles[i]);
								}
							},
							fillDirection: gposition,
							type: tp,
							controlPoints: arr
						});

					}
				});
			}
		}
		
	}

	MunzaTHM.docLoad = {
		init: function(){
			MunzaTHM.init.radios();
			MunzaTHM.init.import_demo();
			MunzaTHM.init.mainform();
			MunzaTHM.init.globals();
			MunzaTHM.init.add_boxes();
			MunzaTHM.init.add_modules();
			MunzaTHM.init.subsections();
			MunzaTHM.init.itemdepend();
			MunzaTHM.init.indVal();
			MunzaTHM.init.selVal();
			MunzaTHM.init.uploads();
			MunzaTHM.init.itr_upload_font();
			MunzaTHM.init.add_vls();
			MunzaTHM.init.load_icons();
			MunzaTHM.init.click_icons();
			MunzaTHM.init.collap();
			MunzaTHM.init.remove_box();
			MunzaTHM.init.sidebars();
			MunzaTHM.init.sorting();
			MunzaTHM.init.gradientPicker();
			MunzaTHM.init.load_google_fonts();
			$('.it_bx').customcheck();
		}
	};

	/* ================ Window.Load Functions. ================ */
	$(window).on( 'load', MunzaTHM.docLoad.init );

	/* ================ AjaxComplete Functions. ================ */
	$(document).unbind('ajaxComplete').ajaxComplete(function(){
		MunzaTHM.init.uploads();
		MunzaTHM.init.itr_upload_font();
		MunzaTHM.init.icons_init();
		MunzaTHM.init.click_icons();
		MunzaTHM.init.add_vls();
		MunzaTHM.init.countdate();
		$('.it_bx').customcheck();
	});

})(jQuery);