<?php
/**
 *
 * IT-RAYS Framework
 *
 * @author IT-RAYS
 * @license Commercial License
 * @link http://www.it-rays.net
 * @copyright 2017 IT-RAYS Themes
 * @package ITFramework
 * @version 1.0.0
 *
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) die;
        
class ITR_Framework {
    
    public $itr_theme_version = '1.0.0';
    public $itr_sections;
    public $itr_checkboxes;
    public $itr_settings;
    
    public function __construct() {
        
        $this->itr_checkboxes = array();
        $this->itr_settings = array();
        $this->itr_get_option();
                
        $this->itr_sections['it_appearance']      = '<i class="stline-cog"></i>'.esc_html__('General Settings','munza');
        $this->itr_sections['it_topbar']          = '<i class="stline-layout-agenda"></i>'.esc_html__('Top Bar','munza');        
        $this->itr_sections['it_header']          = '<i class="stline-layout-top"></i>'.esc_html__('Header','munza');
        $this->itr_sections['it_logo']            = '<i class="stline-picture-landscape"></i>'.esc_html__('Logo','munza');
        $this->itr_sections['it_menu']            = '<i class="stline-navigation-menu"></i>'.esc_html__('Menu','munza');
        $this->itr_sections['it_footer']          = '<i class="stline-award-badge-2"></i>'.esc_html__('Footer','munza');
        $this->itr_sections['it_pagetitles']      = '<i class="stline-pencil-write"></i>'.esc_html__('Page Title','munza');
        $this->itr_sections['it_typography']      = '<i class="stline-small-caps"></i>'.esc_html__('Typography','munza');
        $this->itr_sections['it_slidingbar']      = '<i class="stline-hierarchy-2"></i>'.esc_html__('Sliding Bar','munza');
        $this->itr_sections['it_blogoptions']     = '<i class="stline-bookmarks-document"></i>'.esc_html__('Blog Settings','munza');
        $this->itr_sections['it_sidebars']        = '<i class="stline-layout-3"></i>'.esc_html__('Sidebars','munza');
        $this->itr_sections['it_socialicons']     = '<i class="stline-smiley-tongue"></i>'.esc_html__('Social icons','munza'); 
        
        if ( class_exists( 'munza_Core' ) ){
            $this->itr_sections['it_demo']       = '<i class="stline-layers"></i>'.esc_html__('Import Demo','munza');       
        }

        if(class_exists('Woocommerce')) {
            $this->itr_sections['it_woocommerce'] = '<i class="stline-shopping-bag-side"></i>'.esc_html__('Shop','munza').' <span class="hint">'.esc_html__('WooCommerce','munza').'</span>';
        }
        
        if(class_exists('bbPress')) {
            $this->itr_sections['it_bbpress']     = '<i class="fa fa-comments"></i>'.esc_html__('Forums','munza').'<span class="hint">'.esc_html__('BBPress','munza').'</span>';
        }
                
        add_action( 'admin_enqueue_scripts', array( &$this, 'itr_enq_scripts' ) );         
        add_action( 'admin_menu', array( &$this, 'itr_add_pages' ) );
        add_action( 'admin_init', array( &$this, 'itr_register_settings' ) );
        add_action( 'admin_init', array( &$this, 'itr_export_settings' ) );
        register_setting( 'munza_theme_options', 'munza_theme_options', array ( &$this, 'itr_validate_settings' ) );
        if ( ! get_option( 'munza_theme_options' ) ) $this->itr_initialize_settings(); 
        add_action( 'admin_footer' , array ( &$this,'itr_admin_icons') ); 
                        
    }
    
    public function itr_add_pages() {
        add_theme_page(esc_html__( "Munza Options", "munza" ), esc_html__( "Munza Options", "munza" ), 'manage_options', 'theme-options', array( &$this, 'itr_display_page' ) );
    }

    public function itr_create_setting( $args = array() ) {
        
        $defaults = array(
            'id'                    => '',
            'title'                 => '',
            'desc'                  => '',
            'std'                   => '',
            'type'                  => 'text',
            'src'                   => '',
            'link'                  => '',
            'group'                 => '',
            'parent'                => '',
            'section'               => '',
            'choices'               => array(),
            'class'                 => '',
            'parentclass'           => '',
            'defcolor'              => '',
            'data_id'               => '',
            'min'                   => '',
            'max'                   => '',
            'firstInput'            => '',
            'lastInput'             => '',
            'items'                 => array(),
            'sidebar'               => array(),
            'slides'                => array(),
            'dependency'            => array()
        );
            
        extract( wp_parse_args( $args, $defaults ) );
        
        $field_args = array(
            'type'                  => $type,
            'id'                    => $id,
            'desc'                  => $desc,
            'std'                   => $std,
            'src'                   => $src,
            'link'                  => $link,
            'group'                 => $group,
            'parent'                => $parent,
            'choices'               => $choices,
            'items'                 => $items,
            'sidebar'               => $sidebar,
            'label_for'             => $id,
            'class'                 => $class,
            'parentclass'           => $parentclass,
            'defcolor'              => $defcolor,
            'slides'                => $slides,
            'min'                   => $min,
            'max'                   => $max,  
            'firstInput'            => $firstInput,
            'lastInput'             => $lastInput,
            'data_id'               => $data_id,
            'dependency'            => $dependency
        );
        
        if ( $type == 'checkbox' ){
            $this->checkboxes[] = $id;
        }
                
        add_settings_field( $id, $title, array( $this, 'itr_display_setting' ), 'theme-options', $section, $field_args );
        
    }
    
    public function itr_initialize_settings() {
        $default_settings = array();
        $std = '';
        foreach ( $this->itr_settings as $id => $setting ) {
            if ( $setting['type'] != 'heading' )
                if ( isset($setting['std']) ){
                    $default_settings[$id] = $setting['std'];
                }
        }
        
        update_option( 'munza_theme_options', $default_settings );        
        
    }
    
    public function itr_register_settings() {
        
        foreach ( $this->itr_sections as $slug => $title ) {
            add_settings_section( $slug, $title, array( &$this, 'itr_display_section' ), 'theme-options' );
        }
        
        $this->itr_get_option();
        
        foreach ( $this->itr_settings as $id => $setting ) {
            $setting['id'] = $id;
            $this->itr_create_setting( $setting );
        }
    }
    
    public function itr_display_page() {

        echo '<div class="theme-options">';
            if ( isset( $_GET['settings-updated'] ) && $_GET['settings-updated'] == true ){
                echo '<div class="new-upd updated fade"><p>' . esc_html__( 'Theme options updated.', 'munza' ) . '</p></div>';
                settings_errors( 'munza_theme_options' );
            }
            echo '<div class="itr-tabs">';
                
                echo '<ul class="itr-tabs-nav" data-logo="Munza">';
                    foreach ( $this->itr_sections as $section_slug => $section ){
                        echo '<li><a href="#' . $section_slug . '">' . $section . '</a></li>';
                    }
                    if ( class_exists( 'munza_Core' ) ) echo '<li><a href="#imp_exp_form"><i class="stline-settings-slider"></i>'.esc_html__( "Import / Export options", "munza" ).'</a></li>';
                echo '</ul>';
                                
                echo '<div class="itr_tabs_wrap">';
                    echo '<form action="options.php" method="post" class="main-options-form">';
                        settings_fields( 'munza_theme_options' );
                        echo '<div class="form-btns">';
                            echo '<button name="submit" type="submit" class="button button-primary save_btn">' . esc_html__( 'Save Changes', 'munza' ) . '<span class="loader"><i class="stline-loading-2"></i></span><span class="msg"></span></button>';
                            echo '<button type="submit" name="reset" class="button button-default reset_btn">' . esc_html__( 'Restore Defaults', 'munza' ) . '</button>';
                        echo '</div>';
                        $this->itr_settings_sections( $_GET['page'] );
                    echo '</form>';
                    
                    // import / export tab.
                    if ( class_exists( 'munza_Core' ) ) {
                        echo '<div class="itr-tabs-panel" id="imp_exp_form"><form method="POST" enctype="multipart/form-data">';
                            
                            echo '<div class="opts-ul">';
                                echo '<h4 class="pnl-head"><i class="stline-settings-slider"></i>'.esc_html__('Import / Export Options', 'munza').'</h4>';
                                echo '<div class="section">';
                                    echo '<div class="lbl">
                                        <label class="opt-lbl">'.esc_html__('Export Theme Options', 'munza').'</label>
                                        <span class="description">'.esc_html__('The following are the stored theme options for the theme:', 'munza').'</span>
                                    </div>';
                                    echo '<div class="group">';
                                        echo '<p><a href="?action=download" class="button-secondary"><i class="stline-arrow-double-down"></i>'.esc_html__('Download File', 'munza').'</a></p>';
                                    echo '</div>';
                                echo '</div>';
                                    
                                echo '<div class="section">';
                                    echo '<div class="lbl">
                                        <label class="opt-lbl">'.esc_html__('Import Theme Options', 'munza').'</label>
                                        <span class="description">'.esc_html__('Restore a previous theme options.', 'munza').'</span>
                                    </div>';
                                    echo '<div class="group">';
                                        echo '<p><input type="file" class="regular-text up-file" name="import_file" id="import_file" />
                                        <button type="submit" name="upload_options" id="upload_options" class="button-primary"><i class="stline-attachment"></i>'.esc_html__('Import File', 'munza').'</button>
                                        </p>';
                                    echo '</div>';
                                echo '</div>';
                                
                            echo '</div>';
                        echo '</form>';
                    echo '</div>';
                }
                
                echo '</div>';
                
            echo '</div>';

        echo '</div>';
                
    }
    
    public function itr_display_section() {
            
    }
        
    public function itr_display_setting( $args = array() ) {
        extract( $args );
        
        $options        = get_option( 'munza_theme_options' );        
        $field_class    = ( $class != '' ) ? ' ' . $class : '';
        $d_id           = ( $data_id ) ? ' data-id="'.esc_attr($data_id).'"' : '';
        $is_lang        = ( class_exists( 'SitePress' ) && isset( $this->itr_settings[$id]['multilang'] ) ) ? true : false;
        $languages = $current = $lang = '';
        
        if ( class_exists( 'SitePress' ) ) {
            $languages = icl_get_languages();
            $current   = ICL_LANGUAGE_CODE;
            $lang      = ICL_LANGUAGE_NAME;    
        } 
        
        if ( ! isset( $options[$id] ) && $type != 'checkbox' )
            $options[$id] = $std;
        elseif ( ! isset( $options[$id] ) )
            $options[$id] = 0;
        
        switch ( $type ) {
            
            case 'heading':
                echo '<div class="sec-heading' . esc_attr($field_class) . '"'.$d_id.'><h4>' . $desc . '</h4></div>';
                break;
            
            case 'label':
                 echo '<div class="group ' . esc_attr($field_class) . '" data-parent="'.esc_attr($parent).'">';
                    echo '<label>'. $desc .'</label>';
                 echo '</div>';
                 break;
                 
            case 'checkbox':
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    echo '<input class="dep-field checktxt' . esc_attr($field_class) . '" type="hidden" id="' . esc_attr($id) . '" name="munza_theme_options[' . esc_attr($id) . ']" placeholder="' . esc_attr($std) . '" value="' . esc_attr( $options[$id] ) . '" />';
                    echo '<span class="it_bx custom-checkbox"><span class="switcher"></span></span>';
                echo '</div>';
                break;
            
            case 'text':
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    if ( $is_lang ) {
                         foreach ( $languages as $txtkey => $txtvl ) {
                            $txtCls             = ( $txtkey != $current ) ? ' hidden' : '';
                            $txtvl              = $id.'-'.$txtkey;
                            $options[$txtvl]    = ( isset( $options[$txtvl] ) ) ? $options[$txtvl] : $std;
                            
                            echo '<input type="text" class="dep-field regular-text' . esc_attr($field_class) . $txtCls . '" id="' . esc_attr( $txtvl ) . '" placeholder="' . esc_attr( $std ) . '" 
                            name="'. ('munza_theme_options['. $txtvl .']') .'" value="'. esc_attr( sanitize_text_field( $options[$txtvl] ) ) .'" />';
                         }
                         echo '<div class="lang_hint">'.esc_html__('You Are Editing in Language ', 'munza').'( <strong>'.$lang.'</strong> )</div>';
                    } else {
                        echo '<input type="text" class="dep-field regular-text' . esc_attr( $field_class ) . '" id="' . esc_attr( $id ) . '" name="munza_theme_options[' . esc_attr( $id ) . ']" 
                        placeholder="' . esc_attr( sanitize_text_field( $std ) ) . '" value="' . esc_attr( sanitize_text_field( $options[$id] ) ) . '" />'; 
                    }
                echo '</div>';
                break;
                
            case 'textarea':
                 echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                     if ( $is_lang ) {

                         foreach ( $languages as $areakey => $areavl ) {
                            $areaCls             = ( $areakey != $current ) ? ' hidden' : '';
                            $areavl             = $id.'-'.$areakey;
                            $options[$areavl]   = ( isset( $options[$areavl] ) ) ? $options[$areavl] : $std;
                            
                            echo '<textarea class="regular-text txtArea' . esc_attr($field_class) . $areaCls . '" placeholder="' . esc_attr($std) . '" name="'. ('munza_theme_options['. $areavl .']') .'" 
                            rows="5" cols="30">' . format_for_editor( $options[$areavl] ) . '</textarea>';
                         }
                         echo '<div class="lang_hint">'.esc_html__('You Are Editing in Language ', 'munza').'( <strong>'.$lang.'</strong> )</div>';
                     } else {
                        echo '<textarea class="regular-text txtArea' . esc_attr($field_class) . '" id="' . esc_attr($id) . '" name="munza_theme_options[' . esc_attr($id) . ']" placeholder="' . esc_attr($std) . '" 
                        rows="5" cols="30">' . format_for_editor( $options[$id] ) . '</textarea>'; 
                     }
                 echo '</div>';
                 break;
            
            case 'number':
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    echo '<div class="slidernum" data-min="' . $min . '" data-max="' . $max . '"></div>';
                    if ( $is_lang ) {
                        foreach ( $languages as $numkey => $numvl ) {
                            $numCls             = ( $numkey != $current ) ? ' hidden' : '';
                            $numvl              = $id.'-'.$numkey;
                            $options[$numvl]    = ( isset( $options[$numvl] ) ) ? $options[$numvl] : $std;

                            echo '<input class="regular-text num-txt' . esc_attr($field_class) . $numCls . '" id="' . esc_attr( $numvl ) . '" type="number" placeholder="' . esc_attr( $std ) . '" 
                            name="'. ('munza_theme_options['. $numvl .']') .'" value="'. esc_attr( sanitize_text_field( $options[$numvl] ) ) .'" />';
                        }
                        echo '<div class="lang_hint">'.esc_html__('You Are Editing in Language ', 'munza').'( <strong>'.$lang.'</strong> )</div>';
                    } else {
                        
                        echo '<input class="regular-text num-txt' . esc_attr($field_class) . '" type="number" id="' . esc_attr($id) . '" name="munza_theme_options[' . esc_attr($id) . ']" placeholder="' . esc_attr($std) . '" 
                        value="' . esc_attr( sanitize_text_field( $options[$id] ) ) . '" />';
                    }
                echo '</div>';
                break;
            
            case 'select':
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    if ( $is_lang ) {
                        foreach ( $languages as $selkey => $selvl ) {
                            $selvl           = $id.'-'.$selkey;
                            $selCls          = ( $selkey != $current ) ? ' hidden' : '';
                            $options[$selvl] = ( isset( $options[$selvl] ) ) ? $options[$selvl] : $std;
                            
                            echo '<select class="dep-field select' . esc_attr($field_class) . $selCls . '" id="' . esc_attr( $selvl) . '" name="'. ('munza_theme_options['. $selvl .']') .'">';
                                foreach ( $choices as $selvalue => $label )
                                
                                echo '<option value="' . esc_attr( $selvalue ) . '"' . selected( $options[$selvl], $selvalue, false ) . '>' . $label . '</option>';
                            echo '</select>';

                        }
                        echo '<div class="lang_hint">'.esc_html__('You Are Editing in Language ', 'munza').'( <strong>'.$lang.'</strong> )</div>';
                    } else {
                    
                        echo '<select class="dep-field select' . esc_attr($field_class) . '" id="' . esc_attr( $id ) . '" name="munza_theme_options[' . esc_attr($id) . ']">';
                            foreach ( $choices as $value => $label )
                            echo '<option value="' . esc_attr( $value ) . '"' . selected( $options[$id], $value, false ) . '>' . $label . '</option>';
                        echo '</select>';
                    }
                
                echo '</div>';
                break;
                
            case 'googlefonts':
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    echo '<select class="fontSel dep-field select' . esc_attr($field_class) . '"></select>';
                    if ( $is_lang ) {
                         foreach ( $languages as $txtkey => $txtvl ) {
                            $txtCls             = ( $txtkey != $current ) ? ' hidden' : '';
                            $txtvl              = $id.'-'.$txtkey;
                            $options[$txtvl]    = ( isset( $options[$txtvl] ) ) ? $options[$txtvl] : $std;
                            
                            echo '<input type="hidden" class="font-hid" id="' . esc_attr( $txtvl ) . '" name="'. ('munza_theme_options['. $txtvl .']') .'" value="'. esc_attr( sanitize_text_field( $options[$txtvl] ) ) .'" />';
                         }
                         echo '<div class="lang_hint">'.esc_html__('You Are Editing in Language ', 'munza').'( <strong>'.$lang.'</strong> )</div>';
                    } else {
                        echo '<input type="hidden" class="font-hid" id="' . esc_attr( $id ) . '" name="munza_theme_options[' . esc_attr( $id ) . ']" value="' . esc_attr( sanitize_text_field( $options[$id] ) ) . '" />'; 
                    }
                echo '</div>';
                break;
                
            case 'editor':                
                echo '<div class="wp-ed group" data-parent="'.esc_attr($parent).'">';
                    if ( $is_lang ) {
                         foreach ( $languages as $edkey => $edvl ) {
                            $edclass            = ( $edkey == $current ) ? '' : ' class="hidden"';
                            $edvl               = $id.'-'.$edkey;
                            $options[$edvl]     = ( isset( $options[$edvl] ) ) ? $options[$edvl] : $std;
                            $content            = $options[$edvl];
                            $editor_settings    = array(
                                'textarea_name' => 'munza_theme_options[' . $edvl . ']',
                                'textarea_rows' => 30,
                                'tinymce'       => false
                            );
                            echo '<div'.$edclass.'>';
                                echo wp_editor( $content, $edvl , $editor_settings );
                            echo '</div>';
                         }
                        echo '<div class="lang_hint">'.esc_html__('You Are Editing in Language ', 'munza').'( <strong>'.$lang.'</strong> )</div>';
                    } else {
                        $content         = $options[$id];
                        $editor_settings = array(
                            'textarea_name' => 'munza_theme_options[' . esc_attr($id) . ']',
                            'textarea_rows' => 30,
                            'tinymce'       => false
                        ); 
                        echo wp_editor( $content, $id, $editor_settings );
                    }
                echo '</div>';
                break;
            
            case 'radio':
                $i = 0;
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    foreach ( $choices as $value => $label ) {
                        echo '<div class="radio-select"><img class="head-img" src="'.ITR_FRAMEWORK_ASSETS_URI.'/images/" >
                        <input class="radio'. esc_attr($field_class) .'" type="radio" name="munza_theme_options['. esc_attr($id) .']" id="'. esc_attr($id) . $i .'" value="'. esc_attr( $value ) .'" '. checked( $options[$id], $value, false ) .'> 
                        <label for="'. esc_attr($id) . $i .'">'. $label .'</label></div>';
                            if ( $i < count( $options ) - 1 )
                            $i++;
                    }
                echo '</div>';
                break;
                
            case 'radioimages':
                $i = 0;
                echo '<div class="group" data-parent="'.esc_attr($parent).'">'; 
                    foreach ( $choices as $value => $label ) {
                        $src = substr($label, strpos($label, "|") + 1);
                        $til = strstr($label, '|', true);
                        echo '<div class="radio-select">
                        <input class="radio-inp'. esc_attr($field_class) .'" type="radio" name="munza_theme_options['. esc_attr($id) .']" id="'. esc_attr($id) . $i .'" value="'. esc_attr( $value ) .'" '. checked( $options[$id], $value, false ) .'> 
                        <img class="radio-img" data-tip="'.$til.'" src="'.$src.'" ></div>';
                            if ( $i < count( $options ) - 1 )
                            $i++;
                    }
                    echo '<input class="rad_val hidden' . esc_attr($field_class) . '" id="' . esc_attr($id) . '" type="text" name="munza_theme_options[' . esc_attr($id) . ']" placeholder="' . esc_attr($std) . '" value="' . esc_attr( $options[$id] ) . '" />';
                echo '</div>';
                break;
            
            case 'twonumber':
                $firstVal = explode('|', esc_attr( $options[$id] ));
                $lastVal = substr(esc_attr( $options[$id] ), strpos(esc_attr( $options[$id] ), "|") + 1);
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    echo '<b class="inp_lbl main-color">'.$firstInput.'</b><input class="regular-text num-txt no-slider firstVL" type="number" value="' . $firstVal[0] . '" />';
                    echo '<b class="inp_lbl last main-color">'.$lastInput.'</b><input class="regular-text num-txt no-slider lastVL" type="number" value="' . $lastVal . '" />';
                    echo '<input class="hid_two_num' . esc_attr($field_class) . '" type="hidden" id="' . esc_attr($id) . '" name="munza_theme_options[' . esc_attr($id) . ']" value="' . esc_attr( sanitize_text_field( $options[$id] ) ) . '" />';
                echo '</div>';
                break;
                             
            case 'gradientpicker':
                 echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    echo '<div id="colpic_'.$id.'" data-name="munza_theme_options[' . esc_attr($id) . ']"></div>';
                    echo '<textarea class="hidden regular-text txtArea' . esc_attr($field_class) . '" id="' . esc_attr($id) . '" name="munza_theme_options[' . esc_attr($id) . ']" placeholder="' . esc_attr($std) . '" 
                    rows="5" cols="30">' . format_for_editor( $options[$id] ) . '</textarea>'; 
                 echo '</div>';
                 break;
                         
            case 'color':
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    echo '<input class="color-chooser'. esc_attr($field_class) .'" type="text"  data-alpha="true" id="' . esc_attr($id) . '" name="munza_theme_options[' . esc_attr($id) . ']" 
                    placeholder="' . esc_attr($std) . '" value="' . esc_attr( sanitize_text_field( $options[$id] ) ) . '"  data-default-color="' . $defcolor . '" />';
                echo '</div>';
                break;
                
            case 'gradient':
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                echo '<div class="grad_wrapper">';
                    echo '<div class="gradpic">
                    <div class="grad_tools">
                        <select class="gtype"> 
                            <option selected="selected" value="linear">'.esc_html__( "Linear", "munza" ).'</option>
                            <option value="radial">'.esc_html__( "Radial", "munza" ).'</option>
                        </select>
                        <select class="gposition">
                            <option selected="selected" value="left">'.esc_html__( "Left", "munza" ).'</option>
                            <option value="right">'.esc_html__( "Right", "munza" ).'</option>
                            <option value="top">'.esc_html__( "Top", "munza" ).'</option>
                            <option value="bottom">'.esc_html__( "Bottom", "munza" ).'</option>
                        </select>
                    </div>
                </div>
                <textarea class="hidden grad_vl ' . esc_attr($field_class) . '" placeholder="'.esc_attr($std).'" name="munza_theme_options[' . esc_attr($id) . ']" value="' . esc_attr( sanitize_text_field( $options[$id] ) ) . '" 
                data-vl="' . esc_attr( sanitize_text_field( $options[$id] ) ) . '">
                </textarea>
                </div></div>';    
                break;
                 
            case 'file':
                echo '<div class="group ' . esc_attr($field_class) . '" data-parent="'.esc_attr($parent).'">';
                    echo '<input class="dep-field regular-text custom-up'. esc_attr($field_class) .'" id="' . esc_attr($id) . '" type="text" name="munza_theme_options[' . esc_attr($id) . ']" placeholder="' . esc_attr($std) . '" value="' . esc_attr( $options[$id] ) . '" />';
                    echo '<a class="upload_image_button" href="#"></a>';
                    echo '<span class="clear-img"><img class="logo-im" alt="'.esc_attr(esc_html__('Upload', 'munza')).'" src="'. esc_url( wp_get_attachment_url( $options[$id] ) ) .'" /><a class="remove-img" href="#" title="'.esc_attr(esc_html__('Remove Image', 'munza')).'"></a></span>';
                echo '</div>';
                break;
            
            case 'upload':
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    echo '<input class="dep-field regular-text custom-up'. esc_attr($field_class) .'" id="' . esc_attr($id) . '" type="text" name="munza_theme_options[' . esc_attr($id) . ']" placeholder="' . esc_attr($std) . '" value="' . esc_attr( $options[$id] ) . '" />';
                    echo '<a href="#" class="remove-val"></a><a class="upload_button" href="#">'.esc_html__('Upload', 'munza').'</a>';
                echo '</div>';
                break;
            
            case 'uploadfont':
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    echo '<input class="dep-field regular-text custom-up'. esc_attr($field_class) .'" id="' . esc_attr($id) . '" type="text" name="munza_theme_options[' . esc_attr($id) . ']" placeholder="' . esc_attr($std) . '" value="' . esc_attr( $options[$id] ) . '" />';
                    echo '<a href="#" class="remove-font"></a><a class="upload_font_button" href="#" data-orig-text="'.esc_html__('Upload', 'munza').'">'.esc_html__('Upload', 'munza').'</a>';
                echo '</div>';
                break;
                
            case 'arrayItems':
                echo '<div class="group" data-parent="'.esc_attr($parent).'">'; 
                    echo '<div class="patterns-div' . esc_attr($field_class) . '"><input class="hidden' . esc_attr($field_class) . '" id="' . esc_attr($id) . '" type="text" name="munza_theme_options[' . esc_attr($id) . ']" 
                    placeholder="' . esc_attr($std) . '" value="' . esc_attr( $options[$id] ) . '" />';
                        foreach ( $items as $value => $label )
                        echo '<img src="' . esc_attr( $value ) . '" class="pattern-img" />';
                    echo '</div>';
                echo '</div>';
                break;
                
            case 'arraySelect':
                echo '<div class="dep-field group arraySelect" data-parent="'.esc_attr($parent).'">'; 
                    echo '<div class="' . esc_attr($field_class) . '">';
                        echo '<select class="dep-field hiddenSelect hidden' . esc_attr($field_class) . '" id="' . esc_attr( $id ) . '" name="munza_theme_options[' . esc_attr($id) . ']">';
                            foreach ( $choices as $value => $label )
                                echo '<option value="' . esc_attr( $value ) . '"' . selected( $options[$id], $value, false ) . '>' . $label . '</option>';
                        echo '</select>';    
                            
                        foreach ( $choices as $value => $label )
                        echo '<div class="sel_block" data-hover="'.$value.'"><img src="' . esc_attr( $label ) . '" data-value="'.$value.'" class="select-img" /></div>';
                    echo '</div>';
                echo '</div>';
                break;
                
            case 'icon':
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    echo '<i class="ico"></i><a class="button btn_icon" href="#"><i class="stline-add"></i>'.esc_html__('Add Icon', 'munza').'</a>';
                    echo '<input type="hidden" name="munza_theme_options[' . esc_attr($id) . ']" id="' . esc_attr($id) . '" class="icon_cust '. esc_attr($field_class) .'" value="' . esc_attr( $options[$id] ) . '" />';
                    echo '<a class="button icon-remove" title="'.esc_attr(esc_html__('Remove Icon', 'munza')).'"><i class="stline-close"></i></a>';
                echo '</div>';
                break;
            
            case 'addbox':
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    echo '<div class="add_btn"><a class="button button-default add_box" href="#"><i class="stline-add"></i>'.esc_html__('Add New', 'munza').'</a>';
                    echo '<input class="hid_txt' . esc_attr($field_class) . '" type="hidden" id="' .$id. '" name="munza_theme_options[' . esc_attr($id) . ']" value="' . esc_attr( $options[$id] ) . '" /></div>';
                echo '</div>';
                break;
                
            case 'addmodule':
                echo '<div class="group" data-parent="'.esc_attr($parent).'">';
                    echo '<div class="add_mod"><a class="button button-default add_module" href="#"><i class="stline-add"></i>'.esc_html__('Add Module', 'munza').'</a>';
                    echo '<input class="hid_txt' . esc_attr($field_class) . '" type="hidden" id="' .$id. '" name="'.'munza_theme_options[' . esc_attr($id) . ']" value="' . esc_attr( $options[$id] ) . '" /></div>';
                echo '</div>';
                break;
            
            case 'import_data':
                echo '<div class="group ' . esc_attr($field_class) . '" data-parent="'.esc_attr($parent).'">';
                    echo '<a class="button button-primary btn-success import_btn" href="#"><i class="stline-arrow-double-down"></i>'.esc_html__('Import Demo Data', 'munza').'<span class="loader"><i class="stline-loading-2">
                    </i></span><span class="import_success"><i class="stline-check-double"></i></span></a>';
                    echo '<div class="import_message"></div><div class="noticeImp">'.esc_html__('This can take several minutes, please wait and do not worry!', 'munza').'</div>';
                    echo '<div class="attachments"><input type="checkbox" name="' . esc_attr($id) . '" id="' . esc_attr($id) . '" value="1"' . checked( $options[$id], 1, false ) .'/>  '.esc_html__('Download and import file attachments!', 'munza').'</div>';
                echo '</div>';
                break; 
                        
        }
    }
    
    public function itr_get_options() {
        global $wpdb;
        return $wpdb->get_results($wpdb->prepare( "SELECT option_name, option_value FROM {$wpdb->options} WHERE option_name='%s'" , "munza_theme_options" ));
    }
    
    public function itr_get_option() {
        require_once( get_parent_theme_file_path('it-framework/config/it-framework-config.php') );
    }        
    
    public function itr_settings_sections( $page ) {
        global $wp_settings_sections, $wp_settings_fields;

        if ( ! isset( $wp_settings_sections[$page] ) )
            return;
            
        foreach ( (array) $wp_settings_sections[$page] as $section ) {

            if ( $section['callback'] )
                call_user_func( $section['callback'], $section );

            if ( ! isset( $wp_settings_fields ) || !isset( $wp_settings_fields[$page] ) || !isset( $wp_settings_fields[$page][$section['id']] ) )
                continue;
            echo '<div class="itr-tabs-panel" id="'.$section['id'].'">';
                if ( $section['title'] ) echo "<h3>{$section['title']}</h3>";
                $this->itr_settings_fields( $page, $section['id'] );
            echo '</div>';
        }         
    }

    public function itr_settings_fields($page, $section) {
        global $wp_settings_fields;
        
        if ( ! isset( $wp_settings_fields[$page][$section] ) )
            return;
        
        foreach ( (array) $wp_settings_fields[$page][$section] as $field ) {
            
            $grp            = $field['args']['group'];
            $parnt          = $field['args']['parent'];
            $dd             = $field['args']['id'];
            $typ            = $field['args']['type'];   
            $dependency     = $field['args']['dependency'];
            $parentcls      = $field['args']['parentclass'];
            $parent_class   = ( $parentcls != '' ) ? ' '.$parentcls : ''; 
             
            if ( empty($field['args']['desc']) ) {
                $mid = ' middle';
            } else {
                $mid = '';
            }          
            // dependencies.
            $cm = $dep_element = $dep_value = $em_arr = $vll = $ell = '';  
            foreach ( $dependency as $key => $value ) {
                
                $dp = $dependency['element'];
                $v = isset( $dependency['value'] ) ? $dependency['value'] : '';
                $em = isset( $dependency['not_empty'] ) ? $dependency['not_empty'] : '';
                
                if( is_array($dp)){
                    $ard = array();
                    foreach ($dp as $el){
                        $ard[] .= $cm . $el;
                        $cm = ',';
                    }
                    $dep_element = " data-dep='".trim(implode('', $ard), ',')."'";
                }else{
                    $dep_element = " data-dep='".$dp."'";
                }
                
                if( is_array($v)){
                    $ar = array();
                    foreach ($v as $vl){
                        $ar[] = $cm . $vl;
                        $cm = ',';
                    }
                    $dep_value = " data-vl='".trim(implode('', $ar), ',')."'";
                }else{
                    $dep_value = " data-vl='".$v."'";
                }
                
                if ( $em ){
                    $dep_element = " data-dep='".$dp."'";
                    if($em == true){
                       $dep_value = " data-vl='1'"; 
                    }else{
                        $dep_value = " data-vl=''";
                    }
                    
                }           
            }
            
            if ($typ != 'heading'){
                
                if ( $parnt ) {
                    echo '<div class="it-sec sub-section '.$parnt.$parent_class.'" data-id="'.$dd.'"'.$dep_element.$dep_value.'>';
                } else{
                    echo '<div class="it-sec section'.$parent_class.'" data-id="'.$dd.'"'.$dep_element.$dep_value.'>';
                }
                
                if ( !empty($field['title']) ) {
                    echo '<div class="lbl'.$mid.'">';
                    if ( !empty($field['args']['desc']) ) {
                        echo '<p class="description"><i class="stline-alert-diamond"></i><span class="desc_tip"><span>' . $field['args']['desc'] . '</span></span></p>';
                    }
                    echo '<label class="opt-lbl" for="' . esc_attr( $field['args']['label_for'] ) . '">' . $field['title'] . '</label>';
                    echo '</div>';
                }    
            }
            
            call_user_func($field['callback'], $field['args']);
            if ($typ != 'heading') echo '</div>';
            
        } 
    }
    
    public function itr_validate_settings( $input ) { 
        $options = get_option( 'munza_theme_options' );
        
        if ( isset( $_POST['reset'] ) ) {
            return $this->itr_get_default_values();
        }else{
            return $input;
        }
    }
    
    public function itr_get_default_values() {
        $output = array();
        foreach ( (array) $this->settings as $option ) {
            if ( ! isset( $option['id'] ) ) {
                continue;
            }
            if ( ! isset( $option['std'] ) ) {
                continue;
            }
            if ( ! isset( $option['type'] ) ) {
                continue;
            }
            if ( has_filter( 'of_sanitize_' . $option['type'] ) ) {
                $output[$option['id']] = apply_filters( 'of_sanitize_' . $option['type'], $option['std'], $option );
            }
        }
        return $output;
    } 
    
    public function itr_export_settings() {
        if (isset($_GET['action']) && ($_GET['action'] == 'download')) {
            header("Cache-Control: public, must-revalidate");
            header("Pragma: hack");
            header("Content-Type: text/plain");
            header('Content-Disposition: attachment; filename="theme-options-'.date("d-m-Y").'.txt"');
            echo serialize($this->itr_get_options());
            die();
        }
    }
    
    public function itr_enq_scripts() {
        wp_enqueue_script('jquery-ui-tabs');
        wp_enqueue_script('media-upload');
        wp_enqueue_media();
        wp_enqueue_script('wp-color-picker');
        wp_enqueue_script('it-assets',          ITR_FRAMEWORK_ASSETS_URI . '/js/assets.js',                     array('jquery'), null, true);
        wp_enqueue_script('it-framework',       ITR_FRAMEWORK_ASSETS_URI . '/js/framework.js',                  array('jquery'), null, true);
        wp_enqueue_script('itr-color-picker',   ITR_FRAMEWORK_ASSETS_URI . '/js/colorpicker.js',                array('jquery'), null, true);
        wp_enqueue_script('itr-gradient',       ITR_FRAMEWORK_ASSETS_URI . '/js/jquery.gradientPicker.js',      array('jquery'), null, true);
        
        wp_enqueue_style('it-assets',           ITR_FRAMEWORK_ASSETS_URI.'/css/assets.css');     
        wp_enqueue_style('it-framework',        ITR_FRAMEWORK_ASSETS_URI . '/css/framework.css' );
        wp_enqueue_style('wp-color-picker');       
    }
    
    public function itr_admin_icons(){
        require get_parent_theme_file_path ( 'it-framework/includes/fields/icons/icons.php' );    
    }
    
}
$itr_framewrk = new ITR_Framework();
