<?php 
/**
 *
 * IT-RAYS Framework
 *
 * @author IT-RAYS
 * @license Commercial License
 * @link http://www.it-rays.net
 * @copyright 2016 IT-RAYS Themes
 * @package ITFramework
 * @version 1.0.0
 *
 */
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );
 
class ITR_MetaBoxes {
      
    public $itr_meta_box;
    public $itr_fields;
    public $itr_sections;               

    public function __construct ( $meta_box ) {
          
        $this->itr_meta_box = $meta_box;
        
        $this->itr_sections['itr_general']              = '<i class="stline-cog"></i>'.esc_html__('General Settings','munza');
        $this->itr_sections['itr_topbar']               = '<i class="stline-layout-agenda"></i>'.esc_html__('Top Bar','munza');        
        $this->itr_sections['itr_header']               = '<i class="stline-layout-top"></i>'.esc_html__('Header','munza');
        $this->itr_sections['itr_pagetitles']           = '<i class="stline-pencil-write"></i>'.esc_html__('Page Title','munza');
        $this->itr_sections['itr_footer']               = '<i class="stline-award-badge-2"></i>'.esc_html__('Footer','munza');

        add_action( 'add_meta_boxes', array( $this, 'itr_add_meta_boxes' ) );
        add_action( 'save_post', array( $this, 'itr_save_meta_boxes' ) );

    }

    public function itr_add_meta_boxes( ) {
        
        $post_types = array('post','page','product','raysgridpost','forum','topic');
        
        foreach ( $post_types as $post_type ) {
            add_meta_box( $this->itr_meta_box["id"], $this->itr_meta_box["title"], array( $this, 'itr_show_meta_boxes' ),$post_type, 'normal', 'high' );
        }
        
    }

    public function itr_show_meta_boxes() {
        
        echo '<span class="hidden page_settings_title">'.esc_html__('Custom Page Settings', 'munza').'</span>';
        wp_nonce_field( 'itr_meta_box_nonce', 'itr_meta_box_nonce' );        
        echo '<div class="theme-options">';
            echo '<div class="itr-tabs">';
                echo '<ul class="itr-tabs-nav">';
                    foreach ( $this->itr_sections as $section_slug => $section ){
                        echo '<li><a href="#' . esc_attr($section_slug) . '">' . $section . '</a></li>';
                    }
                echo '</ul>';
                
                echo '<div class="itr_tabs_wrap">';
                    foreach ( $this->itr_sections as $section_slug => $section ) {
                        echo '<div class="itr-tabs-panel" id="'.esc_attr($section_slug).'">';
                            $this->itr_sets_field($section_slug);
                        echo '</div>';
                    }
                echo '</div>';
            echo '</div>';
        echo '</div>';
          
  }
  
    public function itr_sets_field ( $section_slug ){
        global $post;
        foreach ( $this->itr_fields as $field ) {
            $meta = get_post_meta( $post->ID, $field['id'], true );
            $meta = ( $meta !== '' ) ? $meta : $field['std'];
            if( $field['section'] == $section_slug) call_user_func ( array( $this, 'itr_field_type_' . $field['type'] ), $field, $meta );        
        }
    }
  
    public function itr_wrapper_start( $field, $meta) {
        
        $grp        = isset($field['group']) ? $field['group'] : '';
        $parnt      = isset($field['parent']) ? $field['parent'] : '';
        $dd         = isset($field['id']) ? $field['id'] : '';
        $typ        = isset($field['type']) ? $field['type'] : '';  
        $dependency = isset($field['dependency']) ? $field['dependency'] : ''; 
        $mid        = ( empty($field['desc']) ) ? ' middle' : '';
      
        // dependencies.
        $cm = $dep_element = $dep_value = $em_arr = $vll = $ell = '';  
        if($dependency){
            foreach ( $dependency as $key => $value ) {
                
                $dp = $dependency['element'];
                $v = isset( $dependency['value'] ) ? $dependency['value'] : '';
                $em = isset( $dependency['not_empty'] ) ? $dependency['not_empty'] : '';
                
                if( is_array($dp)){
                    $ard = array();
                    foreach ($dp as $el){
                        $ard[] .= $cm . $el;
                        $cm = ',';
                    }
                    $dep_element = " data-dep='".trim(implode('', $ard), ',')."'";
                }else{
                    $dep_element = " data-dep='".$dp."'";
                }
                
                if( is_array($v)){
                    $ar = array();
                    foreach ($v as $vl){
                        $ar[] = $cm . $vl;
                        $cm = ',';
                    }
                    $dep_value = " data-vl='".trim(implode('', $ar), ',')."'";
                }else{
                    $dep_value = " data-vl='".$v."'";
                }
                
                if ( $em ){
                    $dep_element = " data-dep='".$dp."'";
                    if($em == true){
                       $dep_value = " data-vl='1'"; 
                    }else{
                        $dep_value = " data-vl=''";
                    }
                    
                }           
            }    
        }
        
        echo "<div class='it-sec section' data-id='{$field["id"]}'{$dep_element}{$dep_value}>";
        
        if ( isset($field['name']) && $field['name'] != '' ) {
          echo "<div class='lbl".$mid."'>";
            if ( isset($field['desc']) && $field['desc'] != '' ){
                echo "<p class='description'><i class='stline-alert-diamond'></i><span class='desc_tip'><span>{$field['desc']}</span></span></p>";    
            }
            echo "<label for='{$field['id']}' class='opt-lbl'>{$field['name']}</label>";
          echo "</div>";
        }
        
    }

    public function itr_wrapper_end( $field, $meta) {
        echo "</div>";
    }
    
    public function itr_field_type_text( $field, $meta) {  
        $this->itr_wrapper_start( $field, $meta );
            echo "<div class='group'><input type='text' id='".$field["id"]."' class='dep-field regular-text".( isset($field['class'])? ' ' . $field['class'] : '' )."' name='".$field['id']."' value='".esc_attr($meta)."' /></div>"; 
        $this->itr_wrapper_end( $field, $meta );
    }
    
    public function itr_field_type_number( $field, $meta) {  
        $this->itr_wrapper_start( $field, $meta );
            echo "<div class='group'><input type='number' id='".$field["id"]."' class='regular-text num-txt".( isset($field['class'])? ' ' . $field['class'] : '' )."' name='".$field['id']."' value='".esc_attr($meta)."' /></div>"; 
        $this->itr_wrapper_end( $field, $meta );
    }
    
    public function itr_field_type_twonumber( $field, $meta) {  
        $std = '';
        $this->itr_wrapper_start( $field, $meta );
            echo "<div class='group'>";
                $firstVal = explode('|', esc_attr( $meta ));
                $lastVal = substr(esc_attr( $meta ), strpos(esc_attr( $meta ), "|") + 1);
                echo '<b class="inp_lbl main-color">'.$field['firstInput'].'</b><input class="regular-text num-txt no-slider firstVL" type="number" value="' . esc_attr($firstVal[0]) . '" />';
                echo '<b class="inp_lbl last main-color">'.$field['lastInput'].'</b><input class="regular-text num-txt no-slider lastVL" type="number" value="' . esc_attr($lastVal) . '" />';
                echo '<input class="hid_two_num' . ( isset($field['class'])? ' ' . $field['class'] : '' ) . '" type="hidden" id="' . esc_attr($field["id"]) . '" name="'.esc_attr($field['id']).'" value="' . esc_attr($meta) . '" />';
            
            echo "</div>"; 
        $this->itr_wrapper_end( $field, $meta );
    }

    public function itr_field_type_select( $field, $meta ) {

        if ( ! is_array( $meta ) ) 
          $meta = (array) $meta;
          
        $this->itr_wrapper_start( $field, $meta );
            echo "<div class='group'><select id='".esc_attr($field["id"])."' class='dep-field select".( isset($field['class'])? ' ' . $field['class'] : '' )."' name='".esc_attr($field['id'])."'>";
                foreach ( $field['options'] as $key => $value ) {
                    echo "<option value='".esc_attr($key)."'" . selected( in_array( $key, $meta ), true, false ) . ">".$value."</option>";
                }
            echo "</select></div>";
        $this->itr_wrapper_end( $field, $meta );

    }
    
    public function itr_field_type_menus( $field, $meta ) {

        if ( ! is_array( $meta ) ) 
          $meta = (array) $meta;
          
        $this->itr_wrapper_start( $field, $meta );
            echo "<div class='group'><select id='".esc_attr($field["id"])."' class='dep-field select".( isset($field['class'])? ' ' . $field['class'] : '' )."' name='".esc_attr($field['id'])."'>";
                $menus = get_registered_nav_menus();
                echo "<option value=''>-- ".esc_html__('Choose Menu','munza')." --</option>";
                foreach ( $menus as $key => $value ) {
                    echo "<option value='".esc_attr($key)."'" . selected( in_array( $key, $meta ), true, false ) . ">".$value."</option>";
                }
            echo "</select></div>";
        $this->itr_wrapper_end( $field, $meta );

    }
    
    public function itr_field_type_sidebars( $field, $meta ) {
        global $wp_registered_sidebars;
        if ( ! is_array( $meta ) ) 
          $meta = (array) $meta;
          
        $this->itr_wrapper_start( $field, $meta );
            echo "<div class='group'><select id='".esc_attr($field["id"])."' class='select".( isset($field['class'])? ' ' . $field['class'] : '' )."' name='".esc_attr($field['id'])."'>";
                echo "<option value=''>".esc_html__( '-- Select Sidebar --', 'munza' )."</option>";
                foreach ( $wp_registered_sidebars as $sidebar_id => $sidebar ) {
                    echo "<option value='".esc_attr($sidebar_id)."'" . selected( in_array( $sidebar_id, $meta ), true, false ) . ">".$sidebar['name']."</option>";
                }
            echo "</select></div>";
        $this->itr_wrapper_end( $field, $meta );

    }

    public function itr_field_type_radio( $field, $meta ) {

        if ( ! is_array( $meta ) )
          $meta = (array) $meta;
          
        $this->itr_wrapper_start( $field, $meta );
          echo "<div class='group'>";
            foreach ( $field['options'] as $key => $value ) {
            echo "<input type='radio' id='".$field["id"]."' class='radio".( isset($field['class'])? ' ' . $field['class'] : '' )."' name='".$field['id']."' value='".$key."'" . checked( in_array( $key, $meta ), true, false ) . " /> <span class='at-radio-label'>{$value}</span>";
          }
          echo "</div>";
        $this->itr_wrapper_end( $field, $meta );
    }
    
    public function itr_field_type_radioimages( $field, $meta ) {

        $this->itr_wrapper_start( $field, $meta );
        $i = 0;
        echo "<div class='group'>";
            foreach ( $field['choices'] as $key => $value ) {
                $src = substr($value, strpos($value, "|") + 1);
                $til = strstr($value, '|', true);
                echo "<div class='radio-select'><input class='radio-inp' type='radio' value='{$key}' /><img class='radio-img' data-tip='".$til."' src='".$src."' ></div>";
                if ( $i < count( $field['choices'] ) - 1 )$i++;
            }
            echo "<input type='text' id='".$field["id"]."' class='dep-field regular-text rad_val hidden radioimages ".( isset($field['class'])? ' ' . $field['class'] : '' )."' name='".$field['id']."' value='".$meta."' />";
        echo "</div>";
        $this->itr_wrapper_end( $field, $meta );
        
    }

    public function itr_field_type_checkbox( $field, $meta ) {

        $this->itr_wrapper_start($field, $meta);
        echo "<div class='group'><input type='hidden' id='".$field["id"]."' class='dep-field checktxt".( isset($field['class'])? ' ' . $field['class'] : '' )."' value='".$meta."' name='".$field['id']."' /><span class='it_bx custom-checkbox'><span class='switcher'></span></span></div>";
        $this->itr_wrapper_end( $field, $meta );
      
    }

    public function itr_field_type_file( $field, $meta ) {
        $this->itr_wrapper_start( $field, $meta );

        $data_type = isset($field["data-type"]) ? ( $field['data-type'] ) : '';
        
        if ( $data_type == 'video'){
            
            echo "<div class='group upload_video ".$field["id"]."'><input type='text' id='".$field["id"]."' class='custom-up regular-text".( isset($field['class'])? ' ' . $field['class'] : '' )."'  name='".$field['id']."' value='".$meta."' />
            <a href='#' class='remove-val'></a><a href='#' class='upload_button'>".esc_html__('Upload', 'munza')."</a></div>";
            
        }else{
            
            echo "<div class='group'><input type='text' id='".$field["id"]."' class='dep-field custom-up regular-text".( isset($field['class'])? ' ' . $field['class'] : '' )."'  name='".$field['id']."' value='".$meta."' />
            <a href='#' class='upload_image_button'></a>
            <span class='clear-img'><img class='logo-im' alt='' src='".wp_get_attachment_url($meta)."' /><a class='remove-img' href='#' title='".esc_html__('Remove Image', 'munza')."'></a></span></div>";
             
        }
        
        $this->itr_wrapper_end( $field, $meta );
    }

    public function itr_field_type_color( $field, $meta ) {
          
        $this->itr_wrapper_start( $field, $meta );
        
            echo "<div class='group'><input type='text' id='".$field['id']."' data-alpha='true' class='color-chooser".(isset($field['class'])? " {$field['class']}": "")."' name='".$field['id']."' size='8' value='".$meta."' /></div>";  

        $this->itr_wrapper_end($field, $meta);

    }
    
    public function itr_field_type_gradient( $field, $meta ) {
          
        $this->itr_wrapper_start( $field, $meta );

            echo "<div class='group'><div class='grad_wrapper'>
                <div class='gradpic'>
                <div class='grad_tools'>
                    <select class='gtype'>
                        <option selected='selected' value='linear'>".esc_html__( 'Linear', 'munza' )."</option>
                        <option value='radial'>".esc_html__( 'Radial', 'munza' )."</option>
                    </select>
                    <select class='gposition'>
                        <option selected='selected' value='left'>".esc_html__( 'Left', 'munza' )."</option>
                        <option value='right'>".esc_html__( 'Right', 'munza' )."</option>
                        <option value='top'>".esc_html__( 'Top', 'munza' )."</option>
                        <option value='bottom'>".esc_html__( 'Bottom', 'munza' )."</option>
                    </select>
                </div>
            </div>
            <textarea id='".$field['id']."' class='hidden grad_vl ".(isset($field['class'])? " {$field['class']}": "")."' name='".$field['id']."' value='".$meta."' data-vl='".$meta."'></textarea>
            </div></div>";    
            
            
        $this->itr_wrapper_end($field, $meta);

    }
    
    public function itr_field_type_icon( $field, $meta ) {
        $this->itr_wrapper_start( $field, $meta );
        echo "<div class='group'><i class='ico'></i>
        <a class='button button-primary btn_icon' href='#'><i class='fa fa-plus-square'></i>".esc_html__('Add Icon', 'munza')."</a>
        <input type='hidden' name='".$field['id']."' id='".$field['id']."' class='icon_cust ".( isset($field['class'])? ' ' . $field['class'] : '' )."' value='".$meta."' />
        <a class='button icon-remove' title='".esc_html__('Remove Icon', 'munza')."'><i class='fa fa-times'></i></a></div>";
        $this->itr_wrapper_end( $field, $meta );
    } 
    
    public function itr_type_textbox( $id, $args ){
        $new_field = array('type' => 'text','id'=> $id,'std' => '','desc' => '','name' => '');
        $new_field = array_merge($new_field, $args);
        $this->itr_fields[] = $new_field;
    }
    
    public function itr_type_numberbox( $id, $args ){
        $new_field = array('type' => 'number','id'=> $id,'std' => '','desc' => '','name' => '');
        $new_field = array_merge($new_field, $args);
        $this->itr_fields[] = $new_field;
    }
    
    public function itr_type_twonumber( $id, $args ){
        $new_field = array('type' => 'twonumber','id'=> $id,'std' => '','desc' => '','name' => '');
        $new_field = array_merge($new_field, $args);
        $this->itr_fields[] = $new_field;
    }
    
    public function itr_type_checkbox( $id, $args ){
        $new_field = array('type' => 'checkbox','id'=> $id,'std' => '','desc' => '','name' => '');
        $new_field = array_merge($new_field, $args);
        $this->itr_fields[] = $new_field;
    }

    public function itr_type_select( $id, $options, $args ){
        $new_field = array('type' => 'select','id'=> $id,'std' => array(),'desc' => '','name' => '','options' => $options);
        $new_field = array_merge($new_field, $args);
        $this->itr_fields[] = $new_field;
    }
    
    public function itr_type_menus( $id, $args ){
        $new_field = array('type' => 'menus','id'=> $id,'std' => array(),'desc' => '','name' => '');
        $new_field = array_merge($new_field, $args);
        $this->itr_fields[] = $new_field;
    }
    
    public function itr_type_sidebars( $id, $args ){
        $new_field = array('type' => 'sidebars','id'=> $id,'std' => array(),'desc' => '','name' => '');
        $new_field = array_merge($new_field, $args);
        $this->itr_fields[] = $new_field;
    }

    public function itr_type_radio( $id, $options, $args ){
        $new_field = array('type' => 'radio','id'=> $id,'std' => array(),'desc' => '','name' => '','options' => $options);
        $new_field = array_merge($new_field, $args);
        $this->itr_fields[] = $new_field;
    }
    
    public function itr_type_radioimages( $id, $args ){
        $new_field = array('type' => 'radioimages','id'=> $id,'std' => '','desc' => '','name' => '');
        $new_field = array_merge($new_field, $args);
        $this->itr_fields[] = $new_field;
    }

    public function itr_type_color( $id, $args ){
        $new_field = array('type' => 'color','id'=> $id,'std' => '','desc' => '','name' => '');
        $new_field = array_merge($new_field, $args);
        $this->itr_fields[] = $new_field;
    }
    
    public function itr_type_gradient( $id, $args ){
        $new_field = array('type' => 'gradient','id'=> $id,'std' => '','desc' => '','name' => '');
        $new_field = array_merge($new_field, $args);
        $this->itr_fields[] = $new_field;
    }

    public function itr_type_uploadfile( $id, $args ){
        $new_field = array('type' => 'file','id'=> $id,'std' => '','desc' => '','name' => '');
        $new_field = array_merge($new_field, $args);
        $this->itr_fields[] = $new_field;
    }
    
    public function itr_type_icon( $id, $args ){
        $new_field = array('type' => 'icon','id'=> $id,'std' => '','desc' => '','name' => '');
        $new_field = array_merge($new_field, $args);
        $this->itr_fields[] = $new_field;
    }
      
    public function itr_save_meta_boxes( $post_id ) {
                
        if( defined( 'DOING_AUTOSAVE' ) && DOING_AUTOSAVE ) return;
         
        if( !isset( $_POST['itr_meta_box_nonce'] ) || !wp_verify_nonce( $_POST['itr_meta_box_nonce'], 'itr_meta_box_nonce' ) ) return;
         
        if( !current_user_can( 'edit_post' ) ) return;
        
        foreach ( $this->itr_fields as $field ) {
            $name = $field['id'];
            $type = $field['type'];
            $current_val = get_post_meta( $post_id, $name, true );
            $new_val = ( isset( $_POST[$name] ) ) ? $_POST[$name] : ( ( $field['std'] ) ? array() : '' );
            $save_func = 'save_field_' . $type;
            $this->itr_save_field( $post_id, $field, $current_val, $new_val );
        }
        
    }
     
    public function itr_save_field( $post_id, $field, $current_val, $new_val ) {
        $name = $field['id'];
        delete_post_meta( $post_id, $name );
        if ( $new_val === '' || $new_val === array() ) return;
        update_post_meta( $post_id, $name, $new_val );
    }  

}
