<?php 
/**
 *
 * IT-RAYS Framework
 *
 * @author IT-RAYS
 * @license Commercial License
 * @link http://www.it-rays.net
 * @copyright 2017 IT-RAYS Themes
 * @package ITFramework
 * @version 1.0.0
 *
 */
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );
$options = get_option( 'munza_theme_options' );
/* Appearance
===========================================*/
$this->itr_settings['general_layout_heading'] = array(
    'section' => 'it_appearance',
    'desc'    => esc_html__('General Settings','munza'),
    'type'    => 'heading',
    'data_id' => 'layout-opt-acc'
);
$this->itr_settings['layout'] = array(
    'title'   => esc_html__( 'Choose layout', 'munza' ),
    'desc'    => esc_html__( 'This option define the main site container box to be Boxed or wide.', 'munza' ),
    'section' => 'it_appearance',
    'type'    => 'radioimages',
    'choices' => array(
        ''      => esc_html__('Wide Layout','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/theme_wide.png',
        'boxed' => esc_html__('Boxed Layout','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/theme_boxed.png',
    )
);
$this->itr_settings['main_width'] = array(
    'title'   => esc_html__( 'Site Width (px)', 'munza' ),
    'desc'    => esc_html__( 'Define the main site content width in px.', 'munza' ),
    'std'     => '1170',
    'min'     => '0',
    'max'     => '2000',
    'type'    => 'number',
    'section' => 'it_appearance',
);
$this->itr_settings['sidebar_width'] = array(
    'title'   => esc_html__( 'Sidebar Width (%)', 'munza' ),
    'desc'    => esc_html__( 'Define the sidebar content width in %.', 'munza' ),
    'std'     => '25',
    'min'     => '0',
    'max'     => '100',
    'type'    => 'number',
    'section' => 'it_appearance',
);
$this->itr_settings['content_padding'] = array(
    'title'   => esc_html__( 'Content Padding (px)', 'munza' ),
    'desc'    => esc_html__( 'Top and Bottom main content padding in px.', 'munza' ),
    'std'     => '',
    'firstInput' => '<i class="stline-arrow-up"></i>',
    'lastInput' => '<i class="stline-arrow-down"></i>',
    'type'    => 'twonumber',
    'section' => 'it_appearance',
);
$this->itr_settings['tags_limit'] = array(
    'title'   => esc_html__( 'Tags Limit', 'munza' ),
    'desc'    => esc_html__( 'Number of tags  displayed in widgets.', 'munza' ),
    'std'     => '10',
    'min'     => '0',
    'max'     => '50',
    'type'    => 'number',
    'section' => 'it_appearance',
);
$this->itr_settings['show_top'] = array(
    'title'   => esc_html__( 'Back To Top Button', 'munza' ),
    'desc'    => esc_html__('"ON" to show the back to top button at the bottom of the page when scrolling down.', 'munza'),
    'type'    => 'checkbox',
    'std'     => '1',
    'section' => 'it_appearance',
);
$this->itr_settings['body_smooth'] = array(
    'section' => 'it_appearance',
    'title'   => esc_html__( 'Smooth Scrolling', 'munza' ),
    'desc'    => esc_html__( '"ON" to enable smooth scrolling in the site.', 'munza' ),
    'type'    => 'checkbox',
);
$this->itr_settings['img_placeholder'] = array(
    'section' => 'it_appearance',
    'title'   => esc_html__( 'Image Placeholders', 'munza' ),
    'desc'    => esc_html__( '"ON" to show default image for posts that not having featured image.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => ''
);
$this->itr_settings['loader-heading'] = array(
    'section' => 'it_appearance',
    'desc'    => esc_html__('Page Loader','munza'),
    'type'    => 'heading',
    'data_id' => 'loader-head-acc'
);
$this->itr_settings['page_loader'] = array(
    'section' => 'it_appearance',
    'title'   => esc_html__( 'Page Pre-Loader', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
    'desc'    => esc_html__( 'Enable / Disable Page preloader.', 'munza' )
);
$this->itr_settings['loader_bg'] = array(
    'title'   => esc_html__( 'Body Background color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_appearance',
    'dependency' => array(
        'element' => 'page_loader',
        'not_empty' => true
    )
);
$this->itr_settings['page_loader_style'] = array(
    'title'   => esc_html__( 'Pre-loader Style', 'munza' ),
    'desc'    => esc_html__( 'Select a preloading style that appears before page completely loaded.', 'munza' ),
    'type'    => 'select',
    'section' => 'it_appearance',
    'choices' => array(
        '1'         => esc_html__('Loading Bar 1','munza'),
        '2'         => esc_html__('Loading Bar 2','munza'),
        '3'         => esc_html__('Falling Circles','munza'),
        'img'       => esc_html__('Upload Image','munza')
    ),
    'dependency' => array(
        'element' => 'page_loader',
        'not_empty' => true
    )
);
$this->itr_settings['loaderimage'] = array(
    'title'   => esc_html__( 'Loading image', 'munza' ),
    'desc'    => esc_html__( 'Choose Image from the media Library.', 'munza' ),
    'type'    => 'file',
    'section' => 'it_appearance',
    'dependency' => array(
        'element' => 'page_loader_style',
        'value' => 'img'
    )
);
$this->itr_settings['loader_bar_forecolor'] = array(
    'title'   => esc_html__( 'Animated Bar color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_appearance',
    'dependency' => array(
        'element' => 'page_loader',
        'not_empty' => true
    )
);
$this->itr_settings['loader_bar_bg'] = array(
    'title'   => esc_html__( 'Bar Background color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_appearance',
    'dependency' => array(
        'element' => 'page_loader',
        'not_empty' => true
    )
);
$this->itr_settings['loadertext'] = array(
    'title'   => esc_html__( 'Loading Text', 'munza' ),
    'desc'    => esc_html__( 'Enter Loading text.', 'munza' ),
    'type'    => 'text',
    'section' => 'it_appearance',
    'dependency' => array(
        'element' => 'page_loader',
        'not_empty' => true
    )
);
$this->itr_settings['loader_text_color'] = array(
    'title'   => esc_html__( 'Loading Text Color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_appearance',
    'dependency' => array(
        'element' => 'loadertext',
        'not_empty' => true
    )
);
$this->itr_settings['skin-heading'] = array(
    'section' => 'it_appearance',
    'desc'    => esc_html__('Styling Options','munza'),
    'type'    => 'heading',
    'data_id' => 'skin-head-acc'
);
$this->itr_settings['skin_color'] = array(
    'title'   => esc_html__( 'Main Site color', 'munza' ),
    'desc'    => esc_html__( 'Choose the main color scheme from this color pallete the color suits your needs.', 'munza' ),
    'std'     => '#ef2674',
    'type'    => 'color',
    'section' => 'it_appearance',
    'defcolor' => '#ef2674'
);
$this->itr_settings['bodyfontcolor'] = array(
    'title'   => esc_html__( 'Body Font color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_appearance',
);
$this->itr_settings['bodylinkscolor'] = array(
    'title'   => esc_html__( 'Body Links color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_appearance',
);
$this->itr_settings['bodybgcolor'] = array(
    'title'   => esc_html__( 'Body background color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_appearance',
); 
$this->itr_settings['bodybgimage'] = array(
    'title'   => esc_html__( 'Body Background image', 'munza' ),
    'desc'    => esc_html__( 'Choose Image from the media Library.', 'munza' ),
    'type'    => 'file',
    'section' => 'it_appearance',
);
$this->itr_settings['body_bg_img_repeat'] = array(
    'title'   => esc_html__( 'Background repeat', 'munza' ),
    'desc'    => esc_html__( 'How the background image repeats.', 'munza' ),
    'type'    => 'select',
    'section' => 'it_appearance',
    'class'   => 'select_boxes',
    'choices' => array(
        ''          => esc_html__('Repeat','munza'),
        'no-repeat' => esc_html__('No Repeat','munza'),
        'repeat-x'  => esc_html__('Repeat X','munza'),
        'repeat-y'  => esc_html__('Repeat Y','munza')
    ),
    'dependency' => array(
        'element' => 'bodybgimage',
        'not_empty' => true
    )
);
$this->itr_settings['body_bg_position'] = array(
    'title'   => esc_html__( 'Background Position', 'munza' ),
    'type'    => 'select',
    'section' => 'it_appearance',
    'choices' => array(
        '0 0'       => esc_html__('Left Top','munza'),
        '0 50%'     => esc_html__('Left Middle','munza'),
        '0 100%'    => esc_html__('Left Bottom','munza'),
        '50% 0'     => esc_html__('Center Top','munza'),
        '50% 50%'   => esc_html__('Center Middle','munza'),
        '50% 100%'  => esc_html__('Center Right','munza'),
        '100% 0'    => esc_html__('Right Top','munza'),
        '100% 50%'  => esc_html__('Right Middle','munza'),
        '100% 100%' => esc_html__('Right Bottom','munza'),
    ),
    'std'   => '0 100%',
    'dependency' => array(
        'element' => 'bodybgimage',
        'not_empty' => true
    )
);
$this->itr_settings['body_bg_size'] = array(
    'title'   => esc_html__( 'Background Size', 'munza' ),
    'type'    => 'select',
    'section' => 'it_appearance',
    'class'   => 'select_boxes',
    'choices' => array(
        'inherit'   => esc_html__('Inherit','munza'),
        'cover'     => esc_html__('Cover','munza'),
        'contain'   => esc_html__('Contain','munza'),
        '100% 100%' => '100%',
    ),
    'dependency' => array(
        'element' => 'bodybgimage',
        'not_empty' => true
    )
);
$this->itr_settings['body_bg_img_parallax'] = array(
    'title'   => esc_html__( 'Fixed Background', 'munza' ),
    'type'    => 'checkbox',
    'section' => 'it_appearance',
    'dependency' => array(
        'element' => 'bodybgimage',
        'not_empty' => true
    )
);

/* 404 */
$this->itr_settings['page-404-heading'] = array(
    'section' => 'it_appearance',
    'desc'    => esc_html__('404 Page Settings','munza'),
    'type'    => 'heading',
    'data_id' => '404-head-acc'
);
$this->itr_settings['bg_404_color'] = array(
    'title'   => esc_html__( 'Background color', 'munza' ),
    'desc'    => esc_html__( 'Choose the main color scheme from this color pallete the color suits your needs.', 'munza' ),
    'std'     => '#fff',
    'type'    => 'color',
    'section' => 'it_appearance',
);
$this->itr_settings['bg_404_disable'] = array(
    'section' => 'it_appearance',
    'title'   => esc_html__( 'Disable Default background image', 'munza' ),
    'type'    => 'checkbox',
);
$this->itr_settings['bgimage404'] = array(
    'title'   => esc_html__( 'Body Background image', 'munza' ),
    'desc'    => esc_html__( 'Choose Image from the media Library.', 'munza' ),
    'type'    => 'file',
    'section' => 'it_appearance',
);
$this->itr_settings['bg_img_404_repeat'] = array(
    'title'   => esc_html__( 'Background repeat', 'munza' ),
    'desc'    => esc_html__( 'How the background image repeats.', 'munza' ),
    'type'    => 'select',
    'section' => 'it_appearance',
    'class'   => 'select_boxes',
    'choices' => array(
        ''          => esc_html__('Repeat','munza'),
        'no-repeat' => esc_html__('No Repeat','munza'),
        'repeat-x'  => esc_html__('Repeat X','munza'),
        'repeat-y'  => esc_html__('Repeat Y','munza')
    ),
    'dependency' => array(
        'element' => 'bgimage404',
        'not_empty' => true
    )
);
$this->itr_settings['bg_404_position'] = array(
    'title'   => esc_html__( 'Background Position', 'munza' ),
    'type'    => 'select',
    'section' => 'it_appearance',
    'choices' => array(
        '0 0'       => esc_html__('Left Top','munza'),
        '0 50%'     => esc_html__('Left Middle','munza'),
        '0 100%'    => esc_html__('Left Bottom','munza'),
        '50% 0'     => esc_html__('Center Top','munza'),
        '50% 50%'   => esc_html__('Center Middle','munza'),
        '50% 100%'  => esc_html__('Center Right','munza'),
        '100% 0'    => esc_html__('Right Top','munza'),
        '100% 50%'  => esc_html__('Right Middle','munza'),
        '100% 100%' => esc_html__('Right Bottom','munza'),
    ),
    'std'   => '0 100%',
    'dependency' => array(
        'element' => 'bgimage404',
        'not_empty' => true
    )
);
$this->itr_settings['bg_404_size'] = array(
    'title'   => esc_html__( 'Background Size', 'munza' ),
    'type'    => 'select',
    'section' => 'it_appearance',
    'class'   => 'select_boxes',
    'choices' => array(
        'inherit'   => esc_html__('Inherit','munza'),
        'cover'     => esc_html__('Cover','munza'),
        'contain'   => esc_html__('Contain','munza'),
        '100% 100%' => '100%',
    ),
    'dependency' => array(
        'element' => 'bgimage404',
        'not_empty' => true
    )
);
$this->itr_settings['head_404_color'] = array(
    'title'   => esc_html__( 'Header Links color', 'munza' ),
    'desc'    => esc_html__( 'Choose the main color scheme from this color pallete the color suits your needs.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_appearance',
);
$this->itr_settings['head_404_icons_color'] = array(
    'title'   => esc_html__( 'Header Icons color', 'munza' ),
    'desc'    => esc_html__( 'Choose the main color scheme from this color pallete the color suits your needs.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_appearance',
);
$this->itr_settings['head_404_hover_color'] = array(
    'title'   => esc_html__( 'Header Hover color', 'munza' ),
    'desc'    => esc_html__( 'Choose the main color scheme from this color pallete the color suits your needs.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_appearance',
);
$this->itr_settings['head_404_bgcolor'] = array(
    'title'   => esc_html__( 'Header Background color', 'munza' ),
    'desc'    => esc_html__( 'Choose the main color scheme from this color pallete the color suits your needs.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_appearance',
);
$this->itr_settings['logo404'] = array(
    'title'   => esc_html__( 'Custom Logo', 'munza' ),
    'desc'    => esc_html__( 'Choose Image from the media Library.', 'munza' ),
    'type'    => 'file',
    'section' => 'it_appearance',
);

/* Top Bar Settings
==========================================*/ 
$this->itr_settings['top-bar-heading'] = array(
    'section' => 'it_topbar',
    'desc'    => esc_html__( 'Top Bar', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'top-bar-acc'
);
$this->itr_settings['show_top_bar'] = array(
    'section' => 'it_topbar',
    'title'   => esc_html__( 'Show top bar', 'munza' ),
    'desc'    => esc_html__( 'Show/Hide top bar above header.', 'munza' ),
    'type'    => 'checkbox',
);

// left top bar
$this->itr_settings['top_left_mod'] = array(
    'section' => 'it_topbar',
    'title'   => esc_html__( 'Top Bar Left', 'munza' ),
    'type'    => 'addmodule',
    'class'   => 'left_top_bar',
    'std'     => '0',
    'dependency' => array(
        'element' => 'show_top_bar',
        'not_empty' => true
    ),
);

$ltopbar = isset($options['top_left_mod']) ? $options['top_left_mod'] : 0;        
for( $e = 0 ; $e <= $ltopbar ; $e++ ) {
    $this->itr_settings['top_bar_left_'.$e] = array(
        'type'    => 'select',
        'class'   => 'selVal top_bar_left_'.$e,
        'section' => 'it_topbar',
        'choices' => array(
            ''              => esc_html__('-- Select Box --','munza'),
            'menu'          => esc_html__('Menu','munza'),
            'text'          => esc_html__('Text','munza'),
            'link'          => esc_html__('Link','munza'),
            'socials'       => esc_html__('Social Icons','munza'),
            'search'        => esc_html__('Search','munza'),
            'login'         => esc_html__('WP Login','munza'),
            'woocart'       => esc_html__('Shopping Cart','munza'),
            'wpml'          => esc_html__('Language Switcher (WPML)','munza'),
        ),
        'parent'    => 'top_left_mod'
    );
    
    // menu
    $this->itr_settings['top_left_menu_'.$e] = array(
        'title'   => esc_html__( 'Choose Menu', 'munza' ),
        'type'    => 'select',
        'section' => 'it_topbar',
        'parent'   => 'top_bar_left_'.$e,
        'choices' => itr_site_menu(),
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'menu'
        ),
    );
    $this->itr_settings['top_left_menu_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'menu'
        ),
    );
    $this->itr_settings['top_left_menu_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'menu'
        ),
    );
    
    // text
    $this->itr_settings['top_left_text_icon_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Icon', 'munza' ),
        'desc'    => esc_html__( 'choose icon.', 'munza' ),
        'multilang' => true,
        'type'    => 'icon',
        'parent'   => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'text'
        ),
    );
    $this->itr_settings['top_left_text_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Text', 'munza' ),
        'desc'    => esc_html__( 'Add text to be displayed in the left top bar.', 'munza' ),
        'multilang' => true,
        'type'    => 'text',
        'parent'   => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'text'
        ),
    );
    $this->itr_settings['top_left_text_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'text'
        ),
    );
    $this->itr_settings['top_left_text_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'text'
        ),
    );
    
    // link
    $this->itr_settings['top_left_link_icon_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Icon', 'munza' ),
        'desc'    => esc_html__( 'choose icon.', 'munza' ),
        'multilang' => true,
        'type'    => 'icon',
        'parent'   => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'link'
        ),
    );
    $this->itr_settings['top_left_link_text_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Text', 'munza' ),
        'desc'    => esc_html__( 'Add text to be displayed in the link.', 'munza' ),
        'multilang' => true,
        'type'    => 'text',
        'parent'   => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'link'
        ),
    );
    $this->itr_settings['top_left_link_url_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Link URL', 'munza' ),
        'desc'    => esc_html__( 'Add link url.', 'munza' ),
        'type'    => 'text',
        'multilang' => true,
        'parent'   => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'link'
        ),
    );
    $this->itr_settings['top_left_link_target_'.$e] = array(
        'title'   => esc_html__( 'Target', 'munza' ),
        'type'    => 'select',
        'section' => 'it_topbar',
        'choices' => array(
            ''        => esc_html__('Same Page','munza'),
            '_blank'  => esc_html__('New Window','munza'),
        ),
        'parent'    => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'link'
        ),
    );
    $this->itr_settings['top_left_link_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar',
        'parent'    => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'link'
        ),
    );
    $this->itr_settings['top_left_link_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'link'
        ),
    );
    $this->itr_settings['top_left_link_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'link'
        ),
    );
                
    // social icons
    $this->itr_settings['top_left_socials_txt_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Social icons text before', 'munza' ),
        'desc'    => esc_html__( 'text before Social icons.', 'munza' ),
        'type'    => 'text',
        'multilang' => true,
        'parent'   => 'top_bar_left_'.$e,
        'std'     => esc_html__('Follow us on: ','munza'),
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'socials'
        ),
    );
    $this->itr_settings['top_left_socials_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'socials'
        ),
    );
    $this->itr_settings['top_left_socials_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'socials'
        ),
    );  
    
    // search
    $this->itr_settings['top_left_search_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'search'
        ),
    );
    $this->itr_settings['top_left_search_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'search'
        ),
    );
    
    // login
    $this->itr_settings['top_left_login_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'login'
        ),
    );
    
    // woocart
    $this->itr_settings['top_left_woocart_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'woocart'
        ),
    );
    $this->itr_settings['top_left_woocart_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'woocart'
        ),
    );
    
    // wpml
    $this->itr_settings['top_left_wpml_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'wpml'
        ),
    );
    $this->itr_settings['top_left_wpml_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_left_'.$e,
        'dependency' => array(
            'element' => 'top_bar_left_'.$e,
            'value' => 'wpml'
        ),
    );  
    
}

// right top bar
$this->itr_settings['top_right_mod'] = array(
    'section' => 'it_topbar',
    'title'   => esc_html__( 'Top Bar Right', 'munza' ),
    'type'    => 'addmodule',
    'class'   => 'right_top_bar',
    'std'     => '0',
    'dependency' => array(
        'element' => 'show_top_bar',
        'not_empty' => true
    ),
); 
$rtopbar = isset($options['top_right_mod']) ? $options['top_right_mod'] : 0;        
for( $e = 0 ; $e <= $rtopbar ; $e++ ) {
    $this->itr_settings['top_bar_right_'.$e] = array(
        'type'    => 'select',
        'class'     => 'selVal',
        'section' => 'it_topbar',
        'choices' => array(
            ''              => esc_html__('-- Select Box --','munza'),
            'menu'          => esc_html__('Menu','munza'),
            'text'          => esc_html__('Text','munza'),
            'link'          => esc_html__('Link','munza'),
            'socials'       => esc_html__('Social Icons','munza'),
            'search'        => esc_html__('Search','munza'),
            'login'         => esc_html__('WP Login','munza'),
            'woocart'       => esc_html__('Shopping Cart','munza'),
            'wpml'          => esc_html__('Language Switcher (WPML)','munza'),
        ),
        'parent'    => 'top_right_mod'
    );
    
    // menu
    $this->itr_settings['top_right_menu_'.$e] = array(
        'title'   => esc_html__( 'Choose Menu', 'munza' ),
        'type'    => 'select',
        'section' => 'it_topbar',
        'parent'   => 'top_bar_right_'.$e,
        'choices' => itr_site_menu(),
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'menu'
        ),
    );
    $this->itr_settings['top_right_menu_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'menu'
        ),
    );
    $this->itr_settings['top_right_menu_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'menu'
        ),
    );
    
    // text
    $this->itr_settings['top_right_text_icon_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Icon', 'munza' ),
        'desc'    => esc_html__( 'choose icon.', 'munza' ),
        'multilang' => true,
        'type'    => 'icon',
        'parent'   => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'text'
        ),
    );
    $this->itr_settings['top_right_text_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Text', 'munza' ),
        'desc'    => esc_html__( 'Add text to be displayed in the left top bar.', 'munza' ),
        'multilang' => true,
        'type'    => 'text',
        'parent'   => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'text'
        ),
    );
    $this->itr_settings['top_right_text_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'text'
        ),
    );
    $this->itr_settings['top_right_text_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'text'
        ),
    );
    
    // link
    $this->itr_settings['top_right_link_icon_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Icon', 'munza' ),
        'desc'    => esc_html__( 'choose icon.', 'munza' ),
        'multilang' => true,
        'type'    => 'icon',
        'parent'   => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'link'
        ),
    );
    $this->itr_settings['top_right_link_text_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Text', 'munza' ),
        'desc'    => esc_html__( 'Add text to be displayed in the link.', 'munza' ),
        'multilang' => true,
        'type'    => 'text',
        'parent'   => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'link'
        ),
    );
    $this->itr_settings['top_right_link_url_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Link URL', 'munza' ),
        'desc'    => esc_html__( 'Add link url.', 'munza' ),
        'type'    => 'text',
        'multilang' => true,
        'parent'   => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'link'
        ),
    );
    $this->itr_settings['top_right_link_target_'.$e] = array(
        'title'   => esc_html__( 'Target', 'munza' ),
        'type'    => 'select',
        'section' => 'it_topbar',
        'choices' => array(
            ''        => esc_html__('Same Page','munza'),
            '_blank'  => esc_html__('New Window','munza'),
        ),
        'parent'    => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'link'
        ),
    );
    $this->itr_settings['top_right_link_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar',
        'parent'    => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'link'
        ),
    );
    $this->itr_settings['top_right_link_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'link'
        ),
    );
    $this->itr_settings['top_right_link_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'link'
        ),
    );
                
    // social icons
    $this->itr_settings['top_right_socials_txt_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Social icons text before', 'munza' ),
        'desc'    => esc_html__( 'text before Social icons.', 'munza' ),
        'type'    => 'text',
        'multilang' => true,
        'parent'   => 'top_bar_right_'.$e,
        'std'     => esc_html__('Follow us on: ','munza'),
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'socials'
        ),
    );
    $this->itr_settings['top_right_socials_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'socials'
        ),
    );
    $this->itr_settings['top_right_socials_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'socials'
        ),
    );
    
    // search
    $this->itr_settings['top_right_search_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'search'
        ),
    );
    $this->itr_settings['top_right_search_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'search'
        ),
    );
    
    // login
    $this->itr_settings['top_right_login_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'login'
        ),
    );
    
    // woocart
    $this->itr_settings['top_right_woocart_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'woocart'
        ),
    );
    $this->itr_settings['top_right_woocart_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'woocart'
        ),
    );
    
    // wpml
    $this->itr_settings['top_right_wpml_css_'.$e] = array(
        'title'   => esc_html__( 'CSS Class', 'munza' ),
        'desc'    => esc_html__( 'Add extra class name, then go to : General Settings > Custom CSS & JS and add the new css code for this class.', 'munza' ),
        'type'    => 'text',
        'section' => 'it_topbar', 
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'wpml'
        ),
    );
    $this->itr_settings['top_right_wpml_hide_'.$e] = array(
        'section' => 'it_topbar',
        'title'   => esc_html__( 'Hide ( if user is logged in )', 'munza' ),
        'type'    => 'checkbox',
        'parent'  => 'top_bar_right_'.$e,
        'dependency' => array(
            'element' => 'top_bar_right_'.$e,
            'value' => 'wpml'
        ),
    );
    
}

// styling...
$this->itr_settings['top-bar-styling'] = array(
    'section' => 'it_topbar',
    'desc'    => esc_html__( 'Styling', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'tb-style-acc'
);
$this->itr_settings['topbar_color'] = array(
    'title'   => esc_html__( 'Color', 'munza' ),
    'type'    => 'select',
    'class'   => 'select_boxes',
    'section' => 'it_topbar',
    'choices' => array(
        'light'     => esc_html__('Light','munza'),
        'gry-bg'    => esc_html__('Grey','munza'),
        'main-bg'   => esc_html__('Colored','munza'),
        'dark-bg'   => esc_html__('Dark','munza'),
        'custom'    => esc_html__('Custom','munza'),
    ),
    'std' => 'light'
);
$this->itr_settings['barcolor'] = array(
    'title'   => esc_html__( 'Text color', 'munza' ),
    'desc'    => esc_html__( 'Color of the top bar elements', 'munza' ),
    'type'    => 'color',
    'section' => 'it_topbar',
    'dependency' => array(
        'element' => 'topbar_color',
        'value' => 'custom'
    ),
);
$this->itr_settings['barhovercolor'] = array(
    'title'   => esc_html__( 'Links Hover color', 'munza' ),
    'desc'    => esc_html__( 'Color of the top bar elements on Hover', 'munza' ),
    'type'    => 'color',
    'section' => 'it_topbar',
    'dependency' => array(
        'element' => 'topbar_color',
        'value' => 'custom'
    ),
);
$this->itr_settings['bariconcolor'] = array(
    'title'   => esc_html__( 'Icons color', 'munza' ),
    'desc'    => esc_html__( 'Color of the top bar Icons', 'munza' ),
    'type'    => 'color',
    'section' => 'it_topbar',
    'dependency' => array(
        'element' => 'topbar_color',
        'value' => 'custom'
    ),
);
$this->itr_settings['barbgcolor'] = array(
    'title'   => esc_html__( 'Background color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_topbar',
    'dependency' => array(
        'element' => 'topbar_color',
        'value' => 'custom'
    ),
);
$this->itr_settings['bar_image'] = array(
    'section' => 'it_topbar',
    'title'   => esc_html__( 'Background Image', 'munza' ),
    'desc'    => esc_html__( 'Select or insert image url.', 'munza' ),
    'type'    => 'file',
    'dependency' => array(
        'element' => 'topbar_color',
        'value' => 'custom'
    ),
);
$this->itr_settings['bar_img_repeat'] = array(
    'title'   => esc_html__( 'Background repeat', 'munza' ),
    'desc'    => esc_html__( 'How the background image repeats.', 'munza' ),
    'type'    => 'select',
    'section' => 'it_topbar',
    'class'   => 'select_boxes',
    'choices' => array(
        '' => 'Repeat',
        'no-repeat' => esc_html__('No Repeat','munza'),
        'repeat-x'  => esc_html__('Repeat X','munza'),
        'repeat-y'  => esc_html__('Repeat Y','munza')
    ),
    'dependency' => array(
        'element' => 'bar_image',
        'not_empty' => true
    )
);
$this->itr_settings['bar_bg_size'] = array(
    'title'   => esc_html__( 'Background Size', 'munza' ),
    'type'    => 'select',
    'section' => 'it_topbar',
    'class'   => 'select_boxes',
    'choices' => array(
        'inherit'   => esc_html__('Inherit','munza'),
        'cover'     => esc_html__('Cover','munza'),
        'contain'   => esc_html__('Contain','munza'),
        '100% 100%' => '100%',
    ),
    'dependency' => array(
        'element' => 'bar_image',
        'not_empty' => true
    )
);
$this->itr_settings['bar_full'] = array(
    'section' => 'it_topbar',
    'title'   => esc_html__( 'Full Width ?', 'munza' ),
    'desc'    => esc_html__( 'Make top bar in full width.', 'munza' ),
    'type'    => 'checkbox', 
); 
$this->itr_settings['topbar_border'] = array(
    'section' => 'it_topbar',
    'title'   => esc_html__( 'Bottom Border ?', 'munza' ),
    'desc'    => esc_html__( 'Yes to add bottom border for top bar.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1'
);
$this->itr_settings['topbar_border_color'] = array(
    'title'   => esc_html__( 'Border color', 'munza' ),
    'desc'    => esc_html__( 'Choose a color for tob bar bottom border color.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_topbar',
);
$this->itr_settings['topbar_devices'] = array(
    'section' => 'it_topbar',
    'title'   => esc_html__( 'Show on Small Screens', 'munza' ),
    'desc'    => esc_html__( 'Display top bar in Small Screens.', 'munza' ),
    'type'    => 'checkbox',
);

/* Header Settings
==========================================*/

$this->itr_settings['header-layouts-heading'] = array(
    'section' => 'it_header',
    'desc'    => esc_html__( 'Header', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'hed-layout-acc'
);
$this->itr_settings['header_style'] = array(
    'title'   => esc_html__( 'Choose header layout', 'munza' ),
    'desc'    => esc_html__( 'Choose header layout from the below:', 'munza' ),
    'section' => 'it_header',
    'class'   => 'select_boxes',
    'type'    => 'select',
    'choices' => array(
        'classic'   => esc_html__('Classic','munza'),
        'modern'    => esc_html__('Modern','munza'),
        'creative'  => esc_html__('Creative','munza'),
        'side'      => esc_html__('Side','munza'),
    ),
    'std'   => 'classic'
);
$this->itr_settings['header_left_area'] = array(
    'title'   => esc_html__( 'Left Area', 'munza' ),
    'desc'    => esc_html__( 'Choose header left area element', 'munza' ),
    'section' => 'it_header',
    'class'   => 'select_boxes',
    'dependency' => array(
        'element'   => 'header_style',
        'value'     => 'modern'
    ),
    'type'    => 'select',
    'choices' => array(
        'logo'   => esc_html__('Logo','munza'),
        'menu'   => esc_html__('Menu','munza'),
        'icons'  => esc_html__('Icons','munza'),
        'button' => esc_html__('Button','munza'),
        'none'   => esc_html__('None','munza')
    ),
    'std'   => 'logo'
);
$this->itr_settings['header_left_area_menu'] = array(
    'title'   => esc_html__( 'Choose Menu', 'munza' ),
    'type'    => 'select',
    'section' => 'it_header',
    'choices' => itr_site_menu(),
    'dependency' => array(
        'element' => 'header_left_area',
        'value' => 'menu'
    ),
);
$this->itr_settings['header_left_btn_color'] = array(
    'title'   => esc_html__( 'Button color', 'munza' ),
    'type'    => 'color',
    'std'     => '#fff',
    'section' => 'it_header',
    'dependency' => array(
        'element'   => 'header_left_area',
        'value'     => 'button'
    ),
);
$this->itr_settings['header_left_btn_bg_color'] = array(
    'title'   => esc_html__( 'Button Backgroound color', 'munza' ),
    'type'    => 'color',
    'std'     => '#ef2674',
    'section' => 'it_header',
    'dependency' => array(
        'element'   => 'header_left_area',
        'value'     => 'button'
    ),
);
$this->itr_settings['header_left_btn_text'] = array(
    'title'   => esc_html__( 'Button Text', 'munza' ),
    'type'    => 'text',
    'section' => 'it_header',
    'dependency' => array(
        'element' => 'header_left_area',
        'value' => 'button'
    ),
);
$this->itr_settings['header_left_btn_link'] = array(
    'title'   => esc_html__( 'Button Link', 'munza' ),
    'type'    => 'text',
    'section' => 'it_header',
    'dependency' => array(
        'element' => 'header_left_area',
        'value' => 'button'
    ),
);
$this->itr_settings['header_left_btn_target'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'New Window ?', 'munza' ),
    'type'    => 'checkbox',
    'dependency' => array(
        'element'   => 'header_left_area',
        'value'     => 'button'
    ), 
);
$this->itr_settings['header_center_area'] = array(
    'title'   => esc_html__( 'Center Area', 'munza' ),
    'desc'    => esc_html__( 'Choose header center area element', 'munza' ),
    'section' => 'it_header',
    'class'   => 'select_boxes',
    'type'    => 'select',
    'dependency' => array(
        'element'   => 'header_style',
        'value'     => 'modern'
    ),
    'choices' => array(
        'logo'   => esc_html__('Logo','munza'),
        'menu'   => esc_html__('Menu','munza'),
        'icons'  => esc_html__('Icons','munza'),
        'button' => esc_html__('Button','munza'),
        'none'   => esc_html__('None','munza')
    ),
    'std'   => 'menu'
);
$this->itr_settings['header_center_area_menu'] = array(
    'title'   => esc_html__( 'Choose Menu', 'munza' ),
    'type'    => 'select',
    'section' => 'it_header',
    'choices' => itr_site_menu(),
    'dependency' => array(
        'element' => 'header_center_area',
        'value' => 'menu'
    ),
);
$this->itr_settings['header_center_btn_color'] = array(
    'title'   => esc_html__( 'Button color', 'munza' ),
    'type'    => 'color',
    'std'     => '#fff',
    'section' => 'it_header',
    'dependency' => array(
        'element'   => 'header_center_area',
        'value'     => 'button'
    ),
);
$this->itr_settings['header_center_btn_bg_color'] = array(
    'title'   => esc_html__( 'Button Backgroound color', 'munza' ),
    'type'    => 'color',
    'std'     => '#ef2674',
    'section' => 'it_header',
    'dependency' => array(
        'element'   => 'header_center_area',
        'value'     => 'button'
    ),
);
$this->itr_settings['header_center_btn_text'] = array(
    'title'   => esc_html__( 'Button Text', 'munza' ),
    'type'    => 'text',
    'section' => 'it_header',
    'dependency' => array(
        'element' => 'header_center_area',
        'value' => 'button'
    ),
);
$this->itr_settings['header_center_btn_link'] = array(
    'title'   => esc_html__( 'Button Link', 'munza' ),
    'type'    => 'text',
    'section' => 'it_header',
    'dependency' => array(
        'element' => 'header_center_area',
        'value' => 'button'
    ),
);
$this->itr_settings['header_center_btn_target'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'New Window ?', 'munza' ),
    'type'    => 'checkbox',
    'dependency' => array(
        'element'   => 'header_center_area',
        'value'     => 'button'
    ), 
);
$this->itr_settings['header_right_area'] = array(
    'title'   => esc_html__( 'Right Area', 'munza' ),
    'desc'    => esc_html__( 'Choose header right area element', 'munza' ),
    'section' => 'it_header',
    'class'   => 'select_boxes',
    'type'    => 'select',
    'dependency' => array(
        'element'   => 'header_style',
        'value'     => 'modern'
    ),
    'choices' => array(
        'logo'   => esc_html__('Logo','munza'),
        'menu'   => esc_html__('Menu','munza'),
        'icons'  => esc_html__('Icons','munza'),
        'button' => esc_html__('Button','munza'),
        'none'   => esc_html__('None','munza')
    ),
    'std'   => 'icons'
);
$this->itr_settings['header_right_area_menu'] = array(
    'title'   => esc_html__( 'Choose Menu', 'munza' ),
    'type'    => 'select',
    'section' => 'it_header',
    'choices' => itr_site_menu(),
    'dependency' => array(
        'element' => 'header_right_area',
        'value' => 'menu'
    ),
);
$this->itr_settings['header_right_btn_color'] = array(
    'title'   => esc_html__( 'Button color', 'munza' ),
    'type'    => 'color',
    'std'     => '#fff',
    'section' => 'it_header',
    'dependency' => array(
        'element'   => 'header_right_area',
        'value'     => 'button'
    ),
);
$this->itr_settings['header_right_btn_bg_color'] = array(
    'title'   => esc_html__( 'Button Backgroound color', 'munza' ),
    'type'    => 'color',
    'std'     => '#ef2674',
    'section' => 'it_header',
    'dependency' => array(
        'element'   => 'header_right_area',
        'value'     => 'button'
    ),
);
$this->itr_settings['header_right_btn_text'] = array(
    'title'   => esc_html__( 'Button Text', 'munza' ),
    'type'    => 'text',
    'section' => 'it_header',
    'dependency' => array(
        'element' => 'header_right_area',
        'value' => 'button'
    ),
);
$this->itr_settings['header_right_btn_link'] = array(
    'title'   => esc_html__( 'Button Link', 'munza' ),
    'type'    => 'text',
    'section' => 'it_header',
    'dependency' => array(
        'element' => 'header_right_area',
        'value' => 'button'
    ),
);
$this->itr_settings['header_right_btn_target'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'New Window ?', 'munza' ),
    'type'    => 'checkbox',
    'dependency' => array(
        'element'   => 'header_right_area',
        'value'     => 'button'
    ), 
);
$this->itr_settings['side_dir'] = array(
    'title'   => esc_html__( 'Direction', 'munza' ),
    'desc'    => esc_html__( 'Choose side header direction:', 'munza' ),
    'section' => 'it_header',
    'class'   => 'select_boxes',
    'type'    => 'select',
    'choices' => array(
        'left'   => esc_html__('Left','munza'),
        'right'  => esc_html__('Right','munza'),
    ),
    'dependency' => array(
        'element'   => 'header_style',
        'value'     => 'side'
    ),
    'std'   => 'left'
);
$this->itr_settings['header-full'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'Full Width', 'munza' ),
    'type'    => 'checkbox',
    'dependency' => array(
        'element'   => 'header_style',
        'value'     => array( 'classic' , 'creative' , 'modern' )
    ), 
);
$this->itr_settings['header-fixed'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'Fixed ?', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
    'dependency' => array(
        'element'   => 'header_style',
        'value'     => array( 'classic' , 'creative' , 'modern' )
    ),
);
$this->itr_settings['head_visible'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'Invisible ?', 'munza' ),
    'desc'    => esc_html__( 'Yes to make the header invisible on load and show an icon.', 'munza' ),
    'type'    => 'checkbox',
    'dependency' => array(
        'element'   => 'header_style',
        'value'     => 'side'
    ),
);
$this->itr_settings['side_btn_color'] = array(
    'title'   => esc_html__( 'Button color', 'munza' ),
    'desc'    => esc_html__( 'Choose a color for side header button color.', 'munza' ),
    'type'    => 'color',
    'std'     => '#333',
    'section' => 'it_header',
    'dependency' => array(
        'element'   => 'head_visible',
        'value'     => '1'
    ),
);
$this->itr_settings['show_search'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'Show Search Button', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Search box in header.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1'
);
$this->itr_settings['srch_icon_color'] = array(
    'title'   => esc_html__( 'Icon color', 'munza' ),
    'desc'    => esc_html__( 'Choose a color for search button.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
    'std'     => '#ffffff',
    'parentclass' => 'four_cells',
    'dependency' => array(
        'element'   => 'show_search',
        'value'     => '1'
    ),
);
$this->itr_settings['srch_icon_hovcolor'] = array(
    'title'   => esc_html__( 'Icon Hover color', 'munza' ),
    'desc'    => esc_html__( 'Choose a color for search hover button.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
    'parentclass' => 'four_cells',
    'dependency' => array(
        'element'   => 'show_search',
        'value'     => '1'
    ),
);
$this->itr_settings['srch_icon_bgcolor'] = array(
    'title'   => esc_html__( 'Icon Background color', 'munza' ),
    'desc'    => esc_html__( 'Choose a background color for search button.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
    'parentclass' => 'four_cells',
    'dependency' => array(
        'element'   => 'show_search',
        'value'     => '1'
    ),
);
$this->itr_settings['srch_icon_border_color'] = array(
    'title'   => esc_html__( 'Icon Border color', 'munza' ),
    'desc'    => esc_html__( 'Choose a border color for search button.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
    'std'     => 'rgba(255,255,255,0.15)',
    'parentclass' => 'four_cells',
    'dependency' => array(
        'element'   => 'show_search',
        'value'     => '1'
    ),
);
$this->itr_settings['show_cart'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'Show Cart Button', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Cart box in header.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
    'dependency' => array(
        'element'   => 'header_style',
        'value'     => array( 'classic' , 'creative' , 'modern' )
    ),
);
$this->itr_settings['cart_icon_color'] = array(
    'title'   => esc_html__( 'Icon color', 'munza' ),
    'desc'    => esc_html__( 'Choose a color for cart button.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
    'std'     => '#ffffff',
    'parentclass' => 'four_cells',
    'dependency' => array(
        'element'   => 'show_cart',
        'value'     => '1'
    ),
);
$this->itr_settings['cart_icon_hovcolor'] = array(
    'title'   => esc_html__( 'Icon Hover color', 'munza' ),
    'desc'    => esc_html__( 'Choose a color for cart hover button.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
    'parentclass' => 'four_cells',
    'dependency' => array(
        'element'   => 'show_cart',
        'value'     => '1'
    ),
);
$this->itr_settings['cart_icon_bgcolor'] = array(
    'title'   => esc_html__( 'Icon Background color', 'munza' ),
    'desc'    => esc_html__( 'Choose a background color for cart button.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
    'parentclass' => 'four_cells',
    'dependency' => array(
        'element'   => 'show_cart',
        'value'     => '1'
    ),
);
$this->itr_settings['cart_icon_border_color'] = array(
    'title'   => esc_html__( 'Icon Border color', 'munza' ),
    'desc'    => esc_html__( 'Choose a border color for cart button.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
    'std'     => 'rgba(255,255,255,0.15)',
    'parentclass' => 'four_cells',
    'dependency' => array(
        'element'   => 'show_cart',
        'value'     => '1'
    ),
);
$this->itr_settings['show_head_socials'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'Show Social Icons ?', 'munza' ),
    'desc'    => esc_html__( 'Yes to social icons in the side header.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
    'dependency' => array(
        'element'   => array('header_style'),
        'value'     => 'side'
    ),
);
$this->itr_settings['show_head_copy'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'Left & Right Side Copyrights ?', 'munza' ),
    'desc'    => esc_html__( 'Enable this option to show copyrights in the left, right side headers only.', 'munza' ),
    'type'    => 'checkbox',
    'dependency' => array(
        'element'   => 'header_style',
        'value'     => 'side'
    ),
);
$this->itr_settings['head_copyrights'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'Copyrights Text', 'munza' ),
    'desc'    => esc_html__( 'Insert here the copyrights text to be shown in the left, right side headers only.', 'munza' ),
    'multilang' => true,
    'std' => '&copy; Copyrights 2019 <b class="main-color">munza</b> Co.',
    'type'    => 'editor',
    'dependency' => array(
        'element'   => 'show_head_copy',
        'not_empty' => true
    ),
);
$this->itr_settings['header-styling-heading'] = array(
    'section' => 'it_header',
    'desc'    => esc_html__( 'Styling', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'hed-style-acc'
);
$this->itr_settings['header_height'] = array(
    'title'   => esc_html__( 'Header Height', 'munza' ),
    'desc'    => esc_html__( 'Insert Header height in ( PX ).', 'munza' ),
    'std'     => '',
    'min'     => '0',
    'max'     => '700',
    'type'    => 'number',
    'section' => 'it_header',
    'dependency' => array(
        'element'   => 'header_style',
        'value'     => array( 'classic' , 'creative' )
    ),
);
$this->itr_settings['header_padding'] = array(
    'title'   => esc_html__( 'Header Padding', 'munza' ),
    'desc'    => esc_html__( 'Left and right Header content padding in px.', 'munza' ),
    'std'     => '|',
    'firstInput' => esc_html__('Left','munza'),
    'lastInput' => esc_html__('Right','munza'),
    'type'    => 'twonumber',
    'section' => 'it_header',
);
$this->itr_settings['nav_text_color'] = array(
    'title'   => esc_html__( 'Text color', 'munza' ),
    'desc'    => esc_html__( 'Choose a color for header text color including menu links color.', 'munza' ),
    'type'    => 'color',
    'std'     => '#e4c4ff',
    'section' => 'it_header',
);  
$this->itr_settings['nav_hover_color'] = array(
    'title'   => esc_html__( 'Links Hover color', 'munza' ),
    'desc'    => esc_html__( 'Choose a color for links hover color.', 'munza' ),
    'type'    => 'color',
    'std'     => '#ffffff',
    'section' => 'it_header',
);
$this->itr_settings['nav_hover_border_color'] = array(
    'title'   => esc_html__( 'Links Hover Border color', 'munza' ),
    'desc'    => esc_html__( 'Choose a color for links hover Border color.', 'munza' ),
    'type'    => 'color',
    'std'     => 'rgba(255,255,255,0.2)',
    'section' => 'it_header',
);
$this->itr_settings['nav_icon_color'] = array(
    'title'   => esc_html__( 'Menu Icons color', 'munza' ),
    'desc'    => esc_html__( 'Choose a color for main menu icons.', 'munza' ),
    'type'    => 'color',
    'std'     => '#ffffff',
    'section' => 'it_header',
);       
$this->itr_settings['nav_bg_color'] = array(
    'title'   => esc_html__( 'Background color', 'munza' ),
    'desc'    => esc_html__( 'Choose header background color.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
);
$this->itr_settings['nav_bor_top_color'] = array(
    'title'   => esc_html__( 'Border Top color', 'munza' ),
    'desc'    => esc_html__( 'Choose header top border color.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
);
$this->itr_settings['nav_bor_bot_color'] = array(
    'title'   => esc_html__( 'Border Bottom color', 'munza' ),
    'desc'    => esc_html__( 'Choose header bottom border color.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
);
$this->itr_settings['nav_image'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'Background Image', 'munza' ),
    'desc'    => esc_html__( 'Select or insert image url.', 'munza' ),
    'type'    => 'file',
);
$this->itr_settings['nav_img_full_width'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( '100% Background Image', 'munza' ),
    'desc'    => esc_html__( 'Display at 100% width and height.', 'munza' ),
    'type'    => 'checkbox',
    'dependency' => array(
        'element' => 'nav_image',
        'not_empty' => true
    )
);
$this->itr_settings['nav_img_repeat'] = array(
    'title'   => esc_html__( 'Background repeat', 'munza' ),
    'desc'    => esc_html__( 'How the background image repeats.', 'munza' ),
    'type'    => 'select', 
    'section' => 'it_header',
    'class'   => 'select_boxes',
    'choices' => array(
        ''          => esc_html__('Repeat','munza'),
        'no-repeat' => esc_html__('No Repeat','munza'),
        'repeat-x'  => esc_html__('Repeat X','munza'),
        'repeat-y'  => esc_html__('Repeat Y','munza')
    ),
    'dependency' => array(
        'element' => 'nav_image',
        'not_empty' => true
    )
); 
$this->itr_settings['nav_border_color'] = array(
    'title'   => esc_html__( 'Border color', 'munza' ),
    'desc'    => esc_html__( 'Choose header border color for modern Header ONLY.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
    'dependency' => array(
        'element' => 'header_style',
        'value' => 'modern'
    )
);
$this->itr_settings['nav_border_width'] = array(
    'title'   => esc_html__( 'Border Width', 'munza' ),
    'desc'    => esc_html__( 'Choose header border size in px.', 'munza' ),
    'std'     => '0',
    'min'     => '0',
    'max'     => '20',
    'type'    => 'number',
    'section' => 'it_header',
    'dependency' => array(
        'element' => 'header_style',
        'value' => 'modern'
    )
);   
    
$this->itr_settings['sticky_header'] = array(
    'section' => 'it_header',
    'desc'    => esc_html__( 'Sticky Header', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'sticky-acc'
);
$this->itr_settings['sticky_header_on'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'Enable Sticky Header', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['sticky_bg_color'] = array(
    'title'   => esc_html__( 'Background Color', 'munza' ),
    'desc'    => esc_html__( 'Background color for sticky header.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
);
$this->itr_settings['sticky_text_color'] = array(
    'title'   => esc_html__( 'Font Color', 'munza' ),
    'desc'    => esc_html__( 'Text color for sticky header items.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
);
$this->itr_settings['sticky_hover_color'] = array(
    'title'   => esc_html__( 'Hover Color', 'munza' ),
    'desc'    => esc_html__( 'hover color for sticky header items.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_header',
);
$this->itr_settings['sticky_devices'] = array(
    'section' => 'it_header',
    'title'   => esc_html__( 'Show on Small Screens', 'munza' ),
    'desc'    => esc_html__( 'Display sticky header in Small Screens.', 'munza' ),
    'type'    => 'checkbox',
);

/* Logo
============================================*/
$this->itr_settings['logo_type'] = array(
    'section' => 'it_logo',    
    'title'   => esc_html__( 'Logo Type', 'munza' ),
    'class'   => 'select_boxes',
    'type'    => 'select',
    'choices' => array(
        'image' => esc_html__('Image','munza'),
        'text'  => esc_html__('Text','munza'),
    ),
    'std' => 'text'
);
$this->itr_settings['header_logo_image'] = array(
    'section' => 'it_logo',
    'title'   => esc_html__( 'Default Logo', 'munza' ),
    'desc'    => esc_html__( 'Select or insert image url for logo.', 'munza' ),
    'type'    => 'file',
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'image'
    )
);
$this->itr_settings['sticky_logo'] = array(
    'section' => 'it_logo',
    'title'   => esc_html__( 'Sticky Header Logo', 'munza' ),
    'desc'    => esc_html__( 'Select or insert image url for logo.', 'munza' ),
    'type'    => 'file',
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'image'
    )
);
$this->itr_settings['retina_logo_image'] = array(
    'section' => 'it_logo',
    'title'   => esc_html__( 'Retina Logo', 'munza' ),
    'desc'    => esc_html__( 'Select or insert image url for logo.', 'munza' ),
    'type'    => 'file',
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'image'
    )
);
$this->itr_settings['logo_font'] = array(
    'title'   => esc_html__( 'Font Family', 'munza' ),
    'std'     => 'Josefin Sans',
    'type'    => 'googlefonts',
    'multilang' => true,
    'section' => 'it_logo',
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'text'
    )
);
$this->itr_settings['logo_font_sample'] = array(
    'title'   => '',
    'desc'     => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', 'munza' ),
    'type'    => 'label',
    'class'   => 'gfonts',
    'section' => 'it_logo',
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'text'
    )
);
$this->itr_settings['logo_font_size'] = array(
    'title'   => esc_html__( 'Font Size (px)', 'munza' ),
    'desc'    => esc_html__( 'Enter Font size in px. Ex: 50px', 'munza' ),
    'std'     => '30',
    'multilang' => true,
    'type'    => 'number',
    'section' => 'it_logo',
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'text'
    )
);
$this->itr_settings['logo_font_weight'] = array(
    'title'   => esc_html__( 'Font Weight', 'munza' ),
    'desc'    => esc_html__( 'Choose Font weight for Logo', 'munza' ),
    'std'     => '700',
    'type'    => 'select',
    'multilang' => true,
    'section' => 'it_logo',
    'choices' => array(
        ''          => esc_html__('-- Select --','munza'),
        'normal'    => esc_html__('normal','munza'),
        'bold'      => esc_html__('bold','munza'),
        'lighter'   => esc_html__('lighter','munza'),
        'bolder'    => esc_html__('bolder','munza'),
        '100'       => '100',
        '200'       => '200',
        '300'       => '300',
        '400'       => '400',
        '500'       => '500',
        '600'       => '600',
        '700'       => '700',
        '800'       => '800',
        '900'       => '900',
        'inherit'   => esc_html__('inherit','munza')
    ),
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'text'
    )
);
$this->itr_settings['logo_font_color'] = array(
    'title'   => esc_html__( 'Color', 'munza' ),
    'desc'    => esc_html__( 'Color for the Logo text.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_logo',
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'text'
    )
);
$this->itr_settings['mobile_logo_size'] = array(
    'title'   => esc_html__( 'Mobile Logo Font Size (px)', 'munza' ),
    'std'     => '25',
    'type'    => 'number',
    'section' => 'it_logo',
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'text'
    )
);
$this->itr_settings['slogan_font'] = array(
    'title'   => esc_html__( 'Tagline Font Family', 'munza' ),
    'std'     => 'Nunito',
    'type'    => 'googlefonts',
    'multilang' => true,
    'section' => 'it_logo',
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'text'
    )
);
$this->itr_settings['slg_font_sample'] = array(
    'title'   => '',
    'desc'     => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', 'munza' ),
    'type'    => 'label',
    'class'   => 'gfonts',
    'section' => 'it_logo',
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'text'
    )
);
$this->itr_settings['slogan_font_size'] = array(
    'title'   => esc_html__( 'Tagline Font Size (px)', 'munza' ),
    'std'     => '11',
    'multilang' => true,
    'type'    => 'number',
    'section' => 'it_logo',
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'text'
    )
);
$this->itr_settings['slogan_font_weight'] = array(
    'title'   => esc_html__( 'Tagline Font Weight', 'munza' ),
    'std'     => '400',
    'type'    => 'select',
    'multilang' => true,
    'section' => 'it_logo',
    'choices' => array(
        ''          => esc_html__('-- Select --','munza'),
        'normal'    => esc_html__('normal','munza'),
        'bold'      => esc_html__('bold','munza'),
        'lighter'   => esc_html__('lighter','munza'),
        'bolder'    => esc_html__('bolder','munza'),
        '100'       => '100',
        '200'       => '200',
        '300'       => '300',
        '400'       => '400',
        '500'       => '500',
        '600'       => '600',
        '700'       => '700',
        '800'       => '800',
        '900'       => '900',
        'inherit'   => esc_html__('inherit','munza')
    ),
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'text'
    )
);
$this->itr_settings['slogan_font_color'] = array(
    'title'   => esc_html__( 'Tagline Text Color', 'munza' ),
    'std'     => '#808080',
    'type'    => 'color',
    'section' => 'it_logo',
    'dependency' => array(
        'element' => 'logo_type',
        'value' => 'text'
    )
);

/* Menu
============================================*/
$this->itr_settings['menu-opts-heading'] = array(
    'section' => 'it_menu',
    'desc'    => esc_html__( 'Menu Options', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'menu-opts-acc'
);
$this->itr_settings['menu-anim'] = array(
    'section' => 'it_menu',
    'title'   => esc_html__( 'Hover Animation', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1'
);
$this->itr_settings['header-icons'] = array(
    'section' => 'it_menu',
    'title'   => esc_html__( 'Menu First Level Icons', 'munza' ),
    'type'    => 'checkbox',
);
$this->itr_settings['header-sub-icons'] = array(
    'section' => 'it_menu',
    'title'   => esc_html__( 'Show Submenu Icons', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['header-subtitle'] = array(
    'section' => 'it_menu',
    'title'   => esc_html__( 'Show Menu Subtitles', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '',
);  
$this->itr_settings['sub_menu_color'] = array(
    'title'   => esc_html__( 'Sub Menu Color', 'munza' ),
    'desc'    => esc_html__( 'Select the sub menu color.', 'munza' ),
    'type'    => 'select',
    'class'   => 'select_boxes',
    'section' => 'it_menu',
    'choices' => array(
        ''          => esc_html__('Light','munza'),
        'dark-sub'  => esc_html__('Dark','munza'),
        'custom'    => esc_html__('custom','munza')
    ),
    'std'     => 'custom'
);
$this->itr_settings['sub_menu_bg_color'] = array(
    'title'   => esc_html__( 'Submenu Background Color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_menu',
    'std'     => '#ef2674',
    'dependency' => array(
        'element' => 'sub_menu_color',
        'value' => 'custom'
    )
);
$this->itr_settings['sub_menu_font_color'] = array(
    'title'   => esc_html__( 'Submenu Font Color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_menu',
    'std'     => '#fff',
    'dependency' => array(
        'element' => 'sub_menu_color',
        'value' => 'custom'
    )
);
/* Menu Locations.
============================================*/
$this->itr_settings['location-options'] = array(
    'section' => 'it_menu',
    'desc'    => 'Menu Locations',
    'type'    => 'heading',
    'data_id' => 'locs-acc'
);
$this->itr_settings['locations'] = array(
    'section' => 'it_menu',
    'title'   => esc_html__( 'Locations', 'munza' ),
    'desc'    => esc_html__( 'Add unlimited nav menu locations.', 'munza' ),
    'type'    => 'addbox',
    'std'     => '0'
);

$locss = isset($options['locations']) ? $options['locations'] : 0;        
for ( $i = 0; $i <= $locss ; $i++ ) {
    $this->itr_settings['location_'.$i] = array(
        'title'     => esc_html__( 'Location Name ', 'munza' ),
        'type'      => 'text',
        'parent'    => 'locations',
        'multilang' => true, 
        'class'     => 'indval',    
        'section'   => 'it_menu'
    );
}
               
/* Footer
============================================*/
$this->itr_settings['footer-heading'] = array(
    'section' => 'it_footer',
    'desc'    => esc_html__( 'Main Settings', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'foot-acc'
);
$this->itr_settings['footer_style'] = array(
    'title'   => esc_html__( 'Style', 'munza' ),
    'std'     => '2',
    'type'    => 'select',
    'section' => 'it_footer',
    'class'   => 'select_boxes',
    'choices' => array(
        '1' => esc_html__('Rotated Skew','munza'),
        '2' => esc_html__('Normal','munza'),
        '3' => esc_html__('Simple Skew','munza'),
    )
);
$this->itr_settings['footer_width'] = array(
    'title'   => esc_html__( 'Footer Width', 'munza' ),
    'type'    => 'select',
    'section' => 'it_footer',
    'desc'    => esc_html__( 'This option allows you to select the footer widgets area layout width.', 'munza' ),
    'class'   => 'select_boxes',
    'choices' => array(
        'boxed'     => esc_html__('Boxed','munza'),
        'wide'      => esc_html__('Full Width','munza'),
    )
);
$this->itr_settings['footer_fixed'] = array(
    'section' => 'it_footer',
    'title'   => esc_html__( 'Fixed ?', 'munza' ),
    'desc'    => esc_html__( 'Enable this to have bottom fixed footer.', 'munza' ),
    'type'    => 'checkbox',
);
 
/* Top Footer */
$this->itr_settings['footer-top-head'] = array(
    'section' => 'it_footer',
    'desc'    => esc_html__( 'Top Area', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'foot-top-acc'
);
$this->itr_settings['foot_top_show'] = array(
    'section' => 'it_footer',
    'title'   => esc_html__( 'Show top footer bar Area', 'munza' ),
    'type'    => 'checkbox',
);
$this->itr_settings['foot_nl1'] = array(
    'section' => 'it_footer',
    'title'   => esc_html__( 'Heading', 'munza' ),
    'desc'    => esc_html__( 'Insert here the heading text.', 'munza' ),
    'multilang' => true,
    'dependency' => array( 'element' => 'foot_top_show','not_empty' => true ),
    'type'    => 'editor',
);
$this->itr_settings['foot_nl2'] = array(
    'section' => 'it_footer',
    'title'   => esc_html__( 'Text', 'munza' ),
    'desc'    => esc_html__( 'Insert here the description text.', 'munza' ),
    'multilang' => true,
    'dependency' => array( 'element' => 'foot_top_show','not_empty' => true ),
    'type'    => 'editor',
);
$this->itr_settings['foot_btn_text'] = array(
    'section' => 'it_footer',
    'title'   => esc_html__( 'Button Text', 'munza' ),
    'desc'    => esc_html__( 'Insert here the button text.', 'munza' ),
    'dependency' => array( 'element' => 'foot_top_show','not_empty' => true ),
    'multilang' => true,
    'type'    => 'text',
);
$this->itr_settings['foot_btn_link'] = array(
    'section' => 'it_footer',
    'title'   => esc_html__( 'Button Link', 'munza' ),
    'desc'    => esc_html__( 'Insert here the button link.', 'munza' ),
    'dependency' => array( 'element' => 'foot_top_show','not_empty' => true ),
    'type'    => 'text',
);
$this->itr_settings['foot_btn_link_target'] = array(
    'section' => 'it_footer',
    'title'   => esc_html__( 'New Window ?', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1'
);
$this->itr_settings['foot_top_text_color'] = array(
    'title'   => esc_html__( 'Text color', 'munza' ),
    'dependency' => array( 'element' => 'foot_top_show','not_empty' => true ),
    'type'    => 'color',
    'section' => 'it_footer',
);
$this->itr_settings['foot_top_bg_color'] = array(
    'title'   => esc_html__( 'Background color', 'munza' ),
    'dependency' => array( 'element' => 'foot_top_show','not_empty' => true ),
    'type'    => 'color',
    'std'     => '#fff',
    'section' => 'it_footer',
);
/* Middle Footer */
$this->itr_settings['footer-middle-head'] = array(
    'section' => 'it_footer',
    'desc'    => esc_html__( 'Middle Area', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'foot-mid-acc'
);
$this->itr_settings['foot_mid_show'] = array(
    'section' => 'it_footer',
    'title'   => esc_html__( 'Show footer widgets Area', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1'
);
$this->itr_settings['foot_mid_widg_cols'] = array(
    'title'   => esc_html__( 'Number of Columns', 'munza' ),
    'std'     => '3',
    'type'    => 'select',
    'section' => 'it_footer',
    'class'   => 'select_boxes',
    'dependency' => array( 'element' => 'foot_mid_show','not_empty' => true ),
    'choices' => array(
        '12'    => '1',
        '6'     => '2',
        '4'     => '3',
        '3'     => '4'
    )
);
$this->itr_settings['footer_text_color'] = array(
    'title'   => esc_html__( 'Text color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_footer',
    'std'     => '#e2beff'
);
$this->itr_settings['footer_link_color'] = array(
    'title'   => esc_html__( 'Links color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_footer',
    'std'     => '#ffffff'
);
$this->itr_settings['footer_head_color'] = array(
    'title'   => esc_html__( 'Widgets Headings color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_footer',
    'std'     => '#ffffff'
);            
$this->itr_settings['footer_bg_type'] = array(
    'title'   => esc_html__( 'Background Type', 'munza' ),
    'type'    => 'select',
    'section' => 'it_footer',
    'class'   => 'select_boxes',
    'choices' => array(
        'color'     => esc_html__('Color','munza'),
        'gradient'  => esc_html__('Gradient','munza')
    ),
    'std'   => 'gradient',
);
$this->itr_settings['footer_bg_color'] = array(
    'title'   => esc_html__( 'Background color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_footer',
    'dependency' => array(
        'element' => 'footer_bg_type',
        'value' => 'color'
    )
);
$this->itr_settings['footer_bg_grad'] = array(
    'title'   => esc_html__( 'Gradient color', 'munza' ),
    'type'    => 'gradient',
    'section' => 'it_footer',
    'dependency' => array(
        'element'   => 'footer_bg_type',
        'value'     => 'gradient'
    ),
    'std'       => '-webkit-linear-gradient(left, #ef2674 0%, #2033aa 100%)',
    'defcolor'  => '-webkit-linear-gradient(left, #ef2674 0%, #2033aa 100%)'
);
$this->itr_settings['footer_bg_img'] = array(
    'section' => 'it_footer',
    'title'   => esc_html__( 'Background Image', 'munza' ),
    'type'    => 'file',
);
$this->itr_settings['footer_bg_position'] = array(
    'title'   => esc_html__( 'Background Position', 'munza' ),
    'type'    => 'select',
    'section' => 'it_footer',
    'choices' => array(
        '0 0'       => esc_html__('Left Top','munza'),
        '0 50%'     => esc_html__('Left Middle','munza'),
        '0 100%'    => esc_html__('Left Bottom','munza'),
        '50% 0'     => esc_html__('Center Top','munza'),
        '50% 50%'   => esc_html__('Center Middle','munza'),
        '50% 100%'  => esc_html__('Center Right','munza'),
        '100% 0'    => esc_html__('Right Top','munza'),
        '100% 50%'  => esc_html__('Right Middle','munza'),
        '100% 100%' => esc_html__('Right Bottom','munza'),
    ),
    'std'   => '0 100%',
    'dependency' => array(
        'element'   => 'footer_bg_img',
        'not_empty' => true
    )
);
$this->itr_settings['footer_bg_repeat'] = array(
    'title'   => esc_html__( 'Background repeat', 'munza' ),
    'type'    => 'select',
    'section' => 'it_footer',
    'class'   => 'select_boxes',
    'choices' => array(
        ''          => esc_html__('Repeat','munza'),
        'no-repeat' => esc_html__('No Repeat','munza'),
        'repeat-x'  => esc_html__('Repeat X','munza'),
        'repeat-y'  => esc_html__('Repeat Y','munza')
    ),
    'std'   => 'repeat-x',
    'dependency' => array(
        'element'   => 'footer_bg_img',
        'not_empty' => true
    )
);
$this->itr_settings['footer_bg_size'] = array(
    'title'   => esc_html__( 'Background Size', 'munza' ),
    'type'    => 'select',
    'section' => 'it_footer',
    'class'   => 'select_boxes',
    'choices' => array(
        'inherit'   => esc_html__('Inherit','munza'),
        'cover'     => esc_html__('Cover','munza'),
        'contain'   => esc_html__('Contain','munza'),
        '100% 100%' => '100%',
    ),
    'dependency' => array(
        'element' => 'footer_bg_img',
        'not_empty' => true
    )
);
/* Bottom Footer */
$this->itr_settings['foot-bottom-head'] = array(
    'section' => 'it_footer',
    'desc'    => esc_html__( 'Bottom Area', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'foot-bottom-acc'
);
$this->itr_settings['foot_bottom_show'] = array(
    'section' => 'it_footer',
    'title'   => esc_html__( 'Show SubFooter Area', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide bottom footer bar.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1'
);
$this->itr_settings['foot_bot_widg_cols'] = array(
    'title'   => esc_html__( 'Number of Columns', 'munza' ),
    'std'     => '6',
    'type'    => 'select',
    'section' => 'it_footer',
    'desc'    => esc_html__( 'This option allows you to show subfooter elements in one, two or three columns.', 'munza' ),
    'class'   => 'select_boxes',
    'dependency' => array( 'element' => 'foot_bottom_show','not_empty' => true ),
    'choices' => array(
        '12'    => '1',
        '6'     => '2',
        '4'     => '3',
    )
);
$this->itr_settings['foot_copyrights'] = array(
    'section'    => 'it_footer',
    'title'      => esc_html__( 'Copyrights', 'munza' ),
    'desc'       => esc_html__( 'Insert here the copyrights text.', 'munza' ),
    'multilang'  => true,
    'dependency' => array( 'element' => 'foot_bottom_show','not_empty' => true ),
    'std'        => esc_html__('Copyrights &copy; 2019. All rights reserved to Munza Co.','munza'),
    'type'       => 'editor', 
);
$this->itr_settings['footer_bottom_color'] = array(
    'title'   => esc_html__( 'Text color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_footer',
    'std'     => '#e2beff'
);
$this->itr_settings['footer_bottom_link_color'] = array(
    'title'   => esc_html__( 'Links color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_footer',
    'std'     => '#ffffff'
);
$this->itr_settings['footer_bottom_bg_color'] = array(
    'title'   => esc_html__( 'Background color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_footer',
);
        
/* Page title.
============================================*/
$this->itr_settings['page_title_options'] = array(
    'section' => 'it_pagetitles',
    'desc'    => esc_html__('General Settings','munza'),
    'type'    => 'heading',
    'data_id' => 'title-acc'
);
$this->itr_settings['page_title_style'] = array(
    'section' => 'it_pagetitles',
    'title'   => esc_html__( 'Style', 'munza' ),
    'type'    => 'select',
    'std'     => '1',
    'class'   => 'select_boxes',
    'choices' => array(
        '1'         => esc_html__('Style 1','munza'),
        '2'         => esc_html__('Style 2','munza'),
        '3'         => esc_html__('Style 3','munza'),
        '4'         => esc_html__('Style 4','munza'),
        'normal'    => esc_html__('Normal','munza'),                
    ),
);
$this->itr_settings['page_title_position'] = array(
    'section' => 'it_pagetitles',
    'title'   => esc_html__( 'Position', 'munza' ),
    'desc'    => esc_html__( 'Choose Title Alignment.', 'munza' ),
    'type'    => 'select',
    'multilang' => true,
    'class'   => 'select_boxes',
    'choices' => array(
        'left'      => esc_html__('Left','munza'),
        'center'    => esc_html__('Center','munza'),
        'right'     => esc_html__('Right','munza')                
    ),
    'std'     => 'left',
);
$this->itr_settings['page_title_height'] = array(
    'title'   => esc_html__( 'Height', 'munza' ),
    'desc'    => esc_html__( 'Insert the height (in px). Ex: 200', 'munza' ),
    'type'    => 'number',
    'min'     => '1',
    'max'     => '1200',
    'std'     => '600',
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_icon'] = array(
    'title'   => esc_html__( 'Icon', 'munza' ),
    'desc'    => esc_html__( 'Choose icon for page title.', 'munza' ),
    'type'    => 'icon',
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_iconsize'] = array(
    'title'   => esc_html__( 'Icon Font Size (px)', 'munza' ),
    'desc'    => esc_html__( 'Choose Font size for title icon', 'munza' ),
    'std'     => '40',
    'type'    => 'number',
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_iconcolor'] = array(
    'title'   => esc_html__( 'Icon color', 'munza' ),
    'desc'    => esc_html__( 'Choose a solid Icon color.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_iconbgcolor'] = array(
    'title'   => esc_html__( 'Icon Background color', 'munza' ),
    'desc'    => esc_html__( 'Choose a solid Icon Background color.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_hide'] = array(
    'section' => 'it_pagetitles',
    'title'   => esc_html__( 'Hide All Page Titles', 'munza' ),
    'desc'    => esc_html__( 'Show/Hide page title in all pages.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '0'
);
$this->itr_settings['page_title_typo'] = array(
    'section' => 'it_pagetitles',
    'desc'    => esc_html__('Typography','munza'),
    'type'    => 'heading',
    'data_id' => 'title-typo-acc'
);
$this->itr_settings['page_title_font'] = array(
    'title'   => esc_html__( 'Font Family', 'munza' ),
    'desc'    => esc_html__( 'Choose Font Family for main page title', 'munza' ),
    'std'     => 'Josefin Sans',
    'type'    => 'googlefonts',
    'multilang' => true,
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_sample'] = array(
    'title'   => '',
    'desc'     => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', 'munza' ),
    'type'    => 'label',
    'class'   => 'gfonts',
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_fontsize'] = array(
    'title'   => esc_html__( 'Font Size (px)', 'munza' ),
    'desc'    => esc_html__( 'Choose Font size for main page title', 'munza' ),
    'std'     => '60',
    'multilang' => true,
    'type'    => 'number',
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_sub_fontsize'] = array(
    'title'   => esc_html__( 'Sub Title Font Size (px)', 'munza' ),
    'desc'    => esc_html__( 'Choose Font size for page sub title', 'munza' ),
    'std'     => '20',
    'multilang' => true,
    'type'    => 'number',
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_fontweight'] = array(
    'title'   => esc_html__( 'Font Weight', 'munza' ),
    'desc'    => esc_html__( 'Choose Font weight for main page title', 'munza' ),
    'type'    => 'select',
    'multilang' => true,
    'section' => 'it_pagetitles',
    'std'     => '700',
    'choices' => array(
        ''          => esc_html__('-- Select --','munza'),
        'normal'    => esc_html__('normal','munza'),
        'bold'      => esc_html__('bold','munza'),
        'lighter'   => esc_html__('lighter','munza'),
        'bolder'    => esc_html__('bolder','munza'),
        '100'       => '100',
        '200'       => '200',
        '300'       => '300',
        '400'       => '400',
        '500'       => '500',
        '600'       => '600',
        '700'       => '700',
        '800'       => '800',
        '900'       => '900',
        'inherit'   => esc_html__('inherit','munza')
    ),
);
$this->itr_settings['page_title_styling'] = array(
    'section' => 'it_pagetitles',
    'desc'    => esc_html__('Styling','munza'),
    'type'    => 'heading',
    'data_id' => 'title_st-acc'
);
$this->itr_settings['page_title_fontcolor'] = array(
    'title'   => esc_html__( 'Text color', 'munza' ),
    'type'    => 'color',
    'std'     => '#ffffff',
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_subcolor'] = array(
    'title'   => esc_html__( 'Subtitle color', 'munza' ),
    'type'    => 'color',
    'std'     => '#e4c4ff',
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_textcolor'] = array(
    'title'   => esc_html__( 'Text Background color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_bg_type'] = array(
    'title'   => esc_html__( 'Background Type', 'munza' ),
    'type'    => 'select',
    'section' => 'it_pagetitles',
    'class'   => 'select_boxes',
    'choices' => array(
        'color'     => esc_html__('Color','munza'),
        'gradient'  => esc_html__('Gradient','munza')
    ),
    'std'   => 'gradient',
);
$this->itr_settings['page_title_bgcolor'] = array(
    'title'   => esc_html__( 'Background color', 'munza' ),
    'type'    => 'color',
    'section' => 'it_pagetitles',
    'dependency' => array(
        'element' => 'page_title_bg_type',
        'value' => 'color'
    )
);
$this->itr_settings['page_title_bg_grad'] = array(
    'title'   => esc_html__( 'Gradient color', 'munza' ),
    'type'    => 'gradient',
    'section' => 'it_pagetitles',
    'dependency' => array(
        'element' => 'page_title_bg_type',
        'value' => 'gradient'
    ),
    'std'   => '-webkit-linear-gradient(left, #ef2674 0%, #2033aa 100%)'
);

$this->itr_settings['page_title_bg'] = array(
    'title'   => esc_html__( 'Background Image', 'munza' ),
    'type'    => 'file',
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_bg_size'] = array(
    'title'   => esc_html__( 'Background Size', 'munza' ),
    'type'    => 'select',
    'section' => 'it_pagetitles',
    'class'   => 'select_boxes',
    'choices' => array(
        'inherit'   => esc_html__('Inherit','munza'),
        'cover'     => esc_html__('Cover','munza'),
        'contain'   => esc_html__('Contain','munza'),
        '100% 100%' => '100%',
    ), 
    'std'   => 'inherit',
    'dependency' => array(
        'element'   => 'page_title_bg',
        'not_empty' => true
    )
);
$this->itr_settings['page_title_bg_repeat'] = array(
    'title'   => esc_html__( 'Background repeat', 'munza' ),
    'type'    => 'select',
    'section' => 'it_pagetitles',
    'class'   => 'select_boxes',
    'choices' => array(
        '' => 'Repeat',
        'repeat-x'  => esc_html__('Repeat X','munza'),
        'repeat-y'  => esc_html__('Repeat Y','munza'),
        'no-repeat' => esc_html__('No Repeat','munza'),
    ),
    'std'        => 'no-repeat',
    'dependency' => array(
        'element'   => 'page_title_bg',
        'not_empty' => true
    )
);
$this->itr_settings['page_title_bg_position'] = array(
    'title'   => esc_html__( 'Background Position', 'munza' ),
    'type'    => 'select',
    'section' => 'it_pagetitles',
    'choices' => array(
        '0 0'       => esc_html__('Left Top','munza'),
        '0 50%'     => esc_html__('Left Middle','munza'),
        '0 100%'    => esc_html__('Left Bottom','munza'),
        '50% 0'     => esc_html__('Center Top','munza'),
        '50% 50%'   => esc_html__('Center Middle','munza'),
        '50% 100%'  => esc_html__('Center Bottom','munza'),
        '100% 0'    => esc_html__('Right Top','munza'),
        '100% 50%'  => esc_html__('Right Middle','munza'),
        '100% 100%' => esc_html__('Right Bottom','munza'),
    ),
    'std'   => '0 0',
    'dependency' => array(
        'element' => 'page_title_bg',
        'not_empty' => true
    )
);

$this->itr_settings['page_title_parallax'] = array(
    'title'   => esc_html__( 'Parallax Background', 'munza' ),
    'type'    => 'checkbox',
    'section' => 'it_pagetitles',
    'std'     => '1',
    'dependency' => array(
        'element' => 'page_title_bg',
        'not_empty' => true
    )
);
$this->itr_settings['page_title_overlay'] = array(
    'title'   => esc_html__( 'Overlay ?', 'munza' ),
    'type'    => 'color',
    'section' => 'it_pagetitles',
    'dependency' => array(
        'element' => 'page_title_bg',
        'not_empty' => true
    )
);
$this->itr_settings['breadcrumbs-options'] = array(
    'section' => 'it_pagetitles',
    'desc'    => esc_html__('Breadcrumbs','munza'),
    'type'    => 'heading',
    'data_id' => 'breadcrumbs-acc'
);
$this->itr_settings['page_title_show_breadcrumbs'] = array(
    'title'   => esc_html__( 'Show BreadCrumbs', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
    'section' => 'it_pagetitles',
);
$this->itr_settings['page_title_breadcrumbs_style'] = array(
    'section' => 'it_pagetitles',
    'title'   => esc_html__( 'Style', 'munza' ),
    'type'    => 'select',
    'class'   => 'select_boxes',
    'choices' => array(
        'style1' => esc_html__('Style 1','munza'),
        'style2' => esc_html__('Style 2','munza'),
        'style3' => esc_html__('Style 3','munza'),
    ),
    'std'   => 'style2',
    'dependency' => array(
        'element' => 'page_title_show_breadcrumbs',
        'value' => '1'
    )
);
$this->itr_settings['page_title_breadcrumbs_align'] = array(
    'section' => 'it_pagetitles',
    'title'   => esc_html__( 'Alignment', 'munza' ),
    'type'    => 'select',
    'class'   => 'select_boxes',
    'choices' => array(
        'text-left'     => esc_html__('Left','munza'),
        'text-center'   => esc_html__('Center','munza'),
        'text-right'    => esc_html__('Right','munza'),        
    ),
    'std'   => 'left',
    'dependency' => array(
        'element' => 'page_title_show_breadcrumbs',
        'value' => '1'
    )
);
$this->itr_settings['page_title_breadcrumbs_prefix'] = array(
    'title'   => esc_html__( 'Prefix', 'munza' ),
    'desc'    => esc_html__( 'Enter the text before the breadcrumbs', 'munza' ),
    'type'    => 'text',
    'multilang' => true,
    'section' => 'it_pagetitles',
    'dependency' => array(
        'element' => 'page_title_show_breadcrumbs',
        'value' => '1'
    )
);
$this->itr_settings['page_title_breadcrumbs_suffix'] = array(
    'title'   => esc_html__( 'Suffix', 'munza' ),
    'desc'    => esc_html__( 'Enter the text after the breadcrumbs', 'munza' ),
    'type'    => 'text',
    'multilang' => true,
    'section' => 'it_pagetitles',
    'dependency' => array(
        'element' => 'page_title_show_breadcrumbs',
        'value' => '1'
    )
);
$this->itr_settings['page_title_mobile_breadcrumbs'] = array(
    'title'   => esc_html__( 'Show on Mobiles', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
    'section' => 'it_pagetitles',
    'dependency' => array(
        'element' => 'page_title_show_breadcrumbs',
        'value' => '1'
    )
);
$this->itr_settings['page_title_breadcrumbs_color'] = array(
    'title'   => esc_html__( 'Text color', 'munza' ),
    'type'    => 'color',
    'std'     => '#ffffff',
    'section' => 'it_pagetitles',
    'dependency' => array(
        'element' => 'page_title_show_breadcrumbs',
        'value' => '1'
    )
);
$this->itr_settings['page_title_breadcrumbs_bgcolor'] = array(
    'title'   => esc_html__( 'Background color', 'munza' ),
    'type'    => 'color',
    'std'     => 'rgba(0,0,0,0.15)',
    'section' => 'it_pagetitles',
    'dependency' => array(
        'element' => 'page_title_show_breadcrumbs',
        'value' => '1'
    )
);

/* Typography.
============================================*/
$this->itr_settings['body_heading'] = array(
    'section' => 'it_typography',
    'desc'    => esc_html__( 'Body', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'body_ty-acc'
);
$this->itr_settings['body_font'] = array(
    'title'   => esc_html__( 'Font Family', 'munza' ),
    'std'     => 'Nunito',
    'type'    => 'googlefonts',
    'section' => 'it_typography',
    'multilang' => true,
);
$this->itr_settings['bdy_font_sample'] = array(
    'title'   => '',
    'desc'     => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', 'munza' ),
    'type'    => 'label',
    'class'   => 'gfonts',
    'section' => 'it_typography',
);
$this->itr_settings['body_font_size'] = array(
    'title'   => esc_html__( 'Font Size (px)', 'munza' ),
    'desc'    => esc_html__( 'Enter Font size in px.', 'munza' ),
    'std'     => '14',
    'type'    => 'number',
    'multilang' => true,
    'section' => 'it_typography'
);
$this->itr_settings['body_font_weight'] = array(
    'title'   => esc_html__( 'Font Weight', 'munza' ),
    'std'     => 'normal',
    'type'    => 'select',
    'multilang' => true,
    'section' => 'it_typography',
    'choices' => array(
        ''          => esc_html__('-- Select --','munza'),
        'normal'    => esc_html__('normal','munza'),
        'bold'      => esc_html__('bold','munza'),
        'lighter'   => esc_html__('lighter','munza'),
        'bolder'    => esc_html__('bolder','munza'),
        '100'       => '100',
        '200'       => '200',
        '300'       => '300',
        '400'       => '400',
        '500'       => '500',
        '600'       => '600',
        '700'       => '700',
        '800'       => '800',
        '900'       => '900',
        'inherit'   => esc_html__('inherit','munza')
    )
);
$this->itr_settings['body_line_height'] = array(
    'title'   => esc_html__( 'Line Height', 'munza' ),
    'desc'    => esc_html__( 'Line Height for all body elemets in PX.', 'munza' ),
    'std'     => '26',
    'multilang' => true,
    'type'    => 'number',
    'section' => 'it_typography'
);
$this->itr_settings['body_lett_space'] = array(
    'title'   => esc_html__( 'Letter Spacing (px)', 'munza' ),
    'desc'    => esc_html__( 'Enter letter spacing in px.', 'munza' ),
    'type'    => 'number',
    'multilang' => true,
    'section' => 'it_typography'
);

$this->itr_settings['menu_heading'] = array(
    'section' => 'it_typography',
    'desc'    => esc_html__( 'Menu', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'menu_ty-acc'
);
$this->itr_settings['menu_font'] = array(
    'title'   => esc_html__( 'Font Family', 'munza' ),
    'std'     => 'Nunito',
    'multilang' => true,
    'type'    => 'googlefonts',
    'section' => 'it_typography',
);
$this->itr_settings['mnu_font_sample'] = array(
    'title'   => '',
    'desc'     => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', 'munza' ),
    'type'    => 'label',
    'class'   => 'gfonts',
    'section' => 'it_typography',
);
$this->itr_settings['menu_font_size'] = array(
    'title'   => esc_html__( 'Font Size (px)', 'munza' ),
    'desc'    => esc_html__( 'Enter Font size in px. Ex: 14px', 'munza' ),
    'std'     => '16',
    'type'    => 'number',
    'multilang' => true,
    'section' => 'it_typography'
);
$this->itr_settings['menu_lett_space'] = array(
    'title'   => esc_html__( 'Letter Spacing (px)', 'munza' ),
    'desc'    => esc_html__( 'Enter letter spacing in px.', 'munza' ),
    'std'     => '0.5',
    'type'    => 'number',
    'multilang' => true,
    'section' => 'it_typography'
);
$this->itr_settings['menu_font_weight'] = array(
    'title'   => esc_html__( 'Font Weight', 'munza' ),
    'std'     => '700',
    'type'    => 'select',
    'multilang' => true,
    'section' => 'it_typography',
    'choices' => array(
        ''          => esc_html__('-- Select --','munza'),
        'normal'    => esc_html__('normal','munza'),
        'bold'      => esc_html__('bold','munza'),
        'lighter'   => esc_html__('lighter','munza'),
        'bolder'    => esc_html__('bolder','munza'),
        '100'       => '100',
        '200'       => '200',
        '300'       => '300',
        '400'       => '400',
        '500'       => '500',
        '600'       => '600',
        '700'       => '700',
        '800'       => '800',
        '900'       => '900',
        'inherit'   => esc_html__('inherit','munza')
    )
);
$this->itr_settings['menu_text_style'] = array(
    'title'   => esc_html__( 'Text Style', 'munza' ),
    'std'     => 'uppercase',
    'type'    => 'select',
    'multilang' => true,
    'section' => 'it_typography',
    'choices' => array(
        'none'          => esc_html__('None','munza'),
        'capitalize'    => esc_html__('Capitalize','munza'),
        'lowercase'     => esc_html__('Lowercase','munza'),
        'uppercase'     => esc_html__('Uppercase','munza'),
    )
);

$this->itr_settings['submenu_heading'] = array(
    'section' => 'it_typography',
    'desc'    => esc_html__( 'SubMenu', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'submenu_ty-acc'
);
$this->itr_settings['submenu_font'] = array(
    'title'   => esc_html__( 'Font Family', 'munza' ),
    'std'     => 'Nunito',
    'multilang' => true,
    'type'    => 'googlefonts',
    'section' => 'it_typography',
);
$this->itr_settings['submnu_font_sample'] = array(
    'title'   => '',
    'desc'     => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', 'munza' ),
    'type'    => 'label',
    'class'   => 'gfonts',
    'section' => 'it_typography',
);
$this->itr_settings['submenu_font_size'] = array(
    'title'   => esc_html__( 'Font Size (px)', 'munza' ),
    'desc'    => esc_html__( 'Enter Font size in px. Ex: 14px', 'munza' ),
    'std'     => '14',
    'type'    => 'number',
    'multilang' => true,
    'section' => 'it_typography'
);
$this->itr_settings['submenu_lett_space'] = array(
    'title'   => esc_html__( 'Letter Spacing (px)', 'munza' ),
    'desc'    => esc_html__( 'Enter letter spacing in px.', 'munza' ),
    'type'    => 'number',
    'multilang' => true,
    'section' => 'it_typography'
);
$this->itr_settings['submenu_font_weight'] = array(
    'title'   => esc_html__( 'Font Weight', 'munza' ),
    'type'    => 'select',
    'multilang' => true,
    'section' => 'it_typography',
    'choices' => array(
        ''          => esc_html__('-- Select --','munza'),
        'normal'    => esc_html__('normal','munza'),
        'bold'      => esc_html__('bold','munza'),
        'lighter'   => esc_html__('lighter','munza'),
        'bolder'    => esc_html__('bolder','munza'),
        '100'       => '100',
        '200'       => '200',
        '300'       => '300',
        '400'       => '400',
        '500'       => '500',
        '600'       => '600',
        '700'       => '700',
        '800'       => '800',
        '900'       => '900',
        'inherit'   => esc_html__('inherit','munza')
    )
);
$this->itr_settings['submenu_text_style'] = array(
    'title'   => esc_html__( 'Text Style', 'munza' ),
    'std'     => 'none',
    'type'    => 'select',
    'multilang' => true,
    'section' => 'it_typography',
    'choices' => array(
        'none' => 'None',
        'capitalize'    => esc_html__('Capitalize','munza'),
        'lowercase'     => esc_html__('Lowercase','munza'),
        'uppercase'     => esc_html__('Uppercase','munza'),
    )
);

$this->itr_settings['headings_heading'] = array(
    'section' => 'it_typography',
    'desc'    => esc_html__( 'Headings', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'headings_ty-acc'
);
$this->itr_settings['headings_font'] = array(
    'title'   => esc_html__( 'Font Family', 'munza' ),
    'std'     => 'Josefin Sans',
    'type'    => 'googlefonts',
    'multilang' => true,
    'section' => 'it_typography',
);
$this->itr_settings['head_font_sample'] = array(
    'title'   => '',
    'desc'     => esc_html__( 'Grumpy wizards make toxic brew for the evil Queen and Jack.', 'munza' ),
    'type'    => 'label',
    'class'   => 'gfonts',
    'section' => 'it_typography',
);
$this->itr_settings['headings_font_weight'] = array(
    'title'   => esc_html__( 'Font Weight', 'munza' ),
    'std'     => '500',
    'type'    => 'select',
    'multilang' => true,
    'section' => 'it_typography',
    'choices' => array(
        ''          => esc_html__('-- Select --','munza'),
        'normal'    => esc_html__('normal','munza'),
        'bold'      => esc_html__('bold','munza'),
        'lighter'   => esc_html__('lighter','munza'),
        'bolder'    => esc_html__('bolder','munza'),
        '100'       => '100',
        '200'       => '200',
        '300'       => '300',
        '400'       => '400',
        '500'       => '500',
        '600'       => '600',
        '700'       => '700',
        '800'       => '800',
        '900'       => '900',
        'inherit'   => esc_html__('inherit','munza')
    )
);
$this->itr_settings['headings_lett_space'] = array(
    'title'   => esc_html__( 'Letter Spacing (px)', 'munza' ),
    'desc'    => esc_html__( 'Enter letter spacing in px.', 'munza' ),
    'type'    => 'number',
    'multilang' => true,
    'section' => 'it_typography'
);
$this->itr_settings['headings_text_style'] = array(
    'title'   => esc_html__( 'Text Style', 'munza' ),
    'type'    => 'select',
    'multilang' => true,
    'section' => 'it_typography',
    'choices' => array(
        ''              => esc_html__('-- Select --','munza'),
        'capitalize'    => esc_html__('Capitalize','munza'),
        'none'          => esc_html__('None','munza'),
        'lowercase'     => esc_html__('Lowercase','munza'),
        'uppercase'     => esc_html__('Uppercase','munza'),
    )
);
$this->itr_settings['typo_heading'] = array(
    'section' => 'it_typography',
    'desc'    => esc_html__( 'Custom Fonts', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'typo_ty-acc'
);
$this->itr_settings['custom_fonts'] = array(
    'title'   => esc_html__( 'Upload New Font', 'munza' ),
    'desc'    => esc_html__( 'The new font will appear in the Font Family selector (Just refresh the page after saving).', 'munza' ),
    'std'     => '0',
    'class'   => 'fontat',
    'type'    => 'addbox',
    'section' => 'it_typography',
);
$cfonts = isset($options['custom_fonts']) ? $options['custom_fonts'] : 0;
for( $i = 0 ; $i <= $cfonts ; $i++ ) {
    $this->itr_settings['custom_font_name_'.$i] = array(
        'title'   => esc_html__( 'Font-Family Name', 'munza' ),
        'type'    => 'text',
        'class'   => 'indval',
        'parent'    => 'custom_fonts',
        'section' => 'it_typography'
    );
    $this->itr_settings['custom_font_ttf_'.$i] = array(
        'title'   => esc_html__( 'Upload .ttf ', 'munza' ),
        'type'    => 'uploadfont',
        'parent'    => 'custom_fonts',
        'section' => 'it_typography'
    );
    $this->itr_settings['custom_font_eot_'.$i] = array(
        'title'   => esc_html__( 'Upload .eot ', 'munza' ),
        'type'    => 'uploadfont',      
        'parent'    => 'custom_fonts',
        'section' => 'it_typography'
    );
    $this->itr_settings['custom_font_svg_'.$i] = array(
        'title'   => esc_html__( 'Upload .svg ', 'munza' ),
        'type'    => 'uploadfont',      
        'parent'    => 'custom_fonts',
        'section' => 'it_typography'
    );
    $this->itr_settings['custom_font_woff_'.$i] = array(
        'title'   => esc_html__( 'Upload .woff ', 'munza' ),
        'type'    => 'uploadfont',      
        'parent'    => 'custom_fonts',
        'section' => 'it_typography'
    );
    $this->itr_settings['custom_font_css_'.$i] = array(
        'title'   => esc_html__( 'Extra css ', 'munza' ),
        'type'    => 'textarea',      
        'parent'    => 'custom_fonts',
        'section' => 'it_typography'
    );
}

/* Sliding Bar 
==========================================*/
$this->itr_settings['sld-bar'] = array(
    'section' => 'it_slidingbar',
    'desc'    => esc_html__( 'Settings', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'sld-sets-acc',
);
$this->itr_settings['show_sliding_bar'] = array(
    'section' => 'it_slidingbar',
    'title'   => esc_html__( 'Show Sliding Bar', 'munza' ),
    'type'    => 'checkbox',
);
$this->itr_settings['sliding_bar_sidebar'] = array(
    'title'     => esc_html__( 'Select Side Bar', 'munza' ),
    'desc'      => esc_html__( 'Select the side bar for sliding bar content.', 'munza' ),
    'type'      => 'select',
    'section'   => 'it_slidingbar',
    'multilang' => true,
    'choices'   => itr_sidebars_arr(),
    'dependency' => array(
        'element' => 'show_sliding_bar',
        'not_empty' => true
    )
);
$this->itr_settings['sliding_bar_columns'] = array(
    'title'   => esc_html__( 'Coulmns Per Row', 'munza' ),
    'desc'    => esc_html__( 'Select Number of horizontal coulmns per row.', 'munza' ),
    'std'     => '4',
    'type'    => 'select',
    'section' => 'it_slidingbar',
    'class'   => 'select_boxes',
    'choices' => array(
        '1' => '1',
        '2' => '2',
        '3' => '3',
        '4' => '4',
        '5' => '5',
        '6' => '6',
    ),
    'dependency' => array(
        'element' => 'show_sliding_bar',
        'not_empty' => true
    )
);
$this->itr_settings['sliding_bar_on_mobile'] = array(
    'section' => 'it_slidingbar',
    'title'   => esc_html__( 'Sliding Bar On Mobile', 'munza' ),
    'desc'    => esc_html__( 'Turn on to display the sliding bar on mobiles.', 'munza' ),
    'type'    => 'checkbox',
    'dependency' => array(
        'element' => 'show_sliding_bar',
        'not_empty' => true
    )
);
$this->itr_settings['sld-bar-styl'] = array(
    'section' => 'it_slidingbar',
    'desc'    => esc_html__( 'Styling', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'sld-styl-acc',
);
$this->itr_settings['slbr_icon_color'] = array(
    'title'   => esc_html__( 'Icon color', 'munza' ),
    'desc'    => esc_html__( 'Choose a color for Sliding bar button.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_slidingbar',
    'parentclass' => 'four_cells',
    'dependency' => array(
        'element'   => 'show_sliding_bar',
        'value'     => '1'
    ),
);
$this->itr_settings['slbr_icon_hovcolor'] = array(
    'title'   => esc_html__( 'Icon Hover color', 'munza' ),
    'desc'    => esc_html__( 'Choose a color for Sliding bar hover button.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_slidingbar',
    'parentclass' => 'four_cells',
    'dependency' => array(
        'element'   => 'show_sliding_bar',
        'value'     => '1'
    ),
);
$this->itr_settings['slbr_icon_bgcolor'] = array(
    'title'   => esc_html__( 'Icon Background color', 'munza' ),
    'desc'    => esc_html__( 'Choose a background color for Sliding bar button.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_slidingbar',
    'parentclass' => 'four_cells',
    'dependency' => array(
        'element'   => 'show_sliding_bar',
        'value'     => '1'
    ),
);
$this->itr_settings['slbr_icon_border_color'] = array(
    'title'   => esc_html__( 'Icon Border color', 'munza' ),
    'desc'    => esc_html__( 'Choose a border color for Sliding bar button.', 'munza' ),
    'type'    => 'color',
    'section' => 'it_slidingbar',
    'parentclass' => 'four_cells',
    'dependency' => array(
        'element'   => 'show_sliding_bar',
        'value'     => '1'
    ),
);
$this->itr_settings['sliding_padding'] = array(
    'title'   => esc_html__( 'Content Padding', 'munza' ),
    'desc'    => esc_html__( 'Top and Bottom Sliding bar content padding in px.', 'munza' ),
    'std'     => '80|80',
    'firstInput' => '<i class="stline-arrow-up"></i>',
    'lastInput' => '<i class="stline-arrow-down"></i>',
    'type'    => 'twonumber',
    'section' => 'it_slidingbar',
);
$this->itr_settings['sliding_bg_color'] = array(
    'title'   => esc_html__( 'Background Top Color', 'munza' ),
    'desc'    => esc_html__( 'Choose solid color for top gradient background color.', 'munza' ),
    'type'    => 'color',
    'defcolor'=> '#110046',
    'std'     => '#110046',
    'section' => 'it_slidingbar',
);
$this->itr_settings['sliding_bg_bot_color'] = array(
    'title'   => esc_html__( 'Background Bottom Color', 'munza' ),
    'desc'    => esc_html__( 'Choose solid color for sliding bar background.', 'munza' ),
    'type'    => 'color',
    'defcolor'=> '#32004a',
    'std'     => '#32004a',
    'section' => 'it_slidingbar',
);
$this->itr_settings['sliding_bar_headings_color'] = array(
    'title'   => esc_html__( 'Headings Color', 'munza' ),
    'desc'    => esc_html__( 'Choose solid color for the sliding bar heading font.', 'munza' ),
    'type'    => 'color',
    'std'     => '#fff',
    'section' => 'it_slidingbar',
); 
$this->itr_settings['sliding_bar_heading_font_size'] = array(
    'title'   => esc_html__( 'Heading Font Size', 'munza' ),
    'desc'    => esc_html__( 'Choose font size for the sliding bar heading text in px.', 'munza' ),
    'std'     => '17',
    'type'    => 'number',
    'section' => 'it_slidingbar',
);
$this->itr_settings['sliding_bar_font_color'] = array(
    'title'   => esc_html__( 'Content Font Color', 'munza' ),
    'desc'    => esc_html__( 'Choose solid color for the sliding bar font.', 'munza' ),
    'type'    => 'color',
    'std'=> '#ccc',
    'section' => 'it_slidingbar',
);
$this->itr_settings['sliding_bar_content_font_size'] = array(
    'title'   => esc_html__( 'Content Font Size', 'munza' ),
    'desc'    => esc_html__( 'Choose font size for the sliding bar content text in px.', 'munza' ),
    'std'     => '13',
    'type'    => 'number',
    'section' => 'it_slidingbar',
);

/* Blog options.
============================================*/  
$this->itr_settings['blog_listing_heading'] = array(
    'section' => 'it_blogoptions',
    'desc'    => esc_html__( 'Blog listing', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'general_bl-acc'
);     
$this->itr_settings['blogstyle'] = array(
    'title'   => esc_html__( 'Blog Listing Style', 'munza' ),
    'desc'    => esc_html__( 'Select blog posts listing style.', 'munza' ),
    'std'     => 'lg-image',
    'type'    => 'select',
    'section' => 'it_blogoptions',
    'class'   => 'select_boxes',
    'choices' => array(
        'lg-image'      => esc_html__('Large Image','munza'),
        'small-image'   => esc_html__('Side Image','munza'),
        'grid'          => esc_html__('Grid','munza'),
        'masonry'       => esc_html__('Masonry','munza'),
    )
);
$this->itr_settings['blog_columns'] = array(
    'title'   => esc_html__( 'Columns Per Row', 'munza' ),
    'desc'    => esc_html__( 'Select columns per row.', 'munza' ),
    'std'     => '6',
    'type'    => 'select',
    'section' => 'it_blogoptions',
    'class'   => 'select_boxes',
    'choices' => array(
        '6' => esc_html__('2 Columns','munza'),
        '4' => esc_html__('3 Columns','munza'),
        '3' => esc_html__('4 Columns','munza')
    ),
    'dependency' => array(
        'element' => 'blogstyle',
        'value' => array('grid','masonry')
    ),
);
$this->itr_settings['blog_image_size'] = array(
    'title'   => esc_html__( 'Featured Image Size', 'munza' ),
    'desc'    => esc_html__( 'Select Blog Featured Image Size.', 'munza' ),
    'std'     => 'large',
    'type'    => 'select',
    'section' => 'it_blogoptions',
    'choices' => itr_get_image_sizes()
);
$this->itr_settings['blog_sidebar'] = array(
    'title'   => esc_html__( 'Blog Sidebar', 'munza' ),
    'desc'    => esc_html__( 'Full width or with sidebar ?', 'munza' ),
    'std'     => 'right',
    'type'    => 'radioimages',
    'section' => 'it_blogoptions',
    'choices' => array(
        'right' => esc_html__('Right SideBar','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/right_bar.png',
        'left' => esc_html__('Left SideBar','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/left_bar.png',
        'nobar' => esc_html__('No SideBars','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/no_bar.png',
    )
);
$this->itr_settings['read_more_text'] = array(
    'title'   => esc_html__( 'Read More Text', 'munza' ),
    'desc'    => esc_html__( 'Enter Text that will be shown on the Read more button.', 'munza' ),
    'std'     => esc_html__('Read More','munza'),
    'multilang' => true,
    'value'   => 'Read More',
    'type'    => 'text',
    'section' => 'it_blogoptions',
    'dependency' => array(
        'element' => 'more_style',
        'value' => 'style1'
    ),
);
$this->itr_settings['pager_type'] = array(
    'title'   => esc_html__( 'Pager Type', 'munza' ),
    'desc'    => esc_html__( 'Select your prefered pager style.', 'munza' ),
    'std'     => '1',
    'type'    => 'select',
    'section' => 'it_blogoptions',
    'class'   => 'select_boxes',
    'choices' => array(
        '1' => esc_html__('Numeric + Navigation','munza'),
        '2' => esc_html__('Older Newer','munza'),
        '3' => esc_html__('Load More Button','munza')
    )
);
$this->itr_settings['pager_position'] = array(
    'title'   => esc_html__( 'Pager Position', 'munza' ),
    'desc'    => esc_html__( 'position for only Numeric Pager.', 'munza' ),
    'std'     => 'centered',
    'type'    => 'select',
    'section' => 'it_blogoptions',
    'class'   => 'select_boxes',
    'choices' => array(
        'pull-left' => esc_html__('Left','munza'),
        'centered'  => esc_html__('Center','munza'),
        'pull-right'=> esc_html__('Right','munza')
    ),
    'dependency' => array(
        'element' => 'pager_type',
        'value' => '1'
    ),
);
$this->itr_settings['load_more_text'] = array(
    'title'   => esc_html__( 'Load More Text', 'munza' ),
    'desc'    => esc_html__( 'Enter Text that will be shown on the load more button.', 'munza' ),
    'std'     => esc_html__('Load More','munza'),
    'value'   => 'Load More',
    'type'    => 'text',
    'section' => 'it_blogoptions',
    'dependency' => array(
        'element' => 'pager_type',
        'value' => '3'
    ),
);

$this->itr_settings['postimg_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Media', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post image.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['icon_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Post Icon', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post Icon.', 'munza' ),
    'type'    => 'checkbox',
);
$this->itr_settings['title_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Title', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post title.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['category_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Category', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post Category.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['date_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Date', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post Date.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['author_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show By Author', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Author info.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['social_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Social Icons', 'munza' ),
    'desc'    => esc_html__( 'Show Social Sharing icons.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1'
);
$this->itr_settings['comment_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Comments', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post Comments.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['excerpt_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Post Content', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post content.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['content_format_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Disable Post Content Format ?', 'munza' ),
    'desc'    => esc_html__( 'Enable / Disable Post content format in blog listing only.', 'munza' ),
    'type'    => 'checkbox',
    'dependency' => array(
        'element' => 'excerpt_on',
        'value' => '1'
    ),
);
$this->itr_settings['it_excerpt'] = array(
    'title'   => esc_html__( 'Max. number of words.', 'munza' ),
    'desc'    => esc_html__( 'Select Max. number of words to be shown, (Enter -1 to disable this feature).', 'munza' ),
    'std'     => '50',
    'type'    => 'number',
    'min'     => '-1',
    'max'     => '200',
    'section' => 'it_blogoptions',
    'dependency' => array(
        'element' => 'content_format_on',
        'value' => '1'
    ),
);

// Single post
$this->itr_settings['blog_single_heading'] = array(
    'section' => 'it_blogoptions',
    'desc'    => esc_html__( 'Single post', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'single_bl-acc'
);
$this->itr_settings['blog_single_sidebar'] = array(
    'title'   => esc_html__( 'Single Post Sidebar', 'munza' ),
    'desc'    => esc_html__( 'Full width or with sidebar ?', 'munza' ),
    'std'     => 'right',
    'type'    => 'radioimages',
    'section' => 'it_blogoptions',
    'choices' => array(
        'right' => esc_html__('Right SideBar','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/right_bar.png',
        'left'  => esc_html__('Left SideBar','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/left_bar.png',
        'nobar' => esc_html__('No SideBars','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/no_bar.png',
    )
);
$this->itr_settings['singlepostimg_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Media', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post media.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['post_icon_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Post Icon', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post Icon.', 'munza' ),
    'type'    => 'checkbox',
);
$this->itr_settings['singledate_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Date', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post Date.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['singleauthor_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show By Author', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Author info.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
if ( class_exists( 'munza_Core' ) ){
    $this->itr_settings['singleviews_on'] = array(
        'section' => 'it_blogoptions',
        'title'   => esc_html__( 'Show Post Views', 'munza' ),
        'desc'    => esc_html__( 'Show / Hide Post Views.', 'munza' ),
        'type'    => 'checkbox',
        'std'     => '1',
    );
    $this->itr_settings['singlelike_on'] = array(
        'section' => 'it_blogoptions',
        'title'   => esc_html__( 'Show Like Button', 'munza' ),
        'desc'    => esc_html__( 'Show / Hide Like button.', 'munza' ),
        'type'    => 'checkbox',
        'std'     => '1',
    );
}
$this->itr_settings['singlecategory_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Category', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post Category.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['singletitle_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Post Title', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post Title.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['singlecontent_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Post Content', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post content.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['singlesocial_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Social Icons', 'munza' ),
    'desc'    => esc_html__( 'Show Social Sharing icons.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1'
);
$this->itr_settings['singletags_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Tags', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post Tags.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['singleprevnext_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Post navigation', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Previous/Next post navigation.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['singleauthorbox_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Author Info Box', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Author info box.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['singlecomment_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Comments', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Post Comments.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['singlerelated_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Related Posts', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide Related Posts.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['blog_socials_heading'] = array(
    'section' => 'it_blogoptions',
    'desc'    => esc_html__( 'Social Share', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'share_bl-acc',
);
$this->itr_settings['tw_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Twitter', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['fb_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Facebook', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['gplus_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Google Plus', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['ln_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'LinkedIn', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['pin_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Pinterest', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1',
);
$this->itr_settings['whatsapp_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'WhatsApp', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '',
);
$this->itr_settings['email_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Email', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '',
);
$this->itr_settings['stumbleupon_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Stumbleupon', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '',
);
$this->itr_settings['telegram_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Telegram', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '',
);
$this->itr_settings['viber_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Viber', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '',
);
$this->itr_settings['pocket_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Pocket', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '',
);
$this->itr_settings['vkontakte_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Vkontakte', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '',
);
$this->itr_settings['messenger_on'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Messenger', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '',
);    

// Authors Page
$this->itr_settings['author-heading'] = array(
    'section' => 'it_blogoptions',
    'desc'    => esc_html__( 'Authors Page', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'author-acc'
);
$this->itr_settings['show_auth_info'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Author Info', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide the author info.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1'
);
$this->itr_settings['show_auth_posts'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Show Author Posts', 'munza' ),
    'desc'    => esc_html__( 'Show / Hide the author Posts.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1'
);
$this->itr_settings['auth_posts_style'] = array(
    'title'   => esc_html__( 'Author Posts Listing Style', 'munza' ),
    'desc'    => esc_html__( 'Select Author Posts listing style.', 'munza' ),
    'std'     => 'large',
    'type'    => 'select',
    'section' => 'it_blogoptions',
    'class'   => 'select_boxes',
    'choices' => array(
        'lg-image'      => esc_html__('Large Image','munza'),
        'small-image'   => esc_html__('Small Image','munza'),
        'masonry'       => esc_html__('Masonry','munza'),
        'grid'          => esc_html__('Grid','munza')
    ),
    'dependency' => array(
        'element' => 'show_auth_posts',
        'not_empty' => true
    ),
);
$this->itr_settings['auth_content_before'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Content Before', 'munza' ),
    'desc'    => esc_html__( 'Add Text or HTML at the top of auther page.', 'munza' ),
    'multilang' => true,
    'type'    => 'editor',
    'dependency' => array(
        'element' => 'show_auth_posts',
        'not_empty' => true
    ),
);
$this->itr_settings['auth_content_after'] = array(
    'section' => 'it_blogoptions',
    'title'   => esc_html__( 'Content After', 'munza' ),
    'desc'    => esc_html__( 'Add Text or HTML at the end of auther page.', 'munza' ),
    'multilang' => true,
    'type'    => 'editor',
    'dependency' => array(
        'element' => 'show_auth_posts',
        'not_empty' => true
    ),
);

/* SideBars.
============================================*/
$this->itr_settings['sidebars-options'] = array(
    'section' => 'it_sidebars',
    'desc'    => esc_html__('Add Sidebar','munza'),
    'type'    => 'heading',
    'data_id' => 'sidebars-acc'
);
$this->itr_settings['sidebars'] = array(
    'section' => 'it_sidebars',
    'title'   => esc_html__( 'sidebars', 'munza' ),
    'desc'    => esc_html__( 'Add unlimited sidebars the go to Widgets to add widgets for it.', 'munza' ),
    'class'   => 'bars',
    'type'    => 'addbox',
    'std'     => '0'
);

$cbars = isset($options['sidebars']) ? $options['sidebars'] : 0;        
for( $i = 0 ; $i <= $cbars ; $i++ ) {
    $this->itr_settings['sidebar_'.$i] = array(
        'title'   => esc_html__( 'Sidebar Name ', 'munza' ),
        'std'     => esc_html__('Sidebar Name','munza'),
        'type'    => 'text',
        'parent'  => 'sidebars',
        'class'   => 'indval',    
        'section' => 'it_sidebars'
    );
}
$this->itr_settings['sidebars-heading'] = array(
    'section' => 'it_sidebars',
    'desc'    => esc_html__( 'Sidebars', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'sidebars-styling-acc'
);
$this->itr_settings['page_sidebar'] = array(
    'title'   => esc_html__( 'Page Sidebar', 'munza' ),
    'desc'    => esc_html__( 'Full width or with sidebar ?', 'munza' ),
    'std'     => 'right',
    'type'    => 'radioimages',
    'section' => 'it_sidebars',
    'choices' => array(
        'right' => esc_html__('Right SideBar','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/right_bar.png',
        'left'  => esc_html__('Left SideBar','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/left_bar.png',
        'nobar' => esc_html__('No SideBars','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/no_bar.png',
    ),
    'std' => 'nobar'
);

/* Demo Data
===========================================*/
if ( class_exists( 'munza_Core' ) ) {
    $this->itr_settings['import_data'] = array(
        'title'   => esc_html__( 'Install Demo Data', 'munza' ),
        'type'    => 'import_data',
        'section' => 'it_demo'
    );
    $this->itr_settings['demo_desc'] = array(
        'section' => 'it_demo',
        'desc'    => '<p>'.esc_html__('This will import all pages, posts, menus, images, videos and theme options like our demo site.','munza').'</p><p><b class="underline">'.esc_html__('The Importer Needs Some Server Configuration to work properly:','munza').'</b></p><ul><li>- <b>'.esc_html__('PHP','munza').'</b> '.esc_html__('version to be','munza').'<b>5.6.3</b> '.esc_html__('or Higher','munza').'.</li><li>- <b>memory_limit 128M</b> '.esc_html__('or Higher','munza').'</li><li>- <b>max_execution_time 180</b> '.esc_html__('or Higher','munza').'</li><li>- <b>post_max_size 32M</b> '.esc_html__('or Higher','munza').'</li><li>- <b>upload_max_filesize 32M</b> '.esc_html__('or Higher','munza').'</li></ul><br>
                    <strong>'.esc_html__('Please make sure to disable the WordPress Importer Plugin before importing the demo data','munza').'.</strong>',
        'type'    => 'label',
        'class'   => 'itr_notice_msg info'
    );
}

/* Social icons.
============================================*/     
$this->itr_settings['socials-heading'] = array(
    'section' => 'it_socialicons',
    'desc'    => esc_html__( 'Add Social Icons', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'socials-acc'
);
$this->itr_settings['social_icons'] = array(
    'section' => 'it_socialicons',
    'title'   => esc_html__( 'Social Icon', 'munza' ),
    'desc'    => esc_html__( 'Add unlimited social icons.', 'munza' ),
    'type'    => 'addbox',
    'class'   => 'socials',
    'std'     => '0'
);
$csocials = isset($options['social_icons']) ? $options['social_icons'] : 0;
for( $i = 0 ; $i <= $csocials ; $i++ ) {
    $this->itr_settings['social_icon_'.$i] = array(
        'title'   => esc_html__( 'Icon', 'munza' ),
        'type'    => 'icon',
        'multilang' => true, 
        'parent'    => 'social_icons',
        'section' => 'it_socialicons'
    );
    $this->itr_settings['social_icon_title_'.$i] = array(
        'title'   => esc_html__( 'Title ', 'munza' ),
        'class'   => 'indval',
        'type'    => 'text',
        'parent'    => 'social_icons',
        'section' => 'it_socialicons'
    );
    $this->itr_settings['social_icon_link_'.$i] = array(
        'title'   => esc_html__( 'Link ', 'munza' ),
        'type'    => 'text',
        'parent'    => 'social_icons',
        'section' => 'it_socialicons'
    );
}
$this->itr_settings['socs-set-heading'] = array(
    'section' => 'it_socialicons',
    'desc'    => esc_html__( 'Styling', 'munza' ),
    'type'    => 'heading',
    'data_id' => 'soc-sets-acc'
);
$this->itr_settings['socials_nofollow'] = array(
    'section' => 'it_socialicons',
    'title'   => esc_html__( 'Add "nofollow"', 'munza' ),
    'desc'    => esc_html__( '"ON" to add "nofollow" attribute to all social links.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => ''
);
$this->itr_settings['socials_new_window'] = array(
    'section' => 'it_socialicons',
    'title'   => esc_html__( 'Open in a New Window', 'munza' ),
    'desc'    => esc_html__( '"ON" to allow social icons to open in a new window.', 'munza' ),
    'type'    => 'checkbox',
    'std'     => '1'
);

/* woocommerce
===========================================*/
if(class_exists('Woocommerce')) {
    $this->itr_settings['shop_heading'] = array(
        'section' => 'it_woocommerce',
        'desc'    => esc_html__( 'Products Listing', 'munza' ),
        'type'    => 'heading',
        'data_id' => 'shop-acc'
    );
    $this->itr_settings['show_sidebar_woo'] = array(
        'section' => 'it_woocommerce',
        'title'   => esc_html__( 'Show Side Bar', 'munza' ),
        'type'    => 'checkbox',
        'desc'    => esc_html__( 'Show / Hide sidebar in shop page.', 'munza' )
    );
    
    $this->itr_settings['sidebar_woo'] = array(
        'title'   => esc_html__( 'Select Side Bar', 'munza' ),
        'desc'    => esc_html__( 'Select the side bar for shop pages.', 'munza' ),
        'type'    => 'select',
        'section' => 'it_woocommerce',
        'choices' => itr_sidebars_arr(),
        'dependency' => array(
            'element' => 'show_sidebar_woo',
            'not_empty' => true
        ),
    );
    $this->itr_settings['sidebar_position_woo'] = array(
        'title'   => esc_html__( 'Sidebar Position', 'munza' ),
        'desc'    => esc_html__( 'Select the position of the sidebar.', 'munza' ),
        'std'     => 'right',
        'type'    => 'select',
        'section' => 'it_woocommerce',
        'class'   => 'select_boxes',
        'choices' => array(
            'right' => esc_html__('Right','munza'),
            'left'  => esc_html__('Left','munza')
        ),
        'dependency' => array(
            'element' => 'show_sidebar_woo',
            'not_empty' => true
        ),
    );
    $this->itr_settings['columns_woo'] = array(
        'title'   => esc_html__( 'Products Columns', 'munza' ),
        'desc'    => esc_html__( 'Number of columns per row.', 'munza' ),
        'std'     => '4',
        'type'    => 'select',
        'section' => 'it_woocommerce',
        'class'   => 'select_boxes',
        'choices' => array(
            '6' => esc_html__('2 Columns','munza'),
            '4' => esc_html__('3 Columns','munza'),
            '3' => esc_html__('4 Columns','munza')
        )
    );
    
    $this->itr_settings['product_single_heading'] = array(
        'section' => 'it_woocommerce',
        'desc'    => esc_html__( 'Single Product', 'munza' ),
        'type'    => 'heading',
        'data_id' => 'shop-single-acc'
    );
    
    $this->itr_settings['show_sidebar_single_woo'] = array(
        'section' => 'it_woocommerce',
        'title'   => esc_html__( 'Show Side Bar ?', 'munza' ),
        'type'    => 'checkbox',
        'desc'    => esc_html__( 'Show / Hide sidebar in single product page.', 'munza' )
    );
    $this->itr_settings['single_sidebar_position_woo'] = array(
        'title'   => esc_html__( 'Sidebar Position', 'munza' ),
        'desc'    => esc_html__( 'Select the position of the sidebar.', 'munza' ),
        'std'     => 'right',
        'type'    => 'select',
        'section' => 'it_woocommerce',
        'class'   => 'select_boxes',
        'choices' => array(
            'right' => esc_html__('Right','munza'),
            'left'  => esc_html__('Left','munza')
        ),
        'dependency' => array(
            'element' => 'show_sidebar_single_woo',
            'not_empty' => true
        ),
    );
    
    $this->itr_settings['related_heading'] = array(
        'section' => 'it_woocommerce',
        'desc'    => esc_html__( 'Related Products', 'munza' ),
        'type'    => 'heading',
        'data_id' => 'shop-related-acc'
    );
    $this->itr_settings['related_per_page'] = array(
        'title'   => esc_html__( 'Related Products Per Page', 'munza' ),
        'std'     => '4',
        'type'    => 'number',
        'min'     => '1',
        'max'     => '50',
        'section' => 'it_woocommerce',
        'dependency' => array(
            'element' => 'show_related_woo',
            'not_empty' => true
        ),
    );
    $this->itr_settings['related_columns_woo'] = array(
        'title'   => esc_html__( 'Related Products Columns', 'munza' ),
        'std'     => '4',
        'type'    => 'select',
        'section' => 'it_woocommerce',
        'class'   => 'select_boxes',
        'choices' => array(
            '6' => esc_html__('2 Columns','munza'),
            '4' => esc_html__('3 Columns','munza'),
            '3' => esc_html__('4 Columns','munza')
        ),
        'dependency' => array(
            'element' => 'show_related_woo',
            'not_empty' => true
        ),
    );
}

/* bbpress
===========================================*/
if(class_exists('bbPress')) {
    $this->itr_settings['show_welcome_bb'] = array(
        'section' => 'it_bbpress',
        'title'   => esc_html__( 'Show Welcome message', 'munza' ),
        'type'    => 'checkbox',
        'std'     => '1',
        'desc'    => esc_html__( 'Show / Hide welcome message.', 'munza' )
    );
    $this->itr_settings['welcome_bb'] = array(
        'section' => 'it_bbpress',
        'title'   => esc_html__( 'Welcome Message', 'munza' ),
        'desc'    => esc_html__( 'Insert here the welcome message that will appear in the top of the forums.', 'munza' ),
        'multilang' => true,
        'type'    => 'editor',
        'std'     => 'Welcome to our Forums! We love to have you part of our friendly community, discovering the best in everything. As a member, the system will remember where you left off in threads and with sufficient post count.',
        'dependency' => array(
            'element' => 'show_welcome_bb',
            'not_empty' => true
        ),
    );
}

return $this->itr_settings;