<?php
/**
 *
 * IT-RAYS Framework
 *
 * @author IT-RAYS
 * @license Commercial License
 * @link http://www.it-rays.net
 * @copyright 2017 IT-RAYS Themes
 * @package ITFramework
 * @version 1.0.0
 *
 */
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );
 
require_once( get_parent_theme_file_path('it-framework/classes/it-meta-boxes.class.php') );

$itr_cusom_page_box = array(
    'id'       => 'cusom_page_settings',
    'title'    => esc_html__('Custom Page Settings','munza'),
    'fields'   => array(),
);
$itr_cusom_page_box =  new ITR_MetaBoxes($itr_cusom_page_box);

/* General Settings
============================================= */
$itr_cusom_page_box->itr_type_radioimages(
    'meta_main_layout',
    array(
        'name'      => esc_html__('Main Layout Width.','munza'), 
        'section'   => 'itr_general',
        'choices'   => array(
            ''      => esc_html__('Inherit From Theme','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/blank_thmb.png',
            'wide'  => esc_html__('Wide Layout','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/theme_wide.png',
            'boxed' => esc_html__('Boxed Layout','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/theme_boxed.png',
        ),
    )
);
$itr_cusom_page_box->itr_type_radioimages(
    'meta_page_layout',
    array(
        'name'      => esc_html__('Page Layout Mode.','munza'), 
        'section'   => 'itr_general',
        'choices'   => array(
            ''              => esc_html__('Inherit From Theme','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/blank_thmb.png',
            'right'         => esc_html__('Right SideBar','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/right_bar.png',
            'left'          => esc_html__('Left SideBar','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/left_bar.png',
            'full_width'    => esc_html__('Full Width','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/no_bar.png',
            'wide'          => esc_html__('100% Width','munza').'|'.get_template_directory_uri() .'/it-framework/assets/images/wide.png',
        ),
    )
);  
$itr_cusom_page_box->itr_type_checkbox(
    'meta_fullscreen_onepage',
    array(
        'name'      => esc_html__('FullScreen One Page','munza'),
        'section'   => 'itr_general',
    )
);
$itr_cusom_page_box->itr_type_sidebars(
    'meta_sidebar_select',
    array(
        'name'          => esc_html__('Select Sidebar','munza'),
        'section'       => 'itr_general',
        'dependency'    => array(
            'element'   => 'meta_page_layout',
            'value'     => array('right','left')
        )
    )
);
$itr_cusom_page_box->itr_type_menus(
    'meta_page_menu',
    array(
        'name'      => esc_html__('Choose Menu.','munza'), 
        'section'   => 'itr_general',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_body_main_color',
    array(
        'name'      => esc_html__('Main Site Color','munza'),
        'section'   => 'itr_general',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_body_font_color',
    array(
        'name'      => esc_html__('Font Color','munza'),
        'section'   => 'itr_general',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_body_link_color',
    array(
        'name'      => esc_html__('Links Color','munza'),
        'section'   => 'itr_general',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_body_bg_color',
    array(
        'name'      => esc_html__('Background Color','munza'),
        'section'   => 'itr_general',
    )
);
$itr_cusom_page_box->itr_type_uploadfile(
    'meta_body_bg_img',
    array(
        'name'      => esc_html__('Background image','munza'),
        'section'   => 'itr_general',
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_body_bg_repeat',
    array(
        ''          => esc_html__('Repeat','munza'),
        'no-repeat' => esc_html__('No Repeat','munza'),
        'repeat-x'  => esc_html__('Repeat Horizontal','munza'),
        'repeat-y'  => esc_html__('Repeat Vertical','munza'),
    ),
    array(
        'name'          => esc_html__('Background Repeat','munza'),
        'section'       => 'itr_general',
        'dependency'    => array(
            'element'   => 'meta_body_bg_img',
            'not_empty' => true
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_body_bg_size',
    array(
        ''          => esc_html__('Inherit','munza'),
        'cover'     => esc_html__('Cover','munza'),
        'contain'   => esc_html__('Contain','munza'),
        '100% 100%' => esc_html__('100%','munza'),
    ),
    array(
        'name'          => esc_html__('Background Size','munza'),
        'section'       => 'itr_general',
        'class'         => 'select_boxes',
        'dependency'    => array(
            'element'   => 'meta_body_bg_img',
            'not_empty' => true
        )
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_body_parallax',
    array(
        'name'          => esc_html__('Fixed Background ?','munza'),
        'section'       => 'itr_general',
        'dependency'    => array(
            'element'   => 'meta_body_bg_img',
            'not_empty' => true
        )
    )
);

/* Top Bar Settings
============================================= */
$itr_cusom_page_box->itr_type_select(
    'meta_hide_top_bar',
    array(
        ''      => esc_html__('Inherit From Theme','munza'),
        '1'     => esc_html__('Show','munza'),
        '2'     => esc_html__('Hide','munza'),
    ),
    array(
        'name'   => esc_html__('Visibility','munza'), 
        'class'  => 'select_boxes',
        'section'=> 'itr_topbar',
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_topbar_color',
    array(
        ''          => esc_html__('-- Select Color --','munza'),
        'light'     => esc_html__('Light','munza'),
        'gry-bg'    => esc_html__('Grey','munza'),
        'main-bg'   => esc_html__('Colored','munza'),
        'dark-bg'   => esc_html__('Dark','munza'),
        'custom'    => esc_html__('Custom','munza'),
    ),
    array(
        'name'      => esc_html__('Color','munza'),
        'section'   => 'itr_topbar', 
        'class'     => 'select_boxes',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_bar_color',
    array(
        'name'          => esc_html__('Background Color','munza'),
        'section'       => 'itr_topbar',
        'dependency'    => array(
            'element'   => 'meta_topbar_color',
            'value'     => 'custom'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_bar_fcolor',
    array(
        'name'          => esc_html__('Font Color','munza'),
        'section'       => 'itr_topbar',
        'dependency'    => array(
            'element'   => 'meta_topbar_color',
            'value'     => 'custom'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_bar_hovcolor',
    array(
        'name'          => esc_html__('Hover Color','munza'),
        'section'       => 'itr_topbar',
        'dependency'    => array(
            'element'   => 'meta_topbar_color',
            'value'     => 'custom'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_bar_icolor',
    array(
        'name'          => esc_html__('Icons Color','munza'),
        'section'       => 'itr_topbar',
        'dependency'    => array(
            'element'   => 'meta_topbar_color',
            'value'     => 'custom'
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_bar_full',
    array(
        ''      => esc_html__('Inherit From Theme','munza'),
        '1'     => esc_html__('Yes','munza'),
        '2'     => esc_html__('No','munza'),
    ),
    array(
        'name'      => esc_html__('Full Width','munza'),
        'section'   => 'itr_topbar',
        'class'     => 'select_boxes'
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_bar_border',
    array(
        ''      => esc_html__('Inherit From Theme','munza'),
        '1'     => esc_html__('Yes','munza'),
        '2'     => esc_html__('No','munza'),
    ),
    array(
        'name'      => esc_html__('Bottom Border','munza'),
        'section'   => 'itr_topbar',
        'class'     => 'select_boxes'
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_bar_bor_bot_color',
    array(
        'name'      => esc_html__('Border Bottom Color','munza'),
        'section'   => 'itr_topbar',
        'dependency'    => array(
            'element'   => 'meta_bar_border',
            'value'     => '1'
        ),
    )
);
$itr_cusom_page_box->itr_type_textbox(
    'meta_bar_extra_class',
    array(  
        'name'      => esc_html__('Extra CSS Class','munza'),
        'section'   => 'itr_topbar',
    )
);

/* Header Settings
============================================= */
$itr_cusom_page_box->itr_type_select(
    'meta_header_style',
    array(
        ''             => esc_html__('Inherit from theme','munza'),
        'classic'      => esc_html__('Classic','munza'),
        'modern'       => esc_html__('Modern','munza'),
        'creative'     => esc_html__('Creative','munza'),
        'side'         => esc_html__('Side','munza')
    ),
    array(
        'name'      => esc_html__('Header Style','munza'), 
        'section'   => 'itr_header',
        'class'     => 'select_boxes',
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_header_left_area',
    array(
        ''              => esc_html__('Inherit from theme','munza'),
        'logo'          => esc_html__('Logo','munza'),
        'menu'          => esc_html__('Menu','munza'),
        'icons'         => esc_html__('Icons','munza'),
        'button'        => esc_html__('Button','munza'),
        'none'          => esc_html__('None','munza')
    ),
    array(
        'name'      => esc_html__('Left Area','munza'), 
        'section'   => 'itr_header',
        'class'     => 'select_boxes',
        'dependency'    => array(
            'element'   => 'meta_header_style',
            'value'     => 'modern'
        )
    )
);
$itr_cusom_page_box->itr_type_menus(
    'meta_header_left_area_menu',
    array(
        'name'          => esc_html__('Choose Menu','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_left_area',
            'value'     => 'menu'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_header_left_btn_color',
    array(
        'name'      => esc_html__('Button Color','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_left_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_header_left_btn_bg_color',
    array(
        'name'      => esc_html__('Button Background Color','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_left_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_textbox(
    'meta_header_left_btn_txt',
    array(
        'name'      => esc_html__('Button Text','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_left_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_textbox(
    'meta_header_left_btn_link',
    array(
        'name'      => esc_html__('Button Link','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_left_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_header_left_btn_target',
    array(
        'name'          => esc_html__('New Window','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_left_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_header_center_area',
    array(
        ''              => esc_html__('Inherit from theme','munza'),
        'logo'          => esc_html__('Logo','munza'),
        'menu'          => esc_html__('Menu','munza'),
        'icons'         => esc_html__('Icons','munza'),
        'button'        => esc_html__('Button','munza'),
        'none'          => esc_html__('None','munza')
    ),
    array(
        'name'      => esc_html__('Center Area','munza'), 
        'section'   => 'itr_header',
        'class'     => 'select_boxes',
        'dependency'    => array(
            'element'   => 'meta_header_style',
            'value'     => 'modern'
        )
    )
);
$itr_cusom_page_box->itr_type_menus(
    'meta_header_center_area_menu',
    array(
        'name'          => esc_html__('Choose Menu','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_center_area',
            'value'     => 'menu'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_header_center_btn_color',
    array(
        'name'      => esc_html__('Button Color','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_center_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_header_center_btn_bg_color',
    array(
        'name'      => esc_html__('Button Background Color','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_center_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_textbox(
    'meta_header_center_btn_txt',
    array(
        'name'      => esc_html__('Button Text','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_center_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_textbox(
    'meta_header_center_btn_link',
    array(
        'name'      => esc_html__('Button Link','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_center_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_header_center_btn_target',
    array(
        'name'          => esc_html__('New Window','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_center_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_header_right_area',
    array(
        ''              => esc_html__('Inherit from theme','munza'),
        'logo'          => esc_html__('Logo','munza'),
        'menu'          => esc_html__('Menu','munza'),
        'icons'         => esc_html__('Icons','munza'),
        'button'        => esc_html__('Button','munza'),
        'none'          => esc_html__('None','munza')
    ),
    array(
        'name'      => esc_html__('Right Area','munza'), 
        'section'   => 'itr_header',
        'class'     => 'select_boxes',
        'dependency'    => array(
            'element'   => 'meta_header_style',
            'value'     => 'modern'
        )
    )
);
$itr_cusom_page_box->itr_type_menus(
    'meta_header_right_area_menu',
    array(
        'name'          => esc_html__('Choose Menu','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_right_area',
            'value'     => 'menu'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_header_right_btn_color',
    array(
        'name'      => esc_html__('Button Color','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_right_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_header_right_btn_bg_color',
    array(
        'name'      => esc_html__('Button Background Color','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_right_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_textbox(
    'meta_header_right_btn_txt',
    array(
        'name'      => esc_html__('Button Text','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_right_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_textbox(
    'meta_header_right_btn_link',
    array(
        'name'      => esc_html__('Button Link','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_right_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_header_right_btn_target',
    array(
        'name'          => esc_html__('New Window','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_right_area',
            'value'     => 'button'
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_side_dir',
    array(
        ''                 => esc_html__('Inherit from theme','munza'),
        'left'             => esc_html__('Left','munza'),
        'right'            => esc_html__('Right','munza')
    ),
    array(
        'name'      => esc_html__('Direction','munza'), 
        'section'   => 'itr_header',
        'class'     => 'select_boxes',
        'dependency'    => array(
            'element'   => 'meta_header_style',
            'value'     => 'side'
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_header_invisible',
    array(
        ''          => esc_html__('Inherit from theme','munza'),
        '1'         => esc_html__('Yes','munza'),
        '0'         => esc_html__('No','munza')
    ),
    array(
        'name'          => esc_html__('Invisible','munza'),
        'section'       => 'itr_header',
        'class'         => 'select_boxes',
        'dependency'    => array(
            'element'   => 'meta_header_style',
            'value'     => 'side'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_side_btn_color',
    array(
        'name'      => esc_html__('Button Color','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_style',
            'value'     => 'side'
        )
    )
);
$itr_cusom_page_box->itr_type_uploadfile(
    'meta_logo_img',
    array(
        'name'      => esc_html__('Custom Logo','munza'),
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_uploadfile(
    'meta_sticky_logo_img',
    array(
        'name'      => esc_html__('Sticky Header Custom Logo','munza'),
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_header_fixed',
    array(
        ''          => esc_html__('Inherit from theme','munza'),
        '1'         => esc_html__('Yes','munza'),
        '0'         => esc_html__('No','munza')
    ),
    array(
        'name'          => esc_html__('Fixed','munza'),
        'section'       => 'itr_header',
        'class'         => 'select_boxes',
        'dependency'    => array(
            'element'   => 'meta_header_style',
            'value'     => array( 'classic' , 'creative' , 'modern' )
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_header_full',
    array(
        ''      => esc_html__('Inherit From Theme','munza'),
        '1'     => esc_html__('Yes','munza'),
        '2'     => esc_html__('No','munza'),
    ),
    array(
        'name'      => esc_html__('Full Width','munza'),
        'section'   => 'itr_header',
        'class'     => 'select_boxes',
        'dependency'    => array(
            'element'   => 'meta_header_style',
            'value'     => array( 'classic' , 'creative' , 'modern' )
        ),
    )
);
$itr_cusom_page_box->itr_type_numberbox(
    'meta_header_height',
    array(  
        'name'      => esc_html__('Height','munza'),
        'section'   => 'itr_header',
        'std'       => '',
    )
);
$itr_cusom_page_box->itr_type_twonumber(
    'meta_head_padding',
    array(  
        'name'          => esc_html__('Padding','munza'),
        'section'       => 'itr_header',
        'firstInput'    => 'Left',
        'lastInput'     => 'Right',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_header_font_color',
    array(
        'name'      => esc_html__('Links Color','munza'),
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_header_icon_color',
    array(
        'name'      => esc_html__('Menu Icons Color','munza'),
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_header_hover_color',
    array(
        'name'      => esc_html__('Links Hover Color','munza'),
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_header_hover_border_color',
    array(
        'name'      => esc_html__('Links Hover Border Color','munza'),
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_header_bor_top_color',
    array(
        'name'      => esc_html__('Border Top Color','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_style',
            'value'     => array( 'classic' , 'creative' )
        ),
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_header_bor_bot_color',
    array(
        'name'      => esc_html__('Border Bottom Color','munza'),
        'section'   => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_style',
            'value'     => array( 'classic' , 'creative' )
        ),
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_header_bg_color',
    array(
        'name'      => esc_html__('Background Color','munza'),
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_uploadfile(
    'meta_header_bg_img',
    array(
        'name'      => esc_html__('Background image','munza'),
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_header_bg_repeat',
    array(
        ''          => esc_html__('Repeat','munza'),
        'no-repeat' => esc_html__('No Repeat','munza'),
        'repeat-x'  => esc_html__('Repeat Horizontal','munza'),
        'repeat-y'  => esc_html__('Repeat Vertical','munza'),
    ),
    array(
        'name'          => esc_html__('Background Repeat','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_bg_img',
            'not_empty' => true
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_header_bg_size',
    array(
        ''          => esc_html__('Inherit From Theme','munza'),
        'cover'     => esc_html__('Cover','munza'),
        'contain'   => esc_html__('Contain','munza'),
        '100% 100%' => esc_html__('100%','munza'),
    ),
    array(
        'name'          => esc_html__('Background Size','munza'),
        'section'       => 'itr_header',
        'class'         => 'select_boxes',
        'dependency'    => array(
            'element'   => 'meta_header_bg_img',
            'not_empty' => true
        )
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_header_parallax',
    array(
        'name'          => esc_html__('Parallax Background ?','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_header_bg_img',
            'not_empty' => true
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_header_icons',
    array(
        ''      => esc_html__('Inherit From Theme','munza'),
        '1'     => esc_html__('Yes','munza'),
        '2'     => esc_html__('No','munza'),
    ),
    array(
        'name'      => esc_html__('Show Icons','munza'),
        'section'   => 'itr_header',
        'class'     => 'select_boxes'
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_header_sub_icons',
    array(
        ''      => esc_html__('Inherit From Theme','munza'),
        '1'     => esc_html__('Yes','munza'),
        '2'     => esc_html__('No','munza'),
    ),
    array(
        'name'      => esc_html__('Show Submenu Icons','munza'),
        'section'   => 'itr_header',
        'class'     => 'select_boxes'
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_header_subtitle',
    array(
        ''      => esc_html__('Inherit From Theme','munza'),
        '1'     => esc_html__('Yes','munza'),
        '2'     => esc_html__('No','munza'),
    ),
    array(
        'name'      => esc_html__('Show Menu Subtitles','munza'),
        'section'   => 'itr_header',
        'class'     => 'select_boxes'
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_sub_menu_color',
    array(
        ''           => esc_html__('Inherit From Theme','munza'),
        'light'      => esc_html__('Light','munza'),
        'dark-sub'   => esc_html__('Dark','munza'),
        'colored'    => esc_html__('Colored','munza'),
        'custom'     => esc_html__('Custom','munza')
    ),
    array(
        'name'      => esc_html__('Sub Menu Color','munza'), 
        'class'     => 'select_boxes',
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_cust_sub_color',
    array(
        'name'          => esc_html__('Font Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_sub_menu_color',
            'value'     => 'custom'
        )
    )
);
$itr_cusom_page_box->itr_type_numberbox(
    'meta_menu_font_size',
    array(  
        'name'          => esc_html__('Menu Font Size (px)','munza'),
        'section'       => 'itr_header',
        'std'           => '',
    )
);
$itr_cusom_page_box->itr_type_numberbox(
    'meta_menu_letter',
    array(  
        'name'          => esc_html__('Menu Letter Spacing (px)','munza'),
        'section'       => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_menu_weight',
    array(
        ''          => esc_html__('Inherit From Theme','munza'),
        'normal'    => esc_html__('normal','munza'),
        'bold'      => esc_html__('bold','munza'),
        'lighter'   => esc_html__('lighter','munza'),
        'bolder'    => esc_html__('bolder','munza'),
        '100'       => '100',
        '200'       => '200',
        '300'       => '300',
        '400'       => '400',
        '500'       => '500',
        '600'       => '600',
        '700'       => '700',
        '800'       => '800',
        '900'       => '900',
        'inherit'   => esc_html__('inherit','munza')
    ),
    array(
        'name'      => esc_html__('Menu Font Weight','munza'), 
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_menu_style',
    array(
        ''          => esc_html__('Inherit From Theme','munza'),
        'none'      => esc_html__('None','munza'),
        'capitalize'=> esc_html__('Capitalize','munza'),
        'lowercase' => esc_html__('Lowercase','munza'),
        'uppercase' => esc_html__('Uppercase','munza'),
    ),
    array(
        'name'      => esc_html__('Menu Text Style','munza'), 
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_cust_sub_bg_color',
    array(
        'name'          => esc_html__('Background Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_sub_menu_color',
            'value'     => 'custom'
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_header_sticky',
    array(
        ''      => esc_html__('Inherit From Theme','munza'),
        '1'     => esc_html__('Yes','munza'),
        '2'     => esc_html__('No','munza'),
    ),
    array(
        'name'      => esc_html__('Sticky Header','munza'), 
        'class'     => 'select_boxes',
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_hide_menu',
    array(
        'name'      => esc_html__('Hide Logo & Menu','munza'),
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_hide_search',
    array(
        ''      => esc_html__('Inherit From Theme','munza'),
        '1'     => esc_html__('Yes','munza'),
        '2'     => esc_html__('No','munza'),
    ),
    array(
        'name'      => esc_html__('Show Search Button','munza'), 
        'class'     => 'select_boxes',
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_srch_icon_color',
    array(
        'name'          => esc_html__('Icon Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_hide_search',
            'value'     => '1'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_srch_icon_hovcolor',
    array(
        'name'          => esc_html__('Icon Hover Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_hide_search',
            'value'     => '1'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_srch_icon_bgcolor',
    array(
        'name'          => esc_html__('Icon Background Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_hide_search',
            'value'     => '1'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_srch_icon_border_color',
    array(
        'name'          => esc_html__('Icon Border Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_hide_search',
            'value'     => '1'
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_hide_cart',
    array(
        ''      => esc_html__('Inherit From Theme','munza'),
        '1'     => esc_html__('Yes','munza'),
        '2'     => esc_html__('No','munza'),
    ),
    array(
        'name'      => esc_html__('Show Cart Button','munza'), 
        'class'     => 'select_boxes',
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_cart_icon_color',
    array(
        'name'          => esc_html__('Icon Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_hide_cart',
            'value'     => '1'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_cart_icon_hovcolor',
    array(
        'name'          => esc_html__('Icon Hover Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_hide_cart',
            'value'     => '1'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_cart_icon_bgcolor',
    array(
        'name'          => esc_html__('Icon Background Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_hide_cart',
            'value'     => '1'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_cart_icon_border_color',
    array(
        'name'          => esc_html__('Icon Border Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_hide_cart',
            'value'     => '1'
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_hide_slbar',
    array(
        ''      => esc_html__('Inherit From Theme','munza'),
        '1'     => esc_html__('Yes','munza'),
        '2'     => esc_html__('No','munza'),
    ),
    array(
        'name'      => esc_html__('Show Sliding Bar','munza'), 
        'class'     => 'select_boxes',
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_slbr_icon_color',
    array(
        'name'          => esc_html__('Icon Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_hide_slbar',
            'value'     => '1'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_slbr_icon_hovcolor',
    array(
        'name'          => esc_html__('Icon Hover Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_hide_slbar',
            'value'     => '1'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_slbr_icon_bgcolor',
    array(
        'name'          => esc_html__('Icon Background Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_hide_slbar',
            'value'     => '1'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_slbr_icon_border_color',
    array(
        'name'          => esc_html__('Icon Border Color','munza'),
        'section'       => 'itr_header',
        'dependency'    => array(
            'element'   => 'meta_hide_slbar',
            'value'     => '1'
        )
    )
);
$itr_cusom_page_box->itr_type_textbox(
    'meta_header_extra_class',
    array(  
        'name'      => esc_html__('Extra CSS Class','munza'),
        'section'   => 'itr_header',
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_hide_header',
    array(
        'name'      => '<b style="color:red">'.esc_html__('Hide Header','munza').'</b>',
        'section'   => 'itr_header',
    )
);

/* Page Title Settings
============================================= */
$itr_cusom_page_box->itr_type_select(
    'meta_title_style',
    array(
        ''          => esc_html__('Inherit From Theme','munza'),
        '1'         => esc_html__('Style 1','munza'),
        '2'         => esc_html__('Style 2','munza'),
        '3'         => esc_html__('Style 3','munza'),
        '4'         => esc_html__('Style 4','munza'),
        'normal'    => esc_html__('Normal','munza'), 
    ),
    array(
        'name'      => esc_html__('Style','munza'), 
        'class'     => 'select_boxes',
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_textbox(
    'meta_title_txt',
    array(
        'name'      => esc_html__('Title Text','munza'),
        'section'   => 'itr_pagetitles',
    )
); 
$itr_cusom_page_box->itr_type_color(
    'meta_title_color',
    array(
        'name'      => esc_html__('Color','munza'),
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_numberbox(
    'meta_title_fontsize',
    array(
        'name'      => esc_html__('Font Size','munza'),
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_textbox(
    'meta_subtitle',
    array(
        'name'      => esc_html__('SubTitle Text','munza'),
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_subtitle_color',
    array(
        'name'      => esc_html__('SubTitle Color','munza'),
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_numberbox(
    'meta_subtitle_fontsize',
    array(
        'name'      => esc_html__('SubTitle Font Size','munza'),
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_title_position',
    array(
        ''          => esc_html__('Inherit From Theme','munza'),
        'left'      => esc_html__('Left','munza'),
        'center'    => esc_html__('Centered','munza'),
        'right'     => esc_html__('Right','munza')
    ),
    array(
        'name'      => esc_html__('Position','munza'), 
        'class'     => 'select_boxes',
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_numberbox(
    'meta_title_height',
    array(  
        'name'      => esc_html__('Height','munza'),
        'section'   => 'itr_pagetitles',
    )
); 
$itr_cusom_page_box->itr_type_select(
    'meta_title_bg_type',
    array(
        ''          => esc_html__('Inherit From Theme','munza'),
        'color'     => esc_html__('Color','munza'),
        'gradient'  => esc_html__('Gradient','munza'),
    ),
    array(
        'name'      => esc_html__('Background Type','munza'), 
        'class'     => 'select_boxes',
        'section'   => 'itr_pagetitles',
    )
); 
$itr_cusom_page_box->itr_type_color(
    'meta_title_bg_color',
    array(
        'name'          => esc_html__('Background Color','munza'),
        'section'       => 'itr_pagetitles',
        'dependency'    => array(
            'element'   => 'meta_title_bg_type',
            'value'     => 'color'
        )
    )
);
$itr_cusom_page_box->itr_type_gradient(
    'meta_title_bg_grad',
    array(
        'name'          => esc_html__('Gradient Color','munza'),
        'section'       => 'itr_pagetitles',
        'dependency'    => array(
            'element'   => 'meta_title_bg_type',
            'value'     => 'gradient'
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_title_text_bg_color',
    array(
        'name'          => esc_html__('Text Background Color','munza'),
        'section'       => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_title_disable_bg',
    array(
        'name'          => esc_html__('Disable Background Image','munza'),
        'section'       => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_uploadfile(
    'meta_title_bg_img',
    array(
        'name'          => esc_html__('Background image','munza'),
        'section'       => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_title_bg_repeat',
    array(
        ''          => esc_html__('Inherit','munza'),
        'repeat'    => esc_html__('Repeat','munza'),
        'repeat-x'  => esc_html__('Repeat Horizontal','munza'),
        'repeat-y'  => esc_html__('Repeat Vertical','munza'),
        'no-repeat' => esc_html__('No Repeat','munza'),
    ),
    array(
        'name'          => esc_html__('Background Repeat','munza'),
        'section'       => 'itr_pagetitles',
        'class'         => 'select_boxes',
        'dependency'    => array(
            'element'   => 'meta_title_bg_img',
            'not_empty' => true
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_title_bg_size',
    array(
        ''              => esc_html__('Inherit','munza'),
        'cover'         => esc_html__('Cover','munza'),
        'contain'       => esc_html__('Contain','munza'),
        '100% 100%'     => '100%',
    ),
    array(
        'name'          => esc_html__('Background Size','munza'),
        'section'       => 'itr_pagetitles',
        'class'         => 'select_boxes',
        'dependency'    => array(
            'element'   => 'meta_title_bg_img',
            'not_empty' => true
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_title_bg_position',
    array(
        ''          => esc_html__('Inherit','munza'),
        '0 0'       => esc_html__('Left Top','munza'),
        '0 50%'     => esc_html__('Left Middle','munza'),
        '0 100%'    => esc_html__('Left Bottom','munza'),
        '50% 0'     => esc_html__('Center Top','munza'),
        '50% 50%'   => esc_html__('Center Middle','munza'),
        '50% 100%'  => esc_html__('Center Bottom','munza'),
        '100% 0'    => esc_html__('Right Top','munza'),
        '100% 50%'  => esc_html__('Right Middle','munza'),
        '100% 100%' => esc_html__('Right Bottom','munza'),
    ),
    array(
        'name'          => esc_html__('Background Position','munza'),
        'section'       => 'itr_pagetitles',
        'dependency'    => array(
            'element'   => 'meta_title_bg_img',
            'not_empty' => true
        )
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_title_parallax',
    array(
        ''      => esc_html__('Inherit','munza'),
        '1'     => esc_html__('Yes','munza'),
        '2'     => esc_html__('No','munza'),
    ),
    array(
        'name'          => esc_html__('Parallax Background','munza'),
        'section'       => 'itr_pagetitles',
        'class'         => 'select_boxes',
        'dependency'    => array(
            'element'   => 'meta_title_bg_img',
            'not_empty' => true
        )
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_title_bg_overlay',
    array(
        'name'      => esc_html__('Overlay Background','munza'),
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_title_video_bg',
    array(
        'name'      => esc_html__('Video Background','munza'),
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_uploadfile(
    'meta_title_video_cover',
    array(
        'name'          => esc_html__('Video Cover','munza'),
        'section'       => 'itr_pagetitles',
        'class'         => 'vid_cov',
        'dependency'    => array(
            'element'   => 'meta_title_video_bg',
            'not_empty' => true
        )
    )
);
$itr_cusom_page_box->itr_type_uploadfile(
    'meta_title_video_mp4',
    array(
        'name'          => esc_html__('video/mp4','munza'),
        'section'       => 'itr_pagetitles',
        'data-type'     => 'video',
        'dependency'    => array(
            'element'   => 'meta_title_video_bg',
            'not_empty' => true
        )
    )
);
$itr_cusom_page_box->itr_type_uploadfile(
    'meta_title_video_webm',
    array(
        'name'          => esc_html__('video/webm','munza'),
        'section'       => 'itr_pagetitles',
        'data-type'     => 'video',
        'dependency'    => array(
            'element'   => 'meta_title_video_bg',
            'not_empty' => true
        )
    )
);
$itr_cusom_page_box->itr_type_uploadfile(
    'meta_title_video_ogv',
    array(
        'name'          => esc_html__('video/ogv','munza'),
        'section'       => 'itr_pagetitles',
        'data-type'     => 'video',
        'dependency'    => array(
            'element'   => 'meta_title_video_bg',
            'not_empty' => true
        )
    )
);
$itr_cusom_page_box->itr_type_icon(
    'meta_title_icon',
    array(
        'name'      => esc_html__('Title Icon','munza'),
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_show_breadcrumbs',
    array(
        ''      => esc_html__('Inherit From Theme','munza'),
        '1'     => esc_html__('Yes','munza'),
        '2'     => esc_html__('No','munza'),
    ),
    array(
        'name'      => esc_html__('Show Breadcrumbs','munza'),
        'section'   => 'itr_pagetitles',
        'class'     => 'select_boxes',
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_title_bread_position',
    array(
        ''          => esc_html__('Inherit From Theme','munza'),
        'left'      => esc_html__('Left','munza'),
        'center'    => esc_html__('Center','munza'),
        'right'     => esc_html__('Right','munza')
    ),
    array(
        'name'      => esc_html__('Alignment','munza'), 
        'class'     => 'select_boxes',
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_select(
    'meta_breadcrumbs_style',
    array(
        ''          => esc_html__('Inherit From Theme','munza'),
        'style1'    => esc_html__('Style 1','munza'),
        'style2'    => esc_html__('Style 2','munza'),
        'style3'    => esc_html__('Style 3','munza'),
    ),
    array(
        'section'   => 'itr_pagetitles',
        'name'      => esc_html__( 'Breadcrumbs Style', 'munza' ),
        'class'     => 'select_boxes',                
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_breadcrumbs_color',
    array(
        'name'      => esc_html__('Color','munza'),
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_color(
    'meta_breadcrumbs__bgcolor',
    array(
        'name'      => esc_html__('Background Color','munza'),
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_textbox(
    'meta_title_extra_class',
    array(  
        'name'      => esc_html__('Extra CSS Class','munza'),
        'section'   => 'itr_pagetitles',
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_title_hide',
    array(
        'name'      => '<b style="color:red">'.esc_html__('Hide Page Title','munza').'</b>',
        'section'   => 'itr_pagetitles',
    )
);

/* Footer Settings
============================================= */ 
$itr_cusom_page_box->itr_type_select(
    'meta_footer_style',
    array(
        ''     => esc_html__('Inherit From Theme','munza'),
        '1'    => esc_html__('Rotated Skew','munza'),
        '2'    => esc_html__('Normal','munza'),
        '3'    => esc_html__('Simple Skew','munza'),
    ),
    array(
        'section'   => 'itr_footer',
        'name'      => esc_html__( 'Footer Style', 'munza' ),
        'class'     => 'select_boxes',                
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_foot_fixed',
    array(
        'name'      => esc_html__('Fixed','munza'),
        'section'   => 'itr_footer',
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_hide_foot_top',
    array(
        'name'      => esc_html__('Hide Top Footer Bar','munza'),
        'section'   => 'itr_footer',
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_hide_foot_widgets',
    array(
        'name'      => esc_html__('Hide Footer Widgets','munza'),
        'section'   => 'itr_footer',
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_hide_bottom_foot_bar',
    array(
        'name'      => esc_html__('Hide Bottom Footer','munza'),
        'section'   => 'itr_footer',
    )
); 
$itr_cusom_page_box->itr_type_textbox(
    'meta_foot_extra_class',
    array(  
        'name'      => esc_html__('Extra CSS Class','munza'),
        'section'   => 'itr_footer',
    )
);
$itr_cusom_page_box->itr_type_checkbox(
    'meta_hide_footer',
    array(
        'name'      => '<b style="color:red">'.esc_html__('Hide Footer','munza').'</b>',
        'section'   => 'itr_footer',
    )
);