<?php
/**
 *
 * Style Parser
 *
 * @version 1.0.0
 *
**/
 
function itr_custom_css() {
    
    ob_start ();
    
    $CSS                = '';
    $darkestPercent     = -10;
    $m_main_color       = esc_html(get_post_meta( itr_page_ID(), 'meta_body_main_color' , true));
    $hexStr             = ( $m_main_color != '' ) ?  $m_main_color : esc_html(itr_theme_option( "skin_color" ));
    $h_bg_color         = esc_html(get_post_meta( itr_page_ID(), 'meta_header_bg_color' , true));
    $h_bor_top_color    = esc_html(get_post_meta( itr_page_ID(), 'meta_header_bor_top_color' , true));
    $h_bor_bot_color    = esc_html(get_post_meta( itr_page_ID(), 'meta_header_bor_bot_color' , true));
    $bar_bot_color      = esc_html(get_post_meta( itr_page_ID(), 'meta_bar_bor_bot_color' , true));
    $h_bg_img           = esc_html(get_post_meta( itr_page_ID(), 'meta_header_bg_img' , true));
    $h_bg_repeat        = esc_html(get_post_meta( itr_page_ID(), 'meta_header_bg_repeat' , true));
    $h_bg_size          = esc_html(get_post_meta( itr_page_ID(), 'meta_header_bg_size' , true));
    $h_color            = esc_html(get_post_meta( itr_page_ID(), 'meta_header_font_color' , true)); 
    $hi_color           = esc_html(get_post_meta( itr_page_ID(), 'meta_header_icon_color' , true));
    $h_hover_color      = esc_html(get_post_meta( itr_page_ID(), 'meta_header_hover_color' , true));    
    $meta_header        = esc_html(get_post_meta( itr_page_ID(), 'meta_header_style' , true));
    $meta_head_vis      = esc_html(get_post_meta( itr_page_ID(), 'meta_header_invisible' , true));
    $meta_side_btn_col  = esc_html(get_post_meta( itr_page_ID(), 'meta_side_btn_color' , true));
    $them_header        = esc_html(itr_theme_option('header_style'));
    $thm_submenu        = esc_html(itr_theme_option('sub_menu_color'));
    $thm_sub_bg_color   = esc_html(itr_theme_option('sub_menu_bg_color'));
    $thm_sub_color      = esc_html(itr_theme_option('sub_menu_font_color'));
    $thm_sub_bg         = esc_html(itr_theme_option('sub_menu_bg_color'));
    $sub_menu           = esc_html(get_post_meta( itr_page_ID(), 'meta_sub_menu_color' , true));
    $m_sub_color        = esc_html(get_post_meta( itr_page_ID(), 'meta_cust_sub_color' , true));
    $m_sub_bg           = esc_html(get_post_meta( itr_page_ID(), 'meta_cust_sub_bg_color' , true));
    $m_h_pos            = esc_html(get_post_meta( itr_page_ID() , 'meta_header_position' , true));
    $m_nav_bord_c       = esc_html(get_post_meta( itr_page_ID() , 'meta_nav_border_color' , true));
    $m_nav_bord_w       = esc_html(get_post_meta( itr_page_ID() , 'meta_nav_border_width' , true));
    $t_nav_bord_c       = esc_html(itr_theme_option('nav_border_color'));
    $t_nav_bord_w       = esc_html(itr_theme_option('nav_border_width'));
    $sbarWidth          = ( itr_theme_option( 'sidebar_width' ) ) ? itr_theme_option( 'sidebar_width' ) : '25';
    $contPadd           = esc_html(itr_theme_option( 'content_padding' ));
    $stick_tab          = esc_html(itr_theme_option('sticky_tablets'));
    $stick_mob          = esc_html(itr_theme_option('sticky_mobiles'));
    $top_color          = esc_html(itr_theme_option("topbar_color"));
    $meta_bar_color     = esc_html(get_post_meta(itr_page_ID(),'meta_topbar_color',true));
    $meta_col           = esc_html(get_post_meta(itr_page_ID(),'meta_bar_color',true));
    $meta_fcol          = esc_html(get_post_meta(itr_page_ID(),'meta_bar_fcolor',true));
    $meta_hovcol        = esc_html(get_post_meta(itr_page_ID(),'meta_bar_hovcolor',true));
    $meta_icol          = esc_html(get_post_meta(itr_page_ID(),'meta_bar_icolor',true));
    $meta_menu_size     = esc_html(get_post_meta(itr_page_ID(),'meta_menu_font_size',true));
    $meta_menu_weight   = esc_html(get_post_meta(itr_page_ID(),'meta_menu_weight',true));
    $meta_menu_letter   = esc_html(get_post_meta(itr_page_ID(),'meta_menu_letter',true));
    $meta_menu_style    = esc_html(get_post_meta(itr_page_ID(),'meta_menu_style',true));
    $thm_col            = esc_html(itr_theme_option('barbgcolor'));
    $thm_bg             = esc_url(itr_theme_option('bar_image'));
    $thm_rp             = esc_html(itr_theme_option('bar_img_repeat'));
    $thm_cov            = esc_html(itr_theme_option('bar_img_full_width'));
    $thm_fcol           = esc_html(itr_theme_option('barcolor'));
    $thm_hovcol         = esc_html(itr_theme_option('barhovercolor'));
    $thm_icol           = esc_html(itr_theme_option('bariconcolor'));
    $slPadd             = esc_html(itr_theme_option( 'sliding_padding' ));
    $men_anim           = itr_theme_option( 'menu-anim' );
    $srch_icn_col       = ( get_post_meta(itr_page_ID(),'meta_srch_icon_color',true) == '' ) ? itr_theme_option( 'srch_icon_color' ) : get_post_meta(itr_page_ID(),'meta_srch_icon_color',true);
    $srch_icn_hovcol    = ( get_post_meta(itr_page_ID(),'meta_srch_icon_hovcolor',true) == '' ) ? itr_theme_option( 'srch_icon_hovcolor' ) : get_post_meta(itr_page_ID(),'meta_srch_icon_hovcolor',true);
    $srch_icn_bgcol     = ( get_post_meta(itr_page_ID(),'meta_srch_icon_bgcolor',true) == '' ) ? itr_theme_option( 'srch_icon_bgcolor' ) : get_post_meta(itr_page_ID(),'meta_srch_icon_bgcolor',true);
    $srch_icn_bordcol   = ( get_post_meta(itr_page_ID(),'meta_srch_icon_border_color',true) == '' ) ? itr_theme_option( 'srch_icon_border_color' ) : get_post_meta(itr_page_ID(),'meta_srch_icon_border_color',true);
    $cart_icn_col       = ( get_post_meta(itr_page_ID(),'meta_cart_icon_color',true) == '' ) ? itr_theme_option( 'cart_icon_color' ) : get_post_meta(itr_page_ID(),'meta_cart_icon_color',true);
    $cart_icn_hovcol    = ( get_post_meta(itr_page_ID(),'meta_cart_icon_hovcolor',true) == '' ) ? itr_theme_option( 'cart_icon_hovcolor' ) : get_post_meta(itr_page_ID(),'meta_cart_icon_hovcolor',true);
    $cart_icn_bgcol     = ( get_post_meta(itr_page_ID(),'meta_cart_icon_bgcolor',true) == '' ) ? itr_theme_option( 'cart_icon_bgcolor' ) : get_post_meta(itr_page_ID(),'meta_cart_icon_bgcolor',true);
    $cart_icn_bordcol   = ( get_post_meta(itr_page_ID(),'meta_cart_icon_border_color',true) == '' ) ? itr_theme_option( 'cart_icon_border_color' ) : get_post_meta(itr_page_ID(),'meta_cart_icon_border_color',true);
    $slbr_icn_col       = ( get_post_meta(itr_page_ID(),'meta_slbr_icon_color',true) == '' ) ? itr_theme_option( 'slbr_icon_color' ) : get_post_meta(itr_page_ID(),'meta_slbr_icon_color',true);
    $slbr_icn_hovcol    = ( get_post_meta(itr_page_ID(),'meta_slbr_icon_hovcolor',true) == '' ) ? itr_theme_option( 'slbr_icon_hovcolor' ) : get_post_meta(itr_page_ID(),'meta_slbr_icon_hovcolor',true);
    $slbr_icn_bgcol     = ( get_post_meta(itr_page_ID(),'meta_slbr_icon_bgcolor',true) == '' ) ? itr_theme_option( 'slbr_icon_bgcolor' ) : get_post_meta(itr_page_ID(),'meta_slbr_icon_bgcolor',true);
    $slbr_icn_bordcol   = ( get_post_meta(itr_page_ID(),'meta_slbr_icon_border_color',true) == '' ) ? itr_theme_option( 'slbr_icon_border_color' ) : get_post_meta(itr_page_ID(),'meta_slbr_icon_border_color',true);
    $thm_dark_sub       = itr_colourCreator($thm_sub_bg, $darkestPercent);
    $m_dark_sub         = itr_colourCreator($m_sub_bg, $darkestPercent);
    $darkthm            = itr_colourCreator($hexStr, $darkestPercent);
    $rgbacolor          = itr_hex2RGB($hexStr, true, ',');
    $paddTop            = explode('|', $contPadd);
    $paddBottom         = substr($contPadd, strpos($contPadd, "|") + 1);
    $slpaddTop          = explode('|', $slPadd);
    $slpaddBottom       = substr($slPadd, strpos($slPadd, "|") + 1);
    $cWidth             = 100 - $sbarWidth;
    $head_style         = ( $meta_header == '' ) ? $them_header : $meta_header;    
    $langcode           = ( class_exists( 'Polylang' ) || class_exists( 'SitePress' ) ) ? '-'.ICL_LANGUAGE_CODE : '';
        
    // Body Styling...
    $m_body_color       = ( get_post_meta( itr_page_ID(), 'meta_body_font_color' , true) == '' ) ? itr_theme_option('bodyfontcolor') : get_post_meta( itr_page_ID(), 'meta_body_font_color' , true);
    $m_body_bg_col      = ( get_post_meta( itr_page_ID(), 'meta_body_bg_color' , true) == '' ) ? itr_theme_option('bodybgcolor') : get_post_meta( itr_page_ID(), 'meta_body_bg_color' , true);
    $m_body_link_col    = ( get_post_meta( itr_page_ID(), 'meta_body_link_color' , true) == '' ) ? itr_theme_option('bodylinkscolor') : get_post_meta( itr_page_ID(), 'meta_body_link_color' , true);
    $m_body_bg_img      = esc_html(get_post_meta( itr_page_ID(), 'meta_body_bg_img' , true));
    $m_body_bg_rpt      = esc_html(get_post_meta( itr_page_ID(), 'meta_body_bg_repeat' , true));
    $m_body_bg_siz      = esc_html(get_post_meta( itr_page_ID(), 'meta_body_bg_size' , true));
    $m_body_bg_prx      = esc_html(get_post_meta( itr_page_ID(), 'meta_body_parallax' , true));
    
    $custom_fonts       = esc_html(itr_theme_option( 'custom_fonts' ));
    for ( $i = 1; $i <= $custom_fonts ; $i++ ) {
        $fname  = itr_theme_option('custom_font_name_'.$i);
        $feot   = itr_theme_option('custom_font_eot_'.$i);
        $fwoff  = itr_theme_option('custom_font_woff_'.$i);
        $fttf   = itr_theme_option('custom_font_ttf_'.$i);
        $fsvg   = itr_theme_option('custom_font_svg_'.$i);
        $fcss   = itr_theme_option('custom_font_css_'.$i);
        
        $CSS .= "
        @font-face {
            font-family: '{$fname}';
            src: url('{$feot}');
            src: url('{$feot}?#iefix') format('embedded-opentype'),
                 url('{$fwoff}') format('woff'),
                 url('{$fttf}') format('truetype'),
                 url('{$fsvg}#rieslingregular') format('svg');
            font-weight: normal;
            font-style: normal;
        }";
        $CSS .= $fcss;
    }
    
    $CSS .= "body{";
        
        $CSS .= "font-family: ".itr_theme_option('body_font'.$langcode).", sans-serif;";
        $CSS .= ( itr_theme_option('body_font_size'.$langcode) ) ? "font-size: ".itr_theme_option('body_font_size'.$langcode)."px;" : "";
        $CSS .= ( itr_theme_option('body_font_weight'.$langcode) ) ? "font-weight: ".itr_theme_option('body_font_weight'.$langcode).";" : "";
        $CSS .= ( itr_theme_option('body_lett_space'.$langcode) ) ? "letter-spacing: ".itr_theme_option('body_lett_space'.$langcode)."px;" : "";
        $CSS .= ( itr_theme_option('body_line_height'.$langcode) ) ? "line-height: ".itr_theme_option('body_line_height'.$langcode)."px;" : "";
        $CSS .= ( $m_body_color ) ? "color: ".$m_body_color.";" : '';
                    
    if ( $m_body_bg_col || $m_body_bg_img || itr_theme_option('bodybgimage') ) {
                    
        $CSS .= ( $m_body_bg_col ) ? "background-color: ".$m_body_bg_col.";" : '';
        if ( $m_body_bg_img ) {
            
            $bodm_id = preg_replace( '/[^\d]/', '', $m_body_bg_img );
            $bodm_src = wp_get_attachment_image_src( $bodm_id,'full' );
            $CSS .= "background-image: url('".esc_url($bodm_src[0])."');";
            
            $CSS .= ( $m_body_bg_rpt ) ? "background-repeat: ".$m_body_bg_rpt.";" : "";
            $CSS .= ( $m_body_bg_siz ) ? "background-size: ".$m_body_bg_siz.";" : "";
            $CSS .= ( $m_body_bg_prx != '' ) ? "background-attachment: fixed;" : "";
            
        } else if ( itr_theme_option('bodybgimage') ) {
            
            $bod_id = preg_replace( '/[^\d]/', '', itr_theme_option('bodybgimage') );
            $bod_src = wp_get_attachment_image_src( $bod_id,'full' );
            $CSS .= "background-image: url('".$bod_src[0]."');";
            
            $CSS .= ( itr_theme_option('body_bg_img_repeat') ) ? "background-repeat: ".itr_theme_option('body_bg_img_repeat').";" : "";
            $CSS .= "background-size: ".itr_theme_option('body_bg_size').";";
            $CSS .= ( itr_theme_option('body_bg_position') ) ? "background-position: ".itr_theme_option('body_bg_position').";" : "";
            $CSS .= ( itr_theme_option('body_bg_img_parallax') == '1' ) ? "background-attachment: fixed;" : "";
            
        }
           
            
    }
    
    $CSS .= "}";
    
    $CSS .= ( $m_body_link_col != '' ) ? "a {color: ".$m_body_link_col.";}" : "";
    
    if ( itr_theme_option( 'main_width' ) != '1170' && itr_theme_option( 'main_width' ) != '' ) {
        $CSS .= ".container,.pageWrapper.boxed,.pageWrapper.boxed .top-head.sticky-head,.pageWrapper.boxed .top-head.fixed-head{
            width: ".itr_theme_option( 'main_width' )."px;
        }";
    }
    
    // Headings...
    $CSS .= "h1,h2,h3,h4,h5,h6,.wpb-js-composer .vc_tta.vc_tta-tabs .vc_tta-tab>a{";        
        $CSS .= "font-family: ".itr_theme_option('headings_font'.$langcode).", sans-serif;";
        $CSS .= ( itr_theme_option('headings_font_weight'.$langcode) != '' )   ? "font-weight: ".itr_theme_option('headings_font_weight'.$langcode).";"        : "";
        $CSS .= ( itr_theme_option('headings_lett_space'.$langcode) != '' )    ? "letter-spacing: ".itr_theme_option('headings_lett_space'.$langcode)."px;"    : "";
        $CSS .= ( itr_theme_option('headings_text_style'.$langcode) != '' )    ? "text-transform: ".itr_theme_option('headings_text_style'.$langcode).";"      : "";
    $CSS .= "}";
    
    // Content Padding...
    if( $paddTop[0] != '' || $paddBottom != '' ){
        $CSS .= ".itr-main-content,.site_content{";
            $CSS .= ( $paddTop[0] != '' ) ? "padding-top: {$paddTop[0]}px;" : "";
            $CSS .= ( $paddBottom != '' ) ? "padding-bottom: {$paddBottom}px;" : "";
        $CSS .= "}";
    }
        
    if ( $sbarWidth != '25' && $sbarWidth != '' ) {
        $CSS .= ".sidebar{
            flex: 0 0 {$sbarWidth}%;
        }";
    }
    
    // Top Bar...
    if($meta_bar_color == 'custom'){
        $CSS .= ( $meta_col != '' ) ? ".top-bar{background-color: ".$meta_col.";}" : "";
        $CSS .= ( $meta_fcol != '' ) ? ".top-bar,.top-bar a, .top-bar span{color: ".$meta_fcol.";}" : "";
        $CSS .= ( $meta_hovcol != '' ) ? ".top-bar a:hover{color: ".$meta_hovcol.";}" : "";
        $CSS .= ( $meta_icol != '' ) ? ".top-bar i,.top-bar .social-list a i{color: ".$meta_icol.";}" : "";
        
    } else if ( $meta_bar_color == '' && $top_color == 'custom' ){
        $bar_id = preg_replace( '/[^\d]/', '', $thm_bg );
        $bar_src = wp_get_attachment_image_src( $bar_id,'full' );
        $CSS .= "
        .top-bar{";
            $CSS .= ($thm_col != '') ? "background-color: ".$thm_col.";" : "";
            $CSS .= ($thm_bg != '') ? "background-image: url('".$bar_src[0]."');" : "";
            $CSS .= ($thm_rp != '') ? "background-repeat: ".$thm_rp.";" : "";
            $CSS .= ($thm_bg != '') ? "background-size: ".itr_theme_option('bar_bg_size').";" : ""; 
        $CSS .= "
        }";
        
        $CSS .= ($thm_fcol != '') ? ".top-bar,.top-bar a, .top-bar span{color: ".$thm_fcol.";}" : "";
        $CSS .= ($thm_hovcol != '') ? ".top-bar a:hover{color: ".$thm_hovcol.";}" : "";
        $CSS .= ($thm_icol != '') ? ".top-bar i,.top-bar .social-list a i{color: ".$thm_icol.";}" : "";
    }
    
    // Menu Styling...
    $mfont = itr_theme_option('menu_font'.$langcode);
    $msize = ( $meta_menu_size != '' ) ? $meta_menu_size : itr_theme_option('menu_font_size'.$langcode);
    $mwegt = ( $meta_menu_weight != '' ) ? $meta_menu_weight : itr_theme_option('menu_font_weight'.$langcode);
    $mstle = ( $meta_menu_style != '' ) ? $meta_menu_style : itr_theme_option('menu_text_style'.$langcode);
    $mlett = ( $meta_menu_letter != '' ) ? $meta_menu_letter : itr_theme_option('menu_lett_space'.$langcode);
    
    if( $mfont != '' || $msize != '' || $mwegt != '' || $mstle != '' || $mlett != '' ){
        $CSS .= ".top-head .itr_main_nav > ul > li > a,.side-head .itr_main_nav > ul > li > a{";
            $CSS .= ( $mfont != '' ) ? "font-family: ".$mfont.", sans-serif;" : "";
            $CSS .= ( $msize != '' ) ? "font-size: ".$msize."px;" : "";
            $CSS .= ( $mwegt != '' ) ? "font-weight: ".$mwegt.";" : "";
            $CSS .= ( $mstle != '' ) ? "text-transform: ".$mstle.";" : "";
            $CSS .= ( $mlett != '' ) ? "letter-spacing: ".$mlett."px;" : "";
        $CSS .= "}";    
    }
    
    // SubMenu Styling...
    $smfont = itr_theme_option('submenu_font'.$langcode);
    $smsize = itr_theme_option('submenu_font_size'.$langcode);
    $smwegt = itr_theme_option('submenu_font_weight'.$langcode);
    $smstle = itr_theme_option('submenu_text_style'.$langcode);
    $smlett = itr_theme_option('submenu_lett_space'.$langcode);
    
    if( $smfont != '' || $smsize != '' || $smwegt != '' || $smstle != '' || $smlett != '' ){
        $CSS .= ".top-head .itr_main_nav ul ul a,.side-head .itr_main_nav ul ul a{";
            $CSS .= ( $smfont != '' ) ? "font-family: ".$smfont.", sans-serif;" : "";
            $CSS .= ( $smsize != '' ) ? "font-size: ".$smsize."px;" : "";
            $CSS .= ( $smwegt != '' ) ? "font-weight: ".$smwegt.";" : "";
            $CSS .= ( $smstle != '' ) ? "text-transform: ".$smstle.";" : "";
            $CSS .= ( $smlett != '' ) ? "letter-spacing: ".$smlett."px;" : "";
        $CSS .= "}";    
    }
    
    // header Height..
    $headheight       = ( get_post_meta( itr_page_ID() , 'meta_header_height' , true) == '' ) ? itr_theme_option( 'header_height' ) : get_post_meta( itr_page_ID() , 'meta_header_height' , true);
    if ( $headheight != '' && $headheight != '100' ) {
        $CSS .= ".top-head .itr_head_wrap{";
            $CSS .= "height: {$headheight}px;";
            $CSS .= "line-height: {$headheight}px;";
        $CSS .= "}";
    }
    
    $meta_hd_pad        = esc_html(get_post_meta(itr_page_ID(),'meta_head_padding',true));
    $headPadd           = ( $meta_hd_pad == '' || $meta_hd_pad == '|' ) ? itr_theme_option( 'header_padding' ) : $meta_hd_pad;
    $hd_pad_left        = explode('|', $headPadd);
    $hd_pad_right       = substr($headPadd, strpos($headPadd, "|") + 1);
    
    if( $hd_pad_left[0] != '' || $hd_pad_right != '' ){
            
        if( $head_style == 'side' ){
            
            $CSS .= ".side-head{";
                $CSS .= ( $hd_pad_left[0] != '' ) ? "padding-left: {$hd_pad_left[0]}px;" : "";
                $CSS .= ( $hd_pad_right != '' ) ? "padding-right: {$hd_pad_right}px;" : "";
            $CSS .= "}"; 
               
        } else {
            
            $CSS .= ".itr_head_wrap{";
                $CSS .= ( $hd_pad_left[0] != '' ) ? "padding-left: {$hd_pad_left[0]}px;" : "";
                $CSS .= ( $hd_pad_right != '' ) ? "padding-right: {$hd_pad_right}px;" : "";
            $CSS .= "}";
                
        }
    } 

    // header bg color..
    if( $head_style != 'creative' ){
        
        if($h_bg_img != ''){
            $hedm_id = preg_replace( '/[^\d]/', '', $h_bg_img );
            $hedm_src = wp_get_attachment_image_src( $hedm_id,'full' );
            $CSS .= "
            .top-head:not(.sticky-head),.side-head:not(.invis_head){
                background-image: url(".esc_url($hedm_src[0]).") !important;";
                if($h_bg_repeat != ''){
                    $CSS .= "background-repeat: ".$h_bg_repeat.";";    
                }
                if($h_bg_size != ''){
                    $CSS .= "background-size: ".$h_bg_size.";";    
                }
            $CSS .= "}";
            $CSS .= ".top-head:not(.sticky-head), .top-head:not(.sticky-head) .mod-container{
                background-color: transparent !important;";
            $CSS .= "}";        
            
        } else if ( itr_theme_option('nav_bg_color') || itr_theme_option('nav_image') ) {
            $CSS .= "
            .top-head:not(.sticky-head),.side-head:not(.invis_head){";
                if ( itr_theme_option('nav_bg_color') ) {
                    $CSS .= "background-color: ".itr_theme_option('nav_bg_color').";";
                }
                $nv_id = preg_replace( '/[^\d]/', '', itr_theme_option('nav_image') );
                $nv_src = wp_get_attachment_image_src( $nv_id,'full' );
                if ( itr_theme_option('nav_image') ) {
                    $CSS .= "background-image: url('".esc_url($nv_src[0])."');";
                    if ( itr_theme_option('nav_img_repeat') ) {
                        $CSS .= "background-repeat: ".itr_theme_option('nav_img_repeat').";";
                    }
                    if ( itr_theme_option('nav_img_full_width') == '1' ) {
                        $CSS .= "background-size:cover;";
                    }
                }
            $CSS .= "}";  
        }
        
        if( $h_bg_color != '' ){
            $CSS .= ".top-head:not(.sticky-head),.side-head:not(.invis_head){
                background-color: {$h_bg_color} !important;
            }
            ";
        }
        
        if($h_bor_top_color != ''){
            $CSS .= ".top-head.classic:not(.sticky-head){
                border-top: 1px {$h_bor_top_color} solid !important;
            }";
            $CSS .= ".top-head.classic:not(.sticky-head) .bottom-head{
                border-top: 1px {$h_bor_top_color} solid !important;
            }";
        } else if ( itr_theme_option('nav_bor_top_color') ) {
            $CSS .= ".top-head.classic:not(.sticky-head){";
                $CSS .= "border-top: 1px ".itr_theme_option('nav_bor_top_color')." solid;";
            $CSS .= "}";
            $CSS .= ".top-head.classic:not(.sticky-head) .bottom-head{
                border-top: 1px ".itr_theme_option('nav_bor_top_color')." solid;
            }";
        }
        
        if($h_bor_bot_color != ''){
            $CSS .= ".top-head.classic:not(.sticky-head){
                border-bottom: 1px {$h_bor_bot_color} solid !important;
            }";
        } else if ( itr_theme_option('nav_bor_bot_color') ) {
            $CSS .= ".top-head.classic:not(.sticky-head){";
                $CSS .= "border-bottom: 1px ".itr_theme_option('nav_bor_bot_color')." solid;";
            $CSS .= "}";
        }
    
    } else if ( $head_style == 'creative' ) {
        if( $h_bg_color != '' ){
            $CSS .= ".top-head:not(.sticky-head).creative .itr_head_wrap .slurve-svg{
                fill: {$h_bg_color};
            }";
        } else if ( itr_theme_option('nav_bg_color') != '' ) {
            $CSS .= ".top-head:not(.sticky-head).creative .itr_head_wrap .slurve-svg{
                fill: ".itr_theme_option('nav_bg_color').";
            }";
        }    
    }

    $lnkcol = ( $h_color != '' ) ? $h_color : itr_theme_option('nav_text_color');
    $hovcol = ( $h_hover_color != '' ) ? $h_hover_color : itr_theme_option('nav_hover_color');
    
    $ho_bor_nav = ( get_post_meta(itr_page_ID(),'meta_header_hover_border_color',true) == '' ) ? itr_theme_option('nav_hover_border_color') :  get_post_meta(itr_page_ID(),'meta_header_hover_border_color',true); 
    
    if($ho_bor_nav != ''){
        $CSS .= ".top-head:not(.sticky-head) .itr_main_nav > ul > li:hover > a > span,.top-head:not(.sticky-head) .itr_main_nav > ul > li.current-menu-parent > a > span,.top-head:not(.sticky-head) .itr_main_nav > ul > li.current-menu-ancestor > a > span{
            border-color: {$ho_bor_nav};
        }";    
    }
    
    if($lnkcol != ''){
        
        if ( $head_style == 'side' ) {
            $CSS .= ".side-head .itr_main_nav > ul > li > a,.side-head .side_bot_block a,.side-head .side_bot_block {
                color: {$lnkcol};
            }";    
        } else {
            $CSS .= ".top-head:not(.sticky-head) .itr_main_nav > ul > li > a,.top-head:not(.sticky-head) .menu-message {
                color: {$lnkcol};
            }";    
        }
        
    }
    
    if($hovcol != ''){
        
        if( $men_anim != '' ){
            
            if ( $head_style == 'side' ) {
                $CSS .= ".side-head .itr_main_nav.anim_hover > ul > li > a span span:before {
                    color: {$hovcol};
                }";    
            } else {
                $CSS .= ".top-head:not(.sticky-head) .itr_main_nav.anim_hover > ul > li > a span span:before {
                    color: {$hovcol};
                }";    
            }
            
        } else {
            
            if ( $head_style == 'side' ) {
                $CSS .= ".side-head .itr_main_nav > ul > li > a:hover {
                    color: {$hovcol};
                }";    
            } else {
                $CSS .= ".top-head:not(.sticky-head) .itr_main_nav > ul > li > a:hover {
                    color: {$hovcol};
                }";    
            }
            
        }
        
    }
    
    if($hi_color != ''){
        
        $CSS .= ".top-head:not(.sticky-head) .itr_main_nav > ul > li i{
            color: {$hi_color};
        }";
        
    } else if ( itr_theme_option('nav_icon_color') ) {
        
        $CSS .= ".top-head:not(.sticky-head) .itr_main_nav > ul > li i{
            color: ".itr_theme_option('nav_icon_color').";
        }";
        
    }
    
    if( $srch_icn_col != '' ) {
        $CSS .= ".top-head:not(.sticky-head) .open_search i{";
            $CSS .= "color: {$srch_icn_col};";
        $CSS .= "}";    
    }
    
    if( $srch_icn_hovcol != '' ) {
        $CSS .= ".top-head:not(.sticky-head) .open_search i.btn_back{";
            $CSS .= "color: {$srch_icn_hovcol};";
        $CSS .= "}";    
    }
    
    if( $srch_icn_bgcol != '' || $srch_icn_bordcol != '' ) {
        $CSS .= ".top-head:not(.sticky-head) .open_search:before,.top-head:not(.sticky-head) .open_search:after{";
            ( $srch_icn_bgcol != '' ) ? $CSS .= "background-color: {$srch_icn_bgcol};" : "";
            ( $srch_icn_bordcol != '' ) ? $CSS .= "border-color: {$srch_icn_bordcol} !important;" : "";
        $CSS .= "}";    
    }
    
    if( $cart_icn_col != '' ) {
        $CSS .= ".top-head:not(.sticky-head) .cart-btn i{";
            $CSS .= "color: {$cart_icn_col};";
        $CSS .= "}";    
    }
    
    if( $cart_icn_hovcol != '' ) {
        $CSS .= ".top-head:not(.sticky-head) .cart-btn i.btn_back{";
            $CSS .= "color: {$cart_icn_hovcol};";
        $CSS .= "}";    
    }
    
    if( $cart_icn_bgcol != '' || $cart_icn_bordcol != '' ) {
        $CSS .= ".top-head:not(.sticky-head) .cart-btn:before,.top-head:not(.sticky-head) .cart-btn:after{";
            ( $cart_icn_bgcol != '' ) ? $CSS .= "background-color: {$cart_icn_bgcol};" : "";
            ( $cart_icn_bordcol != '' ) ? $CSS .= "border-color: {$cart_icn_bordcol} !important;" : "";
        $CSS .= "}";    
    }
    
    if( $slbr_icn_col != '' ) {
        $CSS .= ".top-head:not(.sticky-head) .slbar_btn i{";
            $CSS .= "color: {$slbr_icn_col};";
        $CSS .= "}";    
    }
    
    if( $slbr_icn_hovcol != '' ) {
        $CSS .= ".top-head:not(.sticky-head) .slbar_btn i.btn_back{";
            $CSS .= "color: {$slbr_icn_hovcol};";
        $CSS .= "}";    
    }
    
    if( $slbr_icn_bgcol != '' || $slbr_icn_bordcol != '' ) {
        $CSS .= ".top-head:not(.sticky-head) .slbar_btn:before,.top-head:not(.sticky-head) .slbar_btn:after{";
            ( $slbr_icn_bgcol != '' ) ? $CSS .= "background-color: {$slbr_icn_bgcol};" : "";
            ( $slbr_icn_bordcol != '' ) ? $CSS .= "border-color: {$slbr_icn_bordcol} !important;" : "";
        $CSS .= "}";    
    }
    
    if($bar_bot_color != ''){
        
        $CSS .= ".top-bar.bord{
            border-bottom-color: {$bar_bot_color};
        }";
        $CSS .= ".top-bar.bord .top-socials.topbar-box{
            border-left-color: {$bar_bot_color};
            border-right-color: {$bar_bot_color};
        }";
        
    } else if ( itr_theme_option('topbar_border_color') ) {
        
        $CSS .= ".top-bar.bord{";
            $CSS .= "border-bottom-color: ".itr_theme_option('topbar_border_color').";";
        $CSS .= "}";
        
        $CSS .= ".top-bar.bord .top-socials.topbar-box{
            border-left-color: ".itr_theme_option('topbar_border_color').";
            border-right-color: ".itr_theme_option('topbar_border_color').";
        }";
        
    }
       
    if( ( $meta_header == 'side' ) && $meta_head_vis == '1' && $h_bg_color != '' ) {
        
        $CSS .= ".side-head{
            background-color:".$h_bg_color.";
        }";
            
    } else if( ( $them_header == 'side' ) && itr_theme_option('nav_bg_color') != '' ) {
        
        $CSS .= ".side-head{
            background-color:".itr_theme_option('nav_bg_color').";
        }";
            
    }
    
    if( ( $meta_header == 'side' ) && $meta_head_vis == '1' && $meta_side_btn_col != '' ) {
        
        $CSS .= ".itr_head_btn i{
            background-color: " . $meta_side_btn_col . ";
        }";
            
    } else if( ( $them_header == 'side' ) && itr_theme_option('head_visible') == '1' && itr_theme_option('side_btn_color') != '' ) {
        
        $CSS .= ".itr_head_btn i{
            background-color: " . itr_theme_option('side_btn_color') . ";
        }";
            
    }
    
    if(itr_theme_option('sbar_btn_bg_color')){
        
        $CSS .= ".top-head:not(.sticky-head) a.slbar_btn span i,.side-head a.slbar_btn span i{
            background-color:".itr_theme_option('sbar_btn_bg_color').";
        }";
            
    }

    if ( itr_theme_option('sticky_bg_color') ) {
        
        $CSS .= ".top-head.sticky-head{
            background-color: ".itr_theme_option('sticky_bg_color').";
        }";
        
    }

    if ( itr_theme_option('sticky_text_color') ) {
        
        $CSS .= ".top-head.sticky-head a,.top-head.sticky-head .itr_main_nav > ul > li:not(.current-menu-ancestor) > a{
            color: ".itr_theme_option('sticky_text_color').";
        }";
        
        $CSS .= ".top-head.sticky-head a.slbar_btn span i,.side-head a.slbar_btn span i{
            background-color: ".itr_theme_option('sticky_text_color')." !important;
        }";
        
    }
    
    if ( itr_theme_option('sticky_hover_color') ) {
        
        if( $men_anim != '' ){

            $CSS .= ".top-head.sticky-head .itr_main_nav.anim_hover > ul > li > a span span:before {
                color: ".itr_theme_option('sticky_hover_color').";
            }";    
            
        } else {

            $CSS .= ".top-head.sticky-head .itr_main_nav > ul > li > a:hover {
                color: ".itr_theme_option('sticky_hover_color').";
            }";
            
        }
        
    }
    
    if ( itr_theme_option('loader_bg') ) {

        $CSS .= ".page-loader {
            background-color: ".itr_theme_option('loader_bg').";
        }";
                    
    }
    
    // LOGO Text...
    if ( itr_theme_option( 'logo_type' ) == 'text' ){
        $CSS .= "
            .logo a i.logo-txt{";
            if(itr_theme_option('logo_font_color')){
                $CSS .= "color: ".itr_theme_option('logo_font_color').";";
            }
            $CSS .= "
            font-size: ".itr_theme_option('logo_font_size'.$langcode)."px;
            font-family: '".itr_theme_option('logo_font'.$langcode)."', sans-serif;
            font-weight: ".itr_theme_option('logo_font_weight'.$langcode).";
        }

        .logo a span{
            font-family: '".itr_theme_option('slogan_font'.$langcode)."', sans-serif;
            color: ".itr_theme_option('slogan_font_color'.$langcode).";
            font-size: ".itr_theme_option('slogan_font_size'.$langcode)."px;
            font-weight: ".itr_theme_option('slogan_font_weight'.$langcode).";
        }";    
    }
    
    // Page Title Styling ...
    $meta_titl_type     = get_post_meta(itr_page_ID(), 'meta_title_bg_type',true);
    $meta_title_style   = get_post_meta(itr_page_ID(), 'meta_title_style',true);
    $meta_titl_dis_bg   = get_post_meta(itr_page_ID(), 'meta_title_disable_bg',true);
    $meta_titl_img      = get_post_meta(itr_page_ID(), 'meta_title_bg_img',true);
    $meta_titl_col      = get_post_meta(itr_page_ID(), 'meta_title_bg_color',true);
    $meta_titl_grd      = get_post_meta(itr_page_ID(), 'meta_title_bg_grad',true);
    $meta_titl_size     = ( $meta_titl_img ) ? get_post_meta(itr_page_ID(), 'meta_title_bg_size',true) : '';
    $meta_titl_rpt      = ( $meta_titl_img ) ? get_post_meta(itr_page_ID(), 'meta_title_bg_repeat',true) : '';
    $meta_titl_atch     = ( $meta_titl_img ) ? get_post_meta(itr_page_ID(), 'meta_title_bg_position',true) : '';
    
    $titl_style         = ( $meta_title_style == '' ) ? itr_theme_option( 'page_title_style' )       : $meta_title_style;
    $titl_type          = ( $meta_titl_type == '' )   ? itr_theme_option( 'page_title_bg_type' )     : $meta_titl_type;
    $titl_grad          = ( $meta_titl_grd == '' )    ? itr_theme_option( 'page_title_bg_grad' )     : $meta_titl_grd;
    $titl_color         = ( $meta_titl_col == '' )    ? itr_theme_option( 'page_title_bgcolor' )     : $meta_titl_col;
    $title_bg_img       = ( $meta_titl_img == '' )    ? itr_theme_option( 'page_title_bg' )          : $meta_titl_img;
    $title_bg_size      = ( $meta_titl_size == '' )   ? itr_theme_option( 'page_title_bg_size' )     : $meta_titl_size;
    $title_bg_repeat    = ( $meta_titl_rpt == '' )    ? itr_theme_option( 'page_title_bg_repeat' )   : $meta_titl_rpt;
    $title_bg_pos       = ( $meta_titl_atch == '' )   ? itr_theme_option( 'page_title_bg_position' ) : $meta_titl_atch; 
       
    $titlm_id           = preg_replace( '/[^\d]/', '', $title_bg_img );
    $titlm_src          = wp_get_attachment_image_src( $titlm_id,'full' );
       
    if( $titl_style == 'normal' ){
        if ( $titl_type == 'color' && $titl_color != '' ) {
            $CSS .= ".page-title{";
                $CSS .= " background-color: {$titl_color};";  
            $CSS .= "}";
        } else if ( $titl_type == 'gradient' && $titl_grad != '' ) {
            $CSS .= ".page-title{";
                $CSS .= "background: {$titl_grad};";  
            $CSS .= "}";
        }    
    } else {
        if ( $titl_type == 'color' && $titl_color != '' ) {
            $CSS .= ".page-title .slurve-svg{";
                $CSS .= " fill:{$titl_color};";  
            $CSS .= "}";
        } else if ( $titl_type == 'gradient' && $titl_grad != '' ) {
            $CSS .= ".page-title .slurve-svg{";
                $CSS .= "fill: url(#pgt_grad);";  
            $CSS .= "}";
        }
    }
    
    if ( $title_bg_img != '' ) {
        $CSS .= ".page-title .title_bg {";
            ( $titlm_src[0] != '' )     ? $CSS .= "background-image: url('".esc_url($titlm_src[0])."');"    : "";
            ( $title_bg_repeat != '' )  ? $CSS .= "background-repeat: {$title_bg_repeat};"                  : "";
            ( $title_bg_size != '' )    ? $CSS .= "background-size: {$title_bg_size};"                      : "";
            ( $title_bg_pos != '' )     ? $CSS .= "background-position: {$title_bg_pos};"                   : "";
        $CSS .= "}";
    }
    
    if( $meta_titl_dis_bg != '' ){
        $CSS .= ".page-title .title_bg {";
            $CSS .= "background-image: none !important;";
        $CSS .= "}";    
    }

    $title_fam  = itr_theme_option( 'page_title_font'.$langcode);
    $title_wet  = itr_theme_option( 'page_title_fontweight'.$langcode);
    $title_col  = ( get_post_meta(itr_page_ID(), 'meta_title_color',true) == '' )     ? itr_theme_option('page_title_fontcolor')  : get_post_meta(itr_page_ID(), 'meta_title_color',true);
    $title_size = ( get_post_meta(itr_page_ID(), 'meta_title_fontsize',true) == '' )  ? itr_theme_option('page_title_fontsize')   : get_post_meta(itr_page_ID(), 'meta_title_fontsize',true);
    
    if( $title_fam != '' || $title_wet != '' || $title_col != '' || $title_size != '' ){
        $CSS .= ".page-title h1 {";
            $CSS .= ( $title_fam != '' ) ? "font-family: '". $title_fam ."', sans-serif;" : "";
            $CSS .= ( $title_wet != '' ) ? "font-weight: ". $title_wet .";" : "";
            $CSS .= ( $title_col != '' ) ? "color: {$title_col};" : "";
            $CSS .= ( $title_size != '' ) ? "font-size: {$title_size}px;" : ""; 
        $CSS .= "}";    
    }
    
    
    $subtitle_col  = ( get_post_meta(itr_page_ID(), 'meta_subtitle_color',true) == '' )     ? itr_theme_option('page_title_subcolor')       : get_post_meta(itr_page_ID(), 'meta_subtitle_color',true);
    $subtitle_size = ( get_post_meta(itr_page_ID(), 'meta_subtitle_fontsize',true) == '' )  ? itr_theme_option('page_title_sub_fontsize')   : get_post_meta(itr_page_ID(), 'meta_subtitle_fontsize',true);
    
    if( $subtitle_col != '' || $subtitle_size != '' ){
        $CSS .= ".page-title h3 {";
            $CSS .= ( $subtitle_col != '' ) ? "color: {$subtitle_col};" : "";
            $CSS .= ( $subtitle_size != '' ) ? "font-size: {$subtitle_size}px;" : ""; 
        $CSS .= "}";    
    }    
    
    // page title icon color..
    if ( itr_theme_option('page_title_iconbgcolor') != '' || itr_theme_option('page_title_iconcolor') != '' || itr_theme_option('page_title_iconsize') != '' ){
        $CSS .= ".page-title .title-icon {";
            ( itr_theme_option('page_title_iconcolor') ) ? $CSS .= "color: ".itr_theme_option('page_title_iconcolor').";" : "";
            ( itr_theme_option('page_title_iconbgcolor') ) ? $CSS .= "background-color: ".itr_theme_option('page_title_iconbgcolor').";" : "";
            ( itr_theme_option('page_title_iconsize') ) ? $CSS .= "font-size: ".itr_theme_option('page_title_iconsize')."px;" : ""; 
        $CSS .= "}";
    }
    
    // page title overlay..
    $title_overlay = ( get_post_meta(itr_page_ID(), 'meta_title_bg_overlay',true) == '' ) ? itr_theme_option('page_title_overlay') : get_post_meta(itr_page_ID(), 'meta_title_bg_overlay',true);        
    if ( $title_overlay != '' ) {
        $CSS .= ".page-title .video-overlay{
            background-color: {$title_overlay} !important;
        }";
    }
    
    // title text background color...
    $m_txt_color        = ( get_post_meta( itr_page_ID(), 'meta_title_text_bg_color' , true) == '' ) ? itr_theme_option('page_title_textcolor') : get_post_meta( itr_page_ID(), 'meta_title_text_bg_color' , true);
    if ( $m_txt_color != '' ){
        $CSS .= ".page-title .titl_txt_bg{
            background-color: {$m_txt_color};
        }";
    }
    
    // page title height..
    $title_height = ( get_post_meta(itr_page_ID(), 'meta_title_height',true) == '' ) ? itr_theme_option('page_title_height') : get_post_meta(itr_page_ID(), 'meta_title_height',true);
    if ( $title_height != '' ){
        $CSS .= ".page-title .in-page-title{
            height: {$title_height}px;
        }";
    }
    
    // breadcrumbs..
    $bread_col      = ( get_post_meta(itr_page_ID(), 'meta_breadcrumbs_color',true) == '' ) ? itr_theme_option('page_title_breadcrumbs_color') : get_post_meta(itr_page_ID(), 'meta_breadcrumbs_color',true);
    $bread_bgcol    = ( get_post_meta(itr_page_ID(), 'meta_breadcrumbs__bgcolor',true) == '' ) ? itr_theme_option('page_title_breadcrumbs_bgcolor') : get_post_meta(itr_page_ID(), 'meta_breadcrumbs__bgcolor',true);
    if ( $bread_col != '' ) {
        $CSS .= ".breadcrumb a, .breadcrumb, .breadcrumb span{";
            ( $bread_col != '' ) ? $CSS .= "color: {$bread_col};" : "";
        $CSS .= "}";
    }
    if ( $bread_bgcol != '' ) {
        $CSS .= ".breadcrumb{";
            ( $bread_bgcol != '' ) ? $CSS .= "background-color: {$bread_bgcol};" : "";
        $CSS .= "}";
    }
    
    // Footer Styling..
    $pg_foot_style      = esc_html(get_post_meta( itr_page_ID(), 'meta_footer_style' , true));
    $thm_foot_style     = esc_html(itr_theme_option('footer_style'));
    $foot_style         = ($pg_foot_style != '') ? $pg_foot_style : $thm_foot_style;    
    $foot_type          = esc_html(itr_theme_option('footer_bg_type'));
    $foot_col           = esc_html(itr_theme_option('footer_bg_color'));
    $foot_grad          = esc_html(itr_theme_option('footer_bg_grad'));
    $foot_bot_col       = esc_html(itr_theme_option('footer_bottom_color'));
    $foot_bot_link      = esc_html(itr_theme_option('footer_bottom_link_color'));
    $foot_bot_bg        = esc_html(itr_theme_option('footer_bottom_bg_color'));
    
    
    // top footer
    if ( itr_theme_option('foot_top_text_color') ) {
        $CSS .= "#footWrapper .foot-top > .container{";
            $CSS .= "color: ".itr_theme_option('foot_top_text_color').";";
        $CSS .= "}";
    }
    
    if ( $foot_style == '1' && itr_theme_option('foot_top_bg_color') ) {
        $CSS .= "#footWrapper .foot-top > .container svg{";
            $CSS .= "fill: ".itr_theme_option('foot_top_bg_color').";";
        $CSS .= "}";
    }    
    
    if ( $foot_style == '2' && itr_theme_option('foot_top_bg_color') ) {
        $CSS .= "#footWrapper .foot-top{";
            $CSS .= "background-color: ".itr_theme_option('foot_top_bg_color').";";
        $CSS .= "}";
    }
    
    if ( $foot_style == '3' && ( itr_theme_option('foot_top_bg_color') || itr_theme_option('foot_top_text_color') ) ) {
        $CSS .= "#footWrapper .foot-top > .container{";
            $CSS .= ( itr_theme_option('foot_top_bg_color') != '' ) ? "background-color: ".itr_theme_option('foot_top_bg_color')." !important;" : "";
            $CSS .= ( itr_theme_option('foot_top_text_color') != '' ) ? "color: ".itr_theme_option('foot_top_text_color').";" : "";
        $CSS .= "}";
    }
    
    // middle footer
    if ( itr_theme_option('footer_text_color') != '' ) {
        $CSS .= "#footWrapper .footer-middle,#footWrapper .footer-middle a{";
            $CSS .= "color: ".itr_theme_option('footer_text_color').";";
        $CSS .= "}";
    }
    
    if ( itr_theme_option('footer_link_color') != '' ) {
        $CSS .= "#footWrapper .footer-middle a,#footWrapper .footer-middle a:hover{";
            $CSS .= "color: ".itr_theme_option('footer_link_color').";";
        $CSS .= "}";
        $CSS .= "#footWrapper .footer-middle .widget li a:after{";
            $CSS .= "background-color: ".itr_theme_option('footer_link_color').";";
        $CSS .= "}";
    }
    
    if ( itr_theme_option('footer_head_color') != '' ) {
        $CSS .= "#footWrapper .footer-middle .widget h2.widgettitle{";
            $CSS .= "color: ".itr_theme_option('footer_head_color').";";
        $CSS .= "}";
    }
    
    if ( $foot_style != '2' && ( $foot_col != '' || $foot_grad != '' ) ) {
        $CSS .= ".foot_slrv{";
            $CSS .= ( $foot_col != '' ) ? "fill: ".$foot_col.";" : "";
            $CSS .= ( $foot_type == 'gradient' && $foot_grad != '' ) ? "fill: url(#foot_grad);" : '';
        $CSS .= "}";
    }
    
    if ( $foot_style == '2' ) {
        $CSS .= "#footWrapper .footer_bg{";
            $CSS .= ( $foot_type == 'color' && $foot_col != '' ) ? "background-color: ".$foot_col.";" : "";
            $CSS .= ( $foot_type == 'gradient' && $foot_grad != '' ) ? "background: ".$foot_grad.";" : '';
        $CSS .= "}";
    }
    
    if ( itr_theme_option('footer_bg_img') != '' ) {
        $ft_id = preg_replace( '/[^\d]/', '', itr_theme_option('footer_bg_img') );
        $ft_src = wp_get_attachment_image_src( $ft_id,'full' );
        $CSS .= "#footWrapper .footer_bg:before{
            background-image: url('".esc_url($ft_src[0])."');
            background-repeat: ".itr_theme_option('footer_bg_repeat').";
            background-position: ".itr_theme_option('footer_bg_position').";
            background-size: ".itr_theme_option('footer_bg_size').";
        }";
    }
    
    // bottom footer...
    if ( $foot_style != '3' && ( $foot_bot_col || $foot_bot_bg ) ) {
        $CSS .= "#footWrapper .footer-bottom{";
            $CSS .= ( $foot_bot_col  ) ? "color: ".$foot_bot_col.";" : "";
            $CSS .= ( $foot_bot_bg ) ? "background-color: ".$foot_bot_bg.";" : '';
        $CSS .= "}";
    }
    
    if ( $foot_style == '3' && ( $foot_bot_bg || $foot_bot_col ) ) {
        $CSS .= "#footWrapper .footer-bottom > .container{";
            $CSS .= ( $foot_bot_col  ) ? "color: ".$foot_bot_col.";" : "";
            $CSS .= ( $foot_bot_bg ) ? "background-color: ".$foot_bot_bg." !important;" : '';
        $CSS .= "}";
    } 
    
    if ( $foot_bot_link ) {
        $CSS .= "#footWrapper .footer-bottom a{";
            $CSS .= "color: ".$foot_bot_link.";";
        $CSS .= "}";
        $CSS .= "#footWrapper .footer-bottom a:after{";
            $CSS .= "background-color: ".$foot_bot_link.";";
        $CSS .= "}";
    } 
    
    // Sliding Bar...
    $t_slbar_on     = itr_theme_option( 'show_sliding_bar' );
    $m_slbar_on     = get_post_meta( itr_page_ID(), 'meta_hide_slbar' , true);
    $slbar_on       = ( $m_slbar_on == '' ) ? $t_slbar_on : $m_slbar_on;
    
    if( $slbar_on == '1' ){
        
        $CSS .= ".sl_bar_content{
            padding-top:{$slpaddTop[0]}px;
            padding-bottom:{$slpaddBottom}px;
        }";
        
        $consize = itr_theme_option('sliding_bar_content_font_size') ? itr_theme_option('sliding_bar_content_font_size') : '';
        
        if( $consize != '' || itr_theme_option('sliding_bar_font_color') != '' ){
            $CSS .= ".sl_bar_content *{";
                $CSS .= ( $consize != '' ) ? "font-size: {$consize}px !important;" : "";
                $CSS .= ( itr_theme_option('sliding_bar_font_color') != '' ) ? "color: ".itr_theme_option('sliding_bar_font_color').";" : "";
            $CSS .= "}";    
        }
        
        $headsize = itr_theme_option('sliding_bar_heading_font_size') ? itr_theme_option('sliding_bar_heading_font_size') : '17';
        
        $CSS .= ".sl_bar_content h2{
            font-size:{$headsize}px !important;
            color:".itr_theme_option('sliding_bar_headings_color')." !important;
        }";       
            
    }
    
    // 404 settings..
    if( is_404() ){
        if( itr_theme_option('bg_404_color') ){
            $CSS .= "body.error404{";
                $CSS .= "background-color: ".itr_theme_option('bg_404_color').";";
            $CSS .= "}";    
        }
        
        if ( itr_theme_option('bgimage404') != '' ) {
            $bg404_id = preg_replace( '/[^\d]/', '', itr_theme_option('bgimage404') );
            $bg404_src = wp_get_attachment_image_src( $bg404_id,'full' );
            $CSS .= "body.error404{
                background-image: url('".esc_url($bg404_src[0])."');
                background-repeat: ".itr_theme_option('bg_img_404_repeat').";
                background-position: ".itr_theme_option('bg_404_position').";
                background-size: ".itr_theme_option('bg_404_size').";
            }";
        }
        
        if ( itr_theme_option('bg_404_disable') != '' ) {
            $CSS .= "body.error404{
                background-image: none !important;
            }";
        }
        
        if ( itr_theme_option('head_404_bgcolor') ) {
            if( $head_style == 'creative' ){
                $CSS .= "body.error404 .top-head:not(.sticky-head).creative .itr_head_wrap .slurve-svg {
                    fill: ".itr_theme_option('head_404_bgcolor').";
                }";    
            } else {
                $CSS .= "body.error404 .top-head:not(.sticky-head), body.error404 .side-head:not(.invis_head) {
                    background-color: ".itr_theme_option('head_404_bgcolor').";
                }";    
            }
            
        }
        
        if ( itr_theme_option('head_404_color') ) {
            $CSS .= "body.error404 .top-head:not(.sticky-head) .itr_main_nav.anim_hover > ul > li > a {
                color: ".itr_theme_option('head_404_color').";
            }";
        }
        
        if ( itr_theme_option('head_404_icons_color') ) {
            $CSS .= "body.error404 .top-head:not(.sticky-head) .head-btn i {
                color: ".itr_theme_option('head_404_icons_color').";
            }";
            $CSS .= "body.error404 .top-head:not(.sticky-head) .head-btn > a:before,body.error404 .top-head:not(.sticky-head) .head-btn > a:after {
                border-color: rgba(" . itr_hex2RGB(itr_theme_option('head_404_icons_color'), true, ',') . " ,0.2) !important;
            }";
        }
        
        if ( itr_theme_option('head_404_hover_color') ) {
            $CSS .= "body.error404 .top-head:not(.sticky-head) .itr_main_nav.anim_hover > ul > li > a span span:before,body.error404 .top-head:not(.sticky-head) .head-btn > a i.btn_back{
                color: ".itr_theme_option('head_404_hover_color').";
            }";
            
        }    
    }    
    
    // responsive styles..
    $mob_sbar = itr_theme_option('sliding_bar_on_mobile');
    
    $CSS .= "@media only screen and (max-width: 768px) {
        header.top-head .logo a i.logo-txt{
            font-size: ".itr_theme_option('mobile_logo_size')."px;
        }";
    
    if( $mob_sbar == '' ){    
        $CSS .= ".slbar_btn,.top-slbar{
            display:none !important;    
        }";
    }
        
    $CSS .= "}";
    
    if( itr_theme_option('sticky_devices') != '1' ){
        $CSS .= "@media (max-width: 992px) {
                header.top-head.sticky-head{
                position: absolute;
            }";
        $CSS .= "}";    
    }
    
    if( itr_theme_option('topbar_devices') != '1' ){
        $CSS .= "@media (max-width: 992px) {
            .top-bar{
                display: none;
            }";
        $CSS .= "}";    
    }
    
    
    // Skin color styles..
    $CSS .= "
    .main-bg,.form-submit input.submit,.pager .page-numbers li > span:not(.dots),.tagcloud a:hover,.cp-text.loading-bar .cd-words-wrapper::after,.post-tags a:hover:after,#pp-nav li .active span, .pp-slidesNav .active span,
    .sidebar .mc4wp-form input[type='submit'],.vc_progress_bar .vc_single_bar .vc_bar,.post-info h3.itr-post-title:after,.post-info h2.itr-post-title:after,.cp-img-compare-handle i,.itr-blog-single .post-categories li a:hover,
    .itr_main_nav.colored li.mega-menu .mega-content,.page-loader .line_with_Dots .circlesload i,.page-loader .large_dots:before,.page-loader .large_dots:after,.page-loader .large_dots > div:before,#to-top:before,#to-top:after,
    .page-loader .circles .circlesload:after,thead th,.page-loader .cp-balls:after,.page-loader .spin_Square,.page-loader .cp-bubble:before,.page-loader .cp-bubble:after,.page-loader .cp-bubble,.itr-single-tags a:hover,
    .page-loader .cp-eclipse,.page-loader .circles .circlesload:before,.page-loader .large_dots > div:after,#raysgrid_related.raysgrid.kara .portfolio-item:hover .port-captions:after,.filter-by.style1 li.selected a,
    .wpb-js-composer .vc_tta.vc_general.vc_tta-style-classic .vc_tta-tab.vc_active>a,.wpb-js-composer .vc_tta.vc_tta-tabs.vc_tta-style-with_shadow .vc_tta-tab.vc_active>a,.itr-heading.main:before,
    .vc_toggle_title:after,.vc_grid-filter-item.vc_active>span,.vc_gitem-post-data-source-post_title h4:after,.social-list a i:last-child,.jssocials-share-link i:last-child {
        background-color: {$hexStr};
        color: #fff;
    }";
        
    $CSS .= ".itr_main_nav.colored ul ul,.wpb-js-composer .vc_tta-tabs.vc_tta-style-classic:not(.vc_tta-o-no-fill) .vc_tta-panel.vc_active .vc_tta-panel-body,.main-bg-import{
        background-color: {$hexStr} !important
    }
    
    a:hover,.main-color,.main-color > a,.top-head nav > ul > li > a > span::before,.breadcrumb a, .price_label span,.comment-list li article .reply a,ul.post-meta li:after,.bottom-head.bot-menu-bg .itr_main_nav > ul > li:hover > a,blockquote:before,
    .vc_toggle_active .vc_toggle_title,.meta .comment-reply-link,.meta .comment-edit-link,.sidebar .widget h2.widgettitle,.widget_nav_menu ul li.current-menu-ancestor > a,.widget_nav_menu ul li.current-menu-item > a,.search-wrapper .search-form .btn,
    .widget_nav_menu ul li.current-menu-parent > a,.widget_nav_menu ul li.current-menu-ancestor li.current-menu-item.current_page_item > a,.itr_main_nav ul li li a:hover,.HotspotPlugin_Hotspot .Hotspot_Title,.search-wrapper .close_search,
    .widget_nav_menu ul li.current-menu-parent li.current-menu-item.current_page_item > a,.top-bar-menu ul.sub-menu li:hover > a > span,.top-head .itr_main_nav:not(.anim_hover) > ul > li:hover > a > span,.nav-single > div .meta-nav i,
    .wpb-js-composer .vc_tta.vc_general.vc_tta-style-creative .vc_tta-tab.vc_active>a,.vc_toggle .vc_toggle_icon:after,.wpb_widgetised_column .widget h2.widgettitle,.vc_progress_bar.prog1 .vc_label_units,.itr_logout a,.itr-heading.style2:before {
        color: {$hexStr};
    }
    
    .box_more:hover:after,.box_more:hover:before,.post-tags a:hover:before,.itr_main_nav li:not(.mega-menu) ul,.itr_main_nav li.mega-menu .mega-content,.itr-border-form .wpcf7-form-control.wpcf7-text:focus,.itr-border-form .wpcf7-form-control.wpcf7-textarea:focus,
    .sidebar .widget h2.widgettitle,.slbar .widget h2.widgettitle,.wpb_widgetised_column .widget h2.widgettitle{
        border-color: {$hexStr};
    }
    .vc_gitem_row .vc_btn3-container .vc_btn3:before,.vc_gitem_row .vc_btn3-container .vc_btn3:after{
        border-color: {$hexStr} !important;
    }"; 
    
    if ( class_exists( 'WooCommerce' ) ) {
        $CSS .= "
        .woocommerce .widget_price_filter .ui-slider .ui-slider-range,.woocommerce #respond input#submit.alt, .woocommerce a.button.alt, .woocommerce button.button.alt, .woocommerce input.button.alt,.woocommerce nav.woocommerce-pagination ul li span,
        .woocommerce span.onsale,.shop-item .itr-quick-view,.woocommerce-MyAccount-navigation ul li.is-active a{
            background-color: {$hexStr} !important;
            color: #fff;
        }
        .woocommerce div.product .woocommerce-tabs ul.tabs{
            background-color: {$hexStr};
        }
        .woocommerce .widget_price_filter .ui-slider .ui-slider-handle,.up-sells > h2,.cross-sells > h2,.cart_totals > h2,header.title h3,.woocommerce-billing-fields > h3,.woocommerce-shipping-fields > h3,
        .woocommerce-additional-fields > h3,.woocommerce-column__title,#order_review_heading,.wc-bacs-bank-details-heading, body.woocommerce-checkout .itr-main-content .woocommerce h2,.woocommerce-tabs h2,.related.products > h2{
            border-color: {$hexStr};
        }
        .woocommerce div.product .woocommerce-tabs ul.tabs li.active a:before,.woocommerce div.product .summary .product_meta > span:before,.woocommerce div.product div.summary .yith-wcwl-add-button > a i,
        .yith-wcwl-wishlistaddedbrowse a,.yith-wcwl-wishlistexistsbrowse a,.woocommerce-product-search button[type='submit']{
            color: {$hexStr} !important;
        }
        .oc-woo .woocommerce-result-count{
            border-bottom-color: {$hexStr} !important;
        }";    
    }
    
    if( function_exists('is_bbpress') && is_bbpress() ) {
        $CSS .= ".forum-titles li, .bbp-header > div {
            border-bottom-color: {$hexStr};
        }";    
    }
    
    $CSS .= "
    .page-loader .cp-round:after{
        border-top-color: {$hexStr};
    }
    .page-loader .cp-eclipse:before{
        border-right-color: {$hexStr};
    }
    .page-loader .cp-eclipse:after{
        border-left-color: {$hexStr};
    }"; 
    
    // sub menu color..
    if ($sub_menu == 'custom') {
        if($m_sub_bg != ''){
            $CSS .= "
            .itr_main_nav.custom ul ul,.itr_main_nav.custom li.mega-menu .mega-content{
                background-color: {$m_sub_bg} !important;
            }";
        }
        if($m_sub_color != ''){
            $CSS .= "
            .itr_main_nav.custom ul ul li a{
                color: {$m_sub_color} !important;
            }
            .itr_main_nav.custom > ul > li:not(.mega-menu) ul li.hasChildren:before, .itr_main_nav.custom > ul > li:not(.mega-menu) ul li.hasChildren:after,.no-touch .itr_main_nav ul li li:not(.with_icons) > a:before {
                background-color: {$m_sub_color};
            }";
        }    
    } else if ( $thm_submenu == 'custom' ) {
        
        if($thm_sub_bg_color != ''){
            $CSS .= "
            .itr_main_nav.custom ul ul,.itr_main_nav.custom li.mega-menu .mega-content{
                background-color: {$thm_sub_bg_color} !important
            }";    
        }
        
        if ($thm_sub_color != ''){
            $CSS .= "
            .itr_main_nav.custom ul ul li a{
                color: {$thm_sub_color} !important;
            }
            .itr_main_nav.custom > ul > li:not(.mega-menu) ul li.hasChildren:before, .itr_main_nav.custom > ul > li:not(.mega-menu) ul li.hasChildren:after,.no-touch .itr_main_nav ul li li:not(.with_icons) > a:before {
                background-color: {$thm_sub_color};
            }";
        }                
    }
    
    $CSS = str_replace(': ', ':', str_replace(';}', '}', str_replace('; ',';',str_replace(' }','}',str_replace(' {', '{', str_replace('{ ','{',str_replace(array("\r\n","\r","\n","\t",'  ','    ','    '),"",preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!','',$CSS))))))));
    
    return $CSS;
      
}

if ( ! function_exists( 'itr_add_menu_bg' ) ) {
    
    function itr_add_menu_bg ( $cssE ) {
        
        $cssE = str_replace(': ', ':', str_replace(';}', '}', str_replace('; ',';',str_replace(' }','}',str_replace(' {', '{', str_replace('{ ','{',str_replace(array("\r\n","\r","\n","\t",'  ','    ','    '),"",
        preg_replace('!/\*[^*]*\*+([^/][^*]*\*+)*/!','',$cssE))))))));
        wp_enqueue_style( 'itr-menu-style', ITR_THM_URI . '/assets/css/vendor/menu.css', array( 'itr-main-style' ) );
        wp_add_inline_style ('itr-menu-style', $cssE);
        
    }
    
}

