<?php
/**
 *
 * IT-RAYS Framework
 *
 * @author IT-RAYS
 * @license Commercial License
 * @link http://www.it-rays.net
 * @copyright 2017 IT-RAYS Themes
 * @package ITFramework
 * @version 1.0.0
 *
 */
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

class itr_enq_Styles {
    
    public function __construct () {
        add_action( 'wp_enqueue_scripts', array( &$this , 'itr_enqueue_styles' ) );
    }
    
    public function itr_enqueue_styles() {
        $langcode = '';
        if ( class_exists( 'SitePress' ) ) {
            $langcode = '-'.ICL_LANGUAGE_CODE;
        } else if ( class_exists( 'Polylang' ) ) {
            $langcode = '-'.ICL_LANGUAGE_CODE;
        }
        
        $url_handle     = 'itr_google_fonts';
        $variants       = ':100,200,300,400,500,600,700,900';        
        $body_font      = ( itr_theme_option( 'body_font' . $langcode ) )     ? str_replace( ' ', '+', itr_theme_option('body_font'.$langcode) ) . $variants        : "";
        $menu_font      = ( itr_theme_option( 'menu_font' . $langcode ) )     ? str_replace( ' ', '+', itr_theme_option('menu_font'.$langcode) ) . $variants        : "";
        $headings_font  = ( itr_theme_option( 'headings_font' . $langcode ) ) ? str_replace( ' ', '+', itr_theme_option('headings_font'.$langcode) ) . $variants    : "";
        $logo_font      = ( itr_theme_option( 'logo_font' . $langcode ) )     ? str_replace( ' ', '+', itr_theme_option('logo_font'.$langcode) ) . $variants        : "";
        $slogan_font    = ( itr_theme_option( 'slogan_font' . $langcode ) )   ? str_replace( ' ', '+', itr_theme_option('slogan_font'.$langcode) ) . $variants      : "";
        $title_font     = ( itr_theme_option( 'title_font' . $langcode ) )    ? str_replace( ' ', '+', itr_theme_option('title_font'.$langcode) ) . $variants       : "";
        
        $font_families  = array( $body_font, $menu_font, $headings_font, $logo_font, $slogan_font, $title_font );
        $font_families  = array_unique( $font_families );
        
        $bbp            = ( function_exists('is_bbpress') && is_bbpress() ) ? 'is_bbpress' : '';
        $buddy          = ( function_exists('is_buddypress') && is_buddypress() ) ? 'is_buddypress' : '';
        
        if ( ! empty( $font_families ) ){    
            $itr_query_args = array(
                'family' => implode( '%7C', $font_families ),
                'subset' => 'latin,latin-ext',
            );
                    
            $request_url = add_query_arg( $itr_query_args, "//fonts.googleapis.com/css" );    
            wp_deregister_style( $url_handle );
            
            wp_register_style( $url_handle, $request_url, array(), null );
            wp_enqueue_style( $url_handle );
            
        }
        
        wp_enqueue_style( 'itr-rest-style',             ITR_THM_URI . '/assets/css/vendor/rest.css' );
        wp_enqueue_style( 'outlinefont',                ITR_THM_URI . '/assets/css/vendor/outlinefont.css' );
        wp_enqueue_style( 'streamline',                 ITR_THM_URI . '/assets/css/vendor/streamline.css' );
        wp_enqueue_style( 'font-awesome',               ITR_THM_URI . '/assets/css/vendor/font.awesome.css' );
                
        if ( is_singular() && comments_open() && get_option( 'thread_comments' ) == "1" ){
            wp_enqueue_script( 'comment-reply' );
        } 
        
        wp_register_script( 'modernizr',           ITR_THM_URI . '/assets/js/vendor/modernizr.js',                  array('jquery'), null, true);
                
        wp_register_script( 'scroll-to-id',        ITR_THM_URI . '/assets/js/vendor/scroll.to.id.js',               array('jquery'), null, true);
        
        if( itr_theme_option( 'body_smooth' ) == 1 ){
            wp_register_script( 'itr-smooth-scroll',   ITR_THM_URI . '/assets/js/vendor/smooth.scroll.js',          array('jquery'), null, true);    
        }
        
        if( $bbp ){
            wp_enqueue_style( 'itr-bbpress-css',    ITR_THM_URI . '/assets/css/plugins/bbpress.css' );
        }
        
        if( $buddy ) {
            wp_enqueue_style( 'itr-buddy-style',    ITR_THM_URI . '/assets/css/plugins/buddypress.css' );
        }
        
        if( function_exists('is_woocommerce') ){
            wp_enqueue_style( 'itr-woo-css',            ITR_THM_URI . '/woocommerce/assets/woo.css' );
            wp_enqueue_style( 'magnific-popup',         ITR_THM_URI . '/woocommerce/assets/magnific-popup.css' );
            wp_enqueue_script( 'magnific-popup',        ITR_THM_URI . '/woocommerce/assets/magnific.popup.js',      array('jquery'), null, true);
            wp_enqueue_script( 'itr-woo-js',            ITR_THM_URI . '/woocommerce/assets/woo.js',                 array('jquery'), null, true );
        }
        
        wp_enqueue_style( 'itr-main-style',             ITR_THM_URI . '/assets/css/style.css' );
        
        wp_add_inline_style( 'itr-main-style', itr_custom_css() );
        
        if( get_post_meta( itr_page_ID(), 'meta_fullscreen_onepage' , true ) == 1 ){
            wp_enqueue_style( 'jquery.pagepiling',    ITR_THM_URI . '/assets/css/vendor/jquery.pagepiling.css' );
            wp_enqueue_script( 'jquery.pagepiling',   ITR_THM_URI . '/assets/js/vendor/jquery.pagepiling.min.js',   array('jquery'), null, true);    
        }
        
        wp_register_script( 'jquery.slurve',       ITR_THM_URI . '/assets/js/vendor/jquery.slurve.js',              array('jquery'), null, true);
                
        wp_register_script( 'itr-main-script',     ITR_THM_URI . '/assets/js/script.js',                            array('jquery'), null, true);
        
        wp_enqueue_script('modernizr');
        wp_enqueue_script('scroll-to-id');
        wp_enqueue_script('itr-smooth-scroll');
        wp_enqueue_script( 'jquery.slurve' ); 
        wp_enqueue_script('itr-main-script');
          
    }
    
}
new itr_enq_Styles();