<?php
/**
 *
 * IT-RAYS Framework
 *
 * @author IT-RAYS
 * @license Commercial License
 * @link http://www.it-rays.net
 * @copyright 2017 IT-RAYS Themes
 * @package ITFramework
 * @version 1.0.0
 *
 */
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

// Add theme support..
if( ! function_exists( 'itr_after_setup_theme' ) ) {
    function itr_after_setup_theme() {
        
        if ( function_exists( 'add_theme_support' ) ) {
            
            add_theme_support( 'post-thumbnails' );
            add_theme_support('automatic-feed-links');
            
            // add theme support for wp 4.1 and higher.
            add_theme_support( "title-tag" );
            
            add_theme_support( 'html5', array(
                'search-form', 'comment-form', 'comment-list', 'gallery', 'caption'
            ));
            add_theme_support( 'post-formats', array(
                'aside', 'image', 'video', 'audio', 'quote', 'link', 'gallery', 'status', 'chat',
            ));
            
            add_theme_support( 'custom-background', apply_filters( 'it_custom_background_args', array(
                'default-color' => 'f5f5f5',
            ) ) );

            // Add support for featured content.
            add_theme_support( 'featured-content', array(
                'featured_content_filter' => 'it_get_featured_posts',
                'max_posts' => 6,
            ));
            add_theme_support('custom-header');
        }
        
        if ( ! isset( $content_width ) ) $content_width = itr_theme_option( 'main_width' );
        
        add_editor_style();
        
        define( 'ITR_HEADER_IMAGE_WIDTH', apply_filters( 'itr_header_image_width', 1170 ) );
        define( 'ITR_HEADER_IMAGE_HEIGHT', apply_filters( 'itr_header_image_height', 400 ) );
        
        load_theme_textdomain( 'munza' , ITR_THM_DIR . '/languages' );
                            
    }
    add_action( 'after_setup_theme', 'itr_after_setup_theme' );
}

if ( ! function_exists( 'itr_language_selector_flags' ) ) {
    function itr_language_selector_flags(){
        $languages = icl_get_languages('skip_missing=0&orderby=code');
        if(!empty($languages)){
            foreach($languages as $l){
                echo '<span class="lng_select">';
                    if(!$l['active']) echo '<a href="'.$l['url'].'">';
                    echo '<img src="'.$l['country_flag_url'].'" height="12" alt="'.$l['language_code'].'" width="18" />';
                    if(!$l['active']) echo '</a>';
                echo '</span>';
            }
        }
    }
}

// Get theme image sizes..
if ( ! function_exists( 'itr_get_image_sizes' ) ) {
    function itr_get_image_sizes() {
        global $_wp_additional_image_sizes;
        $itr_image_sizes = get_intermediate_image_sizes(); 
        $itr_imgs = array();
        foreach ( $itr_image_sizes as $size ) {
            $itr_imgs[$size] = $size;
        }
               
        return $itr_imgs;
    }    
}

// Add media to editor.. 
if ( ! function_exists( 'itr_media_editor' ) ){
    function itr_media_editor($html, $send_id, $attachment ){
        $post = get_post($send_id);
        $html .= '<media>'.$post->guid.'</media>';
        return $html;
    }
    add_filter('media_send_to_editor', 'itr_media_editor', 1, 3);
}

// Select menus..
if ( ! function_exists( 'itr_site_menu' ) ){
    function itr_site_menu(){
        $selmenu = array();
        $itr_menus = get_registered_nav_menus();
        foreach($itr_menus as $location => $description){
            $selmenu[$location] = $description;
        }
        $smenu = array('' => '-- '.esc_html__('Select Menu','munza').' --');
        $itr_menu = $smenu + $selmenu;
        return $itr_menu;
    }    
}

// get current page ID..
if ( ! function_exists( 'itr_page_ID' ) ){
    function itr_page_ID(){
        global $post;
        $pageID = '';
        if( ( get_option( 'show_on_front' ) && get_option( 'page_for_posts' ) && is_home() )) {
            $pageID = get_option('page_for_posts');
        } else {
            if(isset($post) && !is_search()) {
                $pageID = $post->ID;
            }
            if(class_exists('Woocommerce')) {
                if(is_shop() || is_tax('product_cat') || is_tax('product_tag')) {
                    $pageID = get_option('woocommerce_shop_page_id');
                }
            }
        }
        return $pageID;
    }
}

// Page Loader..
if ( ! function_exists( 'itr_loader' ) ) {
    function itr_loader(){
        $loader         = itr_theme_option('page_loader');
        $pr_ld          = itr_theme_option('page_loader_style');
        $loadtxt        = itr_theme_option( 'loadertext' );
        $m_main_color   = esc_html(get_post_meta( itr_page_ID() , 'meta_body_main_color' , true));
        $hexStr         = ( $m_main_color != '' ) ?  $m_main_color : esc_html(itr_theme_option( "skin_color" ));
        $load_id        = preg_replace( '/[^\d]/', '', itr_theme_option('loaderimage') );
        $load_src       = wp_get_attachment_image_src( $load_id,'full' );
        
        if ($loader == '1'){
            
            echo '<style type="text/css">';
            if ( itr_theme_option('loader_bar_bg') ) {
                if ( $pr_ld == '1' ){
                echo ".itr-loader-".$pr_ld." {
                        background-color: ".itr_theme_option('loader_bar_bg').";
                    }";
                } else if ( $pr_ld == '2' ){
                    echo ".spinningSquaresG {
                        --background-color: ".itr_theme_option('loader_bar_bg').";
                        background-color: ".itr_theme_option('loader_bar_bg').";
                    }";
                }
            }
            
            if ( itr_theme_option('loader_bar_forecolor') ) {
                if ( $pr_ld == '1' ){
                    echo ".itr-loader-".$pr_ld.":before {
                        background-color: ".itr_theme_option('loader_bar_forecolor').";
                    }";    
                } else if ( $pr_ld == '2' ){
                    echo ".spinningSquaresG {
                        --forground-color: ".itr_theme_option('loader_bar_forecolor').";
                        
                    }";    
                } else if ( $pr_ld == '3' ){
                    echo ".cssload-dot {
                        background-color: ".itr_theme_option('loader_bar_forecolor').";
                    }";    
                }
                            
            }
            
            if ( itr_theme_option('loader_text_color') ) {

                echo ".itr-loader-text {
                    color: ".itr_theme_option('loader_text_color').";
                }";
                            
            }
            echo '</style>';
                         
            echo '<div class="page-loader">';
                echo '<div class="inner_loader">';
                    
                    if( $pr_ld == 'img') {
                        echo '<div class="loader_img"><img alt="'.esc_attr(esc_html__('Loading','munza')).'" src="'.esc_url($load_src[0]).'"></div>';
                    } else {
                        echo '<div class="itr-loader-'.$pr_ld.'">';
                            if( $pr_ld == '2' ){
                                echo '<div id="spinningSquaresG">
                                    <div id="spinningSquaresG_1" class="spinningSquaresG"></div>
                                    <div id="spinningSquaresG_2" class="spinningSquaresG"></div>
                                    <div id="spinningSquaresG_3" class="spinningSquaresG"></div>
                                    <div id="spinningSquaresG_4" class="spinningSquaresG"></div>
                                    <div id="spinningSquaresG_5" class="spinningSquaresG"></div>
                                    <div id="spinningSquaresG_6" class="spinningSquaresG"></div>
                                    <div id="spinningSquaresG_7" class="spinningSquaresG"></div>
                                    <div id="spinningSquaresG_8" class="spinningSquaresG"></div>
                                </div>';
                            } else if( $pr_ld == '3' ) {
                                echo '<div class="cssload-contain"><div class="cssload-dot"></div><div class="cssload-dot"></div><div class="cssload-dot"></div><div class="cssload-dot"></div><div class="cssload-dot"></div></div>';
                            }
                        echo '</div>';
                    }
                    
                    if( $loadtxt ){
                        echo '<div class="itr-loader-text">' . esc_html( $loadtxt ) . '</div>';
                    }
                    
                echo '</div>';
            echo '</div>';
            
        }
        
    }    
}

// Site Logo..
if ( ! function_exists( 'itr_header_logo' ) ) {
    function itr_header_logo () {
        global $post;
        $cst_stic_log_src   = '';
        $logo_type          = itr_theme_option( "logo_type" );
        $log_id             = preg_replace( '/[^\d]/', '', itr_theme_option( "header_logo_image" ) );
        $log_src            = wp_get_attachment_image_src( $log_id,'full' );
        
        $ret_id             = preg_replace( '/[^\d]/', '', itr_theme_option( "retina_logo_image" ) );
        $ret_src            = wp_get_attachment_image_src( $ret_id,'full' );
        
        $sitck_log_id       = preg_replace( '/[^\d]/', '', itr_theme_option( "sticky_logo" ) );
        $sitck_log_src      = wp_get_attachment_image_src( $sitck_log_id,'full' );
        
        if ( !is_404() && !is_search() ) {
        
            $cst_log_id         = preg_replace( '/[^\d]/', '', get_post_meta( itr_page_ID(),'meta_logo_img',true ) );
            $cst_log_src        = ( wp_attachment_is_image( $post->ID ) ) ? '' : wp_get_attachment_image_src( $cst_log_id,'full' );
            
            $cst_stic_log_id    = preg_replace( '/[^\d]/', '', get_post_meta( itr_page_ID(),'meta_sticky_logo_img',true ) );
            $cst_stic_log_src   = ( wp_attachment_is_image( $post->ID ) ) ? '' : wp_get_attachment_image_src( $cst_stic_log_id,'full' );
        
        } else if ( is_404() ){
            
            $cst_log_404      = preg_replace( '/[^\d]/', '', itr_theme_option( 'logo404' ) );
            $cst_log_src      = wp_get_attachment_image_src( $cst_log_404,'full' ); 
            
        } else {
            
            $cst_log_src = $cst_stic_log_src = '';
            
        }
        
        $logo   = ( $cst_log_src != '' )                ? $cst_log_src[0]                       : $log_src[0];
        $stic   = ( $cst_stic_log_src && !is_404() )    ? $cst_stic_log_src[0]                  : $sitck_log_src[0];
        $dstic  = ( $stic != '' && $stic != $logo )     ? " data-sticky=".esc_url($stic)        : '';
        $dorg   = ( $stic != '' && $stic != $logo )     ? " data-orig-logo=".esc_url($logo)     : ''; 
        $reti   = ( $ret_src != '' )                    ? $ret_src[0]                           : '';
        $dritn  = ( $reti != '' )                       ? ' data-retina="'.esc_url($reti).'"'   : '';
        $retlogo= ( $reti != '' )                       ? ' has-retina'                          : '';
        
        ?>
        <div class="itr_logo<?php echo esc_attr($retlogo); ?>">
            <?php if( $logo_type == 'image' ){ ?>
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">
                    
                    <img alt="<?php bloginfo( 'name' ); ?>" class="site_logo" src="<?php echo esc_url($logo); ?>"<?php echo esc_attr($dorg); ?><?php echo esc_attr($dstic); ?><?php echo esc_attr($dritn); ?>>
                    
                    <?php if( $ret_src != '' ){ ?>
                        <img alt="<?php bloginfo( 'name' ); ?>" class="retina_logo" src="<?php echo esc_url($ret_src[0]); ?>" srcset="<?php echo esc_url($ret_src[0]); ?> 2x">
                    <?php } ?>
                        
                </a>
            <?php } else { ?>
                <a href="<?php echo esc_url( home_url( '/' ) ); ?>" rel="home">     
                    <i class="logo-txt white"><?php bloginfo( 'name' ); ?></i>
                    <span class="tagline white"><?php bloginfo('description'); ?></span>
                </a>
           <?php } ?>
        </div>
        <?php
    }
}

// Theme Header..
if ( ! function_exists( 'itr_header' ) ){
    function itr_header(){
        
        $hide_header    = get_post_meta( itr_page_ID() , 'meta_hide_header'         , true );
        $meta_header    = get_post_meta( itr_page_ID() , 'meta_header_style'        , true );
        $meta_layout    = get_post_meta( itr_page_ID() , 'meta_main_layout'         , true );
        $meta_invis     = get_post_meta( itr_page_ID() , 'meta_header_invisible'    , true );
        $meta_dir       = get_post_meta( itr_page_ID() , 'meta_side_dir'            , true );
        $theme_header   = itr_theme_option( 'header_style' );
        $scrlClass      = itr_theme_option( 'body_smooth' );
        $invis          = itr_theme_option( 'head_visible' );
        $dir            = ( $meta_dir       == '' )     ? itr_theme_option('side_dir')  : $meta_dir;
        $hedinvis       = ( $meta_invis     == '' )     ? $invis                        : $meta_invis;
        $head_style     = ( $meta_header    == '' )     ? $theme_header                 : $meta_header;
        
        $class          = 'pageWrapper';
        $class         .= ( $scrlClass      == '1' )                        ? ' smooth_scrl'        : "";
        $class         .= ( $head_style    == 'side' && $hedinvis == '1' ) ? ' invis_header'       : '';
        $class         .= ( $head_style     == 'side' )                     ? ' side-wrap ' .$dir   : '';
        $class         .= ( isset( $meta_layout ) && $meta_layout != '' )   ? ' '.$meta_layout      : ' '.itr_theme_option( 'layout' );
        $class         .= ( get_post_meta( itr_page_ID(), 'meta_fullscreen_onepage' , true) == 1 ) ? ' itr-fullscreen-page' : '';            
                
        echo '<div class="'. $class .'">';
                
        if ( !$hide_header == '1' ){
            get_template_part( 'layout/headers/'.$head_style );
        } 

    }
}

// Theme Footer..
if ( ! function_exists( 'itr_footer' ) ){
    function itr_footer(){
        $hide_footer    = get_post_meta( itr_page_ID(), 'meta_hide_footer',true);
        $meta_search    = get_post_meta(itr_page_ID(),'meta_hide_search',true);
        $srch           = ( $meta_search != '' ) ? $meta_search : itr_theme_option("show_search");
        $meta_header    = get_post_meta(itr_page_ID(), 'meta_header_style',true);
        $theme_header   = itr_theme_option('header_style');
        $pg_foot_style  = get_post_meta( itr_page_ID(), 'meta_footer_style' , true);
        $thm_foot_style = itr_theme_option('footer_style');
        $foot_style     = ($pg_foot_style != '') ? $pg_foot_style : $thm_foot_style;
        $head           = ( $meta_header != '' ) ? $meta_header : $theme_header;
                
        echo '</div>';
        
        if ( is_singular() && class_exists( 'munza_Core' ) ) {
            echo '<span class="ino_url hidden">'.esc_url(content_url()).'</span>';
        }
        if ( $hide_footer == '' ){
            get_template_part( 'layout/footers/footer-'.$foot_style);
        }
        if( itr_theme_option('show_top') == 1 ){
            echo '<a id="to-top" href="#"><span><i class="stline-arrow-up"></i><i class="stline-arrow-up btn_back"></i></span></a>';
        }
        
        echo '</div>';
        echo '<div class="itr_overlay"></div>';
        itr_sliding_bar();
        if( $srch == '1' && $head != 'side' ){
            echo '<div class="search-wrapper main-bg">';
                echo '<span class="close_search"><i class="stline-remove-bold"></i></span>';
                echo get_search_form();
            echo '</div>';
        }
        
    }
}

// get ID by slug
if ( ! function_exists( 'itr_get_ID_by_slug' ) ) {
    function itr_get_ID_by_slug($page_slug) {
        $page = get_page_by_path($page_slug);
        if ($page) {
            return $page->ID;
        } else {
            return null;
        }
    }
}

// Custom Page Title..
if ( ! function_exists( 'itr_custom_page_title' ) ){
    function itr_custom_page_title() {
        global $post;
        $post_type = get_post_type();
        $post_type_slug = '';
        if ( $post_type ) {
            $post_type_data = get_post_type_object( $post_type );
            $post_type_slug = $post_type_data->rewrite['slug'];
        }
        $page_title = '';
        if(is_front_page() && !is_home() ){
            
            $page_title .= esc_html('Home Page','munza');
            
        } else if(is_front_page() && is_home() ){
            
            $page_title = esc_html('Blog Posts','munza');
            
        } else if( is_home() ) {
            
            $page_title = get_the_title(get_option('page_for_posts', true));
            
        } else if ( is_search() ) {
    
            $page_title .= get_search_query();
            
        } else if ( is_author() ){
            
            $page_title .= itr_author_title();
            
        } else if ( is_tag() ) {
            
            $page_title .= single_tag_title( '', false );
            
        } else if( is_archive() ) {
            
            if ( is_day() ) {
                $page_title .= get_the_date( _x( 'j F Y', 'yearly archives', 'munza' ) );
            } elseif ( is_month() ) {
                $page_title .= get_the_date( _x( 'F Y', 'yearly archives', 'munza' ) );
            } elseif ( is_year() ) {
                $page_title .= get_the_date( _x( 'Y', 'yearly archives', 'munza' ) );
            } else if( class_exists( 'Woocommerce' ) && is_woocommerce() && ( is_product() || is_shop() ) && ! is_search() ) {
                $page_title = woocommerce_page_title( false );
            } else if(class_exists( 'Woocommerce' ) && is_product_category()){
                $page_title = single_cat_title('', false);
            } else if ( 'post' == get_post_type() ) {
                $page_title = single_cat_title('', false);
            } else if ( $post_type_slug == get_post_type() ) {
                $page_title = single_cat_title('', false);
            } else {
                $page_title = get_the_title();
            }
            
        } else if( class_exists( 'Woocommerce' ) && is_woocommerce() && ( is_shop() ) && ! is_search() ) {
            
            if( ! is_product() ) {
                $page_title = woocommerce_page_title( false );
            }
            
        } else {
            
            $page_title = get_the_title();
            
        }

        return $page_title;
    }
}

// Custom Page Sub Title..
if ( ! function_exists( 'itr_custom_page_subtitle' ) ){
    function itr_custom_page_subtitle() {
        global $post,$wp_query;
        $subtitl_text = '';
        if ( is_search() ) {
    
            $subtitl_text .= '<span class="itr-found-posts">'.esc_attr( $wp_query->found_posts ). '</span> ' .esc_html__( 'Search results found', 'munza' );
            
        } else if ( is_author() ){
            
            $subtitl_text .= esc_html__('Profile Page', 'munza');
            
        } else if ( is_tag() ) {
                        
            if(tag_description()){
                $subtitl_text .= tag_description( $tag_id );
            }
            
        } else if( is_archive() ) {
            
            if(category_description()){
                $subtitl_text .= category_description( $category_id );
            }
            
        }

        return $subtitl_text;
    }
}

// Custom Page Title Icon..
if ( ! function_exists( 'itr_page_title_icon' ) ){
    function itr_page_title_icon(){
        
        $title_icon = ( get_post_meta( itr_page_ID() , 'meta_title_icon' , true) == '' ) ? itr_theme_option('page_title_icon') : get_post_meta( itr_page_ID() , 'meta_title_icon' , true);
        
        if( $title_icon != '' ){
           echo '<i class="title-icon '.$title_icon.'"></i>'; 
        }
        
    }
}

// Site Breadcrumbs..
if ( ! function_exists( 'itr_site_breadcrumbs' ) ) {
    function itr_site_breadcrumbs () {
        
        $br_align           = ( get_post_meta(itr_page_ID(),'meta_title_bread_position',true) == '' ) ? itr_theme_option( 'page_title_breadcrumbs_align' ) : get_post_meta(itr_page_ID(),'meta_title_bread_position',true);
        $bread_show         = ( get_post_meta(itr_page_ID(),'meta_hide_breadcrumbs',true) == '' ) ? itr_theme_option( 'page_title_show_breadcrumbs' ) : get_post_meta(itr_page_ID(),'meta_hide_breadcrumbs',true);
        $bread_style        = ( get_post_meta(itr_page_ID(),'meta_breadcrumbs_style',true) == '' )? itr_theme_option( 'page_title_breadcrumbs_style' ) : get_post_meta(itr_page_ID(),'meta_breadcrumbs_style',true);
        $prefix             = itr_theme_option( 'page_title_breadcrumbs_prefix' );
        $suffix             = itr_theme_option( 'page_title_breadcrumbs_suffix' );
        $bread_mobile       = itr_theme_option( 'page_title_mobile_breadcrumbs' );
        
        if ( $bread_mobile == '' ){
            $mob = ' hidden-xs';    
        } else {
            $mob = '';
        }
        
        if( $bread_show == '1'  ){
            $yoast_links_options = get_option( 'wpseo_internallinks' );
            $yoast_bc_enabled=$yoast_links_options['breadcrumbs-enable'];
            
            if ( function_exists('yoast_breadcrumb') && $yoast_bc_enabled) {
                yoast_breadcrumb('<div id="breadcrumbs" class="breadcrumb'.esc_attr($mob).' '.esc_attr($br_align).' '.esc_attr($bread_style).'"><div class="container">','</div></div>');
            }else if(function_exists('bcn_display')) {
                echo '<div class="breadcrumb'.esc_attr($mob).' '.esc_attr($br_align).' '.esc_attr($bread_style).'">';
                
                if( $bread_style == 'style1' ) echo '<div class="container">';
                
                if($prefix) echo '<span>'.esc_html($prefix).'</span> '; 
                bcn_display();
                if($suffix) echo '<span>'.esc_html($suffix).'</span> ';
                
                if( $bread_style == 'style1' ) echo '</div>';
                
                echo '</div>';
            }    
        }    
    }
}

// If visual composer plugin is active functions..
if ( ! function_exists( 'itr_vc_active' ) ) {
    
    function itr_vc_active() {
        if ( class_exists( 'Vc_Manager' ) && defined( 'WPB_VC_VERSION' ) ) { return true; } else { return false; }
    }
    
    if( itr_vc_active() ){
        
        
        if( ! function_exists( 'itr_get_vc_column' ) ) {
            function itr_get_vc_column( $width = '' ) {
                $width = explode('/', $width);
                $width = ( $width[0] != '1' ) ? $width[0] * (12 / $width[1]) : (12 / $width[1]);
                $width = str_replace('.', '-', $width);
                return  'col-md-'.$width;
            }
        }

        if( ! function_exists( 'itr_column_offset_class_merge' ) ) {
            function itr_column_offset_class_merge( $column_offset, $width ) {
                $width = explode('/', $width);
                $width = ( $width[0] != '1' ) ? $width[0] * (12 / $width[1]) : (12 / $width[1]);
                $width = str_replace('.', '-', $width);
                if ( '1' === vc_settings()->get( 'not_responsive_css' ) ) {
                    $column_offset = preg_replace( '/col\-(lg|md|xs)[^\s]*/', '', $column_offset );
                }
                if ( preg_match( '/col\-sm\-\d+/', $column_offset ) ) {
                    return $column_offset;
                }
                return 'col-md-'.$width . ( empty( $column_offset ) ? '' : ' ' . $column_offset );
            }
        }
    }
}

// Forums issue with selected menu item..  
if ( ! function_exists( 'itr_custom_menu_classes' ) ){
   function itr_custom_menu_classes( $classes , $item ){
        global $post;
        if ( is_archive() || ( !is_singular('post') ) || is_tag() || is_404() || is_search() ) {
            $classes = str_replace( 'current_page_parent', '', $classes );
        }
        return $classes;
    }
    add_filter( 'nav_menu_css_class', 'itr_custom_menu_classes', 10, 2 );
}

// Pagination..
if ( ! function_exists( 'itr_paging_nav' ) ) {
    function itr_paging_nav() {
        global $wp_query;
        if ( $wp_query->max_num_pages < 2 ) return;
        $big = 999999999;
        $args = array(
            'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
            'format' => '?paged=%#%',
            'current' => max( 1, get_query_var('paged') ),
            'total' => $wp_query->max_num_pages,
            'type' => 'list',
            'prev_text' => '<i class="fa fa-angle-left"></i>',
            'next_text' => '<i class="fa fa-angle-right"></i>'                    
        );
        
        $pg_pos = itr_theme_option('pager_position');
        $p_type = itr_theme_option('pager_type');
        $lodtxt = (itr_theme_option('load_more_text') != '' ) ? esc_attr(itr_theme_option('load_more_text')) : esc_html__('Load More','munza');
        
        if ( $p_type == "1" ) { ?>
            <div class="pager <?php echo esc_attr($pg_pos);?>">
                <?php echo paginate_links( $args ); ?>
            </div>
        <?php } else if ( $p_type == "2" ) { ?>
            <ul class="pager oldnew">
                <li class="previous"><?php next_posts_link('<span><i class="fa fa-angle-left main-color"></i></span> '.esc_html__('OLDER ENTIRES', 'munza')) ?></li>
                <li class="next"><?php previous_posts_link(esc_html__('NEWER ENTIRES', 'munza'). ' <span><i class="fa fa-angle-right main-color"></i></span>') ?></li>
            </ul>
        <?php } else if ( $p_type == "3" ){
            $perm = ( get_option('permalink_structure') ) ? '/page/' : '&paged='; ?>
             <div class="loadmore">
                <span class="hidden blgurl" data-pag="<?php echo esc_attr($perm); ?>"><?php echo esc_url(itr_get_post_page_url()); ?></span>
                <a href="#" class="btn bold btn-lg btn-hover-shad"><?php echo esc_attr($lodtxt); ?> <span class="itr_preloader"><i class="main-color stline-loading-2"></i></span></a>
                <div class="hidden pgnum"><?php echo esc_attr($wp_query->max_num_pages) ?></div>
                <div class="load_msg"><?php echo esc_html__('No More Posts To Show !!', 'munza') ?></div>
            </div>
        <?php }
    }
}

if ( ! function_exists( 'itr_get_post_page_url' ) ) {
    function itr_get_post_page_url() {
        if( 'page' == get_option( 'show_on_front' ) ) {
            return get_permalink( get_option('page_for_posts' ) );
        } else {
            return home_url();
        }
    }
}

// if wpml is activated..
if ( ! function_exists( 'itr_wpml_activated' ) ) {
    function itr_wpml_activated() {
        if ( class_exists( 'SitePress' ) ) { return true; } else { return false; }
    }
}

// WPML plugin..
if ( class_exists( 'SitePress' ) ) {
   define('ICL_DONT_LOAD_LANGUAGE_SELECTOR_CSS', true); 
}

// Get current user..
if ( ! function_exists('itr_get_user_name') ){
    function itr_get_user_name(){
        $current_user   = wp_get_current_user();
        $firstname      = $current_user->user_firstname;
        $lastname       = $current_user->user_lastname;
        $a_nicename     = $current_user->user_nicename;
        $loginname      = $current_user->user_login;
        $author_id      = $current_user->user_id;
        $user_name      = $loginname;
        if(isset($firstname) && !empty($firstname)) {
            $user_name = $firstname . ' ' . $lastname;
        }
        if ( class_exists( 'woocommerce' ) ){
            return ' <a class="bold" href="'.esc_url(get_permalink( get_option('woocommerce_myaccount_page_id') )).'">' . $user_name . '</a>';    
        } else {
            return ' <a class="bold" href="'.esc_url(get_author_posts_url( $author_id, $a_nicename )).'">' . $user_name . '</a>';    
        }
    }
}

if ( ! function_exists('itr_author_title') ){
    function itr_author_title(){
        $current_user   = wp_get_current_user();
        $firstname      = $current_user->user_firstname;
        $lastname      = $current_user->user_lastname;
        $loginname      = $current_user->user_login;
        $user_name      = $loginname;
        if(isset($firstname) && !empty($firstname)) {
            $user_name = $firstname . ' ' . $lastname;
        }
        return $user_name;
    }
}

if ( ! function_exists('itr_login_form') ){
    function itr_login_form( $args = array() ){
        
        $defaults = array(
            'echo' => true,
            'form_id' => 'loginform',
            'remember' => true,
            'value_remember' => true,
        );
        $args           = wp_parse_args( $args, apply_filters( 'login_form_defaults', $defaults ) );
        $form_id        = uniqid('loginform_');
        $user_id        = uniqid('user_login_');
        $pass_id        = uniqid('user_pass_');
        $remember_id    = uniqid('rememberme_');
        $submit_id      = uniqid('wp-submit_');

        echo '<form class="wid_login_form" name="' . $form_id . '" id="' . $form_id . '" action="' . esc_url( site_url( 'wp-login.php', 'login_post' ) ) . '" method="post">';
            
            echo '<div class="form-group">';
                echo '<label for="' . esc_attr( $user_id ) . '" class="form-label">' . esc_html__( 'Username or Email Address', 'munza' ) . '</label>';
                echo '<input type="text" name="log" id="' . esc_attr( $user_id ) . '" class="form-control" size="20" />';
            echo '</div>';
            
            echo '<div class="form-group">';
                echo '<label for="' . esc_attr( $pass_id ) . '" class="form-label">' . esc_html__( 'Password', 'munza' ) . '</label>';
                echo '<input type="password" name="pwd" id="' . esc_attr( $pass_id ) . '" class="form-control" size="20" />';
            echo '</div>';
            
            echo '<div class="form-group itr-login-links">';
                echo '<div class="itr-login-lft">';
                    echo '<button type="submit" name="wp-submit" id="' . esc_attr( $submit_id ) . '" class="btn btn-login btn-hover-shad main-bg">' .esc_html__( 'LOGIN', 'munza' ). '</button>';
                echo '</div>';
                
                echo '<div class="itr-login-rit">';
                    echo '<div><input name="rememberme" type="checkbox" id="' . esc_attr( $remember_id ) . '" value="'. $args['value_remember'] .'" /> ' . esc_html__( 'Remember me!','munza' ) . '</div>';
                    echo '<div><a href="' . wp_lostpassword_url() . '" class="main-color">' . esc_html__( 'Lost your password ?','munza' ) . '</a></div>';
                echo '</div>';
                
            echo '</div>';
                                    
            if ( get_option( 'users_can_register' ) ) {
                echo '<div>';
                    echo '<span>'. esc_html__("Don't have an account?", 'munza') .'</span> ';
                    echo '<a href="'.wp_registration_url() .'" class="main-color">'. esc_html__('Sign up Now', 'munza') .'</a>';
                echo '</div>';
            }
             
        echo '</form>';
        
    }
}

// Sliding bar function..
if ( ! function_exists('itr_sliding_bar') ){
    function itr_sliding_bar() {
        $langcode = '';
        if ( class_exists( 'SitePress' ) ) {
            $langcode = '-'.ICL_LANGUAGE_CODE;
        } else if ( class_exists( 'Polylang' )){
            $langcode = '-'.ICL_LANGUAGE_CODE;
        }
        
        $meta_header          = get_post_meta( itr_page_ID() , 'meta_header_style' , true );
        $theme_header         = itr_theme_option( 'header_style' );
        $head_style           = ( $meta_header == '' ) ? $theme_header : $meta_header;
        $show_sliding_bar     = itr_theme_option('show_sliding_bar');
        $sbar_cols            = itr_theme_option('sliding_bar_columns');
        $sbar_top_border      = itr_theme_option('top_border_on_sliding_bar');
        $sbar_btn_pos         = itr_theme_option('btn_position'); 
        $sb                   = itr_theme_option('sliding_bar_sidebar'.$langcode); 
        $class                = 'slbar columns-'.$sbar_cols;
        
        if($sbar_top_border == '1'){
            $class .= ' sl_tp_border';
        }
                
        if ( $show_sliding_bar == "1" && $head_style != 'side' ) { 
        wp_enqueue_script( 'itr-slbar', ITR_THM_URI . '/assets/js/vendor/slidingbar.js', array('jquery'), null, true );
        ?>
        <div class="<?php echo esc_attr($class); ?>">
            <a href="#" class="slbar_close">
                <span class="itr-cls-line itr-cls-line-cross01">
                    <span class="itr-cls-line-in itr-cls-line-in-cross01"></span>
                </span>
                <span class="itr-cls-line itr-cls-line-cross02">
                    <span class="itr-cls-line-in itr-cls-line-in-cross02"></span>
                </span>
            </a>
            <div class="sl_bar_content">
                <?php dynamic_sidebar( $sb ); ?>
            </div>
            <svg class="itr-slbar-over" viewBox="0 0 100 100" preserveAspectRatio="none">
                <defs>
                    <linearGradient id="slbar-grad1" x1="0%" y1="0%" x2="0%" y2="100%">
                        <stop offset="0%"   stop-color="#00c99b"/>
                        <stop offset="100%" stop-color="#ff0ea1"/>
                    </linearGradient>
                    <linearGradient id="slbar-grad2" x1="0%" y1="0%" x2="0%" y2="100%">
                        <stop offset="0%"   stop-color="#ffd392"/>
                        <stop offset="100%" stop-color="#ff3898"/>
                    </linearGradient>
                    <linearGradient id="slbar-grad3" x1="0%" y1="0%" x2="0%" y2="100%">
                        <stop offset="0%"   stop-color="<?php echo itr_theme_option('sliding_bg_color'); ?>"/>
                        <stop offset="100%" stop-color="<?php echo itr_theme_option('sliding_bg_bot_color'); ?>"/>
                    </linearGradient>
                </defs>
                <path class="itr-slbar-over-path" d=""></path>
                <path class="itr-slbar-over-path" d=""></path>
                <path class="itr-slbar-over-path" d=""></path>
            </svg> 
        </div>
        <?php
        } 
    }
}

// Get site menus..
if ( ! function_exists('itr_header_menu') ){
    function itr_header_menu(){
        $page_men   = get_post_meta(itr_page_ID(), 'meta_page_menu' , true);        
        $menu       = ( $page_men != '' ) ? $page_men : 'main-menu';
        
        if ( has_nav_menu( $menu ) ) {
            echo '<a href="#" class="itr-responsive-btn"><i class="stline-navigation-menu-vertical"></i></a>';
            $itr_custom_menu = new itr_custom_menu();
            $itr_custom_menu->itr_nav_menu( array( 'theme_location' => $menu) ); 
        } else {
            echo '<span class="menu-message">'.esc_html__('Please go to admin panel > Menus > select the menu and add items to it.', 'munza').'</span>';
        }
    }
}

// Custom Header menus..
if ( ! function_exists('itr_choose_header_menu') ){
    function itr_choose_header_menu($area){                                                                             
        $page_men = ( get_post_meta(itr_page_ID(), 'meta_header_'.$area.'_area_menu', true) == '' ) ? itr_theme_option( 'header_'.$area.'_area_menu' ) : get_post_meta(itr_page_ID(), 'meta_header_'.$area.'_area_menu', true);
                
        $menu = ( $page_men ) ? $page_men : 'main-menu';
        
        if ( has_nav_menu( $menu ) ) {
            echo '<a href="#" class="itr-responsive-btn"><i class="stline-navigation-menu-vertical"></i></a>';
            $itr_custom_menu = new itr_custom_menu();
            $itr_custom_menu->itr_nav_menu( array( 'theme_location' => $menu) ); 
        }else{
            echo '<span class="menu-message">'.esc_html__('Please go to admin panel > Menus > select the menu and add items to it.', 'munza').'</span>';
        }
    }
}

if ( ! function_exists('itr_header_icons') ){
    function itr_header_icons(){
        
        $meta_search    = get_post_meta(itr_page_ID(),'meta_hide_search',true);
        $meta_cart      = get_post_meta(itr_page_ID(),'meta_hide_cart',true);
        $srch           = ( $meta_search != '' ) ? $meta_search : itr_theme_option("show_search");
        $cart           = ( $meta_cart != '' ) ? $meta_cart : itr_theme_option("show_cart");
        $meta_slbar     = get_post_meta(itr_page_ID(),'meta_hide_slbar',true);
        $slbar          = ( $meta_slbar != '' ) ? $meta_slbar : itr_theme_option("show_sliding_bar");
        
        if( $srch == '1' || $slbar == '1' || $cart == '1' ){ ?>
            <div class="itr-head-btns">
                <?php if( $srch == '1' ) { ?>
                    <div class="head-btn">
                        <a href="#" class="open_search"><i class="stline-search"></i><i class="stline-search btn_back"></i></a>
                    </div>
                <?php } ?>
                
                <?php if ( class_exists( 'woocommerce' ) && $cart  == '1' ) { ?>
                    <div class="head-btn cart-btn">
                        <?php echo itr_woo_cart(); ?>
                    </div>
                <?php } ?>
                
                <?php if ( $slbar == '1' ) { ?>
                    <div class="head-btn ">
                        <a href="#" class="slbar_btn"><i class="stline-navigation-menu-2"></i><i class="stline-navigation-menu-2 btn_back"></i></a>
                    </div>
                    
                <?php } ?>
                
            </div>
        <?php }
        
    }
}

if ( ! function_exists( 'itr_header_button' ) ){
    function itr_header_button ($area){
        
        $meta_btn_txt       = get_post_meta(itr_page_ID(),'meta_header_'.$area.'_btn_txt',true);
        $meta_btn_link      = get_post_meta(itr_page_ID(),'meta_header_'.$area.'_btn_link',true);
        $meta_btn_target    = get_post_meta(itr_page_ID(),'meta_header_'.$area.'_btn_targe',true);
        $meta_btn_col       = get_post_meta(itr_page_ID(),'meta_header_'.$area.'_btn_color',true);
        $meta_btn_bg        = get_post_meta(itr_page_ID(),'meta_header_'.$area.'_btn_bg_color',true);
        
        $head_btn_text      = ( $meta_btn_txt == '' ) ? itr_theme_option('header_'.$area.'_btn_text') : $meta_btn_txt;
        $head_btn_link      = ( $meta_btn_link == '' ) ? itr_theme_option('header_'.$area.'_btn_link') : $meta_btn_link;
        $target             = ( $meta_btn_target == '' ) ? itr_theme_option('header_'.$area.'_btn_target') : $meta_btn_target;
        $targ               = ( $target == '1' ) ? ' target="_blank"' : '';
        $head_btn_color     = ( $meta_btn_col == '' ) ? itr_theme_option('header_'.$area.'_btn_color') : $meta_btn_col;
        $head_btn_bg        = ( $meta_btn_bg == '' ) ? itr_theme_option('header_'.$area.'_btn_bg_color') : $meta_btn_bg; 
        
        if ( $head_btn_color || $head_btn_bg ){
            echo '<style type="text/css">'; 
                echo '.itr-head-btn-'.$area.'{';
                    if ( $head_btn_color ) echo 'color: '.$head_btn_color.' !important;';
                    if ( $head_btn_bg ) echo 'background-color: '.$head_btn_bg;
                echo '}';
            echo '</style>';   
        }
        echo '<a href="'.$head_btn_link.'"'.$targ.' class="btn bold itr-lett-1 rounded btn-shad btn-md itr-head-btn itr-head-btn-'.$area.'">'. $head_btn_text .'</a>';
    }
}

 if ( ! function_exists('itr_side_head_bottom') ){
    function itr_side_head_bottom(){
        
        
        
    }
}

// Theme page title style..
if ( ! function_exists( 'itr_title_style' ) ){
    function itr_title_style(){
        if ( !is_404() ){
            $h_title = get_post_meta(itr_page_ID(),'hide_page_title',true);
            if( $h_title != '1' ) {
                get_template_part( 'layout/headers/page-title');
            }
        }
    }
}

// Limit number of tags inside widget..
if ( ! function_exists( 'itr_tag_widget_limit' ) ){
    function itr_tag_widget_limit($args){
        $tagsNo = itr_theme_option('tags_limit');
         if(isset($args['taxonomy']) && $args['taxonomy'] == 'post_tag'){
          $args['number'] = esc_attr($tagsNo);
         }

         return $args;
    }
    add_filter('widget_tag_cloud_args', 'itr_tag_widget_limit');
}

// Allowed tags..
if ( ! function_exists( 'itr_allowed_tags' ) ){
    function itr_allowed_tags(){
        global $allowedtags;
        
        $attrs = array(
            'style'                 => array(),
            'id'                    => array(),
            'src'                   => array(),
            'alt'                   => array(),
            'title'                 => array(),
            'data-toggle'           => array(),
            'data-trigger'          => array(),
            'data-placement'        => array(),
            'data-content'          => array(),
            'data-original-title'   => array(),
            'href'                  => array(),
            'class'                 => array(),
        );
        
        $allowedtags['span']    = $attrs;
        $allowedtags['div']     = $attrs;
        $allowedtags['p']       = $attrs;
        $allowedtags['img']     = $attrs;
        $allowedtags['b']       = $attrs;
        $allowedtags['i']       = $attrs;
        $allowedtags['strong']  = $attrs;
        $allowedtags['a']       = $attrs;
        $allowedtags['u']       = $attrs;
        
        return $allowedtags;
    }
}

// Social icons..
if ( ! function_exists( 'itr_display_social_icons' ) ) {
    function itr_display_social_icons(){
        
        $soc            = itr_theme_option('social_icons');
        $nofollow       = itr_theme_option('socials_nofollow');
        $newwindow      = itr_theme_option('socials_new_window');
        $rel            = ( $nofollow ) ? ' rel="nofollow"' : '';
        $target         = ( $newwindow ) ? ' target="_blank"' : '';
        
        $output         = '<div class="social-list">';
        
            for ( $i = 1; $i <= $soc ; $i++ ) {
                
                $ico = itr_theme_option( "social_icon_" . $i );
                $lnk = itr_theme_option( "social_icon_link_" . $i );
                
                if ( $ico ) { 
                    $output .= "<a href='{$lnk}'{$rel}{$target}><i class='{$ico}'></i><i class='{$ico}'></i></a>";
                }
            }
        
        $output .='</div>'; 
           
        return $output;    
    }    
}

if ( ! function_exists( 'itr_remove_contact_wrapper' ) ) {
    function itr_remove_contact_wrapper($content) {
        $content = preg_replace('/<(span).*?class="\s*(?:.*\s)?wpcf7-form-control-wrap(?:\s[^"]+)?\s*"[^\>]*>(.*)<\/\1>/i', '\2', $content);
        return $content;
    }
    add_filter('wpcf7_form_elements', 'itr_remove_contact_wrapper');
}

// Fix tags issue in custom post types..
if ( ! function_exists( 'itr_fix_tags' ) ) {
    function itr_fix_tags( $query ) {
        if( is_tag() && $query->is_main_query() ) {
            $post_types = get_post_types();
            $query->set( 'post_type', $post_types );
        }
    }
    add_filter( 'pre_get_posts', 'itr_fix_tags' );    
}

if ( ! function_exists( 'itr_allow_data_event_content' ) ) {
    function itr_allow_data_event_content() {
        global $allowedposttags, $allowedtags;
        $newattribute                           = "style"; 
        $allowedposttags["span"][$newattribute] = true;
        $allowedtags["span"][$newattribute]     = true;
        $allowedposttags["ul"][$newattribute]   = true;
        $allowedtags["ul"][$newattribute]       = true;
        $allowedposttags["li"][$newattribute]   = true;
        $allowedtags["li"][$newattribute]       = true;
    }
    add_action( 'init', 'itr_allow_data_event_content' );
}

if ( ! function_exists( 'itr_them_url_dash' ) ) {
    function itr_them_url_dash(){
        
        echo '<span class="hidden adm">'.esc_url(admin_url()).'</span>';
        echo '<span class="hidden themeURI">'.ITR_THM_URI.'</span>';
        
    } 
    add_action('admin_footer', 'itr_them_url_dash');   
}

if ( ! function_exists( 'itr_sidebars_arr' ) ) {
    function itr_sidebars_arr() {
        $options = get_option( 'munza_theme_options' );
        global $wp_registered_sidebars;
        $sbars = array();
        foreach($wp_registered_sidebars as $sidebar_id => $sidebar){
            $sbars[$sidebar_id] = $sidebar['name'];
        }
        return $sbars;
    }
}

if ( ! function_exists( 'itr_dynamic_sidebar' ) ) {
    function itr_dynamic_sidebar($index = 1) {
        $sidebar_contents = "";
        ob_start();
        dynamic_sidebar($index);
        $sidebar_contents = ob_get_clean();
        return $sidebar_contents;
    }    
}

// Color creator functions..
if ( ! function_exists( 'itr_colourCreator' ) ) {
    function itr_colourCreator($colour, $per) {  
        $colour = substr( $colour, 1 ); // Removes first character of hex string (#) 
        $rgb = ''; // Empty variable 
        $per = $per/100*255; // Creates a percentage to work with. Change the middle figure to control colour temperature
         
        if  ($per < 0 ) // Check to see if the percentage is a negative number 
        { 
            // DARKER 
            $per =  abs($per); // Turns Neg Number to Pos Number 
            for ($x=0;$x<3;$x++) 
            { 
                $c = hexdec(substr($colour,(2*$x),2)) - $per; 
                $c = ($c < 0) ? 0 : dechex($c); 
                $rgb .= (strlen($c) < 2) ? '0'.$c : $c; 
            }   
        }  
        else 
        { 
            // LIGHTER         
            for ($x=0;$x<3;$x++) 
            {             
                $c = hexdec(substr($colour,(2*$x),2)) + $per; 
                $c = ($c > 255) ? 'ff' : dechex($c); 
                $rgb .= (strlen($c) < 2) ? '0'.$c : $c; 
            }    
        } 
        return '#'.$rgb; 
    }    
}

if ( ! function_exists( 'itr_hex2RGB' ) ) {
    function itr_hex2RGB($hexStr, $returnAsString = false, $seperator = ',') {
        $hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); // Gets a proper hex string
        $rgbArray = array();
        if (strlen($hexStr) == 6) { //If a proper hex code, convert using bitwise operation. No overhead... faster
            $colorVal = hexdec($hexStr);
            $rgbArray['red'] = 0xFF & ($colorVal >> 0x10);
            $rgbArray['green'] = 0xFF & ($colorVal >> 0x8);
            $rgbArray['blue'] = 0xFF & $colorVal;
        } elseif (strlen($hexStr) == 3) { //if shorthand notation, need some string manipulations
            $rgbArray['red'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
            $rgbArray['green'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
            $rgbArray['blue'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
        } else {
            return false; //Invalid hex color code
        }
        return $returnAsString ? implode($seperator, $rgbArray) : $rgbArray; // returns the rgb string or the associative array
    }
}

if ( ! function_exists( 'itr_colourBrightness' ) ){
    function itr_colourBrightness($hex, $percent) {
        $hash = '';
        if (stristr($hex,'#')) {
            $hex = str_replace('#','',$hex);
            $hash = '#';
        }
        $rgb = array(hexdec(substr($hex,0,2)), hexdec(substr($hex,2,2)), hexdec(substr($hex,4,2)));
        for ($i=0; $i<3; $i++) {
            if ($percent > 0) {
                // Lighter
                $rgb[$i] = round($rgb[$i] * $percent) + round(255 * (1-$percent));
            } else {
                // Darker
                $positivePercent = $percent - ($percent*2);
                $rgb[$i] = round($rgb[$i] * $positivePercent) + round(0 * (1-$positivePercent));
            }
            if ($rgb[$i] > 255) {
                $rgb[$i] = 255;
            }
        }
        $hex = '';
        for($i=0; $i < 3; $i++) {
            $hexDigit = dechex($rgb[$i]);
            if(strlen($hexDigit) == 1) {
            $hexDigit = "0" . $hexDigit;
            }
            $hex .= $hexDigit;
        }
        return $hash.$hex;
    }
}

if ( ! function_exists( 'itr_pro_category' ) ) {
    function itr_pro_category() {
        global $post;
        $cats = array();
        $terms = get_the_terms($post->id, 'raysgrid_categories');
        if (is_array($terms)) {
            foreach ($terms as $term) {
                $id = $term->term_id;
                $cats [] = '<a href="' . site_url() . '/' . $term->taxonomy . '/' . $term->slug . '">' . $term->name . '</a>';
            }
            return implode('  ,  ', $cats);
        }
    }

}

// Enable custom fonts extensions uploads..
if ( ! function_exists( 'itr_enable_extended_upload' ) ) {
    function itr_enable_extended_upload ( $mime_types =array() ) {
       $mime_types['ttf']   = 'application/font-sfnt';
       $mime_types['eot']   = 'application/vnd.ms-fontobject';
       $mime_types['svg']   = 'image/svg+xml';
       $mime_types['svgz']  = 'image/svg+xml';
       $mime_types['woff']  = 'application/font-woff';
       return $mime_types;
    }
    add_filter('upload_mimes', 'itr_enable_extended_upload');    
}