<?php
/**
 *
 * IT-RAYS Framework
 *
 * @author IT-RAYS
 * @license Commercial License
 * @link http://www.it-rays.net
 * @copyright 2016 IT-RAYS Themes
 * @package ITFramework
 * @version 1.0.0
 *
 */
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' ); 
 
// Add menus to the site
function itr_theme_menus() {
    
    register_nav_menus(
        array(
            'main-menu'     => esc_html__( 'Main Menu', 'munza' ),
            'one-page'      => esc_html__( 'One Page Menu', 'munza' ),
            'top-bar-menu'  => esc_html__( 'Top Bar Menu', 'munza' ),
        )
    );
    
    // Dynamic menu locations...
    $locs = itr_theme_option('locations');
    for ( $i = 1; $i <= $locs ; $i++ ) {  
        $locname = itr_theme_option('location_'.$i);
        register_nav_menus(
            array(
                'location-'.$locname => $locname
            )
        );
    }
      
}

add_action( 'init', 'itr_theme_menus' );