<?php
/**
 *
 * IT-RAYS Framework
 *
 * @author IT-RAYS
 * @license Commercial License
 * @link https://www.it-rays.org
 * @copyright 2017 IT-RAYS Themes
 * @package ITFramework
 * @version 1.0.0
 *
 */
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );
 
if ( ! function_exists( 'itr_post_thumbnail' ) ) {
    function itr_post_thumbnail() {
        global $post;
        $holder     = itr_theme_option('img_placeholder');
        $imSize     = itr_theme_option( 'blog_image_size' );
        $img_class  = ( is_singular() ) ? 'itr-single-img' : 'post-image';
                
        if ( itr_theme_option('postimg_on') == "1" ){
            if ( get_post_format() == 'gallery' || get_post_format() == 'video' || get_post_format() == 'audio' ) {
                
                echo itr_post_media( get_the_content() );
                
            } else if ( get_post_format() == 'image' ) {
                if( has_post_thumbnail()){
                    echo '<div class="'.$img_class.'">';
                        echo '<a href="'. esc_url(get_the_permalink()) .'" class="post-thumbnail">';
                            echo get_the_post_thumbnail($post->ID, $imSize, '');  
                        echo '</a>'; 
                    echo '</div>';
                } else {
                    echo itr_post_image(get_the_content());
                }        
            } else {
                
                if ( get_the_post_thumbnail() ) {
                    echo '<div class="'.$img_class.'">';
                        echo '<a href="'. esc_url(get_the_permalink()) .'" class="post-thumbnail">';
                            echo get_the_post_thumbnail($post->ID, $imSize, '');  
                        echo '</a>';
                    echo '</div>';
                } else if( $holder ) {
                     echo '<div class="'.$img_class.'">';
                        echo '<a href="'. esc_url(get_the_permalink()) .'" class="post-thumbnail">';
                            echo '<img alt="'.get_the_title().'" src="' . esc_url(get_parent_theme_file_uri("/assets/images/blog/placeholder.jpg")) .'" />';
                        echo '</a>';
                    echo '</div>';
                } 
            }
        }
        
    }
}

if ( ! function_exists( 'itr_simple_post_thumbnail' ) ) {
    function itr_simple_post_thumbnail( $link = '' ) {
        global $post;
        $holder = itr_theme_option('img_placeholder');
        $imSize = itr_theme_option( 'blog_image_size' );
        if ( itr_theme_option('postimg_on') == "1" ){
            
            if ( get_the_post_thumbnail() ) {
                echo get_the_post_thumbnail($post->ID, $imSize, '');  
            } else if( $holder ) {
                echo '<img alt="'.get_the_title().'" src="' . esc_url(get_parent_theme_file_uri("/assets/images/blog/placeholder.jpg")) .'" />';
            }
             
        }
        
    }
}

if ( ! function_exists( 'itr_post_image' ) ) {
    function itr_post_image( $content ) {
        
        global $post;
        ob_start();
        ob_end_clean();
        $output = preg_match_all('/<img.+src=[\'"]([^\'"]+)[\'"].*>/i', $post->post_content, $matches);
        $first_img = $matches [1] [0];
        
        if ( is_singular() ) {
            
            echo '<div class="details-img">';
                echo '<img alt="'.get_the_title().'" src="'.esc_url($first_img).'" />';
            echo '</div>';
            
        } else {
            
            if ( !empty( $first_img ) ) {
                
                echo '<div class="post-image">';
                    echo '<a href="'.get_the_permalink().'">';
                        echo '<img alt="'.get_the_title().'" src="'.esc_url($first_img).'" />';
                    echo '</a>';
                echo '</div>';
                
            } else {
                itr_post_thumbnail();
            }
            
        }
                
    }
}

if ( ! function_exists( 'itr_listing_cat' ) ) {
    function itr_listing_cat (){
        if ( itr_theme_option('category_on') == "1" && itr_theme_option('postimg_on') == "1" ){
            $categories = get_the_category();
            if ( ! empty( $categories ) ) {
                return '<li><a class="main-bg itr_cat_over" href="' . esc_url( get_category_link( $categories[0]->term_id ) ) . '">' . esc_html( $categories[0]->name ) . '</a></li>';
            }
        }
    }
}

if ( ! function_exists( 'itr_post_media' ) ) {
    function itr_post_media( $content ) {
        global $post;
        $output = '';
        $media = itr_getUrl( $content );
        $holder = itr_theme_option('img_placeholder'); 
        if( ! empty( $media ) ) {
            global $wp_embed;
            $content  = do_shortcode( $wp_embed->run_shortcode( '[embed]'. $media .'[/embed]' ) );
        } else {
            $pattern = itr_get_shortcode_regex( itr_wp_tagregexp() );
            preg_match( '/'.$pattern.'/s', $content, $media );
            if ( ! empty( $media[2] ) ) {
                if( $media[2] == 'embed' ) {
                    global $wp_embed;
                    $content = do_shortcode( $wp_embed->run_shortcode( $media[0] ) );
                } else {
                    
                    $gallery = get_post_gallery_images( $post );
                    
                    if ( get_post_format() == 'gallery' && ! empty( $gallery ) && ! empty( $media[0] ) ) {
                        $content = do_shortcode( $media[0] );
                    } else if ( get_post_format() != 'gallery' && ! empty( $media[0] ) ) {
                        $content = do_shortcode( $media[0] );
                    } else {
                        if ( get_the_post_thumbnail() ) {
                            $content = get_the_post_thumbnail();  
                        } else if( $holder ) {
                            $content = '<img alt="'.get_the_title().'" src="' . esc_url(get_parent_theme_file_uri("/assets/images/blog/placeholder.jpg")) .'" />';
                        }
                    }
                }
            }
        }
        
        if( ! empty( $media ) ) {
            $output .= (get_post_format() == 'gallery') ? '<div class="post-gallery">' : '<div class="post-media">';
                $output .= $content;
            $output .= '</div>';
            
            return $output; 
        }
        return false;
    }
}

if ( ! function_exists( 'itr_post_icon' ) ){
    function itr_post_icon(){
        $post_format = get_post_format();
        $output = '<li class="post-icon main-color">';
        
        switch ( $post_format ) {
            
          case 'gallery':
            $output .= '<i class="fa fa-camera" title="'.esc_attr(esc_html__('Gallery', 'munza')).'"></i>';
          break;
          
          case 'link':
            $output .= '<i class="fa fa-link" title="'.esc_attr(esc_html__('Link', 'munza')).'"></i>';
          break;

          case 'image':
            $output .= '<i class="fa fa-image" title="'.esc_attr(esc_html__('Image', 'munza')).'"></i>'; 
          break;
          
          case 'quote':
            $output .= '<i class="fa fa-quote-left" title="'.esc_attr(esc_html__('Quote', 'munza')).'"></i>'; 
          break;
          
          case 'status':
            $output .= '<i class="fa fa-refresh" title="'.esc_attr(esc_html__('Status', 'munza')).'"></i>'; 
          break;
          
          case 'audio':
            $output .= '<i class="fa fa-music" title="'.esc_attr(esc_html__('Status', 'munza')).'"></i>'; 
          break;
          
          case 'video':
            $output .= '<i class="fa fa-video-camera" title="'.esc_attr(esc_html__('Status', 'munza')).'"></i>'; 
          break;
          
          case 'chat':
            $output .= '<i class="fa fa-comments-o" title="'.esc_attr(esc_html__('Chat', 'munza')).'"></i>'; 
          break;
          
          case 'aside':
            $output .= '<i class="fa fa-eyedropper" title="'.esc_attr(esc_html__('Aside', 'munza')).'"></i>'; 
          break;
          
          default:
            $output .= '<i class="fa fa-book" title="'.esc_attr(esc_html__('Standard', 'munza')).'"></i>';
          break;
        }
        
        $output .= '</li>';
        
        return $output;
    }
}

if ( ! function_exists( 'itr_in_title' ) ) {
    function itr_in_title(){
        $title_format   = itr_post_format_link( get_the_content(), get_the_title() );
        $output         = $title_format['title']; 
        return $output;
    }
}

if ( ! function_exists( 'itr_post_title' ) ) {
    function itr_post_title(){
        if ( itr_theme_option('title_on') == "1" ){
            if ( itr_theme_option('date_on') == "1" ){
                echo '<div class="meta_date">' . esc_html(get_the_date()) . '</div>';
            }
            echo itr_in_title();
        }
    }
} 

if ( ! function_exists( 'itr_content_filter' ) ) {
    function itr_content_filter( $content ) {
        $post_format = get_post_format();
        if ( $post_format ) {
            $content = apply_filters( 'it-post-format-'. $post_format, $content );
        }
        return $content;
    }
    add_filter( 'the_content', 'itr_content_filter', 2 );
}

if ( ! function_exists( 'itr_global_more' ) ) {
    function itr_global_more(){
        global $post;
        $langcode = '';
        if ( class_exists( 'SitePress' ) ) {
            $langcode = '-'.ICL_LANGUAGE_CODE;
        } else if ( class_exists( 'Polylang' )){
            $langcode = '-'.ICL_LANGUAGE_CODE;
        }
        $moreoutput = '';
        $more_text  = itr_theme_option( 'read_more_text'.$langcode );
        $moreoutput .= '<div class="more_container"><a class="btn btn-sm box_more" href="'. esc_url(get_permalink($post->ID)) . '"><span>'. esc_html( $more_text ) .'</span></a></div>';
        
        return $moreoutput;
    }    
}

if ( ! function_exists( 'itr_new_excerpt_more' ) ) {
    function itr_new_excerpt_more($more) {
        global $post;
        $langcode = '';
        if ( class_exists( 'SitePress' ) ) {
            $langcode = '-'.ICL_LANGUAGE_CODE;
        } else if ( class_exists( 'Polylang' ) ) {
            $langcode = '-'.ICL_LANGUAGE_CODE;
        }
        $more_text  = itr_theme_option( 'read_more_text'.$langcode );
        return '<div class="more_container"><a class="btn btn-sm box_more" href="'. get_permalink($post->ID) . '">'.$more_text.'</a></div>';
    }
    add_filter('excerpt_more', 'itr_new_excerpt_more');
}  

if ( ! function_exists( 'itr_modify_read_more_link' ) ) {
    function itr_modify_read_more_link() {
        $langcode = '';
        if ( class_exists( 'SitePress' ) ) {
            $langcode = '-'.ICL_LANGUAGE_CODE;
        } else if ( class_exists( 'Polylang' ) ) {
            $langcode = '-'.ICL_LANGUAGE_CODE;
        }
        $more_text  = itr_theme_option( 'read_more_text'.$langcode );
        return '<div class="more_container"><a class="btn btn-sm box_more" href="' . get_permalink() . '">'.$more_text.'</a></div>';
    }
    add_filter( 'the_content_more_link', 'itr_modify_read_more_link' );
}

if ( ! function_exists( 'itr_get_content_format' ) ){
    function itr_get_content_format () {
        
        global $post;
        
        $content        = get_the_content();
        $content        = apply_filters('the_content', $content);
        $content        = str_replace(']]>', ']]&gt;', $content);       
        $cont_format    = itr_theme_option( 'content_format_on' ); 
        $length         = itr_theme_option('it_excerpt');
        $pg_type        = 'list';
        
        if( itr_theme_option( 'excerpt_on' ) == '1' ){ ?>
            <div class="entry-content"><?php
                if( $cont_format == 1 ){
                    if ( $length != '-1' ){
                        echo wp_trim_words( $content , $length , itr_global_more() );    
                    }
                      
                } else {
                    
                    if ( ! has_excerpt() ) {
                          $content = the_content();
                    } else { 
                          $content = the_excerpt();
                    }
                    
                }
                ?>
            </div> 
            <?php 
            
            itr_mini_pager();
            
            if ( class_exists( 'munza_Core' ) ) {
                echo itr_blog_share($pg_type);
            }
        
        }

                        
    }    
}

if ( ! function_exists( 'itr_customize_content' ) ) {
    function itr_customize_content($content) {
        
        if ( get_post_format() == 'image' ) {
            if( !has_post_thumbnail()){
                $first_img ="/<img(.*?)class=\"(.*?)\"(.*?)>/i";
                $content = preg_replace($first_img, '', $content,1);
            }
        }
        $content = str_replace("<p></p>","",$content);
        $content = str_replace("<p>&nbsp;</p>","",$content);
        return $content;    

    }
    add_filter('the_content', 'itr_customize_content',11);    
}

if ( ! function_exists( 'itr_strip_shortcode_gallery' ) ) {
    function itr_strip_shortcode_gallery( $content ) {
        preg_match_all( '/'. itr_get_shortcode_regex() .'/s', $content, $matches, PREG_SET_ORDER );
        if ( ! empty( $matches ) ) {
            foreach ( $matches as $shortcode ) {
                if ( 'gallery' === $shortcode[2] ) {
                    $pos = strpos( $content, $shortcode[0] );
                    if ($pos !== false)
                        return substr_replace( $content, '', $pos, strlen($shortcode[0]) );
                }
            }
        }
        return $content;
    }
    add_filter( 'it-post-format-gallery', 'itr_strip_shortcode_gallery' );    
} 

if ( ! function_exists( 'itr_get_shortcode_regex' ) ) {
  function itr_get_shortcode_regex() {
      global $shortcode_tags;
      $tagnames = array_keys($shortcode_tags);
      $tagregexp = join( '|', array_map('preg_quote', $tagnames) );

      // WARNING! Do not change this regex without changing do_shortcode_tag() and strip_shortcode_tag()
      // Also, see shortcode_unautop() and shortcode.js.
      return
          '\\['                              // Opening bracket
        . '(\\[?)'                           // 1: Optional second opening bracket for escaping shortcodes: [[tag]]
        . "($tagregexp)"                     // 2: Shortcode name
        . '(?![\\w-])'                       // Not followed by word character or hyphen
        . '('                                // 3: Unroll the loop: Inside the opening shortcode tag
        .     '[^\\]\\/]*'                   // Not a closing bracket or forward slash
        .     '(?:'
        .         '\\/(?!\\])'               // A forward slash not followed by a closing bracket
        .         '[^\\]\\/]*'               // Not a closing bracket or forward slash
        .     ')*?'
        . ')'
        . '(?:'
        .     '(\\/)'                        // 4: Self closing tag ...
        .     '\\]'                          // ... and closing bracket
        . '|'
        .     '\\]'                          // Closing bracket
        .     '(?:'
        .         '('                        // 5: Unroll the loop: Optionally, anything between the opening and closing shortcode tags
        .             '[^\\[]*+'             // Not an opening bracket
        .             '(?:'
        .                 '\\[(?!\\/\\2\\])' // An opening bracket not followed by the closing shortcode tag
        .                 '[^\\[]*+'         // Not an opening bracket
        .             ')*+'
        .         ')'
        .         '\\[\\/\\2\\]'             // Closing shortcode tag
        .     ')?'
        . ')'
        . '(\\]?)';                          // 6: Optional second closing brocket for escaping shortcodes: [[tag]]
    }
}

if ( ! function_exists( 'itr_wp_tagregexp' ) ) {
  function itr_wp_tagregexp() {
    apply_filters( 'wp_custom_tagregexp', 'video|media|audio|playlist|video-playlist|embed' );
  }
}

if ( ! function_exists( 'itr_getUrl' ) ) {
  function itr_getUrl( $html ) {
    $regex  = "/^\b(?:(?:https?|ftp):\/\/)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i";
    preg_match( $regex, $html, $matches );
    return ( !empty( $matches[0] ) ) ? $matches[0] : false;
  }
}

if ( ! function_exists( 'itr_link_href' ) ) {
  function itr_link_href( $string ) {
    preg_match( '/<a href="(.*?)">/i', $string, $atts );
    return ( ! empty( $atts[1] ) ) ? $atts[1] : '';
  }
}

if ( ! function_exists( 'itr_post_format_link' ) ) {
    function itr_post_format_link( $content = null, $title = null, $post = null ) {

        if ( ! $content ) {
            $post     = get_post( $post );
            $title    = $post->post_title;
            $content  = $post->post_content;
        }

        $link   = itr_getUrl( $content );

        if( ! empty( $link ) ) {

            $title    = '<a href="'. esc_url( $link ) .'" rel="bookmark">'. $title .'</a>';
            $content  = str_replace( $link, '', $content );

        } else {

            $pattern    = '/^\<a[^>](.*?)>(.*?)<\/a>/i';
            preg_match( $pattern, $content, $link );

            if( ! empty( $link[0] ) && ! empty( $link[2] ) ) {

                $title    = $link[0];
                $content  = str_replace( $link[0], '', $content );

            } elseif( ! empty( $link[0] ) && ! empty( $link[1] ) ) {

                $atts     = shortcode_parse_atts( $link[1] );
                $target = ( ! empty( $atts['target'] ) ) ? $atts['target'] : '_self';
                $title  = ( ! empty( $atts['title'] ) )  ? $atts['title']  : $title;
                $title    = '<a href="'. esc_url( $atts['href'] ) .'" rel="bookmark" target="'. esc_attr($target) .'">'. $title .'</a>';
                $content  = str_replace( $link[0], '', $content );

            } else {
                $title  = '<a href="'. esc_url( get_permalink() ) .'" rel="bookmark">'. $title .'</a>';
            }

        }

        $output['title']   = '<h3 class="itr-post-title">'. $title . '</h3>';
        $output['content'] = $content;

        return $output;

    }
}

if ( ! function_exists( 'itr_post_chat' ) ) {
  function itr_post_chat( $content ) {

    $output = '<ul class="post-chat">';
    $rows   = preg_split( "/(\r?\n)+|(<br\s*\/?>\s*)+/", $content );
    $i      = 0;

    foreach ( $rows as $row ) {

      if ( strpos( $row, ':' ) ) {

        $row_split  = explode( ':', trim( $row ), 2 );
        $author     = strip_tags( trim( $row_split[0] ) );
        $text       = trim( $row_split[1] );

        $output .= '<li class="chat-row row-'. ($i%2 ? 'odd':'even') .'">';
        $output .= '<span class="chat-author '. sanitize_html_class( strtolower( "chat-author-{$author}" ) ) . '"><i class="fa fa-comment"></i> <cite class="auth-name">' . $author . '</cite>' . ':' . '</span>'.$text;
        $output .= '</li>';

        $i++;
      } else {
        $output .= $row;
      }

    }

    $output .= '</ul>';
    return $output;

  }
  add_filter( 'it-post-format-chat', 'itr_post_chat' );
}

if ( ! function_exists( 'itr_media_content' ) ) {
  function itr_media_content( $content ) {

    $media = itr_getUrl( $content );

    if( ! empty( $media ) ){

      $content  = str_replace( $media, '', $content );

    } else {

      $pattern = itr_get_shortcode_regex( itr_wp_tagregexp() );
      preg_match( '/'.$pattern.'/s', $content, $media );
      if ( ! empty( $media[2] ) ) {
        $content = str_replace( $media[0], '', $content );
      }

    }

    return $content;
  }
  add_filter( 'it-post-format-video', 'itr_media_content' );
  add_filter( 'it-post-format-audio', 'itr_media_content' );
}

if ( ! function_exists( 'itr_post_link' ) ) {
    function itr_post_link( $content ){
        $parse_content = itr_post_format_link( $content );
        return $parse_content['content'];
    }
    add_filter( 'it-post-format-link', 'itr_post_link' );
}

if ( ! function_exists( 'itr_post_meta' ) ) {
    function itr_post_meta() {

        global $post;

        echo '<ul class="post-meta">';
        
        if ( itr_theme_option('icon_on') == "1" ){
            echo itr_post_icon();
        }
                
        if( itr_theme_option( 'author_on' ) == '1' ){
            itr_mini_author_meta(); 
        }
        
        if ( itr_theme_option('category_on') == "1" ){
            $categories = get_the_category();
            if ( ! empty( $categories ) ) {
                echo '<li class="meta-cat"><a href="' . esc_url( get_category_link( $categories[0]->term_id ) ) . '">' . esc_html( $categories[0]->name ) . '</a></li>';
            }
        }
        
        $num_comments = get_comments_number();
        if ( itr_theme_option('comment_on') == "1" ) {
                if ( $num_comments == 0 ) {
                    $comments = esc_html__(' 0 Comments', 'munza');
                } elseif ( $num_comments > 1 ) {
                    $comments = $num_comments . esc_html__(' Comments', 'munza');
                } else {
                    $comments = esc_html__(' 1 Comment', 'munza');
                }
                echo '<li><a href="' . get_comments_link() .'">'. $comments.'</a></li>';
        }

        if ( class_exists( 'munza_Core' ) ) {
            echo '<li>'.getPostLikeLink( $post->ID ).'</li>';
        }
        
        echo '</ul>';

    }
}

if ( ! function_exists( 'itr_author_meta' ) ) {
    function itr_author_meta () {
        $auth_id = get_the_author_meta('ID');
        echo '<div class="author_meta_section">';
            echo '<span class="byline author vcard">';
                echo get_avatar( $auth_id, '32', '' );
                echo '<span>'.esc_html__( 'By: ','munza' ).'</span>';
                echo '<a href="'.get_author_posts_url( $auth_id ).'" rel="author">';
                    echo get_the_author();
                echo '</a>';
            echo '</span>';
        echo '</div>';
    }
}

if ( ! function_exists( 'itr_mini_author_meta' ) ) {
    function itr_mini_author_meta () {
        $auth_id = get_the_author_meta('ID');
        echo '<li class="author_meta">';
            echo '<a href="'.get_author_posts_url( $auth_id ).'" rel="author">';
                echo get_the_author();
            echo '</a>';
        echo '</li>';
    }
}

if ( ! function_exists( 'itr_mini_pager' ) ) {
    function itr_mini_pager (){
        
        $itr_min_pag = wp_link_pages( array(
            'before'      => '<div class="sub-pager"><span class="page-links-title">' . esc_html__( 'Pages:', 'munza' ) . '</span>',
            'after'       => '</div>',
            'link_before' => '<span>',
            'link_after'  => '</span>',
        ) );
        
        return $itr_min_pag;
        
    }
}

if ( ! function_exists( 'itr_post_meta_single' ) ) {
    function itr_post_meta_single() {

        global $post;
        
        echo '<ul class="post-meta">';
                    
            if ( itr_theme_option('post_icon_on') == "1" ){
                echo itr_post_icon();
            }
            
            if ( itr_theme_option('singleauthor_on') == "1" ){    
                echo '<li class="meta-user"><a href="'.esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ).'">'.get_the_author().'</a></li>';
            }
            
            $num_comments = get_comments_number();
            if ( itr_theme_option('singlecomment_on') == "1" ) {
                    if ( $num_comments == 0 ) {
                        $comments = esc_html__(' 0 Comments', 'munza');
                    } elseif ( $num_comments > 1 ) {
                        $comments = $num_comments . esc_html__(' Comments', 'munza');
                    } else {
                        $comments = esc_html__(' 1 Comment', 'munza');
                    }
                    echo '<li><a href="' . get_comments_link() .'">'. $comments.'</a></li>';
            }
            
            if ( itr_theme_option('singlelike_on') == "1" && class_exists( 'munza_Core' ) ) {
                echo '<li>';
                    echo getPostLikeLink( $post->ID );
                echo '</li>';
            }
            
            if ( itr_theme_option('singleviews_on') == "1" && class_exists( 'munza_Core' ) ){   
                echo '<li>';
                    echo munza_get_post_views($post->ID);
                echo '</li>';
            }
            
            if ( current_user_can('editor') || current_user_can('administrator') ) {
                echo '<li class="entry-edit-link"><a href="'.get_edit_post_link( $post->ID ).'">'.esc_html__('Edit','munza').'</a></li>';
            }
     
        echo '</ul>';
            

    }
}

if ( ! function_exists( 'itr_single_cats' ) ) {
    function itr_single_cats () {
        if ( itr_theme_option('singlecategory_on') == "1" ){
            if ( in_array( 'category', get_object_taxonomies( get_post_type() ) ) ) {
                echo '<div class="itr-single-cats">' . get_the_category_list() . '</div>';
            }
        }
    }
}

if ( ! function_exists( 'itr_single_title' ) ) {
    function itr_single_title () {
        if ( itr_theme_option('singledate_on') == "1" ){
            echo '<div class="meta_date">'.esc_html(get_the_date()).'</div>';
        }
        if ( itr_theme_option('singletitle_on') == "1" ) {
            if( get_post_format() == 'link' ){
                echo itr_in_title();
            }else{
                ?>
                <h2 class="itr-single-title"><?php the_title(); ?></h2><?php
            }
        }
    }
}

if ( ! function_exists( 'itr_single_sticky' ) ) {
    function itr_single_sticky () {
        if ( is_sticky() ) {
            echo '<span class="post-sticky main-bg" title="' . esc_html__( 'Featured', 'munza' ) . '"><i class="outlinefont-Asset-1252"></i></span>';
        }
    }
}

if ( ! function_exists( 'itr_single_media' ) ) {
    function itr_single_media () {
        global $post;
        if ( itr_theme_option('singlepostimg_on') == "1" ) {
            if ( get_post_format() == 'gallery' || get_post_format() == 'video' || get_post_format() == 'audio' ) {
                
                echo '<div class="itr-single-media">' . itr_post_media( get_the_content() ) . '</div>';
                
            } else if ( get_post_format() == 'image' ) {
                if( has_post_thumbnail()){
                    '<div class="itr-single-img">' . itr_post_thumbnail() . '</div>';
                } else {
                    echo '<div class="itr-single-img">' . itr_post_image(get_the_content()) . '</div>';
                }
            } else {
                echo '<div class="itr-single-img">' . get_the_post_thumbnail( $post->ID,'full') . '</div>';
            }
        }
    }
}

if ( ! function_exists( 'itr_single_author_box' ) ) {
    function itr_single_author_box(){
        global $post,$wp_query;
        $curauth = $wp_query->get_queried_object();
        $first_name = get_the_author_meta( 'first_name', $post->post_author );
        $last_name = get_the_author_meta( 'last_name', $post->post_author );
        if ( ! empty( $first_name ) || ! empty( $last_name ) ){
            $display_name = $first_name . ' ' . $last_name;    
        }else{
            $display_name = get_the_author_meta( 'display_name', $post->post_author );
        }

        $user_description = get_the_author_meta( 'user_description', $post->post_author );
        $user_url = get_author_posts_url( get_the_author_meta( 'ID' ) );
        
        if ( itr_theme_option('singleauthorbox_on') == "1" && $user_description !='' ) {
            echo '<div class="itr-post-block author-info">';
                echo '<div class="author-avatar">';
                    echo '<a href="'.esc_url($user_url).'" rel="author">';
                        echo get_avatar( get_the_author_meta('user_email') , 100 );
                    echo '</a>';
                echo '</div>';
                echo '<div class="author-description">';
                    echo '<h5 class="author-name"><a href="'.esc_url($user_url).'" rel="author">'.esc_html($display_name).'</a></h5>';
                    echo esc_html($user_description);
                echo '</div>';
            echo '</div>';
        }
    }
}

if ( ! function_exists( 'itr_author_widget' ) ) {
    function itr_author_widget(){
        global $post,$wp_query;
        $curauth = $wp_query->get_queried_object();
        $first_name = get_the_author_meta( 'first_name', $post->post_author );
        $last_name = get_the_author_meta( 'last_name', $post->post_author );
        if ( ! empty( $first_name ) || ! empty( $last_name ) ){
            $display_name = $first_name . ' ' . $last_name;    
        }else{
            $display_name = get_the_author_meta( 'display_name', $post->post_author );
        }

        $user_description = get_the_author_meta( 'user_description', $post->post_author );
        $user_url = get_author_posts_url( get_the_author_meta( 'ID' ) );
        
        echo '<div class="itr_author_info">';
            echo '<div class="author-avatar">';
                echo '<a href="'.esc_url($user_url).'" rel="author">';
                    echo get_avatar( get_the_author_meta('user_email') , 100 );
                echo '</a>';
            echo '</div>';
            echo '<h5 class="author-name"><a href="'.esc_url($user_url).'" rel="author">'.esc_html($display_name).'</a></h5>';
            echo '<div class="author-description">';
                echo esc_html($user_description);
            echo '</div>';
        echo '</div>';
    }
}

if ( ! function_exists( 'itr_single_prevnext' ) ) {
    function itr_single_prevnext(){
        
        if ( itr_theme_option('singleprevnext_on') == "1" ) {
            
            if (get_next_post() || get_previous_post()) {
            
                echo '<div class="itr-post-block nav-single">';
                    if (get_previous_post()){
                        echo '<div class="nav-previous">'.get_previous_post_link( '%link', '<span class="meta-nav"><i class="fa fa-long-arrow-left"></i>' . esc_html__( 'Previous post', 'munza' ) . ' </span>
                        <span class="nav-block main-color">%title</span>' ).'</div>';    
                    }
                    
                    echo '<a href="'.esc_attr(get_permalink( get_option( 'page_for_posts' ) )).'" class="nav-blog main-color"><i class="stline-navigation-menu-3"></i></a>';
                    
                    if (get_next_post()){
                        echo '<div class="nav-next text-right">'.get_next_post_link( '%link', '<span class="meta-nav">' . esc_html__( 'Next post', 'munza' ) . ' <i class="fa fa-long-arrow-right"></i></span>
                        <span class="nav-block main-color">%title</span>' ).'</div>';    
                    }
                    
                echo '</div>';
            
            }
            
        }
    }
}

if ( ! function_exists( 'itr_single_tags' ) ) {
    function itr_single_tags(){
        if ( itr_theme_option('singletags_on') == "1" ) {
            if ( get_the_tags() ){ ?>
                <div class="itr-post-block itr-single-tags">
                    <?php the_tags('', ', ', ''); ?>
                </div>
            <?php }
        }
    }
}

if ( ! function_exists( 'itr_single_content' ) ) {
    function itr_single_content(){
        if ( itr_theme_option('singlecontent_on') == "1" ) {
            if ( ! is_single() && ( is_search() || has_excerpt() ) ) { ?>
                
                <div class="entry-summary"><?php the_excerpt(); ?></div>
                
            <?php } else { ?>
            
                <div class="itr-single-content"><?php the_content(); ?></div>
                
            <?php }
        }
    }
}

if ( ! function_exists( 'itr_single_share' ) ) {
    function itr_single_share(){
        $pg_type = 'single';
        if ( class_exists( 'munza_Core' ) ) {
            echo itr_blog_share($pg_type);
        }
    }
}

if ( ! function_exists( 'itr_gallery_slideshow' ) ) {
    function itr_gallery_slideshow(){
        if ( ! isset( get_current_screen()->id ) || get_current_screen()->base != 'post' ) return;
        echo '<div id="tmpl-custom-gallery-setting" class="hidden">';
            echo '<label class="setting">';
                echo '<span>'.esc_html__('SlideShow ?', 'munza').'</span>';
                echo '<select name="slideshow" data-setting="slideshow">';
                    echo '<option value="no">'.esc_html__('No', 'munza').'</option>';
                    echo '<option value="yes">'.esc_html__('Yes', 'munza').'</option>';
                echo '</select>';
            echo '</label>';
        echo '</div>';
    } 
    add_action('print_media_templates', 'itr_gallery_slideshow');  
}

if ( ! function_exists( 'itr_move_pagination' ) ){
    function itr_move_pagination( $content ) {
        if ( is_single() ) {
            $pagination = wp_link_pages( array(
                'before'      => '<div class="sub-pager"><span class="page-links-title">' . esc_html__( 'Pages:', 'munza' ) . '</span>',
                'after'       => '</div>',
                'link_before' => '<span>',
                'link_after'  => '</span>',
                'echo'        => 0,
            ) );
            $content .= $pagination;
            return $content;
        }
        return $content;
    }
    add_filter( 'the_content', 'itr_move_pagination', 1 );    
}

if ( ! function_exists( 'itr_custom_gallery' ) ) {
    function itr_custom_gallery($output, $attr) {
        global $post;
        static $instance = 0;
        $instance++;
        if ( isset( $attr['orderby'] ) ) {
            $attr['orderby'] = sanitize_sql_orderby( $attr['orderby'] );
            if ( !$attr['orderby'] )
                unset( $attr['orderby'] );
        }
        extract(shortcode_atts(array(
            'order'      => 'ASC',
            'orderby'    => 'menu_order ID',
            'id'         => $post->ID,
            'itemtag'    => 'figure',
            'icontag'    => 'p',
            'captiontag' => 'span',
            'columns'    => 3,
            'slideshow'  => 'no',
            'size'       => 'thumbnail',
            'include'    => '',
            'exclude'    => ''
        ), $attr));

        $id = intval($id);
        if ( 'RAND' == $order )
            $orderby = 'none';

        if ( !empty($include) ) {
            $include = preg_replace( '/[^0-9,]+/', '', $include );
            $_attachments = get_posts( array('include' => $include, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );

            $attachments = array();
            foreach ( $_attachments as $key => $val ) {
                $attachments[$val->ID] = $_attachments[$key];
            }
        } elseif ( !empty($exclude) ) {
            $exclude = preg_replace( '/[^0-9,]+/', '', $exclude );
            $attachments = get_children( array('post_parent' => $id, 'exclude' => $exclude, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
        } else {
            $attachments = get_children( array('post_parent' => $id, 'post_status' => 'inherit', 'post_type' => 'attachment', 'post_mime_type' => 'image', 'order' => $order, 'orderby' => $orderby) );
        }

        if ( empty($attachments) )
            return '';

        if ( is_feed() ) {
            $output = "\n";
            foreach ( $attachments as $att_id => $attachment )
                $output .= wp_get_attachment_link($att_id, $size, true) . "\n";
            return $output;
        }

        $itemtag = tag_escape($itemtag);
        $captiontag = tag_escape($captiontag);
        $columns = intval($columns);
        $itemwidth = $columns > 0 ? floor(100/$columns) : 100;
        $float = is_rtl() ? 'right' : 'left';

        $selector = "gallery-{$instance}";

        $gallery_style = $gallery_div = '';

        $size_class = sanitize_html_class( $size );
        $class = "gallery galleryid-{$id} gallery-columns-{$columns} gallery-size-{$size_class}";
        $class .= ( $slideshow == 'yes' ) ? ' itr-post-gallery' : ""; 
        $gallery_div = "<div id='$selector' class='".$class."'>";
        $output = apply_filters( 'gallery_style', $gallery_style . "\n\t\t" . $gallery_div );

        $i = 0;
        foreach ( $attachments as $id => $attachment ) {
            $link = isset($attr['link']) && 'file' == $attr['link'] ? wp_get_attachment_link($id, $size, false, false) : wp_get_attachment_link($id, $size, true, false);

            $output .= "<{$itemtag} class='gallery-item'>";
            $output .= "
                <{$icontag} class='gallery-icon'>
                    $link
                </{$icontag}>";
                if ( $captiontag && trim($attachment->post_excerpt) ) {
                    $output .= "
                        <{$captiontag} class='wp-caption-text gallery-caption'>
                        " . wptexturize($attachment->post_excerpt) . "
                        </{$captiontag}>";
                }
            $output .= "</{$itemtag}>";
        }

        $output .= "</div>\n";
        return $output;
    }
    add_filter("post_gallery", "itr_custom_gallery",10,2);
}

add_filter('use_default_gallery_style','__return_false');
