<?php
/**
 *
 * IT-RAYS Framework
 *
 * @author IT-RAYS
 * @license Commercial License
 * @link http://www.it-rays.net
 * @copyright 2017 IT-RAYS Themes
 * @package ITFramework
 * @version 1.0.0
 *
 */
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );
 
if ( ! function_exists('itr_theme_sidebars') ){
    function itr_theme_sidebars(){
        
        $foot_top_cols = itr_theme_option('foot_top_widg_cols');
        $foot_mid_cols = itr_theme_option('foot_mid_widg_cols');
        $foot_bot_cols = itr_theme_option('foot_bot_widg_cols');
        
        register_sidebar(array(
            'name'          => esc_html__( "Primary SideBar", "munza" ),
            'id'            => 'sidebar-1',
            'before_widget' => '<div class="widget %2$s">',
            'after_widget'  => '</div>',
        ));
        
        register_sidebar(array(
            'name'          => esc_html__( "Secondary SideBar", "munza" ),
            'id'            => 'sidebar-2',
            'before_widget' => '<div class="widget %2$s">',
            'after_widget'  => '</div>',
        ));
        
        /***** Footer Widgets *****/
        register_sidebar( array(
            'name'          => esc_html__( "Middle Footer Widgets", "munza" ),
            'id'            => 'midle-footer-widgets',
            'before_widget' => '<div class="widget %2$s col-md-'.$foot_mid_cols.'">',
            'after_widget'  => '</div>',
            'description'   => esc_html__( "Appears in the middle footer area", "munza" ),
        ));
        
        register_sidebar( array(
            'name'          => esc_html__( "Footer Bottom Widgets", "munza" ),
            'id'            => 'footer-bottom-widgets',
            'before_widget' => '<div class="widget %2$s col-md-'.$foot_bot_cols.'">',
            'after_widget'  => '</div>',
            'description'   => esc_html__( "Appears in the footer bottom bar", "munza" ),
        ));        
        
        /****************** Custom side bar *************************/
        $sbs = itr_theme_option('sidebars');
        for ( $i = 1; $i <= $sbs ; $i++ ) { 
            $sidb = itr_theme_option('sidebar_'.$i);
            register_sidebar(array(
                'name'          => $sidb,
                'id'            => 'side-'.$i,
                'before_widget' => '<div class="widget %2$s">',
                'after_widget'  => '</div>',
            ));
        }
    }
}
add_action( 'widgets_init', 'itr_theme_sidebars', 11 );
