<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

class itr_menu_walker extends Walker_Nav_Menu{
      
    function start_el(&$output, $item, $depth = 0, $args = array(), $id = 0){
        
        $prepend = $append = $class_names = $item_output = '';
        
        $m_ico          = get_post_meta(itr_page_ID(), 'meta_header_icons',true);
        $m_sico         = get_post_meta(itr_page_ID(),'meta_header_sub_icons',true);
        $m_title        = get_post_meta(itr_page_ID(),'meta_header_subtitle',true);
        $icon           = get_post_meta($item->ID, 'menu-item-icon',true);
        $hint           = get_post_meta($item->ID, 'menu-item-hint',true);
        $hid_title      = get_post_meta($item->ID, 'menu-item-hide_title',true);
        $hint_type      = get_post_meta($item->ID, 'menu-item-hint_type',true);
        $megamenu       = get_post_meta($item->ID, 'menu-item-megamenu',true);
        $innermenu      = get_post_meta($item->ID, 'menu-item-inner_mega',true);
        $column         = get_post_meta($item->ID, 'menu-item-column',true); 
        $bg             = get_post_meta($item->ID, 'menu-item-background',true);
        $bgrepeat       = get_post_meta($item->ID, 'menu-item-bgrepeat',true);
        $bgsize         = get_post_meta($item->ID, 'menu-item-bgsize',true);
        $bgposition     = get_post_meta($item->ID, 'menu-item-bgposition',true);
        $meta_header    = get_post_meta(itr_page_ID(), 'meta_header_style',true);
        $onlyicon       = get_post_meta($item->ID, 'menu-item-onlyicon',true); 
        $theme_header   = itr_theme_option('header_style');
        $t_ico          = itr_theme_option( 'header-icons' ); 
        $t_sico         = itr_theme_option( 'header-sub-icons' );
        $t_title        = itr_theme_option( 'header-subtitle' );
        $men_anim       = itr_theme_option( 'menu-anim' );
        $itr_fullscreen = get_post_meta( itr_page_ID() , 'meta_fullscreen_onepage' , true);
        $head_style     = ($meta_header == '' ? $theme_header : $meta_header);
        $col_mega       = ($megamenu == 1 ) ? ' data-mega="'.(12/$column).'"' : "";
        $indent         = ( $depth ) ? str_repeat( "\t", $depth ) : '';
        $classes        = empty( $item->classes ) ? array() : (array) $item->classes;        
        
        $class          = join( ' ', apply_filters( 'nav_menu_css_class', array_filter( $classes ), $item ) );
        $class          .= ( $megamenu == 1 && $depth == 0 ) ? ' mega-menu' : "";
        $class          .= ( isset( $item->nav_label ) && ( $item->nav_label == 1 ) );
        $class          .= ( $hid_title != 0 && $depth != 0 ) ? ' hiddenChild' : '';          
                                
        $class_names     = ' class="'. $class .'"';  
        $txt             = $args->link_before .$prepend.apply_filters( 'the_title', $item->title, $item->ID ).$append;
        $menu_att        = ( $itr_fullscreen == 1 ) ? ' data-menuanchor="'.ltrim($item->url, '#').'"' : '';
        $output         .= $indent . '<li id="menu-item-'. $item->ID . '"' . $class_names . $col_mega . $menu_att .'>';
        $attributes      = ! empty( $item->target )   ? ' target="' . esc_attr( $item->target     ) .'"' : '';
        $attributes     .= ! empty( $item->xfn )     ? ' rel="'    . esc_attr( $item->xfn        ) .'"' : '';
        $attributes     .= ! empty( $item->url )     ? ' href="'   . esc_url( $item->url        ) .'"'  : '';
        $description     = ! empty( $item->description ) ? '<b class="description">'.esc_attr( $item->description ).'</b>' : '';
        $item_output    .= $args->before;
        
        if( $depth == 0 ){
        
            $item_output .= '<a '. $attributes .'>';
                            
                if( $onlyicon == '' ){
                    if( $men_anim != '' ){
                        $item_output .= '<span>';
                            
                            if($m_ico == '1' || ($t_ico == 1 && $m_ico == '')){
                                $item_output .= ($icon != '') ? '<i class="itr_nav_icon '.$icon.'"></i>' : "";
                            }
                            
                            $item_output .= '<span data-hover="'.$txt.'">';
                                $item_output .= $txt;
                            $item_output .= '</span>';
                           
                        $item_output .= '</span>';    
                    } else {
                        $item_output .= $txt;
                    }
                        
                }                
                  
                
                $item_output .= $description.$args->link_after;
                
                if($m_title == '1' || ($t_title == 1 && $m_title == '')){
                    $item_output .= ($item->attr_title != '') ? '<b class="description">'.esc_attr( $item->attr_title ).'</b>' : '';
                }
                
                $item_output .= (! empty ($hint)) ? '<b class="menu-hint '. $hint_type .'">'. $hint .'</b>' : '';
            
            $item_output .= '</a>';            
        
        } else {
            
            $item_output .= '<a '. $attributes .'>';
            
                if($m_sico == '1' || ($t_sico == 1 && $m_sico == '')){
                    $item_output .= ($icon != '') ? '<i class="itr_nav_icon '.$icon.'"></i>' : "";
                }    
                        
                $item_output .= $args->link_before .$prepend.apply_filters( 'the_title', $item->title, $item->ID ).$append;
                $item_output .= $description.$args->link_after;
                
                $item_output .= (! empty ($hint)) ? '<b class="menu-hint '. $hint_type .'">'. $hint .'</b>' : '';
                
                if($m_title == '1' || ($t_title == 1 && $m_title == '')){
                    $item_output .= ($item->attr_title != '') ? '<b class="description">'.esc_attr( $item->attr_title ).'</b>' : '';
                }
            
            $item_output .= '</a>'; 
                   
             
        }
        
        $item_output .= ( $innermenu ) ? $this->itr_get_dynamic_sidebar( $innermenu ): "";
        
        $item_output .= $args->after;
        $output .= apply_filters( 'walker_nav_menu_start_el', $item_output, $item, $depth, $args );
        
        if ( $bg != '' ) {
            $men_itm_id = preg_replace( '/[^\d]/', '', $bg );
            $men_itm_src = wp_get_attachment_image_src( $men_itm_id,'full' );
            $menCSS = '';
            if ($megamenu == 1 && $depth == 0 ) {
                $menCSS .= "#menu-item-{$item->ID} > .mega-content{ ";
            } else {
                $menCSS .= "#menu-item-{$item->ID} > ul.sub-menu{ ";
            }
             $menCSS .= "background-image: url('".($men_itm_src[0])."');";
                  
             $menCSS .= ( $bgrepeat != '' ) ? "background-repeat: ".$bgrepeat.";" : "";
             $menCSS .= ( $bgsize != '' ) ? "background-size: ".$bgsize.";" : "";
             $menCSS .= ( $bgposition != '' ) ? "background-position: ".$bgposition.";" : "";
             $menCSS .= "}";
            
            itr_add_menu_bg($menCSS);    
        }
        
 
    }
    
    function itr_get_dynamic_sidebar($index) {
        $sidebar_contents = "";
        ob_start();
        dynamic_sidebar($index);
        $sidebar_contents = ob_get_clean();
        return $sidebar_contents;
    }
    
}