<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

class itr_custom_menu {

	protected static $fields = array();

	public static function init() {
		add_action( 'wp_nav_menu_item_custom_fields', array( __CLASS__, 'itr_add_menu_fields' ), 10, 4 );
		add_action( 'wp_update_nav_menu_item', array( __CLASS__, 'itr_save_menu_items' ), 10, 3 );
		add_filter( 'manage_nav-menus_columns', array( __CLASS__, 'itr_menu_columns' ), 99 );

        self::$fields = array(
            'megamenu'      => esc_html__( 'Megamenu' , 'munza' ),
            'column'        => esc_html__( 'Column' , 'munza' ),
            'background'    => esc_html__( 'Background' , 'munza' ),
            'bgrepeat'      => esc_html__( 'Background Repeat' , 'munza' ),
            'bgsize'        => esc_html__( 'Background Size' , 'munza' ),
            'bgposition'    => esc_html__( 'Background Position' , 'munza' ),
            'inner_mega'    => esc_html__( 'Add Widget', 'munza' ),
            'hide_title'    => esc_html__( 'Hide Menu Label', 'munza' ),
            'icon'          => esc_html__( 'Icon' , 'munza' ),
            'onlyicon'      => esc_html__( 'Show Icon Only' , 'munza' ),
            'hint'          => esc_html__( 'Hint' , 'munza' ),
            'hint_type'     => esc_html__( 'Hint Type', 'munza' ),
        );        
	}

	public static function itr_add_menu_fields( $id, $item, $depth = 0, $args ) {
        
        foreach ( self::$fields as $_key => $label ) {
			$key   = sprintf( 'menu-item-%s', $_key );
			$id    = sprintf( 'edit-%s-%s', $key, $item->ID );
			$name  = sprintf( '%s[%s]', $key, $item->ID );
			$value = get_post_meta( $item->ID, $key, true );
			$class = sprintf( 'field-%s', $_key );
            global $wp_registered_sidebars;
            
            switch ( $_key ) {
                
                case 'icon':
                ?>
                <div class="m-sep-block">
                    <p class="field-custom description description-wide <?php echo esc_attr( $class ) ?>">
                        <i class="<?php echo esc_attr( $item->icon ); ?> ico"></i>
                        <a class="button button-primary btn_icon" href="#"><i class="stline-add"></i><?php echo esc_html__('Add Icon','munza') ?></a>
                        <input type="hidden" name="<?php echo esc_attr($name); ?>" id="<?php echo esc_attr($id); ?>" class="icon_cust" value="<?php echo esc_attr($value); ?>" />
                        <a class="button icon-remove"><i class="stline-close"></i></a> 
                    </p>
                </div>
                <?php    
                break;
                
                case 'megamenu':
                $mg = $value ? $value : "0";
                ?>
                <div class="m-sep-block mega-menu-block">
                    <p class="field-custom description description-thin mega-choose <?php echo esc_attr( $class ) ?>">
                        <span class="block"><?php echo esc_html__( 'Mega Menu', 'munza' ); ?> </span>
                        <input type="hidden" id="<?php echo esc_attr($id); ?>" class="checktxt hid-vl-chk" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr($mg); ?>" />
                        <span class="it_bx custom-checkbox"><span class="switcher"></span></span>
                    </p>
                <?php    
                break;
                
                case 'onlyicon':
                $ic = $value ? $value : "0";
                ?>
                <div class="m-sep-block">
                    <p class="field-custom description description-thin<?php echo esc_attr( $class ) ?>">
                        <span class="block"><?php echo esc_html__( 'Show Icon Only', 'munza' ); ?> </span>
                        <input type="hidden" id="<?php echo esc_attr($id); ?>" class="checktxt" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr($ic); ?>" />
                        <span class="it_bx custom-checkbox"><span class="switcher"></span></span>
                    </p>
                <?php    
                break;
                
                case 'column':
                $co = $value ? $value : "3";
                ?>
                    <p class="field-custom description description-thin column-choose <?php echo esc_attr( $class ) ?>">
                        <span class="block"><?php echo esc_html__( 'Columns', 'munza' ); ?> </span>
                        <select>
                            <option value="1">1 Column</option>
                            <option value="2">2 Columns</option>
                            <option value="3">3 Columns</option>
                            <option value="4">4 Columns</option>
                            <option value="6">6 Columns</option>
                            <option value="12">12 Columns</option>
                        </select>
                        <input type="hidden" name="<?php echo esc_attr($name); ?>" id="<?php echo esc_attr($id); ?>" class="hid-vl" value="<?php echo esc_attr($co); ?>" />
                    </p>
                </div>
                <?php    
                break;
                
                case 'background':
                    if ($depth == 0 ){
                        ?>
                        <p class="field-custom description description-wide <?php echo esc_attr( $class ) ?>">
                            <label class="block"><?php echo esc_html__( 'Background Image', 'munza' ); ?> </label>
                            <input class="regular-text custom-up hidden" id="<?php echo esc_attr($id); ?>" type="text" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr( $value ); ?>" />
                            <a class="upload_image_button" href="#"></a>
                            <span class="clear-img"><img class="logo-im" alt="<?php echo esc_attr(esc_html__('Upload', 'munza')); ?>" src="<?php echo esc_url( wp_get_attachment_url( $value ) ); ?>" />
                            <a class="remove-img" href="#" title="<?php echo esc_attr(esc_html__('Remove Image', 'munza')); ?>"></a></span>                            
                        </p>
                        <?php
                    }
                    
                break;
                
                case 'bgrepeat':
                ?>
                <p class="field-custom description description-thin <?php echo esc_attr( $class ) ?>">
                    <span class="block"><?php echo esc_html__( 'Background Repeat', 'munza' ); ?> </span>
                    <select>
                        <option value="">Repeat</option>
                        <option value="no-repeat">No Repeat</option>
                        <option value="repeat-x">Repeat X</option>
                        <option value="repeat-y">Repeat Y</option>
                    </select>
                    <input type="hidden" name="<?php echo esc_attr($name); ?>" id="<?php echo esc_attr($id); ?>" class="hid-vl" value="<?php echo esc_attr($value); ?>" />
                </p>
                <?php    
                break;
                
                case 'bgsize':
                ?>
                <p class="field-custom description description-thin <?php echo esc_attr( $class ) ?>">
                    <span class="block"><?php echo esc_html__( 'Background Size', 'munza' ); ?> </span>
                    <select>
                        <option value="inherit">Inherit</option>
                        <option value="cover">Cover</option>
                        <option value="contain">Contain</option>
                        <option value="100% 100%">100%</option>
                    </select>
                    <input type="hidden" name="<?php echo esc_attr($name); ?>" id="<?php echo esc_attr($id); ?>" class="hid-vl" value="<?php echo esc_attr($value); ?>" />
                </p>
                <?php    
                break;
                
                case 'bgposition':
                ?>
                <p class="field-custom description description-thin <?php echo esc_attr( $class ) ?>">
                    <span class="block"><?php echo esc_html__( 'Background Position', 'munza' ); ?> </span>
                    <select>
                        <option value="">Left Top</option>
                        <option value="0% 50%">Left Center</option>
                        <option value="0% 100%">Left Bottom</option>
                        <option value="100% 0%">Right Top</option>
                        <option value="100% 50%">Right Center</option>
                        <option value="100% 100%">Right Bottom</option>
                        <option value="50% 0%">Center Top</option>
                        <option value="50% 50%">Center Center</option>
                        <option value="50% 100%">Center Bottom</option>
                    </select>
                    <input type="hidden" name="<?php echo esc_attr($name); ?>" id="<?php echo esc_attr($id); ?>" class="hid-vl" value="<?php echo esc_attr($value); ?>" />
                </p>
                <?php    
                break;
                
                case 'hint':
                ?>
                <div class="m-sep-block">
                <p class="field-custom description description-thin <?php echo esc_attr( $class ) ?>">
                    <span class="block"><?php echo esc_html__( 'Hint', 'munza' ); ?> </span>
                    <input type="text" id="<?php echo esc_attr($id); ?>" class="widefat edit-menu-item-hint" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr($value); ?>" />
                </p>
                <?php    
                break;

                case 'hint_type':
                $ht = $value ? $value : "default";
                ?>
                <p class="field-custom description description-thin <?php echo esc_attr( $class ) ?>">
                    <span class="block"><?php echo esc_html__( 'Hint Type', 'munza' ); ?> </span>
                    <select>
                        <option value="default">Default</option>
                        <option value="info">Info</option>
                        <option value="success">Success</option>
                        <option value="warning">Warning</option>
                        <option value="error">Error</option>
                    </select>
                    <input type="hidden" name="<?php echo esc_attr($name); ?>" id="<?php echo esc_attr($id); ?>" class="hid-vl" value="<?php echo esc_attr($ht); ?>" />
                </p>
                </div>
                <?php    
                break;
                
                case 'inner_mega':
                    if ($depth != 0 ){
                        $wd = $value ? $value : "";
                        ?>
                        <div class="m-sep-block">
                            <p class="field-custom description description-wide column-widget <?php echo esc_attr( $class ) ?>">
                                <span class="block"><?php echo esc_html__( 'Add Widget', 'munza' ); ?> </span>
                                <select>
                                    <option value=""><?php echo esc_html__('-- Select Widget Area --', 'munza') ?></option>
                                    <?php
                                    foreach($wp_registered_sidebars as $sidebar_id => $sidebar){
                                        ?>
                                        <option value="<?php echo esc_attr($sidebar_id) ?>"><?php echo esc_html($sidebar['name']) ?></option>
                                        <?php
                                    }    
                                    ?>
                                </select>
                                <input type="hidden" name="<?php echo esc_attr($name); ?>" id="<?php echo esc_attr($id); ?>" class="hid-widget" value="<?php echo esc_attr($wd); ?>" />
                            </p>
                        </div>
                    <?php 
                    }   
                break;
                
                case 'hide_title':
                    if ($depth != 0 ){
                        $htl = $value ? $value : "0";
                        ?>
                        <div class="m-sep-block hide-lbl-block">
                            <p class="field-custom description description-thin hide-lbl <?php echo esc_attr( $class ) ?>">
                                <span class="block"><?php echo esc_html__( 'Hide Menu Label', 'munza' ); ?> </span>
                                <input type="hidden" id="<?php echo esc_attr($id); ?>" class="checktxt hid-lbl" name="<?php echo esc_attr($name); ?>" value="<?php echo esc_attr($htl); ?>" />
                                <span class="it_bx custom-checkbox"><span class="switcher"></span></span>
                            </p>  
                        </div>
                        <?php
                    }    
                break;
                
            } 
            
        }
	}
    
    public static function itr_save_menu_items( $menu_id, $menu_item_db_id, $menu_item_args ) {
        if ( defined( 'DOING_AJAX' ) && DOING_AJAX ) {
            return;
        }

        foreach ( self::$fields as $_key => $label ) {
            $key = sprintf( 'menu-item-%s', $_key );

            // Sanitize
            if ( ! empty( $_POST[ $key ][ $menu_item_db_id ] ) ) {
                // Do some checks here...
                $value = $_POST[ $key ][ $menu_item_db_id ];
            }
            else {
                $value = null;
            }

            // Update
            if ( ! is_null( $value ) ) {
                update_post_meta( $menu_item_db_id, $key, $value );
            }
            else {
                delete_post_meta( $menu_item_db_id, $key );
            }
        }
    }
    
	public static function itr_menu_columns( $columns ) {
		$columns = array_merge( $columns, self::$fields );

		return $columns;
	}
    
    public function itr_nav_menu( $args = array() ) {
        static $menu_id_slugs = array();
        $walker = new itr_menu_walker();
        $defaults = array( 'menu' => '', 'container' => '', 'container_class' => '', 'container_id' => '', 'menu_class' => '', 'menu_id' => '',
        'echo' => true, 'fallback_cb' => 'wp_page_menu', 'before' => '', 'after' => '', 'link_before' => '', 'link_after' => '', 'items_wrap' => '<ul id="%1$s" class="%2$s">%3$s</ul>',
        'depth' => 0, 'walker' => $walker, 'theme_location' => 'primary' );
        
        $header_style       = get_post_meta(itr_page_ID(), 'meta_header_style',true);
        $itr_menu_color    = get_post_meta( itr_page_ID() , 'meta_sub_menu_color' , true); 
        $men                = itr_theme_option('header_style');
        $men_anim           = itr_theme_option( 'menu-anim' );
        $menu_color         = itr_theme_option("sub_menu_color");
        
        $args = wp_parse_args( $args, $defaults );
        $args = apply_filters( 'wp_nav_menu_args', $args );
        $args = (object) $args;

        $menu = wp_get_nav_menu_object( $args->menu );

        if ( ! $menu && $args->theme_location && ( $locations = get_nav_menu_locations() ) && isset( $locations[ $args->theme_location ] ) )
            $menu = wp_get_nav_menu_object( $locations[ $args->theme_location ] );

        if ( ! $menu && !$args->theme_location ) {
            $menus = wp_get_nav_menus();
            foreach ( $menus as $menu_maybe ) {
                if ( $menu_items = wp_get_nav_menu_items( $menu_maybe->term_id, array( 'update_post_term_cache' => false ) ) ) {
                    $menu = $menu_maybe;
                    break;
                }
            }
        }

        if ( $menu && ! is_wp_error($menu) && !isset($menu_items) ) $menu_items = wp_get_nav_menu_items( $menu->term_id, array( 'update_post_term_cache' => false ) );
        if ( ( !$menu || is_wp_error($menu) || ( isset($menu_items) && empty($menu_items) && !$args->theme_location ) )
            && $args->fallback_cb && is_callable( $args->fallback_cb ) )
                return call_user_func( $args->fallback_cb, (array) $args );
        if ( ! $menu || is_wp_error( $menu ) ) return false;

        $items = '';
        
        $navclass = 'itr_main_nav';
                
        $navclass .= ( $men_anim != '' ) ? ' anim_hover' : '';
        
        if ($itr_menu_color != '' ){
            $navclass .= ($itr_menu_color != '') ? ' '.$itr_menu_color : "";
        }else if( $menu_color != '' ) {
            $navclass .= ( $menu_color != '' ) ? ' '.$menu_color : "";
        }
        
        $nav_menu = '<nav class="'.$navclass.'">';
        
        $show_container = false;
        if ( $args->container ) {
            $allowed_tags = apply_filters( 'wp_nav_menu_container_allowedtags', array( 'div', 'nav' ) );
            if ( in_array( $args->container, $allowed_tags ) ) {
                $show_container = true;
                $class = $args->container_class ? ' class="' . esc_attr( $args->container_class ) . '"' : ' class="menu-'. $menu->slug .'-container"';
                $id = $args->container_id ? ' id="' . esc_attr( $args->container_id ) . '"' : '';
                $nav_menu .= '<'. $args->container . $id . $class . '>';
            }
        }

        _wp_menu_item_classes_by_context( $menu_items );

        $sorted_menu_items = $menu_items_with_children = array();
        foreach ( (array) $menu_items as $menu_item ) {
            $sorted_menu_items[ $menu_item->menu_order ] = $menu_item;
            if ( $menu_item->menu_item_parent ) $menu_items_with_children[ $menu_item->menu_item_parent ] = true;
        }

        if ( $menu_items_with_children ) {
            foreach ( $sorted_menu_items as &$menu_item ) {
                if ( isset( $menu_items_with_children[ $menu_item->ID ] ) )
                    $menu_item->classes[] = 'hasChildren';
            }
        }

        unset( $menu_items, $menu_item );
        $sorted_menu_items = apply_filters( 'wp_nav_menu_objects', $sorted_menu_items, $args );
        $items .= walk_nav_menu_tree( $sorted_menu_items, $args->depth, $args );
        unset($sorted_menu_items);
        if ( ! empty( $args->menu_id ) ) {
            $wrap_id = $args->menu_id;
        } else {
            $wrap_id = 'menu-' . $menu->slug;
            while ( in_array( $wrap_id, $menu_id_slugs ) ) {
                if ( preg_match( '#-(\d+)$#', $wrap_id, $matches ) )
                    $wrap_id = preg_replace('#-(\d+)$#', '-' . ++$matches[1], $wrap_id );
                else
                    $wrap_id = $wrap_id . '-1';
            }
        }
        $menu_id_slugs[] = $wrap_id;
        $wrap_class = $args->menu_class ? $args->menu_class.' it-menu' : '';
        $items = apply_filters( 'wp_nav_menu_items', $items, $args );
        $items = apply_filters( "wp_nav_menu_{$menu->slug}_items", $items, $args );
        if ( empty( $items ) ) return false;
        $nav_menu .= sprintf( $args->items_wrap, esc_attr( $wrap_id ), esc_attr( $wrap_class ), $items );
        unset( $items );
        if ( $show_container ) $nav_menu .= '</' . $args->container . '>';
        $nav_menu .= '</nav>';
        $nav_menu = apply_filters( 'wp_nav_menu', $nav_menu, $args );
        if ( $args->echo ) echo apply_filters( 'wp_nav_menu', $nav_menu, $args );
        else
            return $nav_menu;
    }
    
}

itr_custom_menu::init();