<?php
/**
 *
 * IT-RAYS Framework
 *
 * @author IT-RAYS
 * @license Commercial License
 * @link http://www.it-rays.net
 * @copyright 2017 IT-RAYS Themes
 * @package ITFramework
 * @version 1.0.0
 *
 */

if ( ! defined( 'WPINC' ) ) { die; }

class ITR_Init_Class { 

    public function __construct() {
        
        $this->itr_define_constants();
        $this->itr_include_files();        
        
    }
    
    public function itr_define_constants(){
                
        define( 'ITR_THM_DIR'               , get_template_directory()       );
        define( 'ITR_THM_URI'               , get_template_directory_uri()   );
        
        define( 'ITR_FRAMEWORK_DIR'         , ITR_THM_DIR . '/it-framework'  );
        define( 'ITR_FRAMEWORK_URI'         , ITR_THM_URI . '/it-framework'  );
        
        define( 'ITR_FRAMEWORK_ASSETS_URI'  , ITR_FRAMEWORK_URI . '/assets'  );
        
        define( 'ITR_FRAMEWORK_PLUGIN_DIR'  , ITR_FRAMEWORK_DIR . '/plugins' );
        define( 'ITR_FRAMEWORK_PLUGIN_URI'  , ITR_FRAMEWORK_URI . '/plugins' );
                
    }
    
    public function itr_include_files(){
        
        require get_parent_theme_file_path ('it-framework/includes/it-framework.php');
        require get_parent_theme_file_path ('it-framework/includes/it-enqueue-files.php');
        require get_parent_theme_file_path ('it-framework/includes/it-custom-css.php');
        require get_parent_theme_file_path ('it-framework/includes/it-nav-menu.php');
        require get_parent_theme_file_path ('it-framework/includes/it-sidebars.php');
        require get_parent_theme_file_path ('it-framework/includes/it-helpers.php');
        require get_parent_theme_file_path ('it-framework/includes/menu/it-menu.php');
        require get_parent_theme_file_path ('it-framework/includes/it-post-formats.php');
        require get_parent_theme_file_path ('it-framework/config/it-metaboxes-config.php');
        require get_parent_theme_file_path ('it-framework/plugins/plugins/tgm-plugins.php');
        require get_parent_theme_file_path ('it-framework/plugins/importer/importer.php');
        
        if(class_exists('Woocommerce')) {
            require get_parent_theme_file_path ('woocommerce/helpers.php');
        }
        
        if(class_exists('bbPress')) {
            require get_parent_theme_file_path ('bbpress/helpers.php');
        }
          
    }
    
    
}

new ITR_Init_Class();