<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

class itr_demo_Importer {
        
    public function __construct() {
        
        add_action( 'wp_ajax_itr_import_action', array( &$this, 'itr_import_demo_files' ) );
        
    }
    
    public function itr_check_import() {
                       
        $plug_dir = trailingslashit( ABSPATH ) . 'wp-content/plugins/munza-core';
    
        if ( ! defined( 'WP_LOAD_IMPORTERS' ) ) define( 'WP_LOAD_IMPORTERS', true );
        require_once ABSPATH . 'wp-admin/includes/import.php';
                  
        if ( ! class_exists( 'WP_Importer' ) ) {
            $class_wp_importer = ABSPATH . 'wp-admin/includes/class-wp-importer.php';
            if ( file_exists( $class_wp_importer ) )
                require $class_wp_importer;
        }
           
        if ( ! class_exists( 'WP_Import' ) ) {
            $class_wp_import = $plug_dir . '/includes/importer/wordpress-importer.php';
            if ( file_exists( $class_wp_import ) )
                require $class_wp_import;
        }        
                                
    }
    
    public function itr_main_wp_options() {
        
        /* setting menu
        -------------------- */
        $main_menu   = get_term_by('name', esc_html__( 'Main Menu', 'munza' ), 'nav_menu');
        $one_page    = get_term_by('name', esc_html__( 'One Page Menu', 'munza' ), 'nav_menu');
        $top_menu    = get_term_by('name', esc_html__( 'Top Bar Menu', 'munza' ), 'nav_menu');
        
        $locations = array(
            'main-menu'        => $main_menu->term_id,
            'one-page'         => $one_page->term_id,
            'top-bar-menu'     => $top_menu->term_id,
        );  
        
        set_theme_mod( 'nav_menu_locations', $locations );

        /* setting custom menu fields
        -------------------------------- */
        $menu_items = wp_get_nav_menu_items( 'main-menu' );

        if ( ! empty( $menu_items ) ) {
            if ( ! empty( $menu_fields ) ) {
                foreach ( $menu_items as $menu_key => $menu_item ) {
                    foreach ( $menu_fields as $field_key => $field_data ) {
                        if ( $field_key == $menu_item->title ) {
                            foreach ( $field_data as $key => $value ) {
                                update_post_meta( $menu_item->ID, '_menu_item_' . $key, $value );
                            }
                        }
                    }
                }
            }
        }

        /* setting home-page
        ---------------------- */
        update_option( 'show_on_front', 'page' );
        update_option( 'page_on_front', itr_get_ID_by_slug( 'home' ) );
        update_option( 'page_for_posts', itr_get_ID_by_slug( 'blog' ) );      
    }
    
    public function itr_import_theme_opts() {
        $itr_opts_file = ITR_FRAMEWORK_PLUGIN_URI . '/importer/content/theme_options.txt';
        $data          = wp_remote_get( $itr_opts_file );
        $options       = unserialize( $data['body'] );
        if ( !empty( $data ) || is_array( $data ) ) {
            foreach ( $options as $option ) {
                update_option( $option->option_name, unserialize( $option->option_value ) );
            }
        }
    }
    
    public function itr_import_grids() {
        if ( class_exists( 'raysgrid_globals' ) ) {
            $itr_grid_file  = ITR_FRAMEWORK_PLUGIN_URI . '/importer/content/rays_grid.json';
            $response       = wp_remote_get( $itr_grid_file );
            $body           = wp_remote_retrieve_body($response);
            $port_data      = json_decode( $body, true );
            $itemArray      = array();
            global $wpdb, $table_prefix;
            $itr_settings_tbl = $table_prefix . 'raysgrid_setting';

            $gridSetting = $wpdb->get_results( " SELECT * FROM {$itr_settings_tbl} " );
            
            $grst_Alias = array();
            foreach ($gridSetting as $rg_alias) {
                $grst_Alias[] = $rg_alias->alias;
            }

            $grst_Alias2 = implode(" ", $grst_Alias);
            
            foreach ($port_data as $row) {
                if (strpos($grst_Alias2, $row['alias']) !== false) {
                    $getAlias = $wpdb->get_row( "SELECT * FROM {$itr_settings_tbl} WHERE  alias=%s ", $row['alias'] );
                    $settingData = $itemArray;
                    $where = array('id' => $getAlias->id);
                    $wpdb->update($itr_settings_tbl, $settingData, $where);
                } else {
                    unset($row['oldalias']);
                    $wpdb->insert($itr_settings_tbl, $row);
                }
            }
        }
    }
    
    public function itr_import_sliders(){
        $plug_dir = trailingslashit( ABSPATH ) . 'wp-content/plugins/munza-core';
        if (class_exists('RevSlider')) {
            $rvfile = $plug_dir . '/assets/sliders/';
            $rev_files = array(
                $rvfile.'home-1-slider.zip',
                $rvfile.'home-2-slider.zip',
                $rvfile.'home-3-slider.zip',
            );
            foreach ($rev_files as $rev_file) {
                $_FILES['import_file']['tmp_name'] = $rev_file;
                $slider = new RevSlider();
                $slider->importSliderFromPost(true, 'none');
            }
        }
    }
    
    public function itr_widgets_func() {
        register_sidebar(array(
            'name' => 'Secondary SideBar',
            'id' => 'sidebar-2',
            'before_widget' => '<li class="widget %2$s shape">',
            'after_widget' => '</div></li>',
            'before_title' => '<h4 class="widget-head main-color">',
            'after_title' => '</h4><div class="widget-content">',
        ));
        
        register_sidebar( array(
            'name' => 'Middle Footer Widgets',
            'id' => 'midle-footer-widgets',
            'before_widget' => '<div class="widget %2$s col-md-3">',
            'after_widget' => '</div>',
            'description' => 'Appears in the middle footer area',
            'before_title' => '<h4 class="block-head">',
            'after_title' => '</h4>'
        ));
        
        register_sidebar( array(
            'name' => 'Footer Bottom Widgets',
            'id' => 'footer-bottom-widgets',
            'before_widget' => '<div class="widget %2$s col-md-6">',
            'after_widget' => '</div>',
            'description' => 'Appears in the footer bottom bar',
            'before_title' => '<h4 class="block-head">',
            'after_title' => '</h4>'
        ));
                    
        // Add data to widgets
        $widgets_file   = ITR_FRAMEWORK_PLUGIN_URI . '/importer/content/widgets.json';
        $widgets_json   = wp_remote_get( $widgets_file );
        $widget_data    = $widgets_json['body'];
        $this->itr_import_widget_data( $widget_data );
        die();
    }
    
    public function itr_import_widget_data( $widget_data ) {
        $json_data = json_decode( $widget_data, true );

        $sidebar_data = $json_data[0];
        $widget_data = $json_data[1];

        foreach ( $widget_data as $widget_data_title => $widget_data_value ) {
            $widgets[ $widget_data_title ] = array();
            foreach ( $widget_data_value as $widget_data_key => $widget_data_array ) {
                if ( is_int( $widget_data_key ) ) {
                    $widgets[ $widget_data_title ][ $widget_data_key ] = 'on';
                }
            }
        }
        unset( $widgets[''] );

        foreach ( $sidebar_data as $title => $sidebar ) {
            $count = count( $sidebar );
            for ( $i = 0; $i < $count; $i++ ) {
                $widget = array();
                $widget['type'] = trim( substr( $sidebar[ $i ], 0, strrpos( $sidebar[ $i ], '-' ) ) );
                $widget['type-index'] = trim( substr( $sidebar[ $i ], strrpos( $sidebar[ $i ], '-' ) + 1 ) );
                if ( ! isset( $widgets[ $widget['type'] ][ $widget['type-index'] ] ) ) {
                    unset( $sidebar_data[ $title ][ $i ] );
                }
            }
            $sidebar_data[ $title ] = array_values( $sidebar_data[ $title ] );
        }

        foreach ( $widgets as $widget_title => $widget_value ) {
            foreach ( $widget_value as $widget_key => $widget_value ) {
                $widgets[ $widget_title ][ $widget_key ] = $widget_data[ $widget_title ][ $widget_key ];
            }
        }

        $sidebar_data = array( array_filter( $sidebar_data ), $widgets );

        $this->itr_parse_import_data( $sidebar_data );
    }

    public function itr_parse_import_data( $import_array ) {
        global $wp_registered_sidebars;
        $sidebars_data = $import_array[0];
        $widget_data = $import_array[1];
        $current_sidebars = get_option( 'sidebars_widgets' );
        $new_widgets = array();

        foreach ( $sidebars_data as $import_sidebar => $import_widgets ) {

            foreach ( $import_widgets as $import_widget ) {
                // If the sidebar exists.
                if ( isset( $wp_registered_sidebars[ $import_sidebar ] ) ) {
                    $title = trim( substr( $import_widget, 0, strrpos( $import_widget, '-' ) ) );
                    $index = trim( substr( $import_widget, strrpos( $import_widget, '-' ) + 1 ) );
                    $current_widget_data = get_option( 'widget_' . $title );
                    $new_widget_name = $this->itr_get_new_widget_name( $title, $index );
                    $new_index = trim( substr( $new_widget_name, strrpos( $new_widget_name, '-' ) + 1 ) );

                    if ( ! empty( $new_widgets[ $title ] ) && is_array( $new_widgets[ $title ] ) ) {
                        while ( array_key_exists( $new_index, $new_widgets[ $title ] ) ) {
                            $new_index++;
                        }
                    }
                    $current_sidebars[ $import_sidebar ][] = $title . '-' . $new_index;
                    if ( array_key_exists( $title, $new_widgets ) ) {
                        if ( 'nav_menu' == $title & ! is_numeric( $index ) ) {
                            $menu = wp_get_nav_menu_object( $index );
                            $menu_id = $menu->term_id;
                            $new_widgets[ $title ][ $new_index ] = $menu_id;
                        } else {
                            $new_widgets[ $title ][ $new_index ] = $widget_data[ $title ][ $index ];
                        }
                        $multiwidget = $new_widgets[ $title ]['_multiwidget'];
                        unset( $new_widgets[ $title ]['_multiwidget'] );
                        $new_widgets[ $title ]['_multiwidget'] = $multiwidget;
                    } else {
                        if ( 'nav_menu' == $title & ! is_numeric( $index ) ) {
                            $menu = wp_get_nav_menu_object( $index );
                            $menu_id = $menu->term_id;
                            $current_widget_data[ $new_index ] = $menu_id;
                        } else {
                            $current_widget_data[ $new_index ] = $widget_data[ $title ][ $index ];
                        }
                        $current_multiwidget = isset( $current_widget_data['_multiwidget'] ) ? $current_widget_data['_multiwidget'] : false;
                        $new_multiwidget = isset( $widget_data[ $title ]['_multiwidget'] ) ? $widget_data[ $title ]['_multiwidget'] : false;
                        $multiwidget = ( $current_multiwidget != $new_multiwidget ) ? $current_multiwidget : 1;
                        unset( $current_widget_data['_multiwidget'] );
                        $current_widget_data['_multiwidget'] = $multiwidget;
                        $new_widgets[ $title ] = $current_widget_data;
                    }
                } // End if().
            } // End foreach().
        } // End foreach().

        if ( isset( $new_widgets ) && isset( $current_sidebars ) ) {
            update_option( 'sidebars_widgets', $current_sidebars );

            foreach ( $new_widgets as $title => $content ) {
                update_option( 'widget_' . $title, $content );
            }
            return true;
        }
        return false;
    }

    public function itr_get_new_widget_name( $widget_name, $widget_index ) {
        $current_sidebars = get_option( 'sidebars_widgets' );
        $all_widget_array = array();
        foreach ( $current_sidebars as $sidebar => $widgets ) {
            if ( ! empty( $widgets ) && is_array( $widgets ) && 'wp_inactive_widgets' != $sidebar ) {
                foreach ( $widgets as $widget ) {
                    $all_widget_array[] = $widget;
                }
            }
        }
        while ( in_array( $widget_name . '-' . $widget_index, $all_widget_array ) ) {
            $widget_index++;
        }
        $new_widget_name = $widget_name . '-' . $widget_index;
        return $new_widget_name;
    }
    
    public function itr_import_conent() {
        $import_filepath  = ITR_FRAMEWORK_PLUGIN_DIR . '/importer/content/content.xml';
        $attachment       = ( ! empty( $_POST['attachment'] ) ) ? true : false;
        $itr_wp_import    = new WP_Import();
        $itr_wp_import->fetch_attachments = $attachment;
        $itr_wp_import->import( $import_filepath );
        $this->itr_main_wp_options();
    } 
    
    public function itr_import_demo_files() {
        
        wp_delete_nav_menu( 'main-menu' ); 
        
        $this->itr_check_import();                        
        
        // Import theme options...    
        $this->itr_import_theme_opts(); 
                        
        //Import Content...
        $this->itr_import_conent(); 
        
        //Import Portfolio Grids...
        $this->itr_import_grids();
        
        //Import Sliders...
        $this->itr_import_sliders();
        
        //Add sidebar widget areas
        $this->itr_widgets_func();
                
    }

}

new itr_demo_Importer();