<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );
global $post;
$itr_tags = wp_get_post_tags($post->ID);

if ($itr_tags) {
    
    $itr_tag_ids = array();
    
    foreach( $itr_tags as $itr_individual_tag ) $itr_tag_ids[] = $itr_individual_tag->term_id;
    
    $args = array(
        'tag__in'               => $itr_tag_ids,
        'post__not_in'          => array($post->ID),
        'showposts'             => 3,
        'ignore_sticky_posts'   => 1
    );
    
    $itr_related_query = new wp_query($args);
    
    if( $itr_related_query->have_posts() ) {
        echo '<div class="itr-related-posts">';
        echo '<h3 class="itr-inner-heading">'.esc_html__('You may', 'munza').' <span class="main-color">'.esc_html__('also like', 'munza').'</span></h3>';
            echo '<div class="row">';
                while ($itr_related_query->have_posts()) {
                    $itr_related_query->the_post();
                    echo '<div class="col-md-4">';
                        echo '<div class="itr_rel_img"><a href="'.esc_url(get_the_permalink()).'" rel="bookmark">' . get_the_post_thumbnail($post->ID, 'large', '') . '</a></div>';
                        echo '<h5 class="itr_rel_link">' . '<a href="'.esc_url(get_the_permalink()).'" rel="bookmark">'.esc_html(get_the_title()).'</a>' . '</h5>';
                        echo '<div class="itr_rel_date">' . get_the_date() . '</div>';
                    echo '</div>';
                }
            echo '</div>';
        echo '</div>';
    }
    
    wp_reset_postdata();
        
}