<?php
/* Footer Style */

if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

$itr_foot_widgets      = (itr_theme_option('foot_mid_show') == '1') ? '1' : '0';
$itr_foot_top          = (itr_theme_option('foot_top_show') == '1') ? '1' : '0';
$itr_bot_foot          = (itr_theme_option('foot_bottom_show') == '1') ? '1' : '0';
$itr_meta_foot_widgets = (get_post_meta(itr_page_ID(),'meta_hide_foot_widgets',true) == '1') ? '1' : '0';
$itr_meta_foot_top     = (get_post_meta(itr_page_ID(),'meta_hide_foot_top',true) == '1') ? '1' : '0';
$itr_meta_foot_bar     = (get_post_meta(itr_page_ID(),'meta_hide_bottom_foot_bar',true) == '1') ? '1' : '0';
$itr_footer_css        = get_post_meta(itr_page_ID(),'meta_foot_extra_class',true);
$itr_cols_wid          = itr_theme_option('foot_bot_widg_cols');
$itr_midcols_wid       = itr_theme_option('foot_mid_widg_cols');
$itr_meta_fixed        = get_post_meta(itr_page_ID(),'meta_foot_fixed',true); 
$itr_langcode          = ( class_exists( 'SitePress' ) ) ? '-'.ICL_LANGUAGE_CODE : '';
$itr_fixed             = itr_theme_option('footer_fixed');
$itr_width             = itr_theme_option('footer_width');
$itr_copy              = itr_theme_option('foot_copyrights'.$itr_langcode);
$itr_nl1               = itr_theme_option('foot_nl1'.$itr_langcode);
$itr_nl2               = itr_theme_option('foot_nl2'.$itr_langcode);
$itr_foot_btn          = itr_theme_option('foot_btn_text'.$itr_langcode);
$itr_foot_btn_link     = itr_theme_option('foot_btn_link');
$itr_btn_targ          = itr_theme_option('foot_btn_link_target');
$itr_class                 = 'footer-3';

if( $itr_meta_fixed == '1' ) {
    $itr_class .= ' fixed-footer';
} else if( $itr_fixed == '1' ) {
    $itr_class .= ' fixed-footer';
} else {
    $itr_class .= '';
}

$itr_cols       = ( $itr_cols_wid == '1' ) ? ' row' : ' row row-eq-height';
$itr_midcols    = ( $itr_midcols_wid == '1' ) ? ' row' : ' row row-eq-height';
$itr_class     .= ($itr_footer_css != '') ? ' '.$itr_footer_css : "";
$itr_class     .= ($itr_width == 'wide') ? ' full_footer' : "";
$itr_svgid      = 'foot_grad';
$itr_grd        = esc_textarea(itr_theme_option('footer_bg_grad'));
$itr_on         = strstr($itr_grd, '#');
$itr_fist_hx    = substr($itr_on, 0, 7);
$itr_str2       = substr($itr_on, 7);
$itr_needle     = strstr($itr_str2, '#'); 
$itr_sec_hx     = substr($itr_needle, 0, 7); 
 
?>
<footer id="footWrapper" class="<?php echo esc_attr( $itr_class ); ?>">
    
    <svg version="1.1" data-id="<?php echo esc_attr( $itr_svgid ); ?>" class="slurve-definitions" xmlns="http://www.w3.org/2000/svg">
        <defs>
            <linearGradient id="<?php echo esc_attr( $itr_svgid ); ?>" gradientTransform="rotate(0)">
                <stop offset="0%" stop-color="<?php echo esc_attr( $itr_fist_hx ); ?>" />
                <stop offset="100%" stop-color="<?php echo esc_attr( $itr_sec_hx ); ?>" />
            </linearGradient>
        </defs>
    </svg>   
    <?php if ( $itr_foot_top == "1" && $itr_meta_foot_top != '1' ) { ?>
        <div class="foot-top">
            <div class="container">
                <div class="row row-eq-height center_vert">
                    <div class="col-md-6 top-foot-nl-txt">
                        <div class="nl-left-txt">
                            <?php if ( $itr_nl1 != "" ) { ?><h4><?php echo wp_kses( $itr_nl1, itr_allowed_tags() ); ?></h4><?php } ?>
                            <?php if ( $itr_nl2 != "" ) { ?><p><?php echo wp_kses( $itr_nl2, itr_allowed_tags() ); ?></p><?php } ?>
                        </div>
                    </div>
                    <div class="col-md-6 text-right top-foot-nl-form">
                        
                        <a class="btn bold main-bg rounded big_shadow" href="<?php echo esc_url($itr_foot_btn_link); ?>"<?php if($itr_btn_targ == 1){?> target="_blank"<?php } ?>>
                            <span><?php echo esc_html( $itr_foot_btn ); ?></span>
                        </a>
                        
                    </div>
                </div>                
            </div>        
        </div>
    <?php } ?>
    
    <div class="footer_bg">
        <div class="slurve foot_slrv" data-slurve="0,35 0,-250 0,0 0,0"></div>
        <?php if ( $itr_foot_widgets == "1" && $itr_meta_foot_widgets != '1' && is_active_sidebar('midle-footer-widgets') ) { ?>
            <div class="footer-middle">
                <div class="container">
                    <div class="<?php echo esc_attr( $itr_midcols ); ?>">
                        <?php dynamic_sidebar('midle-footer-widgets'); ?>
                    </div>
                </div>    
            </div>
        <?php } ?>
        
        <?php if ( $itr_bot_foot == "1" && $itr_meta_foot_bar != '1') { ?>
            <div class="footer-bottom">
                <div class="container">
                    <div class="<?php echo esc_attr( $itr_cols ); ?>">
                        
                        <?php if ( $itr_copy != "" ) { ?>
                            <div class="copyrights text-center">
                                <?php echo wp_kses( $itr_copy, itr_allowed_tags() ); ?>
                            </div>
                        <?php } ?>
                            
                        <?php if(is_active_sidebar('footer-bottom-widgets')){ ?>
                            <?php dynamic_sidebar('footer-bottom-widgets'); ?>
                        <?php } ?>
                        
                    </div>
                </div>
            </div>
            
        <?php } ?>
    </div>
    
</footer>