<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

$clas           = 'top-head';
$ht_bar         = get_post_meta(itr_page_ID(),'meta_hide_top_bar',true);
$st_head        = get_post_meta(itr_page_ID(),'meta_header_sticky',true);
$h_menu         = get_post_meta(itr_page_ID(),'meta_hide_menu',true); 
$header_style   = get_post_meta(itr_page_ID(),'meta_header_style',true);
$header_class   = get_post_meta(itr_page_ID(),'meta_header_extra_class',true);
$h_ful          = get_post_meta(itr_page_ID(),'meta_header_full',true);
$mh_fixed       = get_post_meta(itr_page_ID(),'meta_header_fixed',true);
$me_lft_area    = get_post_meta(itr_page_ID(),'meta_header_left_area',true);
$me_cent_area   = get_post_meta(itr_page_ID(),'meta_header_center_area',true);
$me_rit_area    = get_post_meta(itr_page_ID(),'meta_header_right_area',true);

$hd_left_area   = ( $me_lft_area == '' ) ? itr_theme_option('header_left_area') : $me_lft_area;
$hd_cent_area   = ( $me_cent_area == '' ) ? itr_theme_option('header_center_area') : $me_cent_area;
$hd_rit_area    = ( $me_rit_area == '' ) ? itr_theme_option('header_right_area') : $me_rit_area;
$clas           .= ( $header_class ) ? ' '.$header_class : '';
$clas           .= ( $header_style ) ? ' '.$header_style : ' '.itr_theme_option("header_style");
$clas           .= ( $h_ful != '' && $h_ful == '1') ? ' full_header' : (($h_ful == '' && itr_theme_option('header-full') == '1') ? ' full_header' : '');
$stick          = ( $st_head == '1' || (itr_theme_option('sticky_header_on') == '1' && $st_head == '')) ? ' data-sticky' : '';

if ( $mh_fixed == '1' ){
    $clas .= ' fixed-head';
} else if ( itr_theme_option("header-fixed") == '1' && $mh_fixed == '' ){
    $clas .= ' fixed-head';
}

if ( $ht_bar == '1' || (itr_theme_option("show_top_bar") == '1' && $ht_bar == '') ) {
    get_template_part( 'layout/headers/top-bar');
}

if ( !$h_menu == '1' ) { ?>

<header class="<?php echo esc_attr($clas) ?>"<?php echo esc_attr($stick); ?>>
    
    
    <div class="container">
        
        <div class="itr_head_wrap">
            
            <?php if( $hd_left_area ) { 
                $area = 'left';
                ?>
                <div class="itr-left-head-area itr-head-<?php echo esc_attr($hd_left_area); ?>">
                    <?php if( $hd_left_area == 'logo' ) itr_header_logo(); ?>
                    <?php if( $hd_left_area == 'menu' ) itr_choose_header_menu($area); ?>
                    <?php if( $hd_left_area == 'icons' ) itr_header_icons(); ?>
                    <?php if( $hd_left_area == 'button' ) itr_header_button($area); ?>
                </div>
            <?php } ?>
            
            <?php if( $hd_cent_area ) { 
                $area = 'center';
                ?>
                <div class="itr-center-head-area itr-head-<?php echo esc_attr($hd_cent_area); ?>">
                    <?php if( $hd_cent_area == 'logo' ) itr_header_logo(); ?>
                    <?php if( $hd_cent_area == 'menu' ) itr_choose_header_menu($area); ?>
                    <?php if( $hd_cent_area == 'icons' ) itr_header_icons(); ?>
                    <?php if( $hd_cent_area == 'button' ) itr_header_button($area); ?>
                </div>
            <?php } ?>
            
            <?php if( $hd_rit_area ) {
            $area = 'right';
             ?>
                <div class="itr-right-head-area itr-head-<?php echo esc_attr($hd_rit_area); ?>">
                    <?php if( $hd_rit_area == 'logo' ) itr_header_logo(); ?>
                    <?php if( $hd_rit_area == 'menu' ) itr_choose_header_menu($area); ?>
                    <?php if( $hd_rit_area == 'icons' ) itr_header_icons(); ?>
                    <?php if( $hd_rit_area == 'button' ) itr_header_button($area); ?>
                </div>            
            <?php } ?>
            
        </div>
        
    </div>
            
</header>
<?php } ?>