<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

$langcode = '';
if ( class_exists( 'SitePress' ) ) {
    $langcode = '-'.ICL_LANGUAGE_CODE;
} else if ( class_exists( 'Polylang' )){
    $langcode = '-'.ICL_LANGUAGE_CODE;
}

$pgt_style      = ( get_post_meta(itr_page_ID(), 'meta_title_style',true) == '' )        ? itr_theme_option('page_title_style') : get_post_meta(itr_page_ID(), 'meta_title_style',true);
$pgt_pos        = ( get_post_meta(itr_page_ID(), 'meta_title_position',true) == '' )     ? itr_theme_option('page_title_position'.$langcode) : get_post_meta(itr_page_ID(), 'meta_title_position',true);
$bread_show     = ( get_post_meta(itr_page_ID(), 'meta_show_breadcrumbs',true) == '' )   ? itr_theme_option( 'page_title_show_breadcrumbs' ) : get_post_meta(itr_page_ID(),'meta_show_breadcrumbs',true);
$bread_style    = ( get_post_meta(itr_page_ID(), 'meta_breadcrumbs_style',true) == '' )  ? itr_theme_option( 'page_title_breadcrumbs_style' ) : get_post_meta(itr_page_ID(),'meta_breadcrumbs_style',true);
$title_bg_img   = ( get_post_meta(itr_page_ID(), 'meta_title_bg_img',true) == '' )       ? itr_theme_option( 'page_title_bg' )          : get_post_meta(itr_page_ID(),'meta_title_bg_img',true);
$parallax       = ( get_post_meta(itr_page_ID(), 'meta_title_parallax',true) == '' )     ? itr_theme_option( 'page_title_parallax' ) : get_post_meta(itr_page_ID(),'meta_title_parallax',true);
$txt_bg         = ( get_post_meta(itr_page_ID(), 'meta_title_text_bg_color',true) == '' )? itr_theme_option( 'page_title_textcolor' ) : get_post_meta(itr_page_ID(),'meta_title_text_bg_color',true);
$over           = ( get_post_meta(itr_page_ID(), 'meta_title_bg_overlay',true) == '' )   ? itr_theme_option('page_title_overlay') : get_post_meta(itr_page_ID(), 'meta_title_bg_overlay',true);
$title_text     = ( get_post_meta(itr_page_ID(), 'meta_title_txt',true) == '' )          ?  itr_custom_page_title() : get_post_meta(itr_page_ID(), 'meta_title_txt',true);
$subtitle_text  = ( get_post_meta(itr_page_ID(), 'meta_subtitle',true) == '' )           ? itr_custom_page_subtitle() : get_post_meta(itr_page_ID(), 'meta_subtitle',true);
$title_class    = get_post_meta( itr_page_ID(), 'meta_title_extra_class' , true);
$video_bg       = get_post_meta(itr_page_ID(), 'meta_title_video_bg',true);
$vid_cov_url    = wp_get_attachment_url( esc_url( get_post_meta(itr_page_ID(), 'meta_title_video_cover',true) ) );
$video_mp4      = esc_url( get_post_meta(itr_page_ID(), 'meta_title_video_mp4',true) );
$video_webm     = esc_url( get_post_meta(itr_page_ID(), 'meta_title_video_webm',true) );
$video_ogv      = esc_url( get_post_meta(itr_page_ID(), 'meta_title_video_ogv',true) );
$meta_title     = get_post_meta( itr_page_ID(), 'meta_title_hide' , true);
$itr_title      = itr_theme_option('hide_page_title');
$class          = 'page-title';
$class         .= ( $video_bg != '' && $video_mp4 )  ? ' page-title-video'   : "";
$class         .= ( $title_class )                   ? ' '.$title_class      : "";
$class         .= ( $pgt_style != 'normal' )         ? ' style'.$pgt_style   : "";
$class         .= ' text-'.$pgt_pos;
$atts           = '';
$atts          .= ( $pgt_style == '1' ) ? '-40,0 0,0 0,-250 50,0,80'    : '';
$atts          .= ( $pgt_style == '2' ) ? '0,0 -170,0 -100,-180,80 0,0' : '';
$atts          .= ( $pgt_style == '3' ) ? '0,0 0,0 0,0 0,-280'          : '';
$atts          .= ( $pgt_style == '4' ) ? '0,0 0,0 0,-280 0,0'          : '';

$skrol          = ( $title_bg_img != '' && $parallax == '1' ) ? ' skrollr' : '';

if ( $meta_title != '' ){
    $hide_title = $meta_title;
} else {
    $hide_title = $itr_title;
}
 
if ( $hide_title == '' ) {
    
    wp_enqueue_script( 'skrollr', ITR_THM_URI . '/assets/js/vendor/skrollr.js', array('jquery'), null, true);
    
    if ( $pgt_style == 'normal' ) {
        ?>
        <div class="<?php echo esc_attr( $class ); ?>">
        <?php
    } else { ?>
        <div class="<?php echo esc_attr( $class ); ?>" data-slurve="<?php echo esc_attr( $atts ); ?>">
    <?php }
        if ( $title_bg_img != '' ) { ?>
            <div class="title_bg<?php echo esc_attr($skrol); ?>" <?php if( $parallax == '1' ){ ?> data-0="transform: translate3d(0, 0%, 0);" data-800="transform: translate3d(0, -60%, 0);"<?php } ?>></div>
        <?php }
        
        $meta_titl_type     =  get_post_meta(itr_page_ID(), 'meta_title_bg_type',true);
        $them_titl_type     =  itr_theme_option('page_title_bg_type');
        $titl_type          = ( $meta_titl_type == '' ) ? $them_titl_type : $meta_titl_type;
        $titl_grad          = ( get_post_meta(itr_page_ID(), 'meta_title_bg_grad',true) == '' ) ? itr_theme_option('page_title_bg_grad') : get_post_meta(itr_page_ID(), 'meta_title_bg_grad',true);
        
        if( $pgt_style != 'normal' && $titl_type == 'gradient' ) {
        
        if( $meta_titl_type == '' && $them_titl_type == 'gradient' ){
            $titl_grad = itr_theme_option('page_title_bg_grad');    
        }
        
        $svgid      = 'pgt_grad';
        $grd        = esc_textarea( $titl_grad );
        $on         = strstr($grd, '#');
        $fist_hx    = substr($on, 0, 7);
        $str2       = substr($on, 7);
        $needle     = strstr($str2, '#'); 
        $sec_hx     = substr($needle, 0, 7); ?>
            
        <svg version="1.1" data-id="<?php echo esc_attr($svgid); ?>" class="slurve-definitions" xmlns="http://www.w3.org/2000/svg">
            <defs>
                <linearGradient id="<?php echo esc_attr($svgid); ?>" gradientTransform="rotate(0)">
                    <stop offset="0%" stop-color="<?php echo esc_attr($fist_hx); ?>" />
                    <stop offset="100%" stop-color="<?php echo esc_attr($sec_hx); ?>" />
                </linearGradient>
            </defs>
        </svg>
            
        <?php } ?>
        
        <?php if ( $video_bg == '1' ) { ?>
            <div class="video-wrap">
                
                <?php echo '<video poster="'.esc_url( $vid_cov_url ).'" preload="auto" loop autoplay muted>';
                    if ( $video_mp4 != '' ) { echo '<source src="'.esc_url( $video_mp4 ).'" type="video/mp4" />'; }
                    if ( $video_webm != '' ) { echo '<source src="'.esc_url( $video_webm ).'" type="video/webm" />'; }
                    if ( $video_ogv != '' ) { echo '<source src="'.esc_url( $video_ogv ).'" type="video/ogv" />'; }
                echo '</video>'; ?>
                
            </div>
        <?php } ?>
        
        <div class="container skrollr" data-0="opacity:1; transform:translateY(0px);" data-300="opacity:0; transform:translateY(230px);">
            <div class="title-container">
                <div class="in-page-title">
                        
                    <?php if ( $txt_bg != '' ){ ?><div class="tbl titl_txt_bg"> <?php } ?> 
                    
                    <?php itr_page_title_icon(); ?>
                    
                    <?php if( $bread_show == '1' && $bread_style == 'style3' ){ itr_site_breadcrumbs(); } ?>
                    
                    <div class="title-headings">
                        <?php if( $title_text != '' ) echo '<h1>'.wp_kses( $title_text , itr_allowed_tags() ).'</h1>'; ?>
                        <?php if( $subtitle_text != '' ) echo '<h3>'.wp_kses( $subtitle_text , itr_allowed_tags() ).'</h3>'; ?>
                    </div>
                    
                    <?php if( $bread_show == '1' && $bread_style == 'style2' ){ itr_site_breadcrumbs(); } ?>
                    
                    <?php if ( $txt_bg != '' ){ ?></div> <?php } ?>
                                    
                </div>
            </div>
        </div>
        
        <?php if ( $over != '' ) { ?>
            <div class="video-overlay"></div>
        <?php } ?>
    </div>

    <?php if( $bread_show == '1' && $bread_style == 'style1' ){ itr_site_breadcrumbs(); } 

}
