<?php 
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

$class              = 'top-bar';
$meta_bar_color     = esc_html(get_post_meta(itr_page_ID(),'meta_topbar_color',true));
$meta_border        = esc_html(get_post_meta(itr_page_ID(),'meta_bar_border',true));
$meta_full          = esc_html(get_post_meta(itr_page_ID(),'meta_bar_full',true));
$meta_tb_exclass    = esc_html(get_post_meta(itr_page_ID(),'meta_bar_extra_class',true));
$top_color          = itr_theme_option("topbar_color");
$top_full           = itr_theme_option("bar_full");
$t_border           = itr_theme_option('topbar_border');
$lbar               = itr_theme_option('top_left_mod');
$rbar               = itr_theme_option('top_right_mod');

$class .= ($meta_bar_color != '') ? ' '.$meta_bar_color : ' '.$top_color;    
$class .= ($meta_tb_exclass != '') ? ' '.$meta_tb_exclass : "";

if( $meta_border != '' && $meta_border == '1' ){
    $class .= ' bord';
} else if($meta_border == '' && $t_border == '1'){
    $class .= ' bord';
}
if($meta_full != '' && $meta_full == '1'){
    $class .= ' full-bar';
}else if ($meta_full == '' && $top_full == '1'){
    $class .= ' full-bar';
}

?>
<div class="<?php echo esc_attr($class); ?>">
    <div class="container">
        <div class="row">
        <?php if ($lbar !== 0) { ?>
             <div class="pull-left">   
                <?php for ( $i = 1; $i <= $lbar ; $i++ ) {  
                    $mod = itr_theme_option('top_bar_left_'.$i); 
                    top_bar_mods($mod,$i,'left');    
                } ?>
             </div>   
        <?php } ?>  

        <?php if ($rbar !== 0) { ?>
            <div class="pull-right">
                <?php for ( $i = 1; $i <= $rbar ; $i++ ) {   
                    $mod = itr_theme_option('top_bar_right_'.$i);
                    top_bar_mods($mod,$i,'right');    
                } ?>
            </div>
        <?php } ?>
        </div>
    </div>
</div>

<?php
  
function top_bar_mods($module,$num,$bar){
    $langcode = '';
    global $user_ID; 
    $it_custom_menu = new itr_custom_menu();
    if ( class_exists( 'SitePress' ) ) {
        $langcode = '-'.ICL_LANGUAGE_CODE;
    } else if ( class_exists( 'Polylang' )){
        $langcode = '-'.ICL_LANGUAGE_CODE;
    }
        
    $b_menu = itr_theme_option("top_".$bar."_menu_".$num);
    $b_menu_css = itr_theme_option("top_".$bar."_menu_css_".$num);
    $b_menu_hide = itr_theme_option("top_".$bar."_menu_hide_".$num);
    
    $b_text = itr_theme_option("top_".$bar."_text_".$num.$langcode);
    $b_text_icon = itr_theme_option("top_".$bar."_text_icon_".$num);
    $b_text_css = itr_theme_option("top_".$bar."_text_css_".$num);
    $b_text_hide = itr_theme_option("top_".$bar."_text_hide_".$num);
    
    $b_link_txt = itr_theme_option("top_".$bar."_link_text_".$num.$langcode);
    $b_link_icon = itr_theme_option("top_".$bar."_link_icon_".$num);
    $b_link_url = itr_theme_option("top_".$bar."_link_url_".$num.$langcode);
    $b_link_target = itr_theme_option("top_".$bar."_link_target_".$num);
    $b_link_css = itr_theme_option("top_".$bar."_link_css_".$num);
    $b_link_hide = itr_theme_option("top_".$bar."_link_hide_".$num);
    
    $b_search_css = itr_theme_option("top_".$bar."_search_css_".$num);
    $b_search_hide = itr_theme_option("top_".$bar."_search_hide_".$num);
    
    $b_socials_txt = itr_theme_option("top_".$bar."_socials_txt_".$num.$langcode);
    $b_socials_css = itr_theme_option("top_".$bar."_socials_css_".$num);
    $b_socials_hide = itr_theme_option("top_".$bar."_socials_hide_".$num);
    
    $b_login_css = itr_theme_option("top_".$bar."_login_css_".$num);
    
    $b_wpml_css = itr_theme_option("top_".$bar."_wpml_css_".$num);
    $b_wpml_hide = itr_theme_option("top_".$bar."_wpml_hide_".$num);
    
    $b_woocart_css = itr_theme_option("top_".$bar."_woocart_css_".$num);
    $b_woocart_hide = itr_theme_option("top_".$bar."_woocart_hide_".$num);
        
    $b_soc_txt = itr_theme_option("socials_".$bar."_txt_".$num.$langcode);      
      
    switch($module){
                
        case 'menu':
            if ( !is_user_logged_in() || ( is_user_logged_in() && $b_menu_hide != 1) ) { ?>
                <div class="top-bar-menu topbar-box <?php echo esc_attr($b_menu_css) ?>">
                    <?php if($b_menu != ''){
                        if (has_nav_menu($b_menu)) {
                            $it_custom_menu->itr_nav_menu( array( 'theme_location' => $b_menu) );
                        }
                    }else{
                        echo '<span class="menu-message">' . esc_html__('No menu selected! Please select menu first.', 'munza').'</span>';
                    } ?>
                </div>
            <?php }
        break;
        
        case 'text':
            if ( !is_user_logged_in() || ( is_user_logged_in() && $b_text_hide != 1) ) { ?>     
                <div class="top-bar-txt topbar-box <?php echo esc_attr($b_text_css) ?>">
                    <i class="main-color <?php echo esc_attr($b_text_icon) ?>"></i><?php echo wp_kses($b_text,itr_allowed_tags()); ?>
                </div>
            <?php }
        break;
            
        case 'link':
            if ( !is_user_logged_in() || ( is_user_logged_in() && $b_link_hide != 1) ) { ?>
                <div class="top-bar-txt topbar-box <?php echo esc_attr($b_link_css) ?>">
                    <a href="<?php echo esc_url($b_link_url); ?>" target="<?php echo esc_attr($b_link_target); ?>"><i class="main-color <?php echo esc_attr($b_link_icon) ?>"></i><?php echo wp_kses($b_link_txt,itr_allowed_tags()); ?></a>
                </div>
            <?php }
        break;
            
        case 'search':
            if ( !is_user_logged_in() || ( is_user_logged_in() && $b_search_hide != 1) ) { ?>
                <div class="topbar-box top-bar-search <?php echo esc_attr($b_search_css) ?>">
                    <?php get_search_form(); ?>
                </div>
            <?php } 
        break;
        
        case 'socials':
            if ( !is_user_logged_in() || ( is_user_logged_in() && $b_socials_hide != 1) ) { ?>
                <div class="top-socials topbar-box <?php echo esc_attr($b_socials_css) ?>">
                    <?php if($b_socials_txt){ ?><div class="lbl-txt"><?php echo wp_kses($b_socials_txt,itr_allowed_tags()); ?></div><?php } ?><div class="pull-right"><?php echo itr_display_social_icons(); ?></div>
                </div>
            <?php }
        break;
                        
        case 'login':
            ?>
            <ul class="top-info topbar-box <?php echo esc_attr($b_login_css) ?>">
                <?php if ( $user_ID ) { ?>
                    <?php global $user_identity; ?>
                    <li class="welcome-user"><i class="fa fa-user main-color rit_ic"></i><?php echo esc_html__('Welcome', 'munza') ?>&nbsp;&nbsp;<b class="main-color">[</b> <?php echo itr_get_user_name(); ?> <b class="main-color">]</b>&nbsp;&nbsp; - <a class="main-color bold logout_btn" href="<?php echo esc_url(wp_logout_url()); ?>" title="<?php echo esc_attr(esc_html__('Log out from this account', 'munza')) ?>"><i class="fa fa-power-off main-color rit_ic"></i><?php echo esc_html__('Log Out', 'munza') ?></a></li>
                <?php } else { ?>
                    <li>
                        <?php echo esc_html__('Are You A Member ? ', 'munza') ?>
                        <?php if (get_option('users_can_register')) { ?><a class="bold logout_btn" href="<?php echo esc_url(get_option('siteurl')); ?>/wp-login.php?action=register">
                        <b class="main-color">[&nbsp;&nbsp;</b><?php esc_html_e('Register', 'munza') ?><b class="main-color">&nbsp;&nbsp;]</b>
                        </a> <?php } ?>
                        
                        <div class="inline login_wrap">
                            <a class="bold main-color itr_open_login" href="#">
                                &nbsp;&nbsp;<b class="main-color">[ &nbsp;<i class="fa fa-unlock-alt main-color rit_ic"></i></b><?php echo esc_html__('Login', 'munza') ?><b class="main-color">&nbsp;&nbsp;]</b>
                            </a>
                            <div class="login-popup">
                                <h5 class="main-color"><?php echo esc_html__( 'Login to site','munza' ); ?></h5>
                                <?php itr_login_form(); ?>
                            </div>
                        </div>
                    </li>
                <?php } ?>
            </ul>
            <?php
        break;
            
        case 'wpml':
            if ( !is_user_logged_in() || ( is_user_logged_in() && $b_wpml_hide != 1) ) { ?>
                <div class="topbar-box <?php echo esc_attr($b_wpml_css) ?>">
                    <?php if(itr_wpml_activated()){
                        itr_language_selector_flags();
                    }else{
                        echo '<span class="menu-message">'. esc_html__('Please Install and Activate WPML Plugin', 'munza'). '</span>';
                    } ?>
                </div>
            <?php }
        break;
        
        case 'woocart':
            if ( !is_user_logged_in() || ( is_user_logged_in() && $b_woocart_hide != 1) ) {
                if ( class_exists( 'woocommerce' ) ){ ?>
                    <div class="topbar-box top-cart cart-btn <?php echo esc_attr($b_woocart_css) ?>"><?php echo itr_woo_cart(); ?></div>
                <?php } else { ?>
                    <div class="topbar-box menu-message"><?php echo esc_html__('Please Install and Activate Woocommerce Plugin.', 'munza'); ?></div>
                <?php    
                }
            } 
        break; 
    }   
}
