<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

$layout = itr_theme_option( 'blogstyle' );

$class = 'post-item';
$class .= ( $layout == 'grid' || $layout == 'masonry' ) ? ' col-md-'.itr_theme_option('blog_columns') : '';

if ( $layout == 'masonry' || $layout == 'grid' ){
    wp_enqueue_script( 'imagesloaded',   ITR_THM_URI . '/assets/js/vendor/imagesloaded.js',  array('jquery'), null, true);
    wp_enqueue_script( 'jquery-isotope',        ITR_THM_URI . '/assets/js/vendor/isotope.js',       array('jquery'), null, true);
}

?>
<div id="post-<?php the_ID(); ?>" <?php post_class( $class ); ?>>
    <div class="main-bg abs_bg">               
        <i class="stline-hyperlink-2 abs_lnk"></i>
        <?php 
        if ( is_sticky() && is_home() && ! is_paged() ) {
            echo '<span class="post-sticky main-bg" title="' . esc_html__( 'Featured', 'munza' ) . '"><i class="outlinefont-Asset-1252"></i></span>';
        }
        itr_simple_post_thumbnail(); ?>
        
        <div class="post-info">
            
            <?php itr_post_title(); 
            itr_post_meta(); ?>
            
        </div>
        
        <?php //itr_get_content_format();
        itr_mini_pager(); ?>
    </div>                    
</div>