<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

$itr_woo        = ( function_exists('is_woocommerce') && is_woocommerce() ) ? 'is_woocommerce' : '';
$itr_cart       = ( function_exists('is_cart') && is_cart() ) ? 'is_cart' : '';
$itr_chk        = ( function_exists('is_checkout') && is_checkout() ) ? 'is_checkout' : '';
$meta_bar       = get_post_meta(itr_page_ID(),'meta_sidebar_select',true);
$woo_br         = itr_theme_option('sidebar_woo');
$class          = "itr-main-content sidebar";
$bar_choice     = isset( $meta_bar ) ? $meta_bar : 'default';

if ( $itr_woo || is_tax( 'product_cat' ) || is_tax( 'product_tag' ) || is_singular( 'product' ) || $itr_cart || $itr_chk ) {

    echo '<div class="'.esc_attr( $class ).'">';
        echo itr_dynamic_sidebar( $woo_br );
    echo '</div>';

} else {
    
    if ( $bar_choice && $bar_choice != "default" ) {
        
        echo '<div class="'.esc_attr( $class ).'">';
            echo itr_dynamic_sidebar( $bar_choice );
        echo '</div>';
        
    } else {
        
        if ( is_active_sidebar('sidebar-2') ) {
            
            echo '<div class="'.esc_attr( $class ).'">';
                echo itr_dynamic_sidebar( 'sidebar-2' );
            echo '</div>';
            
        } else if ( is_active_sidebar( 'sidebar-1' ) ) {
            
            echo '<div class="'.esc_attr( $class ).'">';
                echo itr_dynamic_sidebar( 'sidebar-1' ); 
            echo '</div>';
            
        }
    }
}