<?php
/**
 * Empty cart page
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-empty.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see 	    https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 3.5.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

wc_print_notices();

/**
 * @hooked wc_empty_cart_message - 10
 */

if ( wc_get_page_id( 'shop' ) > 0 ) { ?>
	
    <div class="no_products_found oc-cart">
        <div class="not_found_icon"><i class="stline-shopping-cart-1"></i></div>
        <div class="not_found_info">
            <h3><?php do_action( 'woocommerce_cart_is_empty' ); ?></h3>
            <p><?php esc_html_e( 'You Can Try Searching again Or Even return back to Home Page with the button below.', 'munza' ); ?></p>
        </div>
    </div>
    <div class="tbl m-auto">
        <a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="btn btn-md btn-hover-shad rounded main-bg">
            <span><?php echo esc_html__('Go To Home Page','munza') ?></span>
        </a>
    </div>
<?php } else {
    do_action( 'woocommerce_cart_is_empty' );
} ?>
