<?php
if ( ! defined( 'ABSPATH' ) ) exit( 'Access Denied.' );

add_theme_support('woocommerce');
remove_action( 'woocommerce_before_main_content','woocommerce_breadcrumb', 20, 0);

// Add the img wrap
add_action ('woocommerce_before_shop_loop_item_title', 'itr_catalog_start', 5, 2);
add_action( 'woocommerce_before_shop_loop_item_title','itr_catalog_end', 12, 2);
add_action( 'woocommerce_before_shop_loop_item_title', 'itr_loop_second_product_thumbnail' );

add_action( 'woocommerce_after_shop_loop_item', 'itr_quick_view_button' );
add_action( 'woocommerce_after_shop_loop_item', 'itr_wishlist_button', 10 );

if ( ! function_exists( 'itr_catalog_start' ) ) {
    function itr_catalog_start () {
        echo "<div class='catalog-wrap'>";
    }
}

if ( ! function_exists( 'itr_catalog_end' ) ) {
    function itr_catalog_end () {
        echo "</div>";
    }
}

if ( ! function_exists( 'itr_wishlist_button' ) ) {
    function itr_wishlist_button(){
        if( function_exists( 'YITH_WCWL' ) ){
            echo do_shortcode( '[yith_wcwl_add_to_wishlist label="" product_added_text="'.esc_attr(esc_html__('Added to wishlist','munza')).'" browse_wishlist_text="'.esc_attr(esc_html__('View wishlist','munza')).'" already_in_wishslist_text="" icon="fa fa-heart"]' );    
        }
        
    }
}

if ( ! function_exists( 'itr_get_pro_thumbs' ) ){
    function itr_get_pro_thumbs (){
        global $post, $product, $woocommerce;

        $attachment_ids = $product->get_gallery_image_ids();

        if ( $attachment_ids ) {
            $output     = '';
            $loop       = 0;
            $columns    = apply_filters( 'woocommerce_product_thumbnails_columns', 3 );


                foreach ( $attachment_ids as $attachment_id ) {

                    $classes = array( 'zoom' );

                    if ( $loop == 0 || $loop % $columns == 0 )
                        $classes[] = 'first';

                    if ( ( $loop + 1 ) % $columns == 0 )
                        $classes[] = 'last';

                    $image_link = wp_get_attachment_url( $attachment_id );

                    if ( ! $image_link )
                        continue;

                    $image       = wp_get_attachment_image( $attachment_id, apply_filters( 'single_product_small_thumbnail_size', 'shop_full' ) );
                    $image_class = esc_attr( implode( ' ', $classes ) );
                    $image_title = esc_attr( get_the_title( $attachment_id ) );

                    $output .= apply_filters( 'woocommerce_single_product_image_thumbnail_html', sprintf( '<div><a href="%s" class="itr_pro_zoom">%s</a></div>', $image_link, $image ), $attachment_id, $post->ID, $image_class );

                    $loop++;
                }

            return $output;
        }
    }
}

if ( ! function_exists( 'itr_get_pro_price' ) ){
    function itr_get_pro_price (){
        global $product;

        $output = '<div class="product-specs price-block">';
            if ( $price_html = $product->get_price_html() ) {
                $output .= '<div class="price-box">';
                    $output .= '<span class="product-price main-color">';
                        $output .= $product->get_price_html();
                        $output .= '<meta property="price" content="'.$product->get_price().'" />';
                        $output .= '<meta property="priceCurrency" content="'.get_woocommerce_currency().'" />';
                    $output .= '</span>';
                $output .= '</div>';
            } else {
                $output .= '<div class="box error-box">'.esc_html__( 'No Price Added.', 'munza' ).'</div>';
            }
        $output .= '</div>';
        return $output;
    }
}

if ( ! function_exists( 'itr_get_pro_meta' ) ){
    function itr_get_pro_meta (){
        global $post, $product;

        $shop_page_url = get_permalink( wc_get_page_id( 'shop' ) );
        
        $output = '<ul class="product-block">';

            if ( wc_product_sku_enabled() && ( $product->get_sku() || $product->is_type( 'variable' ) ) ) {
                $output .= '<li><i class="stline-check-badge main-color"></i><b>'.esc_html__( 'SKU:', 'munza' ).' </b>';
                $output .= ( $sku = $product->get_sku() ) ? '<span class="sku">' . $sku . '</span>' : '<span class="sku">' . esc_html__( 'N/A', 'munza' ).'</span>';
                $output .= '<li>';
            }
            
            if ( $product->has_weight() ) {
                $output .= '<li>';
                    $output .= '<i class="stline-check-badge main-color"></i><b>'.esc_html__( 'Weight:', 'munza' ).' </b>';
                    $output .= '<span class="product_weight">'.$product->get_weight() . ' ' . esc_attr( get_option( 'woocommerce_weight_unit' ) ).'</span>';
                $output .= '</li>';
            }
            $dimensions = wc_format_dimensions($product->get_dimensions(false));
            if ( $product->has_dimensions() ) {
                $output .= '<li>';
                    $output .= '<i class="stline-check-badge main-color"></i><b>'.esc_html__( 'Dimensions:', 'munza' ).' </b>';
                    $output .= '<span class="product_dimensions">'.$dimensions.'</span>';
                $output .= '</li>';
            }

            $output .= wc_get_product_category_list ( $post->ID, ', ', '<li class="posted_in"><i class="stline-check-badge main-color"></i>' . esc_html__( 'Categories:', 'munza' ) . ' ', '.</li>' );

            $output .= wc_get_product_tag_list( $post->ID, ', ', '<li class="tagged_as"><i class="stline-check-badge main-color"></i>' . esc_html__( 'Tags:', 'munza' ) . ' ', '.</li>' );
            
        $output .= '</ul>';
                
        return $output;
    }
}

if ( ! function_exists( 'itr_quick_view_cart_button' ) ){
    function itr_quick_view_cart_button() {
        global $product;
        $shop_page_url = get_permalink( wc_get_page_id( 'shop' ) );
        $output = '<div class="itr-pro-block">';
            $output .= '<a rel="nofollow" href="'.$shop_page_url.'?add-to-cart='.$product->get_id().'" data-quantity="1" data-product_id="'.$product->get_id().'" 
            data-product_sku="" class="btn btn-md rounded uppercase main-bg"><i class="stline-shopping-cart-1"></i>'.esc_html__( 'Add to cart','munza' ).'</a>';
        $output .= '</div>';
        
        return $output;
    }
}

if ( ! function_exists( 'itr_limit_text' ) ) {
    function itr_limit_text($text, $limit) {
        if (str_word_count($text, 0) > $limit) {
          $words = str_word_count($text, 2);
          $pos = array_keys($words);
          $text = substr($text, 0, $pos[$limit]) . '...';
        }
        return $text;
    }
}

if ( ! function_exists( 'itr_quick_view_button' ) ){
    function itr_quick_view_button($id) {
        global $product;
        $txt = ($product->get_short_description()) ? $product->get_short_description() : "";
        $pro_desc = itr_limit_text($txt, 20);
        
        echo '<a class="itr-quick-view" href="#"><i class="fa fa-eye"></i>'.esc_html__('Quick View','munza').'</a>';
            echo '<div class="itr_woo_quick_view product">';
                echo '<div class="item-content summary entry-summary">';
                    echo '<div class="col-md-5">';
                        echo '<div class="pro-img" data-arrow-size="sm_arrow">';
                            
                            echo '<div><a class="itr_pro_zoom" href="'.get_the_post_thumbnail_url( $product->get_id(), 'full' ).'"><img alt="'.esc_html__('Product Image','munza').'" src="'.get_the_post_thumbnail_url( $product->get_id(), 'full' ).'" /></a></div>';
                            echo itr_get_pro_thumbs ();
                        echo '</div>';
                        
                    echo '</div>';
                    echo '<div class="col-md-7">';
                        
                        echo '<h3 class="itr-pro-block itr-pro-title">'.$product->get_name().'</h3>';
                        
                        echo '<div class="itr-pro-block">';
                            echo itr_get_pro_price ();
                        echo '</div>';
                        
                        echo '<div class="itr-pro-block itr-pro-rating"></div>';
                        
                        echo '<div class="itr-pro-block">'.$pro_desc.'</div>';
                        
                        echo '<div class="itr-pro-block">';
                            echo itr_get_pro_meta();
                        echo '</div>';
                        
                        echo itr_quick_view_cart_button();
                        
                    echo '</div>';
                echo '</div>';

            echo '</div>';
    }
}

add_filter('woocommerce_add_to_cart_fragments', 'itr_icon_add_to_cart_fragment');
function itr_icon_add_to_cart_fragment( $fragments ) {
    global $woocommerce;
    ob_start();
    ?>
    <b class="cart-num main-bg white"><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'munza'), $woocommerce->cart->cart_contents_count);?></b>
    <?php
    $fragments['.cart-num'] = ob_get_clean();
    return $fragments;
}

add_filter('add_to_cart_fragments', 'it_add_to_cart_fragment');
if (!function_exists('it_add_to_cart_fragment')) {
    function it_add_to_cart_fragment( $fragments ) {
        global $woocommerce;
        ob_start();
        ?>
        <div class="mini-cart">
            <ul class="cart_list mini-cart-list product_list_widget">

            <?php if ( sizeof( WC()->cart->get_cart() ) > 0 ) : ?>

                <?php
                    foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                        $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                        $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

                        if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {

                            $product_name  = apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key );
                            $thumbnail     = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
                            $product_price = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );

                            ?>
                            <li>
                            <?php if ( ! $_product->is_visible() ) { ?>
                                <?php echo str_replace( array( 'http:', 'https:' ), '', $thumbnail ); ?>
                            <?php } else { ?>
                                <a class="cart-mini-lft" href="<?php echo esc_url(get_permalink( $product_id )); ?>">
                                    <?php echo str_replace( array( 'http:', 'https:' ), '', $thumbnail ); ?>
                                </a>
                            <?php } ?>
                                <div class="cart-body"><?php echo WC()->cart->get_item_data( $cart_item ); ?>
                                <a href="<?php echo esc_url(get_permalink( $product_id )); ?>"><?php echo $product_name ?></a>
                                <?php echo apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="price">' . sprintf( '%s &times; %s', $cart_item['quantity'], $product_price, 'munza' ) . '</span>', $cart_item, $cart_item_key ); ?></div>
                            </li>
                            <?php
                        }
                    }
                ?>

            <?php else : ?>

                <li class="empty"><?php _e( 'Your Shopping cart is empty.', 'munza' ); ?></li>

            <?php endif; ?>

        </ul>

            <?php if ( sizeof( WC()->cart->get_cart() ) > 0 ) : ?>
                <div class="mini-cart-total"><div class="pull-left"><?php _e( 'Subtotal', 'munza' ); ?>:</div><div class="pull-right"> <?php echo WC()->cart->get_cart_subtotal(); ?></div></div>
                <?php do_action( 'woocommerce_widget_shopping_cart_before_buttons' ); ?>
                <div class="checkout">
                    <a href="<?php echo esc_url(WC()->cart->get_cart_url()); ?>" class="btn main-bg"><?php _e( 'View Cart', 'munza' ); ?></a>
                    <a href="<?php echo esc_url(WC()->cart->get_checkout_url()); ?>" class="btn btn-default"><?php _e( 'Checkout', 'munza' ); ?></a>
                </div>
            <?php endif; ?>
        </div>  
        <?php
        $fragments['div.mini-cart'] = ob_get_clean();
        return $fragments;
        
    }
}

// woo shopping cart in header & top bar.
if ( ! function_exists( 'itr_woo_cart' ) ){
   function itr_woo_cart(){
        global $woocommerce; 
        $cart_url = wc_get_cart_url();
        ?>
                
        <a href="<?php echo esc_url($cart_url) ?>" class="cart-btn">
            <i class="stline-shopping-basket-1"></i><i class="stline-shopping-basket-1 btn_back"></i>
            <b class="cart-num main-bg white"><?php echo sprintf(_n('%d', '%d', $woocommerce->cart->cart_contents_count, 'munza'), $woocommerce->cart->cart_contents_count);?></b>
        </a>
        
        <div class="cart-box">
            <div class="mini-cart">
                <ul class="cart_list mini-cart-list product_list_widget">

                    <?php if ( sizeof( WC()->cart->get_cart() ) > 0 ) {

                            foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
                                $_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );
                                $product_id   = apply_filters( 'woocommerce_cart_item_product_id', $cart_item['product_id'], $cart_item, $cart_item_key );

                                if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_widget_cart_item_visible', true, $cart_item, $cart_item_key ) ) {

                                    $product_name  = apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key );
                                    $thumbnail     = apply_filters( 'woocommerce_cart_item_thumbnail', $_product->get_image(), $cart_item, $cart_item_key );
                                    $product_price = apply_filters( 'woocommerce_cart_item_price', WC()->cart->get_product_price( $_product ), $cart_item, $cart_item_key );

                                    ?>
                                    <li>
                                    <?php if ( ! $_product->is_visible() ) { ?>
                                        <?php echo str_replace( array( 'http:', 'https:' ), '', $thumbnail ); ?>
                                    <?php } else { ?>
                                        <a class="cart-mini-lft" href="<?php echo esc_url(get_permalink( $product_id )); ?>">
                                            <?php echo str_replace( array( 'http:', 'https:' ), '', $thumbnail ); ?>
                                        </a>
                                    <?php } ?>
                                        <div class="cart-body"><?php echo wc_get_formatted_cart_item_data( $cart_item ); ?>
                                        <a href="<?php echo esc_url(get_permalink( $product_id )); ?>"><?php echo esc_html($product_name) ?></a>
                                        <?php echo apply_filters( 'woocommerce_widget_cart_item_quantity', '<span class="price">' . sprintf( '%s &times; %s', $cart_item['quantity'], $product_price , 'munza' ) . '</span>', $cart_item, $cart_item_key ); ?></div>
                                    </li>
                                    <?php
                                }
                            }
                    } else { ?>

                        <li class="empty"><?php echo esc_html__( 'Your Shopping cart is empty.', 'munza' ); ?></li>

                    <?php } ?>

                </ul>

                <?php if ( sizeof( WC()->cart->get_cart() ) > 0 ) : ?>
                    <div class="mini-cart-total"><div class="pull-left"><?php echo esc_html__( 'Subtotal', 'munza' ); ?>:</div><div class="pull-right"> <?php echo WC()->cart->get_cart_subtotal(); ?></div></div>
                    <?php do_action( 'woocommerce_widget_shopping_cart_before_buttons' ); ?>
                    <div class="checkout">
                        <a href="<?php echo esc_url(wc_get_cart_url()); ?>" class="btn btn-sm main-bg"><?php echo esc_html__( 'View Cart', 'munza' ); ?></a>
                        <a href="<?php echo esc_url(wc_get_checkout_url()); ?>" class="btn btn-sm btn-default"><?php echo esc_html__( 'Checkout', 'munza' ); ?></a>
                    </div>
                <?php endif; ?>
            </div>
        </div>  
                                                
        <?php
    }
}

function itr_update_wishlist_count(){
    if( function_exists( 'YITH_WCWL' ) ){
        wp_send_json( YITH_WCWL()->count_products() );
    }
}
add_action( 'wp_ajax_update_wishlist_count', 'itr_update_wishlist_count' );
add_action( 'wp_ajax_nopriv_update_wishlist_count', 'itr_update_wishlist_count' );

// Add if-has-gallery class to products that has a gallery
function itr_product_has_gallery( $classes ) {
    global $product;

    $post_type = get_post_type( get_the_ID() );

    if ( ! is_admin() ) {

        if ( $post_type == 'product' ) {

            $attachment_ids = $product->get_gallery_image_ids();

            if ( $attachment_ids ) {
                $classes[] = 'it-has-gallery';
            }
        }

    }

    return $classes;
}
add_filter( 'post_class', 'itr_product_has_gallery');

// Display the second thumbnails
function itr_loop_second_product_thumbnail() {
    global $product, $woocommerce;

    $attachment_ids = $product->get_gallery_image_ids();

    if ( $attachment_ids ) {
        $secondary_image_id = $attachment_ids['0'];
        echo wp_get_attachment_image( $secondary_image_id, 'shop_catalog', '', $attr = array( 'class' => 'second-shop-catalog' ) );
    }   
}

function itr_related_products_args( $args ) {
    
      $rppage = itr_theme_option('related_per_page');
      $args['posts_per_page'] = $rppage; // 4 related products
      return $args;
      
}
add_filter( 'woocommerce_output_related_products_args', 'itr_related_products_args' );

if(itr_theme_option('show_related_woo') == '0' && is_product()){
    function itr_remove_related_products( $args ) {
        return array();
    }
    add_filter('woocommerce_related_products_args','itr_remove_related_products', 10);
}

function itr_woo_post_classes( $classes ) {
    if ( 'product' == get_post_type() ) {
        $classes = array_diff( $classes, array( 'first', 'last' ) );
    }
    return $classes;
}
add_filter( 'post_class', 'itr_woo_post_classes', 21 );

function itr_woocommerce_category_image() {
    if ( is_product_category() ){
        global $wp_query;
        $cat = $wp_query->get_queried_object();
        $thumbnail_id = get_woocommerce_term_meta( $cat->term_id, 'thumbnail_id', true );
        $image = wp_get_attachment_url( $thumbnail_id );
        if ( $image ) {
            echo '<div class="woo_cat_img"><img src="' . $image . '" alt="'.get_the_title().'" /></div>';
        }
    }
}
add_action( 'woocommerce_archive_description', 'itr_woocommerce_category_image', 2 );